/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.datamovement.PeekingIterator;
import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.JacksonHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JacksonCSVSplitter
implements Splitter<JacksonHandle> {
    private CsvSchema csvSchema = null;
    private CsvMapper csvMapper;
    private long count = 0L;
    private ArrayNode headers = null;
    private UriMaker uriMaker;

    public CsvMapper getCsvMapper() {
        return this.csvMapper;
    }

    public JacksonCSVSplitter withCsvSchema(CsvSchema schema) {
        this.csvSchema = schema;
        return this;
    }

    public JacksonCSVSplitter withCsvMapper(CsvMapper mapper) {
        this.csvMapper = mapper;
        return this;
    }

    public CsvSchema getCsvSchema() {
        return this.csvSchema;
    }

    private CsvMapper configureCsvMapper() {
        if (this.csvMapper == null) {
            this.csvMapper = new CsvMapper().configure(CsvParser.Feature.ALLOW_TRAILING_COMMA, true).configure(CsvParser.Feature.FAIL_ON_MISSING_COLUMNS, false).configure(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE, false).configure(CsvParser.Feature.INSERT_NULLS_FOR_MISSING_COLUMNS, false).configure(CsvParser.Feature.SKIP_EMPTY_LINES, true).configure(CsvParser.Feature.TRIM_SPACES, true).configure(CsvParser.Feature.WRAP_AS_ARRAY, false).configure(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE, true);
        }
        return this.csvMapper;
    }

    @Override
    public Stream<JacksonHandle> split(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("InputSteam cannot be null.");
        }
        return this.configureInput((Iterator<JsonNode>)this.configureObjReader().readValues(input));
    }

    public Stream<JacksonHandle> split(Reader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        MappingIterator nodeItr = this.configureObjReader().readValues(input);
        return this.configureInput((Iterator<JsonNode>)nodeItr);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (this.getUriMaker() == null) {
            UriMakerImpl uriMaker = new UriMakerImpl();
            this.setUriMaker(uriMaker);
        }
        if (splitFilename != null) {
            this.getUriMaker().setSplitFilename(splitFilename);
        }
        MappingIterator nodeItr = this.configureObjReader().readValues(input);
        return this.configureInputDocumentWriteOperation((Iterator<JsonNode>)nodeItr);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(Reader input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(Reader input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (this.getUriMaker() == null) {
            UriMakerImpl uriMaker = new UriMakerImpl();
            this.setUriMaker(uriMaker);
        }
        if (splitFilename != null) {
            this.getUriMaker().setSplitFilename(splitFilename);
        }
        if (this.getUriMaker() instanceof UriMakerImpl) {
            ((UriMakerImpl)this.getUriMaker()).setExtension("json");
        }
        MappingIterator nodeItr = this.configureObjReader().readValues(input);
        return this.configureInputDocumentWriteOperation((Iterator<JsonNode>)nodeItr);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public ArrayNode getHeaders() {
        return this.headers;
    }

    private void incrementCount() {
        ++this.count;
    }

    private ObjectReader configureObjReader() {
        this.count = 0L;
        CsvSchema firstLineSchema = this.getCsvSchema() != null ? this.getCsvSchema() : CsvSchema.emptySchema().withHeader();
        CsvMapper csvMapper = this.getCsvMapper() != null ? this.getCsvMapper() : this.configureCsvMapper();
        ObjectReader objectReader = csvMapper.readerFor(JsonNode.class);
        return objectReader.with((FormatSchema)firstLineSchema);
    }

    private JacksonHandle wrapJacksonHandle(JsonNode content) {
        this.incrementCount();
        return new JacksonHandle(content);
    }

    private DocumentWriteOperation wrapDocumentWriteOperation(JsonNode content) {
        JacksonHandle handle = this.wrapJacksonHandle(content);
        String uri = this.uriMaker.makeUri(this.count, handle);
        return new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, handle);
    }

    private PeekingIterator<JsonNode> configureSplitObj(Iterator<JsonNode> nodeItr) {
        if (nodeItr == null || !nodeItr.hasNext()) {
            throw new MarkLogicIOException("No header found.");
        }
        PeekingIterator<JsonNode> peekingIterator = new PeekingIterator<JsonNode>(nodeItr);
        Iterator headerValue = peekingIterator.getFirst().fieldNames();
        this.headers = new ObjectMapper().createArrayNode();
        while (headerValue.hasNext()) {
            this.headers.add((String)headerValue.next());
        }
        return peekingIterator;
    }

    private Stream<JacksonHandle> configureInput(Iterator<JsonNode> nodeItr) {
        if (this.getCsvSchema() == null) {
            PeekingIterator<JsonNode> peekingIterator = this.configureSplitObj(nodeItr);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(peekingIterator, 16), false).map(this::wrapJacksonHandle);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodeItr, 16), false).map(this::wrapJacksonHandle);
    }

    private Stream<DocumentWriteOperation> configureInputDocumentWriteOperation(Iterator<JsonNode> nodeItr) {
        if (this.getCsvSchema() == null) {
            PeekingIterator<JsonNode> peekingIterator = this.configureSplitObj(nodeItr);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(peekingIterator, 16), false).map(this::wrapDocumentWriteOperation);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodeItr, 16), false).map(this::wrapDocumentWriteOperation);
    }

    public UriMaker getUriMaker() {
        return this.uriMaker;
    }

    public void setUriMaker(UriMaker uriMaker) {
        this.uriMaker = uriMaker;
    }

    private static class UriMakerImpl
    extends com.marklogic.client.datamovement.impl.UriMakerImpl<JacksonHandle>
    implements UriMaker {
        private UriMakerImpl() {
        }

        @Override
        public String makeUri(long num, JacksonHandle handle) {
            StringBuilder uri = new StringBuilder();
            if (this.getInputAfter() != null && this.getInputAfter().length() != 0) {
                uri.append(this.getInputAfter());
            }
            if (this.getSplitFilename() != null && this.getSplitFilename().length() != 0) {
                uri.append(this.getName());
            }
            if (uri.length() == 0) {
                uri.append("/");
            }
            uri.append(num).append("_").append(UUID.randomUUID()).append(".json");
            return uri.toString();
        }
    }

    public static interface UriMaker
    extends Splitter.UriMaker {
        public String makeUri(long var1, JacksonHandle var3);
    }
}

