/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

public interface Forest {
    public String getForestId();

    public String getForestName();

    public String getDatabaseName();

    public String getHost();

    public String getOpenReplicaHost();

    public String getAlternateHost();

    public String getRequestHost();

    public boolean isUpdateable();

    default public String getPreferredHost() {
        if (this.getAlternateHost() != null) {
            return this.getAlternateHost();
        }
        if (this.getOpenReplicaHost() != null) {
            return this.getOpenReplicaHost();
        }
        if (this.getRequestHost() != null) {
            return this.getRequestHost();
        }
        return this.getHost();
    }

    default public HostType getPreferredHostType() {
        if (this.getAlternateHost() != null) {
            return HostType.ALTERNATE_HOST;
        }
        if (this.getOpenReplicaHost() != null) {
            return HostType.OPEN_REPLICA_HOST;
        }
        if (this.getRequestHost() != null) {
            return HostType.REQUEST_HOST;
        }
        return HostType.FOREST_HOST;
    }

    public static enum HostType {
        FOREST_HOST,
        REQUEST_HOST,
        ALTERNATE_HOST,
        OPEN_REPLICA_HOST;

    }
}

