/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.pojo.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.marklogic.client.pojo.annotation.GeospatialLatitude;
import com.marklogic.client.pojo.annotation.GeospatialLongitude;
import com.marklogic.client.pojo.annotation.GeospatialPathIndexProperty;
import com.marklogic.client.pojo.annotation.Id;
import com.marklogic.client.pojo.annotation.PathIndexProperty;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class GenerateIndexConfig {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String[] classes = new String[]{};
        try (Writer out = null;){
            for (int i = 0; i < args.length; ++i) {
                String name = args[i];
                if (!name.startsWith("-") || name.length() <= 1 || ++i >= args.length) continue;
                String argValue = args[i];
                if ("-classes".equals(name)) {
                    classes = argValue.split("\\s+");
                    continue;
                }
                if (!"-file".equals(name)) continue;
                out = new FileWriter(argValue);
            }
            if (out == null) {
                out = new OutputStreamWriter(System.out);
            }
            ObjectMapper mapper = new ObjectMapper();
            GenerateIndexConfig.generateConfig(classes, mapper, out);
        }
    }

    private static void generateConfig(String[] classes, ObjectMapper mapper, Writer out) throws ClassNotFoundException, IOException {
        ArrayList<PathIndexFound> paths = new ArrayList<PathIndexFound>();
        ArrayList<GeoPathIndexFound> geoPaths = new ArrayList<GeoPathIndexFound>();
        ArrayList<GeoPairFound> geoPairs = new ArrayList<GeoPairFound>();
        for (String className : classes) {
            Class clazz = TypeFactory.defaultInstance().findClass(className);
            SerializationConfig serializationConfig = new ObjectMapper().getSerializationConfig();
            JavaType javaType = serializationConfig.constructType(clazz);
            BeanDescription beanDescription = serializationConfig.introspect(javaType);
            List properties = beanDescription.findProperties();
            GeoPairFound geoPair = new GeoPairFound();
            for (BeanPropertyDefinition property : properties) {
                AnnotationFound<GeospatialLongitude> geoLonAnnotation;
                AnnotationFound<GeospatialLatitude> geoLatAnnotation;
                AnnotationFound<GeospatialPathIndexProperty> geoPathAnnotation;
                AnnotationFound<PathIndexProperty> pathIndexAnnotation;
                AnnotationFound<Id> idAnnotation = GenerateIndexConfig.getAnnotation(property, Id.class);
                if (idAnnotation != null) {
                    // empty if block
                }
                if ((pathIndexAnnotation = GenerateIndexConfig.getAnnotation(property, PathIndexProperty.class)) != null) {
                    PathIndexFound found = new PathIndexFound();
                    found.fullyQualifiedClassName = clazz.getName();
                    found.propertyName = property.getName();
                    found.scalarType = ((PathIndexProperty)pathIndexAnnotation.annotation).scalarType();
                    found.foundMessage = pathIndexAnnotation.foundMessage;
                    paths.add(found);
                }
                if ((geoPathAnnotation = GenerateIndexConfig.getAnnotation(property, GeospatialPathIndexProperty.class)) != null) {
                    GeoPathIndexFound found = new GeoPathIndexFound();
                    found.fullyQualifiedClassName = clazz.getName();
                    found.propertyName = property.getName();
                    found.foundMessage = geoPathAnnotation.foundMessage;
                    geoPaths.add(found);
                }
                if ((geoLatAnnotation = GenerateIndexConfig.getAnnotation(property, GeospatialLatitude.class)) != null) {
                    if (geoPair.latitudeName != null) {
                        GenerateIndexConfig.errorExactPair(className);
                    }
                    GenerateIndexConfig.errorIfPairAlreadyFound(geoPair);
                    geoPair.fullyQualifiedClassName = clazz.getName();
                    geoPair.latitudeName = property.getName();
                    geoPair.latitudeFoundMessage = geoLatAnnotation.foundMessage;
                }
                if ((geoLonAnnotation = GenerateIndexConfig.getAnnotation(property, GeospatialLongitude.class)) == null) continue;
                if (geoPair.longitudeName != null) {
                    GenerateIndexConfig.errorExactPair(className);
                }
                GenerateIndexConfig.errorIfPairAlreadyFound(geoPair);
                geoPair.fullyQualifiedClassName = clazz.getName();
                geoPair.longitudeName = property.getName();
                geoPair.longitudeFoundMessage = geoLonAnnotation.foundMessage;
            }
            if (GenerateIndexConfig.isPairComplete(geoPair)) {
                geoPairs.add(geoPair);
                continue;
            }
            if (!GenerateIndexConfig.isPairPartial(geoPair)) continue;
            GenerateIndexConfig.errorExactPair(className);
        }
        JsonGenerator config = mapper.getFactory().createGenerator(out);
        config.useDefaultPrettyPrinter();
        config.writeStartObject();
        GenerateIndexConfig.generatePathIndexes(paths, config);
        GenerateIndexConfig.generateGeoPathIndexes(geoPaths, config);
        GenerateIndexConfig.generateGeoPairIndexes(geoPairs, config);
        config.writeEndObject();
        config.flush();
        config.close();
    }

    private static void errorExactPair(String className) {
        throw new IllegalStateException("Error processing class '" + className + "'. Each class with @GeospatialLatitude or @GeospatialLongitude annotations must have exactly one of each");
    }

    private static void errorIfPairAlreadyFound(GeoPairFound geoPair) {
        if (GenerateIndexConfig.isPairComplete(geoPair)) {
            throw new IllegalStateException("Each class can have a maximum of one @GeospatialLatitude and one @GeospatialLongitude annotation");
        }
    }

    private static boolean isPairComplete(GeoPairFound geoPair) {
        return geoPair != null && geoPair.latitudeName != null && geoPair.longitudeName != null;
    }

    private static boolean isPairPartial(GeoPairFound geoPair) {
        return geoPair != null && (geoPair.latitudeName != null || geoPair.longitudeName != null);
    }

    private static void generatePathIndexes(List<PathIndexFound> paths, JsonGenerator config) throws IOException {
        config.writeArrayFieldStart("range-path-index");
        for (PathIndexFound found : paths) {
            config.writeStartObject();
            config.writeStringField("path-expression", found.getPath());
            config.writeStringField("scalar-type", found.scalarType.toString());
            if (PathIndexProperty.ScalarType.STRING == found.scalarType) {
                config.writeStringField("collation", "http://marklogic.com/collation/");
            } else {
                config.writeStringField("collation", "");
            }
            config.writeStringField("range-value-positions", "false");
            config.writeStringField("invalid-values", "ignore");
            config.writeEndObject();
        }
        config.writeEndArray();
    }

    private static void generateGeoPathIndexes(List<GeoPathIndexFound> geoPaths, JsonGenerator config) throws IOException {
        config.writeArrayFieldStart("geospatial-path-index");
        for (GeoPathIndexFound found : geoPaths) {
            config.writeStartObject();
            config.writeStringField("path-expression", found.getPath());
            config.writeStringField("coordinate-system", "wgs84");
            config.writeStringField("point-format", "point");
            config.writeStringField("range-value-positions", "false");
            config.writeStringField("invalid-values", "ignore");
            config.writeEndObject();
        }
        config.writeEndArray();
    }

    private static void generateGeoPairIndexes(List<GeoPairFound> geoPairs, JsonGenerator config) throws IOException {
        config.writeArrayFieldStart("geospatial-element-pair-index");
        for (GeoPairFound found : geoPairs) {
            config.writeStartObject();
            config.writeStringField("parent-namespace-uri", "");
            config.writeStringField("parent-localname", found.fullyQualifiedClassName);
            config.writeStringField("latitude-namespace-uri", "");
            config.writeStringField("latitude-localname", found.latitudeName);
            config.writeStringField("longitude-namespace-uri", "");
            config.writeStringField("longitude-localname", found.longitudeName);
            config.writeStringField("coordinate-system", "wgs84");
            config.writeStringField("range-value-positions", "false");
            config.writeStringField("invalid-values", "ignore");
            config.writeEndObject();
        }
        config.writeEndArray();
    }

    private static <T extends Annotation> AnnotationFound<T> getAnnotation(BeanPropertyDefinition property, Class<T> annotation) {
        T setterAnnotation;
        T getterAnnotation;
        AnnotationFound found;
        Annotation fieldAnnotation;
        AnnotatedParameter parameter;
        Annotation constructorAnnotation;
        String annotationName = "@" + annotation.getSimpleName();
        if (property.hasConstructorParameter() && (constructorAnnotation = (parameter = property.getConstructorParameter()).getAnnotation(annotation)) != null) {
            AnnotationFound found2 = new AnnotationFound();
            found2.annotation = constructorAnnotation;
            found2.foundMessage = annotationName + " on constructor parameter '" + parameter.getRawType().getName() + " " + parameter.getName() + "'";
            return found2;
        }
        if (property.hasField() && (fieldAnnotation = property.getField().getAnnotation(annotation)) != null) {
            found = new AnnotationFound();
            found.annotation = fieldAnnotation;
            found.foundMessage = annotationName + " on field '" + property.getField().getName() + "'";
            return found;
        }
        if (property.hasGetter() && (getterAnnotation = property.getGetter().getMember().getAnnotation(annotation)) != null) {
            found = new AnnotationFound();
            found.annotation = getterAnnotation;
            found.foundMessage = annotationName + " on method '" + property.getGetter().getName() + "'";
            return found;
        }
        if (property.hasSetter() && (setterAnnotation = property.getSetter().getMember().getAnnotation(annotation)) != null) {
            found = new AnnotationFound();
            found.annotation = setterAnnotation;
            found.foundMessage = annotationName + " on method '" + property.getSetter().getName() + "'";
            return found;
        }
        return null;
    }

    private static class GeoPairFound {
        String fullyQualifiedClassName;
        String latitudeName;
        String longitudeName;
        String latitudeFoundMessage;
        String longitudeFoundMessage;

        private GeoPairFound() {
        }
    }

    private static class GeoPathIndexFound {
        String fullyQualifiedClassName;
        String propertyName;
        String foundMessage;

        private GeoPathIndexFound() {
        }

        String getPath() {
            return this.fullyQualifiedClassName + "/" + this.propertyName;
        }
    }

    private static class PathIndexFound {
        String fullyQualifiedClassName;
        String propertyName;
        PathIndexProperty.ScalarType scalarType;
        String foundMessage;

        private PathIndexFound() {
        }

        String getPath() {
            return this.fullyQualifiedClassName + "/" + this.propertyName;
        }
    }

    private static class AnnotationFound<T extends Annotation> {
        T annotation;
        String foundMessage;

        private AnnotationFound() {
        }
    }
}

