/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.ValuesBuilder;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.ValuesReadHandle;
import com.marklogic.client.query.AggregateResult;
import com.marklogic.client.query.CountedDistinctValue;
import com.marklogic.client.query.ValuesDefinition;
import com.marklogic.client.query.ValuesMetrics;
import com.marklogic.client.query.ValuesResults;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesHandle
extends BaseHandle<InputStream, OperationNotSupported>
implements ValuesReadHandle,
ValuesResults {
    private static final Logger logger = LoggerFactory.getLogger(DOMHandle.class);
    private ValuesBuilder.Values valuesHolder;
    private Unmarshaller unmarshaller;
    private Map<String, AggregateResult> hashedAggregates = null;
    private ValuesDefinition valuesdef = null;

    public ValuesHandle() {
        super.setFormat(Format.XML);
        try {
            JAXBContext jc = JaxbContextLoader.CACHED_CONTEXT;
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new MarkLogicBindingException((Exception)((Object)new JAXBException("JAXB context initialization failed")));
        }
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("ValuesHandle supports the XML format only");
        }
    }

    public ValuesHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            this.valuesHolder = (ValuesBuilder.Values)this.unmarshaller.unmarshal((Reader)new InputStreamReader(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to unmarshall values", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall values", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setQueryCriteria(ValuesDefinition vdef) {
        this.valuesdef = vdef;
    }

    @Override
    public ValuesDefinition getQueryCriteria() {
        return this.valuesdef;
    }

    @Override
    public String getName() {
        return this.valuesHolder.getName();
    }

    @Override
    public String getType() {
        return this.valuesHolder.getType();
    }

    @Override
    public CountedDistinctValue[] getValues() {
        return this.valuesHolder.getValues();
    }

    @Override
    public AggregateResult[] getAggregates() {
        return this.valuesHolder.getAggregates();
    }

    @Override
    public AggregateResult getAggregate(String name) {
        if (this.hashedAggregates == null) {
            this.hashedAggregates = new HashMap<String, AggregateResult>();
            for (AggregateResult aggregate : this.valuesHolder.getAggregates()) {
                this.hashedAggregates.put(aggregate.getName(), aggregate);
            }
        }
        if (this.hashedAggregates.containsKey(name)) {
            return this.hashedAggregates.get(name);
        }
        return null;
    }

    @Override
    public ValuesMetrics getMetrics() {
        return this.valuesHolder.getMetrics();
    }

    private static class JaxbContextLoader {
        private static final JAXBContext CACHED_CONTEXT;

        private JaxbContextLoader() {
        }

        static {
            try {
                CACHED_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ValuesBuilder.Values.class});
            }
            catch (JAXBException e) {
                throw new MarkLogicBindingException((Exception)((Object)e));
            }
        }
    }
}

