/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXBHandle<C>
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<C>,
XMLReadHandle,
XMLWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(JAXBHandle.class);
    private JAXBContext context;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private C content;

    public static ContentHandleFactory newFactory(Class<?> ... pojoClasses) throws JAXBException {
        if (pojoClasses == null || pojoClasses.length == 0) {
            return null;
        }
        return new JAXBHandleFactory((Class[])pojoClasses);
    }

    public static ContentHandleFactory newFactory(JAXBContext context, Class<?> ... pojoClasses) throws JAXBException {
        if (context == null || pojoClasses == null || pojoClasses.length == 0) {
            return null;
        }
        return new JAXBHandleFactory(context, (Class[])pojoClasses);
    }

    public JAXBHandle(JAXBContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null JAXB context for converting classes");
        }
        super.setFormat(Format.XML);
        this.setResendable(true);
        this.context = context;
    }

    @Override
    public C get() {
        return this.content;
    }

    public <T> T get(Class<T> as) {
        if (this.content == null) {
            return null;
        }
        if (as == null) {
            throw new IllegalArgumentException("Cannot cast content to null class");
        }
        if (!as.isAssignableFrom(this.content.getClass())) {
            throw new IllegalArgumentException("Cannot cast " + this.content.getClass().getName() + " to " + as.getName());
        }
        C content = this.get();
        return (T)content;
    }

    @Override
    public void set(C content) {
        this.content = content;
    }

    public JAXBHandle<C> with(C content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("JAXBHandle supports the XML format only");
        }
    }

    public JAXBHandle<C> withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            byte[] buffer = this.toBuffer();
            return buffer == null ? null : new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        return this.getUnmarshaller(true);
    }

    public Unmarshaller getUnmarshaller(boolean reuse) throws JAXBException {
        if (!reuse || this.unmarshaller == null) {
            this.unmarshaller = this.context.createUnmarshaller();
        }
        return this.unmarshaller;
    }

    public Marshaller getMarshaller() throws JAXBException {
        return this.getMarshaller(true);
    }

    public Marshaller getMarshaller(boolean reuse) throws JAXBException {
        if (!reuse || this.marshaller == null) {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.marshaller = marshaller;
        }
        return this.marshaller;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            Object unmarshalled = this.getUnmarshaller().unmarshal((Reader)new InputStreamReader(content, "UTF-8"));
            this.content = unmarshalled;
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall object read from database document", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to unmarshall object read from database document", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No object to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            this.getMarshaller().marshal(this.content, out);
        }
        catch (JAXBException e) {
            logger.error("Failed to marshall object for writing to database document", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
    }

    private static class JAXBHandleFactory
    implements ContentHandleFactory {
        private Class<?>[] pojoClasses;
        private JAXBContext factoryContext;
        private Set<Class<?>> classSet;

        private JAXBHandleFactory(Class<?> ... pojoClasses) throws JAXBException {
            this(JAXBContext.newInstance((Class[])pojoClasses), pojoClasses);
        }

        private JAXBHandleFactory(JAXBContext factoryContext, Class<?> ... pojoClasses) throws JAXBException {
            this.pojoClasses = pojoClasses;
            this.factoryContext = factoryContext;
            this.classSet = new HashSet(Arrays.asList(pojoClasses));
        }

        @Override
        public Class<?>[] getHandledClasses() {
            return this.pojoClasses;
        }

        @Override
        public boolean isHandled(Class<?> type) {
            return this.classSet.contains(type);
        }

        @Override
        public <C> ContentHandle<C> newHandle(Class<C> type) {
            JAXBHandle handle = this.isHandled(type) ? new JAXBHandle(this.factoryContext) : null;
            return handle;
        }
    }
}

