/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.GenericReadHandle;
import com.marklogic.client.io.marker.GenericWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.SPARQLResultsReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamHandle
extends BaseHandle<InputStream, InputStream>
implements BufferableHandle,
ContentHandle<InputStream>,
BinaryReadHandle,
BinaryWriteHandle,
GenericReadHandle,
GenericWriteHandle,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
TriplesReadHandle,
TriplesWriteHandle,
QuadsWriteHandle,
SPARQLResultsReadHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamHandle.class);
    private InputStream content;
    private static final int BUFFER_SIZE = 8192;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{InputStream.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return InputStream.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                InputStreamHandle handle = this.isHandled(type) ? new InputStreamHandle() : null;
                return handle;
            }
        };
    }

    public InputStreamHandle() {
        this.setResendable(false);
    }

    public InputStreamHandle(InputStream content) {
        this();
        this.set(content);
    }

    @Override
    public InputStream get() {
        return this.content;
    }

    @Override
    public void set(InputStream content) {
        this.content = content;
    }

    public InputStreamHandle with(InputStream content) {
        this.set(content);
        return this;
    }

    public InputStreamHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public InputStreamHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            int len = 0;
            while ((len = this.content.read(b)) != -1) {
                buffer.write(b, 0, len);
            }
            this.content.close();
            b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            byte[] buffer = this.toBuffer();
            return buffer == null ? null : new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.content = content;
    }

    @Override
    protected InputStream sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No stream to write");
        }
        return this.content;
    }

    @Override
    public void close() {
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }
}

