/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.Utilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.Duration;

public class ValueConverter {
    private static final BigInteger MIN_UNSIGNED = new BigInteger("0");
    public static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    public static final int MAX_UNSIGNED_SHORT = 65535;
    private static Pattern instantPattern = null;

    private ValueConverter() {
    }

    public static void convertFromJava(Object value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
        } else if (value instanceof BigDecimal) {
            ValueConverter.convertFromJava((BigDecimal)value, processor);
        } else if (value instanceof BigInteger) {
            ValueConverter.convertFromJava((BigInteger)value, processor);
        } else if (value instanceof Boolean) {
            ValueConverter.convertFromJava((Boolean)value, processor);
        } else if (value instanceof Byte) {
            ValueConverter.convertFromJava((Byte)value, processor);
        } else if (value instanceof byte[]) {
            ValueConverter.convertFromJava((byte[])value, processor);
        } else if (value instanceof Calendar) {
            ValueConverter.convertFromJava((Calendar)value, processor);
        } else if (value instanceof Double) {
            ValueConverter.convertFromJava((Double)value, processor);
        } else if (value instanceof Duration) {
            ValueConverter.convertFromJava((Duration)value, processor);
        } else if (value instanceof Float) {
            ValueConverter.convertFromJava((Float)value, processor);
        } else if (value instanceof Integer) {
            ValueConverter.convertFromJava((Integer)value, processor);
        } else if (value instanceof Long) {
            ValueConverter.convertFromJava((Long)value, processor);
        } else if (value instanceof Short) {
            ValueConverter.convertFromJava((Short)value, processor);
        } else if (value instanceof String) {
            ValueConverter.convertFromJava((String)value, processor);
        } else {
            processor.process(value, "xs:anySimpleType", DatatypeConverter.printString((String)value.toString()));
        }
    }

    public static void convertFromJava(BigDecimal value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:decimal", ValueConverter.BigDecimalToString(value));
    }

    public static void convertFromJava(BigInteger value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        if (MIN_UNSIGNED.compareTo(value) <= 0 && MAX_UNSIGNED_LONG.compareTo(value) >= 0) {
            processor.process(value, "xs:unsignedLong", DatatypeConverter.printInteger((BigInteger)value));
        } else {
            processor.process(value, "xs:integer", DatatypeConverter.printInteger((BigInteger)value));
        }
    }

    public static void convertFromJava(Boolean value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:boolean", ValueConverter.BooleanToString(value));
    }

    public static void convertFromJava(Byte value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:byte", DatatypeConverter.printByte((byte)value));
    }

    public static void convertFromJava(byte[] value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:base64Binary", DatatypeConverter.printBase64Binary((byte[])value));
    }

    public static void convertFromJava(Calendar value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        if (!value.isSet(5)) {
            processor.process(value, "xs:time", DatatypeConverter.printTime((Calendar)value));
        } else if (value.isSet(11)) {
            processor.process(value, "xs:dateTime", DatatypeConverter.printDateTime((Calendar)value));
        } else {
            processor.process(value, "xs:date", DatatypeConverter.printDate((Calendar)value));
        }
    }

    public static void convertFromJava(Double value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:double", ValueConverter.DoubleToString(value));
    }

    public static void convertFromJava(Duration value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:" + value.getXMLSchemaType().getLocalPart(), value.toString());
    }

    public static void convertFromJava(Float value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:float", ValueConverter.FloatToString(value));
    }

    public static void convertFromJava(Integer value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        int ival = value;
        if (0 <= ival && ival <= 65535) {
            processor.process(value, "xs:unsignedShort", DatatypeConverter.printUnsignedShort((int)ival));
        } else {
            processor.process(value, "xs:int", ValueConverter.IntegerPrimitiveToString(ival));
        }
    }

    public static void convertFromJava(Long value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        long longVal = value;
        if (0L <= longVal && longVal <= 0xFFFFFFFFL) {
            processor.process(value, "xs:unsignedInt", DatatypeConverter.printUnsignedInt((long)longVal));
        } else {
            processor.process(value, "xs:long", ValueConverter.LongPrimitiveToString(longVal));
        }
    }

    public static void convertFromJava(Short value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:short", DatatypeConverter.printShort((short)value));
    }

    public static void convertFromJava(String value, ValueProcessor processor) {
        if (value == null) {
            processor.process(null, null, null);
            return;
        }
        processor.process(value, "xs:string", ValueConverter.StringToString(value));
    }

    public static Object convertToJava(String type, String value) {
        if ("xs:anySimpleType".equals(type)) {
            return DatatypeConverter.parseAnySimpleType((String)value);
        }
        if ("xs:base64Binary".equals(type)) {
            return DatatypeConverter.parseBase64Binary((String)value);
        }
        if ("xs:boolean".equals(type)) {
            return ValueConverter.StringToBoolean(value);
        }
        if ("xs:byte".equals(type)) {
            return DatatypeConverter.parseByte((String)value);
        }
        if ("xs:date".equals(type)) {
            return DatatypeConverter.parseDate((String)value);
        }
        if ("xs:dateTime".equals(type)) {
            return DatatypeConverter.parseDateTime((String)value);
        }
        if ("xs:dayTimeDuration".equals(type)) {
            return Utilities.getDatatypeFactory().newDurationDayTime(value);
        }
        if ("xs:decimal".equals(type)) {
            return DatatypeConverter.parseDecimal((String)value);
        }
        if ("xs:double".equals(type)) {
            return ValueConverter.StringToDouble(value);
        }
        if ("xs:duration".equals(type)) {
            return Utilities.getDatatypeFactory().newDuration(value);
        }
        if ("xs:float".equals(type)) {
            return ValueConverter.StringToFloat(value);
        }
        if ("xs:int".equals(type)) {
            return ValueConverter.StringToInteger(value);
        }
        if ("xs:integer".equals(type)) {
            return DatatypeConverter.parseInteger((String)value);
        }
        if ("xs:long".equals(type)) {
            return ValueConverter.StringToLong(value);
        }
        if ("xs:short".equals(type)) {
            return DatatypeConverter.parseShort((String)value);
        }
        if ("xs:string".equals(type)) {
            return DatatypeConverter.parseString((String)value);
        }
        if ("xs:time".equals(type)) {
            return DatatypeConverter.parseTime((String)value);
        }
        if ("xs:unsignedInt".equals(type)) {
            return DatatypeConverter.parseUnsignedInt((String)value);
        }
        if ("xs:unsignedLong".equals(type)) {
            BigInteger bi = DatatypeConverter.parseInteger((String)value);
            if (bi.compareTo(MAX_UNSIGNED_LONG) < 0) {
                return bi.longValue();
            }
            return bi;
        }
        if ("xs:unsignedShort".equals(type)) {
            return DatatypeConverter.parseUnsignedShort((String)value);
        }
        if ("xs:yearMonthDuration".equals(type)) {
            return Utilities.getDatatypeFactory().newDurationYearMonth(value);
        }
        return value;
    }

    public static <T> T convertToJava(String type, String value, Class<T> as) {
        return (T)ValueConverter.convertToJava(type, value);
    }

    public static String ObjectToString(Object value) {
        return value == null || value instanceof String ? (String)value : value.toString();
    }

    public static Stream<String> ObjectToString(Stream<?> values) {
        return values == null ? null : values.map(ValueConverter::ObjectToString);
    }

    public static String BigDecimalToString(BigDecimal value) {
        return value == null ? null : DatatypeConverter.printDecimal((BigDecimal)value);
    }

    public static Stream<String> BigDecimalToString(Stream<? extends BigDecimal> values) {
        return values == null ? null : values.map(ValueConverter::BigDecimalToString);
    }

    public static BigDecimal StringToBigDecimal(String value) {
        try {
            return value == null || value.length() == 0 ? null : DatatypeConverter.parseDecimal((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to BigDecimal: " + value, e);
        }
    }

    public static Stream<BigDecimal> StringToBigDecimal(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToBigDecimal);
    }

    public static String BooleanToString(Boolean value) {
        return value == null ? null : ValueConverter.BooleanPrimitiveToString(value);
    }

    public static String BooleanPrimitiveToString(boolean value) {
        return DatatypeConverter.printBoolean((boolean)value);
    }

    public static Stream<String> BooleanToString(Stream<? extends Boolean> values) {
        return values == null ? null : values.map(ValueConverter::BooleanToString);
    }

    public static Boolean StringToBoolean(String value) {
        return value == null || value.length() == 0 ? null : Boolean.valueOf(ValueConverter.StringToBooleanPrimitive(value));
    }

    public static boolean StringToBooleanPrimitive(String value) {
        try {
            return DatatypeConverter.parseBoolean((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to boolean: " + value, e);
        }
    }

    public static Stream<Boolean> StringToBoolean(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToBoolean);
    }

    public static String DateToString(Date value) {
        if (value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }

    public static Stream<String> DateToString(Stream<? extends Date> values) {
        return values == null ? null : values.map(ValueConverter::DateToString);
    }

    public static Date StringToDate(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Calendar cal = DatatypeConverter.parseDateTime((String)value);
            return cal.getTime();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to Date: " + value, e);
        }
    }

    public static Stream<Date> StringToDate(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToDate);
    }

    public static String DoubleToString(Double value) {
        return value == null ? null : ValueConverter.DoublePrimitiveToString(value);
    }

    public static String DoublePrimitiveToString(double value) {
        return DatatypeConverter.printDouble((double)value);
    }

    public static Stream<String> DoubleToString(Stream<? extends Double> values) {
        return values == null ? null : values.map(ValueConverter::DoubleToString);
    }

    public static Double StringToDouble(String value) {
        return value == null || value.length() == 0 ? null : Double.valueOf(ValueConverter.StringToDoublePrimitive(value));
    }

    public static double StringToDoublePrimitive(String value) {
        try {
            return DatatypeConverter.parseDouble((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to double: " + value, e);
        }
    }

    public static Stream<Double> StringToDouble(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToDouble);
    }

    public static String DurationToString(java.time.Duration value) {
        return value == null ? null : value.toString();
    }

    public static Stream<String> DurationToString(Stream<? extends java.time.Duration> values) {
        return values == null ? null : values.map(ValueConverter::DurationToString);
    }

    public static java.time.Duration StringToDuration(String value) {
        try {
            return value == null || value.length() == 0 ? null : java.time.Duration.parse(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to Duration: " + value, e);
        }
    }

    public static Stream<java.time.Duration> StringToDuration(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToDuration);
    }

    public static String FloatToString(Float value) {
        return value == null ? null : ValueConverter.FloatPrimitiveToString(value.floatValue());
    }

    public static String FloatPrimitiveToString(float value) {
        return DatatypeConverter.printFloat((float)value);
    }

    public static Stream<String> FloatToString(Stream<? extends Float> values) {
        return values == null ? null : values.map(ValueConverter::FloatToString);
    }

    public static Float StringToFloat(String value) {
        return value == null || value.length() == 0 ? null : Float.valueOf(ValueConverter.StringToFloatPrimitive(value));
    }

    public static float StringToFloatPrimitive(String value) {
        try {
            return DatatypeConverter.parseFloat((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to float: " + value, e);
        }
    }

    public static Stream<Float> StringToFloat(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToFloat);
    }

    public static String IntegerToString(Integer value) {
        return value == null ? null : ValueConverter.IntegerPrimitiveToString(value);
    }

    public static String IntegerPrimitiveToString(int value) {
        return DatatypeConverter.printInt((int)value);
    }

    public static Stream<String> IntegerToString(Stream<? extends Integer> values) {
        return values == null ? null : values.map(ValueConverter::IntegerToString);
    }

    public static Integer StringToInteger(String value) {
        return value == null || value.length() == 0 ? null : Integer.valueOf(ValueConverter.StringToIntegerPrimitive(value));
    }

    public static int StringToIntegerPrimitive(String value) {
        try {
            return DatatypeConverter.parseInt((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to int: " + value, e);
        }
    }

    public static Stream<Integer> StringToInteger(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToInteger);
    }

    public static String LocalDateTimeToString(LocalDateTime value) {
        return value == null ? null : value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static Stream<String> LocalDateTimeToString(Stream<? extends LocalDateTime> values) {
        return values == null ? null : values.map(ValueConverter::LocalDateTimeToString);
    }

    public static LocalDateTime StringToLocalDateTime(String value) {
        try {
            return value == null || value.length() == 0 ? null : DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse((CharSequence)ValueConverter.getInstantPattern().matcher(value).replaceFirst(""), LocalDateTime::from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to LocalDateTime: " + value, e);
        }
    }

    public static Stream<LocalDateTime> StringToLocalDateTime(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToLocalDateTime);
    }

    public static String LocalDateToString(LocalDate value) {
        return value == null ? null : value.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static Stream<String> LocalDateToString(Stream<? extends LocalDate> values) {
        return values == null ? null : values.map(ValueConverter::LocalDateToString);
    }

    public static LocalDate StringToLocalDate(String value) {
        try {
            return value == null || value.length() == 0 ? null : DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)ValueConverter.getInstantPattern().matcher(value).replaceFirst(""), LocalDate::from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to LocalDate: " + value, e);
        }
    }

    public static Stream<LocalDate> StringToLocalDate(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToLocalDate);
    }

    public static String LocalTimeToString(LocalTime value) {
        return value == null ? null : value.format(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static Stream<String> LocalTimeToString(Stream<? extends LocalTime> values) {
        return values == null ? null : values.map(ValueConverter::LocalTimeToString);
    }

    public static LocalTime StringToLocalTime(String value) {
        try {
            return value == null || value.length() == 0 ? null : DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)ValueConverter.getInstantPattern().matcher(value).replaceFirst(""), LocalTime::from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to LocalTime: " + value, e);
        }
    }

    public static Stream<LocalTime> StringToLocalTime(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToLocalTime);
    }

    public static String LongToString(Long value) {
        return value == null ? null : ValueConverter.LongPrimitiveToString(value);
    }

    public static String LongPrimitiveToString(long value) {
        return DatatypeConverter.printLong((long)value);
    }

    public static Stream<String> LongToString(Stream<? extends Long> values) {
        return values == null ? null : values.map(ValueConverter::LongToString);
    }

    public static Long StringToLong(String value) {
        return value == null || value.length() == 0 ? null : Long.valueOf(ValueConverter.StringToLongPrimitive(value));
    }

    public static long StringToLongPrimitive(String value) {
        try {
            return DatatypeConverter.parseLong((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to long: " + value, e);
        }
    }

    public static Stream<Long> StringToLong(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToLong);
    }

    public static String OffsetDateTimeToString(OffsetDateTime value) {
        return value == null ? null : value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static Stream<String> OffsetDateTimeToString(Stream<? extends OffsetDateTime> values) {
        return values == null ? null : values.map(ValueConverter::OffsetDateTimeToString);
    }

    public static OffsetDateTime StringToOffsetDateTime(String value) {
        try {
            return value == null || value.length() == 0 ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)value, OffsetDateTime::from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to OffsetDateTime: " + value, e);
        }
    }

    public static Stream<OffsetDateTime> StringToOffsetDateTime(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToOffsetDateTime);
    }

    public static String OffsetTimeToString(OffsetTime value) {
        return value == null ? null : value.format(DateTimeFormatter.ISO_OFFSET_TIME);
    }

    public static Stream<String> OffsetTimeToString(Stream<? extends OffsetTime> values) {
        return values == null ? null : values.map(ValueConverter::OffsetTimeToString);
    }

    public static OffsetTime StringToOffsetTime(String value) {
        try {
            return value == null || value.length() == 0 ? null : DateTimeFormatter.ISO_OFFSET_TIME.parse((CharSequence)value, OffsetTime::from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to OffsetTime: " + value, e);
        }
    }

    public static Stream<OffsetTime> StringToOffsetTime(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToOffsetTime);
    }

    public static String StringToString(String value) {
        try {
            return value == null || value.length() == 0 ? null : DatatypeConverter.printString((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert: " + value, e);
        }
    }

    public static Stream<String> StringToString(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToString);
    }

    public static String UnsignedIntegerToString(Integer value) {
        return value == null ? null : ValueConverter.UnsignedIntegerPrimitiveToString(value);
    }

    public static String UnsignedIntegerPrimitiveToString(int value) {
        return Integer.toUnsignedString(value);
    }

    public static Stream<String> UnsignedIntegerToString(Stream<? extends Integer> values) {
        return values == null ? null : values.map(ValueConverter::UnsignedIntegerToString);
    }

    public static Integer StringToUnsignedInteger(String value) {
        return value == null || value.length() == 0 ? null : Integer.valueOf(ValueConverter.StringToUnsignedIntegerPrimitive(value));
    }

    public static int StringToUnsignedIntegerPrimitive(String value) {
        try {
            return Integer.parseUnsignedInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to unsigned int: " + value, e);
        }
    }

    public static Stream<Integer> StringToUnsignedInteger(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToUnsignedInteger);
    }

    public static String UnsignedLongToString(Long value) {
        return value == null ? null : ValueConverter.UnsignedLongPrimitiveToString(value);
    }

    public static String UnsignedLongPrimitiveToString(long value) {
        return Long.toUnsignedString(value);
    }

    public static Stream<String> UnsignedLongToString(Stream<? extends Long> values) {
        return values == null ? null : values.map(ValueConverter::UnsignedLongToString);
    }

    public static Long StringToUnsignedLong(String value) {
        return value == null || value.length() == 0 ? null : Long.valueOf(ValueConverter.StringToUnsignedIntegerLong(value));
    }

    public static long StringToUnsignedIntegerLong(String value) {
        try {
            return Long.parseUnsignedLong(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to unsigned long: " + value, e);
        }
    }

    public static Stream<Long> StringToUnsignedLong(Stream<? extends String> values) {
        return values == null ? null : values.map(ValueConverter::StringToUnsignedLong);
    }

    private static Pattern getInstantPattern() {
        if (instantPattern == null) {
            instantPattern = Pattern.compile("Z.*$");
        }
        return instantPattern;
    }

    public static <I> String[] convert(I[] in, Function<I, String> converter) {
        if (in == null) {
            return null;
        }
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    public static interface ValueProcessor {
        public void process(Object var1, String var2, String var3);
    }
}

