/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.SessionState;
import com.marklogic.client.impl.ClientCookie;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;

public class SessionStateImpl
implements SessionState {
    private List<ClientCookie> cookies;
    private String sessionId = Long.toUnsignedString(ThreadLocalRandom.current().nextLong(), 16);
    private AtomicBoolean setCreatedTimestamp;
    private Calendar created;

    public SessionStateImpl() {
        this.cookies = new ArrayList<ClientCookie>();
        this.setCreatedTimestamp = new AtomicBoolean(false);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    List<ClientCookie> getCookies() {
        return this.cookies;
    }

    void setCookies(List<ClientCookie> cookies) {
        if (cookies != null && this.setCreatedTimestamp.compareAndSet(false, true)) {
            for (ClientCookie cookie : cookies) {
                if (cookie.getName().equalsIgnoreCase("SessionId")) continue;
                this.cookies.add(new ClientCookie(cookie));
            }
            this.created = Calendar.getInstance();
        }
    }

    Calendar getCreatedTimestamp() {
        return this.created;
    }
}

