/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.expression.RdfValue;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.XsValueImpl;
import com.marklogic.client.type.RdfLangStringSeqVal;
import com.marklogic.client.type.RdfLangStringVal;
import com.marklogic.client.type.XsAnyAtomicTypeVal;
import com.marklogic.client.type.XsStringVal;
import java.util.Arrays;

public class RdfValueImpl
implements RdfValue {
    @Override
    public RdfLangStringVal langString(String string, String lang) {
        return new RdfLangStringValImpl(string, lang);
    }

    @Override
    public RdfLangStringSeqVal langStringSeq(RdfLangStringVal ... langStrings) {
        return new RdfLangStringSeqValImpl(langStrings);
    }

    static class RdfLangStringValImpl
    extends XsValueImpl.AnyAtomicTypeValImpl
    implements RdfLangStringVal,
    BaseTypeImpl.ParamBinder {
        private String string = null;
        private String lang = null;

        public RdfLangStringValImpl(String string, String lang) {
            super("rdf", "langString");
            if (string == null) {
                throw new IllegalArgumentException("cannot take null string");
            }
            if (lang == null) {
                throw new IllegalArgumentException("cannot take null lang");
            }
            this.string = string;
            this.lang = lang;
        }

        @Override
        public XsAnyAtomicTypeVal[] getAnyAtomicTypeItems() {
            return new XsAnyAtomicTypeVal[]{this};
        }

        @Override
        public String getString() {
            return this.string;
        }

        @Override
        public String getLang() {
            return this.lang;
        }

        @Override
        public RdfLangStringVal[] getLangStringItems() {
            return this.getItems();
        }

        public RdfLangStringVal[] getItems() {
            return new RdfLangStringVal[]{this};
        }

        @Override
        public XsStringVal[] getStringItems() {
            return this.getItems();
        }

        public String toString() {
            return this.getString();
        }

        @Override
        public String getParamQualifier() {
            return "@" + this.getLang();
        }

        @Override
        public String getParamValue() {
            return this.toString();
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            return strb.append("{\"ns\":\"rdf\", \"fn\":\"langString\", \"args\":[\"").append(this.getString()).append("\", \"").append(this.getLang()).append("\"]}");
        }
    }

    static class RdfLangStringSeqValImpl
    extends XsValueImpl.AnyAtomicTypeSeqValImpl<RdfLangStringValImpl>
    implements RdfLangStringSeqVal {
        RdfLangStringSeqValImpl(RdfLangStringVal[] values) {
            this((RdfLangStringValImpl[])Arrays.copyOf(values, values.length, RdfLangStringValImpl[].class));
        }

        RdfLangStringSeqValImpl(RdfLangStringValImpl[] values) {
            super((XsValueImpl.AnyAtomicTypeValImpl[])values);
        }

        @Override
        public RdfLangStringVal[] getLangStringItems() {
            return (RdfLangStringVal[])this.getItems();
        }

        @Override
        public XsStringVal[] getStringItems() {
            return (XsStringVal[])this.getItems();
        }

        @Override
        public XsAnyAtomicTypeVal[] getAnyAtomicTypeItems() {
            return (XsAnyAtomicTypeVal[])this.getItems();
        }
    }
}

