/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.AbstractQueryDefinition;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.query.RawCombinedQueryDefinition;
import com.marklogic.client.query.RawCtsQueryDefinition;
import com.marklogic.client.query.RawQueryByExampleDefinition;
import com.marklogic.client.query.RawQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;

public abstract class RawQueryDefinitionImpl<T extends StructureWriteHandle>
extends AbstractQueryDefinition
implements RawQueryDefinition {
    private T handle;

    RawQueryDefinitionImpl(T handle) {
        this.setHandle((StructureWriteHandle)handle);
    }

    RawQueryDefinitionImpl(T handle, String optionsName) {
        this(handle);
        this.setOptionsName(optionsName);
    }

    public String serialize() {
        if (this.handle == null) {
            return "";
        }
        return HandleAccessor.contentAsString(this.handle);
    }

    public T getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(StructureWriteHandle handle) {
        this.handle = handle;
    }

    public String toString() {
        if (this.handle == null) {
            return "";
        }
        return this.handle.toString();
    }

    public static class ByExample
    extends RawQueryDefinitionImpl<StructureWriteHandle>
    implements RawQueryByExampleDefinition {
        ByExample(StructureWriteHandle handle) {
            super(handle);
        }

        ByExample(StructureWriteHandle handle, String optionsName) {
            super(handle, optionsName);
        }

        @Override
        public RawQueryByExampleDefinition withHandle(StructureWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    public static class CtsQuery
    extends RawCriteriaQueryImpl<CtsQueryWriteHandle>
    implements RawCtsQueryDefinition {
        public CtsQuery(CtsQueryWriteHandle handle) {
            super(handle);
        }

        public CtsQuery(CtsQueryWriteHandle handle, String optionsName) {
            super(handle, optionsName);
        }

        @Override
        public RawCtsQueryDefinition withCriteria(String criteria) {
            this.setCriteria(criteria);
            return this;
        }

        @Override
        public void setHandle(StructureWriteHandle handle) {
            if (handle != null && !(handle instanceof CtsQueryWriteHandle)) {
                throw new IllegalArgumentException("handle must be an instance of CtsQueryWriteHandle instead of: " + handle.getClass().getCanonicalName());
            }
            super.setHandle((CtsQueryWriteHandle)handle);
        }

        @Override
        public RawCtsQueryDefinition withHandle(StructureWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    public static class Structured
    extends RawCriteriaQueryImpl<StructureWriteHandle>
    implements RawStructuredQueryDefinition {
        public Structured(StructureWriteHandle handle) {
            super(handle);
        }

        public Structured(StructureWriteHandle handle, String optionsName) {
            super(handle, optionsName);
        }

        @Override
        public RawStructuredQueryDefinition withHandle(StructureWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }

        @Override
        public RawStructuredQueryDefinition withCriteria(String criteria) {
            this.setCriteria(criteria);
            return this;
        }
    }

    static abstract class RawCriteriaQueryImpl<T extends StructureWriteHandle>
    extends RawQueryDefinitionImpl<T> {
        private String criteria = null;

        public RawCriteriaQueryImpl(T handle) {
            super(handle);
        }

        public RawCriteriaQueryImpl(T handle, String optionsName) {
            super(handle, optionsName);
        }

        public String getCriteria() {
            return this.criteria;
        }

        public void setCriteria(String criteria) {
            this.criteria = criteria;
        }
    }

    public static class Combined
    extends RawQueryDefinitionImpl<StructureWriteHandle>
    implements RawCombinedQueryDefinition {
        Combined(StructureWriteHandle handle) {
            super(handle);
        }

        Combined(StructureWriteHandle handle, String optionsName) {
            super(handle, optionsName);
        }

        @Override
        public RawCombinedQueryDefinition withHandle(StructureWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }
}

