/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.FailedRetryException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.ResourceNotResendableException;
import com.marklogic.client.SessionState;
import com.marklogic.client.Transaction;
import com.marklogic.client.bitemporal.TemporalDescriptor;
import com.marklogic.client.bitemporal.TemporalDocumentManager;
import com.marklogic.client.document.ContentDescriptor;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.document.DocumentUriTemplate;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.eval.EvalResult;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.impl.BasicPage;
import com.marklogic.client.impl.ClientCookie;
import com.marklogic.client.impl.CombinedQueryBuilderImpl;
import com.marklogic.client.impl.CombinedQueryDefinition;
import com.marklogic.client.impl.DocumentDescriptorImpl;
import com.marklogic.client.impl.FailedRequest;
import com.marklogic.client.impl.HTTPBasicAuthInterceptor;
import com.marklogic.client.impl.HTTPKerberosAuthInterceptor;
import com.marklogic.client.impl.HTTPSamlAuthInterceptor;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.RawQueryDefinitionImpl;
import com.marklogic.client.impl.ServerEvaluationCallImpl;
import com.marklogic.client.impl.SessionStateImpl;
import com.marklogic.client.impl.StreamingOutputImpl;
import com.marklogic.client.impl.TransactionImpl;
import com.marklogic.client.impl.UrisReadHandle;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.JacksonParserHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.ReaderHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.io.marker.DocumentPatchHandle;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.query.DeleteQueryDefinition;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.RawCombinedQueryDefinition;
import com.marklogic.client.query.RawCtsQueryDefinition;
import com.marklogic.client.query.RawQueryByExampleDefinition;
import com.marklogic.client.query.RawQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.client.query.SuggestDefinition;
import com.marklogic.client.query.ValueQueryDefinition;
import com.marklogic.client.query.ValuesDefinition;
import com.marklogic.client.query.ValuesListDefinition;
import com.marklogic.client.semantics.Capability;
import com.marklogic.client.semantics.GraphPermissions;
import com.marklogic.client.semantics.SPARQLBinding;
import com.marklogic.client.semantics.SPARQLBindings;
import com.marklogic.client.semantics.SPARQLQueryDefinition;
import com.marklogic.client.semantics.SPARQLRuleset;
import com.marklogic.client.util.EditableNamespaceContext;
import com.marklogic.client.util.RequestLogger;
import com.marklogic.client.util.RequestParameters;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpServices
implements RESTServices {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpServices.class);
    public static final String OKHTTP_LOGGINGINTERCEPTOR_LEVEL = "com.marklogic.client.okhttp.httplogginginterceptor.level";
    public static final String OKHTTP_LOGGINGINTERCEPTOR_OUTPUT = "com.marklogic.client.okhttp.httplogginginterceptor.output";
    private static final String DOCUMENT_URI_PREFIX = "/documents?uri=";
    private static final int DELAY_FLOOR = 125;
    private static final int DELAY_CEILING = 2000;
    private static final int DELAY_MULTIPLIER = 20;
    private static final int DEFAULT_MAX_DELAY = 120000;
    private static final int DEFAULT_MIN_RETRY = 8;
    private static final MediaType URLENCODED_MIME_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded; charset=UTF-8");
    private static final String UTF8_ID = StandardCharsets.UTF_8.toString();
    private static final ConnectionPool connectionPool = new ConnectionPool();
    private DatabaseClient databaseClient;
    private String database = null;
    private HttpUrl baseUri;
    private OkHttpClient client;
    private boolean released = false;
    private DatabaseClientFactory.Authentication type = null;
    private Random randRetry = new Random();
    private int maxDelay = 120000;
    private int minRetry = 8;
    private boolean checkFirstRequest = true;
    private Set<Integer> retryStatus = new HashSet<Integer>();
    private final ThreadLocal<ThreadState> threadState = new ThreadLocal<ThreadState>(){

        @Override
        protected ThreadState initialValue() {
            return new ThreadState(OkHttpServices.this.checkFirstRequest);
        }
    };

    public OkHttpServices() {
        this.retryStatus.add(502);
        this.retryStatus.add(503);
        this.retryStatus.add(504);
    }

    @Override
    public Set<Integer> getRetryStatus() {
        return this.retryStatus;
    }

    @Override
    public int getMaxDelay() {
        return this.maxDelay;
    }

    @Override
    public void setMaxDelay(int maxDelay) {
        this.maxDelay = maxDelay;
    }

    private FailedRequest extractErrorFields(Response response) {
        if (response == null) {
            return null;
        }
        try {
            if (response.code() == 401) {
                FailedRequest failure = new FailedRequest();
                failure.setMessageString("Unauthorized");
                failure.setStatusString("Failed Auth");
                FailedRequest failedRequest = failure;
                return failedRequest;
            }
            String responseBody = OkHttpServices.getEntity(response.body(), String.class);
            ByteArrayInputStream is = new ByteArrayInputStream(responseBody.getBytes("UTF-8"));
            FailedRequest handler = FailedRequest.getFailedRequest(response.code(), response.header("Content-Type"), is);
            if (handler.getMessage() == null) {
                handler.setMessageString(responseBody);
            }
            FailedRequest failedRequest = handler;
            return failedRequest;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported", e);
        }
        finally {
            OkHttpServices.closeResponse(response);
        }
    }

    @Override
    public void connect(String host, int port, String database, DatabaseClientFactory.SecurityContext securityContext) {
        int min;
        String minRetryStr;
        int max;
        String maxDelayStr;
        Properties props;
        SSLContext sslContext = null;
        DatabaseClientFactory.SSLHostnameVerifier sslVerifier = null;
        X509TrustManager trustManager = null;
        if (host == null) {
            throw new IllegalArgumentException("No host provided");
        }
        OkHttpClient.Builder clientBldr = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).connectionPool(connectionPool).cookieJar(CookieJar.NO_COOKIES).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS);
        if (securityContext instanceof DatabaseClientFactory.BasicAuthContext) {
            DatabaseClientFactory.BasicAuthContext basicContext = (DatabaseClientFactory.BasicAuthContext)securityContext;
            if (basicContext.getSSLContext() != null) {
                sslContext = basicContext.getSSLContext();
                if (basicContext.getTrustManager() != null) {
                    trustManager = basicContext.getTrustManager();
                }
            }
            clientBldr = this.configureAuthentication(basicContext, clientBldr);
        } else if (securityContext instanceof DatabaseClientFactory.DigestAuthContext) {
            DatabaseClientFactory.DigestAuthContext digestContext = (DatabaseClientFactory.DigestAuthContext)securityContext;
            if (digestContext.getSSLContext() != null) {
                sslContext = digestContext.getSSLContext();
                if (digestContext.getTrustManager() != null) {
                    trustManager = digestContext.getTrustManager();
                }
            }
            clientBldr = this.configureAuthentication((DatabaseClientFactory.DigestAuthContext)securityContext, clientBldr);
        } else if (securityContext instanceof DatabaseClientFactory.KerberosAuthContext) {
            DatabaseClientFactory.KerberosAuthContext kerberosContext = (DatabaseClientFactory.KerberosAuthContext)securityContext;
            if (kerberosContext.getSSLContext() != null) {
                sslContext = kerberosContext.getSSLContext();
                if (kerberosContext.getTrustManager() != null) {
                    trustManager = kerberosContext.getTrustManager();
                }
            }
            clientBldr = this.configureAuthentication(kerberosContext, host, clientBldr);
        } else if (securityContext instanceof DatabaseClientFactory.CertificateAuthContext) {
            DatabaseClientFactory.CertificateAuthContext certificateContext = (DatabaseClientFactory.CertificateAuthContext)securityContext;
            this.type = DatabaseClientFactory.Authentication.CERTIFICATE;
            sslContext = certificateContext.getSSLContext();
            if (certificateContext.getTrustManager() != null) {
                trustManager = certificateContext.getTrustManager();
            }
            this.checkFirstRequest = false;
        } else if (securityContext instanceof DatabaseClientFactory.SAMLAuthContext) {
            DatabaseClientFactory.SAMLAuthContext samlAuthContext = (DatabaseClientFactory.SAMLAuthContext)securityContext;
            if (samlAuthContext.getSSLContext() != null) {
                sslContext = samlAuthContext.getSSLContext();
                if (samlAuthContext.getTrustManager() != null) {
                    trustManager = samlAuthContext.getTrustManager();
                }
            }
            clientBldr = this.configureAuthentication(samlAuthContext, clientBldr);
        } else {
            throw new IllegalArgumentException("securityContext must be of type BasicAuthContext, DigestAuthContext, KerberosAuthContext, CertificateAuthContext or SAMLAuthContext");
        }
        if (securityContext.getSSLContext() != null || securityContext instanceof DatabaseClientFactory.CertificateAuthContext) {
            sslVerifier = securityContext.getSSLHostnameVerifier() != null ? securityContext.getSSLHostnameVerifier() : DatabaseClientFactory.SSLHostnameVerifier.COMMON;
        }
        HostnameVerifier hostnameVerifier = null;
        if (sslVerifier == DatabaseClientFactory.SSLHostnameVerifier.ANY) {
            hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
        } else if (sslVerifier == DatabaseClientFactory.SSLHostnameVerifier.COMMON || sslVerifier == DatabaseClientFactory.SSLHostnameVerifier.STRICT) {
            hostnameVerifier = null;
        } else if (sslVerifier != null) {
            hostnameVerifier = new DatabaseClientFactory.SSLHostnameVerifier.HostnameVerifierAdapter(sslVerifier);
        }
        this.database = database;
        this.baseUri = new HttpUrl.Builder().scheme(sslContext == null ? "http" : "https").host(host).port(port).encodedPath("/v1/ping").build();
        if (sslContext != null) {
            if (trustManager == null) {
                String javaVersion = System.getProperty("java.version");
                int javaMajorVersion = Integer.parseInt(javaVersion.substring(0, javaVersion.indexOf(".")));
                if (javaMajorVersion < 9) {
                    clientBldr.sslSocketFactory(sslContext.getSocketFactory());
                } else {
                    try {
                        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustMgrFactory.init((KeyStore)null);
                        TrustManager[] trustMgrs = trustMgrFactory.getTrustManagers();
                        if (trustMgrs == null || trustMgrs.length == 0) {
                            throw new IllegalArgumentException("no trust manager and could not get default trust manager");
                        }
                        if (!(trustMgrs[0] instanceof X509TrustManager)) {
                            throw new IllegalArgumentException("no trust manager and default is not an X509TrustManager");
                        }
                        trustManager = (X509TrustManager)trustMgrs[0];
                        sslContext.init(null, trustMgrs, null);
                        clientBldr.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
                    }
                    catch (KeyStoreException e) {
                        throw new IllegalArgumentException("no trust manager and cannot initialize factory for default", e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalArgumentException("no trust manager and no algorithm for default manager", e);
                    }
                    catch (KeyManagementException e) {
                        throw new IllegalArgumentException("no trust manager and cannot initialize context with default", e);
                    }
                }
            } else {
                clientBldr.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
        }
        if (hostnameVerifier != null) {
            clientBldr = clientBldr.hostnameVerifier(hostnameVerifier);
        }
        if ((props = System.getProperties()).containsKey(OKHTTP_LOGGINGINTERCEPTOR_LEVEL)) {
            final boolean useLogger = "LOGGER".equalsIgnoreCase(props.getProperty(OKHTTP_LOGGINGINTERCEPTOR_OUTPUT));
            final boolean useStdErr = "STDERR".equalsIgnoreCase(props.getProperty(OKHTTP_LOGGINGINTERCEPTOR_OUTPUT));
            HttpLoggingInterceptor networkInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

                public void log(String message) {
                    if (useLogger) {
                        logger.debug(message);
                    } else if (useStdErr) {
                        System.err.println(message);
                    } else {
                        System.out.println(message);
                    }
                }
            });
            if ("BASIC".equalsIgnoreCase(props.getProperty(OKHTTP_LOGGINGINTERCEPTOR_LEVEL))) {
                networkInterceptor = networkInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            } else if ("BODY".equalsIgnoreCase(props.getProperty(OKHTTP_LOGGINGINTERCEPTOR_LEVEL))) {
                networkInterceptor = networkInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            } else if ("HEADERS".equalsIgnoreCase(props.getProperty(OKHTTP_LOGGINGINTERCEPTOR_LEVEL))) {
                networkInterceptor = networkInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
            } else if ("NONE".equalsIgnoreCase(props.getProperty(OKHTTP_LOGGINGINTERCEPTOR_LEVEL))) {
                networkInterceptor = networkInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
            clientBldr = clientBldr.addNetworkInterceptor((Interceptor)networkInterceptor);
        }
        if (props.containsKey("com.marklogic.client.maximumRetrySeconds") && (maxDelayStr = props.getProperty("com.marklogic.client.maximumRetrySeconds")) != null && maxDelayStr.length() > 0 && (max = Integer.parseInt(maxDelayStr)) > 0) {
            this.maxDelay = max * 1000;
        }
        if (props.containsKey("com.marklogic.client.minimumRetries") && (minRetryStr = props.getProperty("com.marklogic.client.minimumRetries")) != null && minRetryStr.length() > 0 && (min = Integer.parseInt(minRetryStr)) > 0) {
            this.minRetry = min;
        }
        this.client = clientBldr.build();
    }

    public OkHttpClient.Builder configureAuthentication(DatabaseClientFactory.BasicAuthContext basicAuthContext, OkHttpClient.Builder clientBuilder) {
        String user = basicAuthContext.getUser();
        String password = basicAuthContext.getPassword();
        this.type = DatabaseClientFactory.Authentication.BASIC;
        if (user == null) {
            throw new IllegalArgumentException("No user provided");
        }
        if (password == null) {
            throw new IllegalArgumentException("No password provided");
        }
        Credentials credentials = new Credentials(user, password);
        OkHttpClient.Builder builder = clientBuilder;
        HTTPBasicAuthInterceptor interceptor = new HTTPBasicAuthInterceptor(credentials);
        this.checkFirstRequest = false;
        if (interceptor != null) {
            builder.addInterceptor((Interceptor)interceptor);
        }
        return builder;
    }

    public OkHttpClient.Builder configureAuthentication(DatabaseClientFactory.DigestAuthContext digestAuthContext, OkHttpClient.Builder clientBuilder) {
        OkHttpClient.Builder builder = clientBuilder;
        String user = digestAuthContext.getUser();
        String password = digestAuthContext.getPassword();
        this.type = DatabaseClientFactory.Authentication.DIGEST;
        if (user == null) {
            throw new IllegalArgumentException("No user provided");
        }
        if (password == null) {
            throw new IllegalArgumentException("No password provided");
        }
        Credentials credentials = new Credentials(user, password);
        ConcurrentHashMap authCache = new ConcurrentHashMap();
        DigestAuthenticator authenticator = new DigestAuthenticator(credentials);
        AuthenticationCacheInterceptor interceptor = new AuthenticationCacheInterceptor(authCache);
        this.checkFirstRequest = true;
        if (authenticator != null) {
            builder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)authenticator, authCache));
        }
        if (interceptor != null) {
            builder.addInterceptor((Interceptor)interceptor);
        }
        return builder;
    }

    public OkHttpClient.Builder configureAuthentication(DatabaseClientFactory.KerberosAuthContext keberosAuthContext, String host, OkHttpClient.Builder clientBuilder) {
        this.type = DatabaseClientFactory.Authentication.KERBEROS;
        Map<String, String> kerberosOptions = keberosAuthContext.getKrbOptions();
        HTTPKerberosAuthInterceptor interceptor = new HTTPKerberosAuthInterceptor(host, kerberosOptions);
        this.checkFirstRequest = false;
        OkHttpClient.Builder builder = clientBuilder;
        if (interceptor != null) {
            builder.addInterceptor((Interceptor)interceptor);
        }
        return builder;
    }

    public OkHttpClient.Builder configureAuthentication(DatabaseClientFactory.SAMLAuthContext samlAuthContext, OkHttpClient.Builder clientBuilder) {
        this.type = DatabaseClientFactory.Authentication.SAML;
        HTTPSamlAuthInterceptor interceptor = null;
        String authorizationTokenValue = samlAuthContext.getToken();
        if (authorizationTokenValue != null && authorizationTokenValue.length() > 0) {
            interceptor = new HTTPSamlAuthInterceptor(authorizationTokenValue);
        } else if (samlAuthContext.getAuthorizer() != null) {
            interceptor = new HTTPSamlAuthInterceptor(samlAuthContext.getAuthorizer());
        } else if (samlAuthContext.getRenewer() != null) {
            interceptor = new HTTPSamlAuthInterceptor(samlAuthContext.getAuthorization(), samlAuthContext.getRenewer());
        } else {
            throw new IllegalArgumentException("Either a call back or renewer expected.");
        }
        this.checkFirstRequest = false;
        OkHttpClient.Builder builder = clientBuilder;
        if (interceptor != null) {
            builder.addInterceptor((Interceptor)interceptor);
        }
        return builder;
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    @Override
    public void setDatabaseClient(DatabaseClient client) {
        this.databaseClient = client;
    }

    private OkHttpClient getConnection() {
        if (this.client != null) {
            return this.client;
        }
        if (this.released) {
            throw new IllegalStateException("You cannot use this connected object anymore--connection has already been released");
        }
        throw new MarkLogicInternalException("Cannot proceed--connection is null for unknown reason");
    }

    @Override
    public void release() {
        if (this.client == null) {
            return;
        }
        try {
            this.released = true;
            this.client.dispatcher().executorService().shutdownNow();
        }
        finally {
            try {
                if (this.client.cache() != null) {
                    this.client.cache().close();
                }
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
            finally {
                this.client = null;
                logger.debug("Releasing connection");
            }
        }
    }

    private boolean isFirstRequest() {
        return this.threadState.get().isFirstRequest;
    }

    private void setFirstRequest(boolean value) {
        this.threadState.get().isFirstRequest = value;
    }

    private void checkFirstRequest() {
        if (this.checkFirstRequest) {
            this.setFirstRequest(true);
        }
    }

    private int makeFirstRequest(int retry) {
        return this.makeFirstRequest(this.baseUri, "ping", retry);
    }

    private int makeFirstRequest(HttpUrl requestUri, String path, int retry) {
        Response response = this.sendRequestOnce(this.setupRequest(requestUri, path, null).head());
        int statusCode = response.code();
        if (!this.retryStatus.contains(statusCode)) {
            OkHttpServices.closeResponse(response);
            return 0;
        }
        String retryAfterRaw = response.header("Retry-After");
        OkHttpServices.closeResponse(response);
        int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
        return Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
    }

    private RequestParameters addTemporalProtectionParams(RequestParameters params, String uri, TemporalDocumentManager.ProtectionLevel level, String duration, Calendar expiryTime, String archivePath) {
        if (params == null) {
            params = new RequestParameters();
        }
        params.add("uri", uri);
        params.add("level", level.toString());
        if (duration != null) {
            params.add("duration", duration);
        }
        if (expiryTime != null) {
            String formattedSystemTime = DatatypeConverter.printDateTime((Calendar)expiryTime);
            params.add("expireTime", formattedSystemTime);
        }
        if (archivePath != null) {
            params.add("archivePath", archivePath);
        }
        return params;
    }

    @Override
    public String advanceLsqt(RequestLogger reqlog, String temporalCollection, long lag) {
        if (logger.isDebugEnabled()) {
            logger.debug("Advancing LSQT in temporal collection {}", (Object)temporalCollection);
        }
        this.logRequest(reqlog, "wiped %s document", temporalCollection);
        RequestParameters params = new RequestParameters();
        params.add("result", "advance-lsqt");
        if (lag > 0L) {
            params.add("lag", String.valueOf(lag));
        }
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.postResource(reqlog, "temporal/collections/" + temporalCollection, null, params, null, null, "advanceLsqt", headers);
        List values = (List)headers.get("ML-LSQT");
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        throw new FailedRequestException("Response missing header \"ML-LSQT\"");
    }

    @Override
    public void protectDocument(RequestLogger requestLogger, String temporalDocumentURI, Transaction transaction, RequestParameters extraParams, TemporalDocumentManager.ProtectionLevel level, String duration, Calendar expiryTime, String archivePath) {
        if (temporalDocumentURI == null) {
            throw new IllegalArgumentException("Document protection for document identifier without uri");
        }
        extraParams = this.addTemporalProtectionParams(extraParams, temporalDocumentURI, level, duration, expiryTime, archivePath);
        if (logger.isDebugEnabled()) {
            logger.debug("Protecting {} in transaction {}", (Object)temporalDocumentURI, (Object)OkHttpServices.getTransactionId(transaction));
        }
        this.postResource(requestLogger, "documents/protection", transaction, extraParams, null, null, "protect");
    }

    @Override
    public void wipeDocument(RequestLogger reqlog, String temporalDocumentURI, Transaction transaction, RequestParameters extraParams) {
        if (logger.isDebugEnabled()) {
            logger.debug("Wiping {} in transaction {}", (Object)temporalDocumentURI, (Object)OkHttpServices.getTransactionId(transaction));
        }
        extraParams.add("result", "wiped");
        extraParams.add("uri", temporalDocumentURI);
        this.deleteResource(reqlog, "documents", transaction, extraParams, null);
        this.logRequest(reqlog, "wiped %s document", temporalDocumentURI);
    }

    @Override
    public TemporalDescriptor deleteDocument(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        String uri = desc.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Document delete for document identifier without uri");
        }
        logger.debug("Deleting {} in transaction {}", (Object)uri, (Object)OkHttpServices.getTransactionId(transaction));
        Request.Builder requestBldr = this.makeDocumentResource(this.makeDocumentParams(uri, categories, transaction, extraParams));
        requestBldr = OkHttpServices.addVersionHeader(desc, requestBldr, "If-Match");
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doDeleteFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.delete().build());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doDeleteFunction, null);
        int status = response.code();
        if (status == 404) {
            OkHttpServices.closeResponse(response);
            throw new ResourceNotFoundException("Could not delete non-existent document");
        }
        if (status == 428) {
            FailedRequest failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTNOVERSION")) {
                throw new FailedRequestException("Content version required to delete document", failure);
            }
            throw new FailedRequestException("Precondition required to delete document", failure);
        }
        if (status == 403) {
            FailedRequest failure = this.extractErrorFields(response);
            throw new ForbiddenUserException("User is not allowed to delete documents", failure);
        }
        if (status == 412) {
            FailedRequest failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTWRONGVERSION")) {
                throw new FailedRequestException("Content version must match to delete document", failure);
            }
            if (failure.getMessageCode().equals("RESTAPI-EMPTYBODY")) {
                throw new FailedRequestException("Empty request body sent to server", failure);
            }
            throw new FailedRequestException("Precondition Failed", failure);
        }
        if (status != 204) {
            throw new FailedRequestException("delete failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        Headers responseHeaders = response.headers();
        TemporalDescriptor temporalDesc = OkHttpServices.updateTemporalSystemTime(desc, responseHeaders);
        OkHttpServices.closeResponse(response);
        this.logRequest(reqlog, "deleted %s document", uri);
        return temporalDesc;
    }

    @Override
    public boolean getDocument(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, DocumentMetadataReadHandle metadataHandle, AbstractReadHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        HandleImplementation contentBase = HandleAccessor.checkHandle(contentHandle, "content");
        String metadataFormat = null;
        String metadataMimetype = null;
        if (metadataBase != null) {
            metadataFormat = metadataBase.getFormat().toString().toLowerCase();
            metadataMimetype = metadataBase.getMimetype();
        }
        String contentMimetype = null;
        if (contentBase != null) {
            contentMimetype = contentBase.getMimetype();
        }
        if (metadataBase != null && contentBase != null) {
            return this.getDocumentImpl(reqlog, desc, transaction, categories, extraParams, metadataFormat, metadataHandle, contentHandle);
        }
        if (metadataBase != null) {
            return this.getDocumentImpl(reqlog, desc, transaction, categories, extraParams, metadataMimetype, metadataHandle);
        }
        if (contentBase != null) {
            return this.getDocumentImpl(reqlog, desc, transaction, null, extraParams, contentMimetype, contentHandle);
        }
        return false;
    }

    private int getRetryAfterTime(Response response) {
        String retryAfterRaw = response.header("Retry-After");
        return retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
    }

    private Response sendRequestOnce(Request.Builder requestBldr) {
        return this.sendRequestOnce(requestBldr.build());
    }

    private Response sendRequestOnce(Request request) {
        try {
            return this.getConnection().newCall(request).execute();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    private Response sendRequestWithRetry(Request.Builder requestBldr, Function<Request.Builder, Response> doFunction, Consumer<Boolean> resendableConsumer) {
        return this.sendRequestWithRetry(requestBldr, true, doFunction, resendableConsumer);
    }

    private Response sendRequestWithRetry(Request.Builder requestBldr, boolean isRetryable, Function<Request.Builder, Response> doFunction, Consumer<Boolean> resendableConsumer) {
        int retry;
        Response response = null;
        int status = -1;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((response = doFunction.apply(requestBldr)) == null) {
                throw new MarkLogicInternalException("null response for: " + requestBldr.build().url().toString());
            }
            status = response.code();
            if (!isRetryable || !this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            OkHttpServices.closeResponse(response);
            if (resendableConsumer != null) {
                resendableConsumer.accept(null);
            }
            nextDelay = Math.max(this.getRetryAfterTime(response), this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        return response;
    }

    private boolean getDocumentImpl(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, String mimetype, AbstractReadHandle handle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        Object entity;
        Function<Request.Builder, Response> doGetFunction;
        Response response;
        int status;
        String uri = desc.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Document read for document identifier without uri");
        }
        logger.debug("Getting {} in transaction {}", (Object)uri, (Object)OkHttpServices.getTransactionId(transaction));
        this.addPointInTimeQueryParam(extraParams, handle);
        Request.Builder requestBldr = this.makeDocumentResource(this.makeDocumentParams(uri, categories, transaction, extraParams));
        if (mimetype != null) {
            requestBldr = requestBldr.header("Accept", mimetype);
        }
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        if (extraParams != null && extraParams.containsKey("range")) {
            requestBldr = requestBldr.header("range", (String)extraParams.get("range").get(0));
        }
        if ((status = (response = this.sendRequestWithRetry(requestBldr = OkHttpServices.addVersionHeader(desc, requestBldr, "If-None-Match"), transaction == null, doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.get().build());
            }
        }, null)).code()) == 404) {
            throw new ResourceNotFoundException("Could not read non-existent document", this.extractErrorFields(response));
        }
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to read documents", this.extractErrorFields(response));
        }
        if (status == 304) {
            OkHttpServices.closeResponse(response);
            return false;
        }
        if (status != 200 && status != 206) {
            throw new FailedRequestException("read failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s document from %s transaction with %s mime type and %s metadata categories", uri, transaction != null ? transaction.getTransactionId() : "no", mimetype != null ? mimetype : "no", this.stringJoin(categories, ", ", "no"));
        HandleImplementation handleBase = HandleAccessor.as(handle);
        Headers responseHeaders = response.headers();
        if (OkHttpServices.isExternalDescriptor(desc)) {
            OkHttpServices.updateVersion(desc, responseHeaders);
            OkHttpServices.updateDescriptor(desc, responseHeaders);
            OkHttpServices.copyDescriptor(desc, handleBase);
        } else {
            OkHttpServices.updateDescriptor(handleBase, responseHeaders);
        }
        Class as = handleBase.receiveAs();
        ResponseBody body = response.body();
        Object v0 = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, as) : null;
        if (entity == null || !InputStream.class.isAssignableFrom(as) && !Reader.class.isAssignableFrom(as)) {
            OkHttpServices.closeResponse(response);
        }
        handleBase.receiveContent(reqlog != null ? reqlog.copyContent(entity) : entity);
        return true;
    }

    @Override
    public DocumentPage getBulkDocuments(RequestLogger reqlog, long serverTimestamp, Transaction transaction, Set<DocumentManager.Metadata> categories, Format format, RequestParameters extraParams, boolean withContent, String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        boolean hasMetadata = categories != null && categories.size() > 0;
        OkHttpResultIterator iterator = this.getBulkDocumentsImpl(reqlog, serverTimestamp, transaction, categories, format, extraParams, withContent, uris);
        return new OkHttpDocumentPage(iterator, withContent, hasMetadata);
    }

    @Override
    public DocumentPage getBulkDocuments(RequestLogger reqlog, long serverTimestamp, QueryDefinition querydef, long start, long pageLength, Transaction transaction, SearchReadHandle searchHandle, QueryManager.QueryView view, Set<DocumentManager.Metadata> categories, Format format, ServerTransform responseTransform, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        boolean hasMetadata = categories != null && categories.size() > 0;
        boolean hasContent = true;
        OkHttpResultIterator iterator = this.getBulkDocumentsImpl(reqlog, serverTimestamp, querydef, start, pageLength, transaction, searchHandle, view, categories, format, responseTransform, extraParams);
        return new OkHttpDocumentPage(iterator, hasContent, hasMetadata);
    }

    private OkHttpResultIterator getBulkDocumentsImpl(RequestLogger reqlog, long serverTimestamp, Transaction transaction, Set<DocumentManager.Metadata> categories, Format format, RequestParameters extraParams, boolean withContent, String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        String path = "documents";
        RequestParameters params = new RequestParameters();
        if (extraParams != null) {
            params.putAll(extraParams);
        }
        if (serverTimestamp != -1L) {
            params.add("timestamp", Long.toString(serverTimestamp));
        }
        this.addCategoryParams(categories, params, withContent);
        if (format != null) {
            params.add("format", format.toString().toLowerCase());
        }
        for (String uri : uris) {
            if (uri == null || uri.length() <= 0) continue;
            params.add("uri", uri);
        }
        DefaultOkHttpResultIterator iterator = this.getIteratedResourceImpl(DefaultOkHttpResultIterator::new, reqlog, path, transaction, params, "multipart/mixed");
        if (iterator != null) {
            if (iterator.getStart() == -1L) {
                iterator.setStart(1L);
            }
            if (iterator.getSize() != -1L) {
                if (iterator.getPageSize() == -1L) {
                    iterator.setPageSize(iterator.getSize());
                }
                if (iterator.getTotalSize() == -1L) {
                    iterator.setTotalSize(iterator.getSize());
                }
            }
        }
        return iterator;
    }

    private OkHttpResultIterator getBulkDocumentsImpl(RequestLogger reqlog, long serverTimestamp, QueryDefinition querydef, long start, long pageLength, Transaction transaction, SearchReadHandle searchHandle, QueryManager.QueryView view, Set<DocumentManager.Metadata> categories, Format format, ServerTransform responseTransform, RequestParameters extraParams) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        try {
            OkHttpSearchRequest request;
            Response response;
            RequestParameters params = new RequestParameters();
            if (extraParams != null) {
                params.putAll(extraParams);
            }
            boolean withContent = true;
            this.addCategoryParams(categories, params, withContent);
            if (searchHandle != null && view != null) {
                params.add("view", view.toString().toLowerCase());
            }
            if (start > 1L) {
                params.add("start", Long.toString(start));
            }
            if (pageLength >= 0L) {
                params.add("pageLength", Long.toString(pageLength));
            }
            if (serverTimestamp != -1L) {
                params.add("timestamp", Long.toString(serverTimestamp));
            }
            this.addPointInTimeQueryParam(params, searchHandle);
            if (format != null) {
                params.add("format", format.toString().toLowerCase());
            }
            HandleImplementation handleBase = HandleAccessor.as(searchHandle);
            if (format == null && searchHandle != null) {
                if (Format.XML == handleBase.getFormat()) {
                    params.add("format", "xml");
                } else if (Format.JSON == handleBase.getFormat()) {
                    params.add("format", "json");
                }
            }
            if ((response = (request = this.generateSearchRequest(reqlog, querydef, "multipart/mixed", transaction, responseTransform, params, null)).getResponse()) == null) {
                return null;
            }
            MimeMultipart entity = null;
            if (searchHandle != null) {
                OkHttpServices.updateServerTimestamp((ContentDescriptor)handleBase, response.headers());
                ResponseBody body = response.body();
                if (body.contentLength() != 0L && (entity = OkHttpServices.getEntity(body, MimeMultipart.class)) != null) {
                    List<BodyPart> partList = OkHttpServices.getPartList(entity);
                    if (entity.getCount() > 0) {
                        BodyPart searchResponsePart = entity.getBodyPart(0);
                        handleBase.receiveContent(OkHttpServices.getEntity(searchResponsePart, handleBase.receiveAs()));
                        partList = partList.subList(1, partList.size());
                    }
                    Response closeable = response;
                    return this.makeResults(OkHttpServiceResultIterator::new, reqlog, "read", "resource", partList, response, (Closeable)closeable);
                }
            }
            return this.makeResults(OkHttpServiceResultIterator::new, reqlog, "read", "resource", response);
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    private boolean getDocumentImpl(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, String metadataFormat, DocumentMetadataReadHandle metadataHandle, AbstractReadHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        String uri = desc.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Document read for document identifier without uri");
        }
        assert (metadataHandle != null) : "metadataHandle is null";
        assert (contentHandle != null) : "contentHandle is null";
        logger.debug("Getting multipart for {} in transaction {}", (Object)uri, (Object)OkHttpServices.getTransactionId(transaction));
        this.addPointInTimeQueryParam(extraParams, contentHandle);
        RequestParameters docParams = this.makeDocumentParams(uri, categories, transaction, extraParams, true);
        docParams.add("format", metadataFormat);
        Request.Builder requestBldr = this.makeDocumentResource(docParams);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        requestBldr = OkHttpServices.addVersionHeader(desc, requestBldr, "If-None-Match");
        Function<Request.Builder, Response> doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.addHeader("Accept", OkHttpServices.this.multipartMixedWithBoundary()).get());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doGetFunction, null);
        int status = response.code();
        if (status == 404) {
            throw new ResourceNotFoundException("Could not read non-existent document", this.extractErrorFields(response));
        }
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to read documents", this.extractErrorFields(response));
        }
        if (status == 304) {
            OkHttpServices.closeResponse(response);
            return false;
        }
        if (status != 200) {
            throw new FailedRequestException("read failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s document from %s transaction with %s metadata categories and content", uri, transaction != null ? transaction.getTransactionId() : "no", this.stringJoin(categories, ", ", "no"));
        try {
            MimeMultipart entity;
            ResponseBody body = response.body();
            MimeMultipart mimeMultipart = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, MimeMultipart.class) : null;
            if (entity == null) {
                return false;
            }
            int partCount = entity.getCount();
            if (partCount == 0) {
                return false;
            }
            List<BodyPart> partList = OkHttpServices.getPartList(entity);
            if (partCount != 2) {
                throw new FailedRequestException("read expected 2 parts but got " + partCount + " parts", this.extractErrorFields(response));
            }
            HandleImplementation metadataBase = HandleAccessor.as(metadataHandle);
            HandleImplementation contentBase = HandleAccessor.as(contentHandle);
            BodyPart contentPart = partList.get(1);
            Headers responseHeaders = response.headers();
            if (OkHttpServices.isExternalDescriptor(desc)) {
                OkHttpServices.updateVersion(desc, responseHeaders);
                OkHttpServices.updateFormat((ContentDescriptor)desc, responseHeaders);
                OkHttpServices.updateMimetype((ContentDescriptor)desc, OkHttpServices.getHeaderMimetype(OkHttpServices.getHeader(contentPart, "Content-Type")));
                OkHttpServices.updateLength((ContentDescriptor)desc, OkHttpServices.getHeaderLength(OkHttpServices.getHeader(contentPart, "Content-Length")));
                OkHttpServices.copyDescriptor(desc, contentBase);
            } else {
                OkHttpServices.updateDescriptor(contentBase, responseHeaders);
            }
            metadataBase.receiveContent(OkHttpServices.getEntity(partList.get(0), metadataBase.receiveAs()));
            Object contentEntity = OkHttpServices.getEntity(contentPart, contentBase.receiveAs());
            contentBase.receiveContent(reqlog != null ? reqlog.copyContent(contentEntity) : contentEntity);
            OkHttpServices.closeResponse(response);
            return true;
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public DocumentDescriptor head(RequestLogger reqlog, String uri, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        Response response = this.headImpl(reqlog, uri, transaction, this.makeDocumentResource(this.makeDocumentParams(uri, null, transaction, null)));
        if (response == null) {
            return null;
        }
        Headers responseHeaders = response.headers();
        OkHttpServices.closeResponse(response);
        this.logRequest(reqlog, "checked %s document from %s transaction", uri, transaction != null ? transaction.getTransactionId() : "no");
        DocumentDescriptorImpl desc = new DocumentDescriptorImpl(uri, false);
        OkHttpServices.updateVersion((DocumentDescriptor)desc, responseHeaders);
        OkHttpServices.updateDescriptor(desc, responseHeaders);
        return desc;
    }

    @Override
    public boolean exists(String uri) throws ForbiddenUserException, FailedRequestException {
        return this.headImpl(null, uri, null, this.setupRequest(uri, null)) != null;
    }

    @Override
    public DatabaseClient.ConnectionResult checkConnection() {
        Request.Builder request = new Request.Builder().url(this.baseUri);
        Response response = this.headImplExec(null, this.baseUri.uri().toString(), null, request);
        ConnectionResultImpl connectionResultImpl = new ConnectionResultImpl();
        int statusCode = response.code();
        if (statusCode < 300) {
            connectionResultImpl.setConnected(true);
        } else {
            connectionResultImpl.setConnected(false);
            connectionResultImpl.setStatusCode(statusCode);
            connectionResultImpl.setErrorMessage(OkHttpServices.getReasonPhrase(response));
        }
        return connectionResultImpl;
    }

    private Response headImpl(RequestLogger reqlog, String uri, Transaction transaction, Request.Builder requestBldr) {
        Response response = this.headImplExec(reqlog, uri, transaction, requestBldr);
        int status = response.code();
        if (status != 200) {
            if (status == 404) {
                OkHttpServices.closeResponse(response);
                return null;
            }
            if (status == 403) {
                throw new ForbiddenUserException("User is not allowed to check the existence of documents", this.extractErrorFields(response));
            }
            throw new FailedRequestException("Document existence check failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        return response;
    }

    private Response headImplExec(RequestLogger reqlog, String uri, Transaction transaction, Request.Builder requestBldr) {
        if (uri == null) {
            throw new IllegalArgumentException("Existence check for document identifier without uri");
        }
        logger.debug("Requesting head for {} in transaction {}", (Object)uri, (Object)OkHttpServices.getTransactionId(transaction));
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doHeadFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.head().build());
            }
        };
        return this.sendRequestWithRetry(requestBldr, transaction == null, doHeadFunction, null);
    }

    @Override
    public TemporalDescriptor putDocument(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        Format descFormat;
        String contentMimetype;
        if (desc.getUri() == null) {
            throw new IllegalArgumentException("Document write for document identifier without uri");
        }
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        HandleImplementation contentBase = HandleAccessor.checkHandle(contentHandle, "content");
        String metadataMimetype = null;
        if (metadataBase != null) {
            metadataMimetype = metadataBase.getMimetype();
        }
        String string = contentMimetype = (descFormat = desc.getFormat()) != null && descFormat != Format.UNKNOWN ? desc.getMimetype() : null;
        if (contentMimetype == null && contentBase != null) {
            Format contentFormat = contentBase.getFormat();
            if (descFormat != null && descFormat != contentFormat) {
                contentMimetype = descFormat.getDefaultMimetype();
            } else if (contentFormat != null && contentFormat != Format.UNKNOWN) {
                contentMimetype = contentBase.getMimetype();
            }
        }
        if (metadataBase != null && contentBase != null) {
            return this.putPostDocumentImpl(reqlog, "put", desc, transaction, categories, extraParams, metadataMimetype, metadataHandle, contentMimetype, contentHandle);
        }
        if (metadataBase != null) {
            return this.putPostDocumentImpl(reqlog, "put", desc, transaction, categories, false, extraParams, metadataMimetype, metadataHandle);
        }
        if (contentBase != null) {
            return this.putPostDocumentImpl(reqlog, "put", desc, transaction, null, true, extraParams, contentMimetype, contentHandle);
        }
        throw new IllegalArgumentException("Either metadataHandle or contentHandle must not be null");
    }

    @Override
    public DocumentDescriptorImpl postDocument(RequestLogger reqlog, DocumentUriTemplate template, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        String directory;
        String extension;
        Format templateFormat;
        String contentMimetype;
        DocumentDescriptorImpl desc = new DocumentDescriptorImpl(false);
        HandleImplementation metadataBase = HandleAccessor.checkHandle(metadataHandle, "metadata");
        HandleImplementation contentBase = HandleAccessor.checkHandle(contentHandle, "content");
        String metadataMimetype = null;
        if (metadataBase != null) {
            metadataMimetype = metadataBase.getMimetype();
        }
        String string = contentMimetype = (templateFormat = template.getFormat()) != null && templateFormat != Format.UNKNOWN ? template.getMimetype() : null;
        if (contentMimetype == null && contentBase != null) {
            Format contentFormat = contentBase.getFormat();
            if (templateFormat != null && templateFormat != contentFormat) {
                contentMimetype = templateFormat.getDefaultMimetype();
                desc.setFormat(templateFormat);
            } else if (contentFormat != null && contentFormat != Format.UNKNOWN) {
                contentMimetype = contentBase.getMimetype();
                desc.setFormat(contentFormat);
            }
        }
        desc.setMimetype(contentMimetype);
        if (extraParams == null) {
            extraParams = new RequestParameters();
        }
        if ((extension = template.getExtension()) != null) {
            extraParams.add("extension", extension);
        }
        if ((directory = template.getDirectory()) != null) {
            extraParams.add("directory", directory);
        }
        if (metadataBase != null && contentBase != null) {
            this.putPostDocumentImpl(reqlog, "post", desc, transaction, categories, extraParams, metadataMimetype, metadataHandle, contentMimetype, contentHandle);
        } else if (contentBase != null) {
            this.putPostDocumentImpl(reqlog, "post", desc, transaction, null, true, extraParams, contentMimetype, contentHandle);
        }
        return desc;
    }

    private TemporalDescriptor putPostDocumentImpl(RequestLogger reqlog, String method, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, boolean isOnContent, RequestParameters extraParams, String mimetype, AbstractWriteHandle handle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        String location;
        FailedRequest failure;
        int retry;
        String uri = desc.getUri();
        HandleImplementation handleBase = HandleAccessor.as(handle);
        logger.debug("Sending {} document in transaction {}", (Object)(uri != null ? uri : "new"), (Object)OkHttpServices.getTransactionId(transaction));
        this.logRequest(reqlog, "writing %s document from %s transaction with %s mime type and %s metadata categories", uri != null ? uri : "new", transaction != null ? transaction.getTransactionId() : "no", mimetype != null ? mimetype : "no", this.stringJoin(categories, ", ", "no"));
        Request.Builder requestBldr = this.makeDocumentResource(this.makeDocumentParams(uri, categories, transaction, extraParams, isOnContent));
        requestBldr = requestBldr.header("Content-Type", mimetype != null ? mimetype : "*/*");
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        if (uri != null) {
            requestBldr = OkHttpServices.addVersionHeader(desc, requestBldr, "If-Match");
        }
        if ("patch".equals(method)) {
            requestBldr = requestBldr.header("X-HTTP-Method-Override", "PATCH");
            method = "post";
        }
        boolean isResendable = handleBase.isResendable();
        Response response = null;
        int status = -1;
        Headers responseHeaders = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            Object value;
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((value = handleBase.sendContent()) == null) {
                throw new IllegalArgumentException("Document write with null value for " + (uri != null ? uri : "new document"));
            }
            if (this.isFirstRequest() && !isResendable && this.isStreaming(value) && (nextDelay = this.makeFirstRequest(retry)) != 0) continue;
            MediaType mediaType = OkHttpServices.makeType(requestBldr.build().header("Content-Type"));
            if (value instanceof OutputStreamSender) {
                StreamingOutputImpl sentStream = new StreamingOutputImpl((OutputStreamSender)value, reqlog, mediaType);
                requestBldr = "put".equals(method) ? requestBldr.put((RequestBody)sentStream) : requestBldr.post((RequestBody)sentStream);
            } else {
                Object sentObj = reqlog != null ? reqlog.copyContent(value) : value;
                requestBldr = "put".equals(method) ? requestBldr.put((RequestBody)new ObjectRequestBody(sentObj, mediaType)) : requestBldr.post((RequestBody)new ObjectRequestBody(sentObj, mediaType));
            }
            response = this.sendRequestOnce(requestBldr);
            status = response.code();
            responseHeaders = response.headers();
            if (transaction != null || !this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            OkHttpServices.closeResponse(response);
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + (uri != null ? uri : "new document"));
            }
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        if (status == 404) {
            throw new ResourceNotFoundException("Could not write non-existent document", this.extractErrorFields(response));
        }
        if (status == 428) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTNOVERSION")) {
                throw new FailedRequestException("Content version required to write document", failure);
            }
            throw new FailedRequestException("Precondition required to write document", failure);
        }
        if (status == 403) {
            failure = this.extractErrorFields(response);
            throw new ForbiddenUserException("User is not allowed to write documents", failure);
        }
        if (status == 412) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTWRONGVERSION")) {
                throw new FailedRequestException("Content version must match to write document", failure);
            }
            if (failure.getMessageCode().equals("RESTAPI-EMPTYBODY")) {
                throw new FailedRequestException("Empty request body sent to server", failure);
            }
            throw new FailedRequestException("Precondition Failed", failure);
        }
        if (status == -1) {
            throw new FailedRequestException("write failed: Unknown Reason", this.extractErrorFields(response));
        }
        if (status != 201 && status != 204) {
            throw new FailedRequestException("write failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        if (uri == null && (location = response.header("Location")) != null) {
            int offset = location.indexOf(DOCUMENT_URI_PREFIX);
            if (offset == -1) {
                OkHttpServices.closeResponse(response);
                throw new MarkLogicInternalException("document create produced invalid location: " + location);
            }
            uri = location.substring(offset + DOCUMENT_URI_PREFIX.length());
            if (uri == null) {
                OkHttpServices.closeResponse(response);
                throw new MarkLogicInternalException("document create produced location without uri: " + location);
            }
            desc.setUri(uri);
            OkHttpServices.updateVersion(desc, responseHeaders);
            OkHttpServices.updateDescriptor(desc, responseHeaders);
        }
        TemporalDescriptor temporalDesc = OkHttpServices.updateTemporalSystemTime(desc, responseHeaders);
        OkHttpServices.closeResponse(response);
        return temporalDesc;
    }

    private TemporalDescriptor putPostDocumentImpl(RequestLogger reqlog, String method, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, RequestParameters extraParams, String metadataMimetype, DocumentMetadataWriteHandle metadataHandle, String contentMimetype, AbstractWriteHandle contentHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        String location;
        FailedRequest failure;
        int retry;
        String uri = desc.getUri();
        logger.debug("Sending {} multipart document in transaction {}", (Object)(uri != null ? uri : "new"), (Object)OkHttpServices.getTransactionId(transaction));
        this.logRequest(reqlog, "writing %s document from %s transaction with %s metadata categories and content", uri != null ? uri : "new", transaction != null ? transaction.getTransactionId() : "no", this.stringJoin(categories, ", ", "no"));
        RequestParameters docParams = this.makeDocumentParams(uri, categories, transaction, extraParams, true);
        Request.Builder requestBldr = this.makeDocumentResource(docParams).addHeader("Accept", "multipart/mixed");
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        if (uri != null) {
            requestBldr = OkHttpServices.addVersionHeader(desc, requestBldr, "If-Match");
        }
        Response response = null;
        int status = -1;
        Headers responseHeaders = null;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            MultipartBody.Builder multiPart = new MultipartBody.Builder();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, new String[]{metadataMimetype, contentMimetype}, new AbstractWriteHandle[]{metadataHandle, contentHandle});
            if (this.isFirstRequest() && hasStreamingPart && (nextDelay = this.makeFirstRequest(retry)) != 0) continue;
            requestBldr = "put".equals(method) ? requestBldr.put((RequestBody)multiPart.build()) : requestBldr.post((RequestBody)multiPart.build());
            response = this.sendRequestOnce(requestBldr);
            status = response.code();
            responseHeaders = response.headers();
            if (transaction != null || !this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            OkHttpServices.closeResponse(response);
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + (uri != null ? uri : "new document"));
            }
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        if (status == 404) {
            OkHttpServices.closeResponse(response);
            throw new ResourceNotFoundException("Could not write non-existent document");
        }
        if (status == 428) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTNOVERSION")) {
                throw new FailedRequestException("Content version required to write document", failure);
            }
            throw new FailedRequestException("Precondition required to write document", failure);
        }
        if (status == 403) {
            failure = this.extractErrorFields(response);
            throw new ForbiddenUserException("User is not allowed to write documents", failure);
        }
        if (status == 412) {
            failure = this.extractErrorFields(response);
            if (failure.getMessageCode().equals("RESTAPI-CONTENTWRONGVERSION")) {
                throw new FailedRequestException("Content version must match to write document", failure);
            }
            if (failure.getMessageCode().equals("RESTAPI-EMPTYBODY")) {
                throw new FailedRequestException("Empty request body sent to server", failure);
            }
            throw new FailedRequestException("Precondition Failed", failure);
        }
        if (status != 201 && status != 204) {
            throw new FailedRequestException("write failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        if (uri == null && (location = response.header("Location")) != null) {
            int offset = location.indexOf(DOCUMENT_URI_PREFIX);
            if (offset == -1) {
                OkHttpServices.closeResponse(response);
                throw new MarkLogicInternalException("document create produced invalid location: " + location);
            }
            uri = location.substring(offset + DOCUMENT_URI_PREFIX.length());
            if (uri == null) {
                OkHttpServices.closeResponse(response);
                throw new MarkLogicInternalException("document create produced location without uri: " + location);
            }
            desc.setUri(uri);
            OkHttpServices.updateVersion(desc, responseHeaders);
            OkHttpServices.updateDescriptor(desc, responseHeaders);
        }
        TemporalDescriptor temporalDesc = OkHttpServices.updateTemporalSystemTime(desc, responseHeaders);
        OkHttpServices.closeResponse(response);
        return temporalDesc;
    }

    @Override
    public void patchDocument(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, boolean isOnContent, DocumentPatchHandle patchHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        this.patchDocument(reqlog, desc, transaction, categories, isOnContent, null, null, patchHandle);
    }

    @Override
    public void patchDocument(RequestLogger reqlog, DocumentDescriptor desc, Transaction transaction, Set<DocumentManager.Metadata> categories, boolean isOnContent, RequestParameters extraParams, String sourceDocumentURI, DocumentPatchHandle patchHandle) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        HandleImplementation patchBase = HandleAccessor.checkHandle(patchHandle, "patch");
        if (sourceDocumentURI != null) {
            extraParams.add("source-document", sourceDocumentURI);
        }
        this.putPostDocumentImpl(reqlog, "patch", desc, transaction, categories, isOnContent, extraParams, patchBase.getMimetype(), patchHandle);
    }

    @Override
    public Transaction openTransaction(String name, int timeLimit) throws ForbiddenUserException, FailedRequestException {
        Function<Request.Builder, Response> doPostFunction;
        logger.debug("Opening transaction");
        RequestParameters transParams = new RequestParameters();
        if (name != null || timeLimit > 0) {
            if (name != null) {
                transParams.add("name", name);
            }
            if (timeLimit > 0) {
                transParams.add("timeLimit", String.valueOf(timeLimit));
            }
        }
        Request.Builder requestBldr = this.setupRequest("transactions", transParams);
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), doPostFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.post(RequestBody.create(null, (String)"")));
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to open transactions", this.extractErrorFields(response));
        }
        if (status != 303) {
            throw new FailedRequestException("transaction open failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        String location = response.headers().get("Location");
        ArrayList<ClientCookie> cookies = new ArrayList<ClientCookie>();
        for (String setCookie : response.headers("Set-Cookie")) {
            ClientCookie cookie = ClientCookie.parse(requestBldr.build().url(), setCookie);
            cookies.add(cookie);
        }
        OkHttpServices.closeResponse(response);
        if (location == null) {
            throw new MarkLogicInternalException("transaction open failed to provide location");
        }
        if (!location.contains("/")) {
            throw new MarkLogicInternalException("transaction open produced invalid location: " + location);
        }
        String transactionId = location.substring(location.lastIndexOf("/") + 1);
        return new TransactionImpl(this, transactionId, cookies);
    }

    @Override
    public void commitTransaction(Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        this.completeTransaction(transaction, "commit");
    }

    @Override
    public void rollbackTransaction(Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        this.completeTransaction(transaction, "rollback");
    }

    private void completeTransaction(Transaction transaction, String result) throws ForbiddenUserException, FailedRequestException {
        if (result == null) {
            throw new MarkLogicInternalException("transaction completion without operation");
        }
        if (transaction == null) {
            throw new MarkLogicInternalException("transaction completion without id: " + result);
        }
        logger.debug("Completing transaction {} with {}", (Object)transaction.getTransactionId(), (Object)result);
        RequestParameters transParams = new RequestParameters();
        transParams.add("result", result);
        Request.Builder requestBldr = this.setupRequest("transactions/" + transaction.getTransactionId(), transParams);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doPostFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.post(RequestBody.create(null, (String)"")).build());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, false, doPostFunction, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to complete transaction with " + result, this.extractErrorFields(response));
        }
        if (status != 204) {
            throw new FailedRequestException("transaction " + result + " failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        OkHttpServices.closeResponse(response);
    }

    private void addCategoryParams(Set<DocumentManager.Metadata> categories, RequestParameters params, boolean withContent) {
        if (withContent) {
            params.add("category", "content");
        }
        if (categories != null && categories.size() > 0) {
            if (categories.contains((Object)DocumentManager.Metadata.ALL)) {
                params.add("category", "metadata");
            } else {
                for (DocumentManager.Metadata category : categories) {
                    params.add("category", category.name().toLowerCase());
                }
            }
        }
    }

    private RequestParameters makeDocumentParams(String uri, Set<DocumentManager.Metadata> categories, Transaction transaction, RequestParameters extraParams) {
        return this.makeDocumentParams(uri, categories, transaction, extraParams, false);
    }

    private RequestParameters makeDocumentParams(String uri, Set<DocumentManager.Metadata> categories, Transaction transaction, RequestParameters extraParams, boolean withContent) {
        RequestParameters docParams = new RequestParameters();
        if (extraParams != null && extraParams.size() > 0) {
            for (Map.Entry<String, List<String>> entry : extraParams.entrySet()) {
                for (String value : entry.getValue()) {
                    String extraKey = entry.getKey();
                    if ("range".equalsIgnoreCase(extraKey)) continue;
                    docParams.add(extraKey, value);
                }
            }
        }
        if (uri != null) {
            docParams.add("uri", uri);
        }
        if (categories == null || categories.size() == 0) {
            docParams.add("category", "content");
        } else {
            if (withContent) {
                docParams.add("category", "content");
            }
            if (categories.contains((Object)DocumentManager.Metadata.ALL)) {
                docParams.add("category", "metadata");
            } else {
                for (DocumentManager.Metadata category : categories) {
                    docParams.add("category", category.toString().toLowerCase());
                }
            }
        }
        if (transaction != null) {
            docParams.add("txid", transaction.getTransactionId());
        }
        return docParams;
    }

    private Request.Builder makeDocumentResource(RequestParameters queryParams) {
        return this.setupRequest("documents", queryParams);
    }

    private static boolean isExternalDescriptor(ContentDescriptor desc) {
        return desc != null && desc instanceof DocumentDescriptorImpl && !((DocumentDescriptorImpl)desc).isInternal();
    }

    private static void updateDescriptor(ContentDescriptor desc, Headers headers) {
        if (desc == null || headers == null) {
            return;
        }
        OkHttpServices.updateFormat(desc, headers);
        OkHttpServices.updateMimetype(desc, headers);
        OkHttpServices.updateLength(desc, headers);
        OkHttpServices.updateServerTimestamp(desc, headers);
    }

    private static TemporalDescriptor updateTemporalSystemTime(DocumentDescriptor desc, Headers headers) {
        if (headers == null) {
            return null;
        }
        DocumentDescriptorImpl temporalDescriptor = desc instanceof DocumentDescriptorImpl ? (DocumentDescriptorImpl)desc : new DocumentDescriptorImpl(desc.getUri(), false);
        temporalDescriptor.setTemporalSystemTime(headers.get("x-marklogic-system-time"));
        return temporalDescriptor;
    }

    private static void copyDescriptor(DocumentDescriptor desc, HandleImplementation handleBase) {
        if (handleBase == null) {
            return;
        }
        if (desc.getFormat() != null) {
            handleBase.setFormat(desc.getFormat());
        }
        if (desc.getMimetype() != null) {
            handleBase.setMimetype(desc.getMimetype());
        }
        handleBase.setByteLength(desc.getByteLength());
    }

    private static void updateFormat(ContentDescriptor descriptor, Headers headers) {
        OkHttpServices.updateFormat(descriptor, OkHttpServices.getHeaderFormat(headers));
    }

    private static void updateFormat(ContentDescriptor descriptor, Format format) {
        if (format != null) {
            descriptor.setFormat(format);
        }
    }

    private static Format getHeaderFormat(Headers headers) {
        String format = headers.get("vnd.marklogic.document-format");
        if (format != null) {
            return Format.valueOf(format.toUpperCase());
        }
        return null;
    }

    private static Format getHeaderFormat(BodyPart part) {
        String contentDisposition = OkHttpServices.getHeader(part, "Content-Disposition");
        String formatRegex = ".* format=(text|binary|xml|json).*";
        String format = OkHttpServices.getHeader(part, "vnd.marklogic.document-format");
        String contentType = OkHttpServices.getHeader(part, "Content-Type");
        if (format != null && format.length() > 0) {
            return Format.valueOf(format.toUpperCase());
        }
        if (contentDisposition != null && contentDisposition.matches(formatRegex)) {
            format = contentDisposition.replaceFirst("^.*" + formatRegex + ".*$", "$1");
            return Format.valueOf(format.toUpperCase());
        }
        if (contentType != null && contentType.length() > 0) {
            return Format.getFromMimetype(contentType);
        }
        return null;
    }

    private static void updateMimetype(ContentDescriptor descriptor, Headers headers) {
        OkHttpServices.updateMimetype(descriptor, OkHttpServices.getHeaderMimetype(headers.get("Content-Type")));
    }

    private static void updateMimetype(ContentDescriptor descriptor, String mimetype) {
        if (mimetype != null) {
            descriptor.setMimetype(mimetype);
        }
    }

    private static String getHeader(Map<String, List<String>> headers, String name) {
        List<String> values = headers.get(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    private static String getHeader(BodyPart part, String name) {
        if (part == null) {
            throw new MarkLogicInternalException("part must not be null");
        }
        try {
            String[] values = part.getHeader(name);
            if (values != null && values.length > 0) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    private static String getHeaderMimetype(String contentType) {
        if (contentType != null) {
            String mimetype;
            int offset = contentType.indexOf(";");
            String string = mimetype = offset == -1 ? contentType : contentType.substring(0, offset);
            if (mimetype != null && mimetype.length() > 0) {
                return mimetype;
            }
        }
        return null;
    }

    private static void updateLength(ContentDescriptor descriptor, Headers headers) {
        OkHttpServices.updateLength(descriptor, OkHttpServices.getHeaderLength(headers.get("Content-Length")));
    }

    private static void updateLength(ContentDescriptor descriptor, long length) {
        descriptor.setByteLength(length);
    }

    private static void updateServerTimestamp(ContentDescriptor descriptor, Headers headers) {
        OkHttpServices.updateServerTimestamp(descriptor, OkHttpServices.getHeaderServerTimestamp(headers));
    }

    private static long getHeaderServerTimestamp(Headers headers) {
        String timestamp = headers.get("ML-Effective-Timestamp");
        if (timestamp != null && timestamp.length() > 0) {
            return Long.parseLong(timestamp);
        }
        return -1L;
    }

    private static void updateServerTimestamp(ContentDescriptor descriptor, long timestamp) {
        if (descriptor instanceof HandleImplementation && descriptor != null && timestamp != -1L) {
            ((HandleImplementation)descriptor).setResponseServerTimestamp(timestamp);
        }
    }

    private static long getHeaderLength(String length) {
        if (length != null) {
            return Long.parseLong(length);
        }
        return -1L;
    }

    private static String getHeaderUri(BodyPart part) {
        try {
            if (part != null) {
                return part.getFileName();
            }
            return null;
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    private static void updateVersion(DocumentDescriptor descriptor, Headers headers) {
        OkHttpServices.updateVersion(descriptor, OkHttpServices.extractVersion(headers.get("ETag")));
    }

    private static void updateVersion(DocumentDescriptor descriptor, String header) {
        OkHttpServices.updateVersion(descriptor, OkHttpServices.extractVersion(header));
    }

    private static void updateVersion(DocumentDescriptor descriptor, long version) {
        descriptor.setVersion(version);
    }

    private static long extractVersion(String header) {
        if (header != null && header.length() > 0) {
            return Long.parseLong(header.substring(1, header.length() - 1));
        }
        return -1L;
    }

    private static Request.Builder addVersionHeader(DocumentDescriptor desc, Request.Builder requestBldr, String name) {
        long version;
        if (desc != null && desc instanceof DocumentDescriptorImpl && !((DocumentDescriptorImpl)desc).isInternal() && (version = desc.getVersion()) != -1L) {
            return requestBldr.header(name, "\"" + String.valueOf(version) + "\"");
        }
        return requestBldr;
    }

    @Override
    public <T extends SearchReadHandle> T search(RequestLogger reqlog, T searchHandle, QueryDefinition queryDef, long start, long len, QueryManager.QueryView view, Transaction transaction, String forestName) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        RequestParameters params = new RequestParameters();
        if (start > 1L) {
            params.add("start", Long.toString(start));
        }
        if (len > 0L) {
            params.add("pageLength", Long.toString(len));
        }
        if (view != null && view != QueryManager.QueryView.DEFAULT) {
            if (view == QueryManager.QueryView.ALL) {
                params.add("view", "all");
            } else if (view == QueryManager.QueryView.RESULTS) {
                params.add("view", "results");
            } else if (view == QueryManager.QueryView.FACETS) {
                params.add("view", "facets");
            } else if (view == QueryManager.QueryView.METADATA) {
                params.add("view", "metadata");
            }
        }
        this.addPointInTimeQueryParam(params, searchHandle);
        HandleImplementation searchBase = HandleAccessor.checkHandle(searchHandle, "search");
        Format searchFormat = searchBase.getFormat();
        switch (searchFormat) {
            case UNKNOWN: {
                searchFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only XML and JSON search results are possible.");
            }
        }
        String mimetype = searchFormat.getDefaultMimetype();
        OkHttpSearchRequest request = this.generateSearchRequest(reqlog, queryDef, mimetype, transaction, null, params, forestName);
        Response response = request.getResponse();
        if (response == null) {
            return null;
        }
        Class as = searchBase.receiveAs();
        ResponseBody body = response.body();
        Object r = entity = body.contentLength() != 0L ? (Object)OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        searchBase.receiveContent(entity);
        OkHttpServices.updateDescriptor(searchBase, response.headers());
        this.logRequest(reqlog, "searched starting at %s with length %s in %s transaction with %s mime type", start, len, OkHttpServices.getTransactionId(transaction), mimetype);
        return searchHandle;
    }

    private OkHttpSearchRequest generateSearchRequest(RequestLogger reqlog, QueryDefinition queryDef, String mimetype, Transaction transaction, ServerTransform responseTransform, RequestParameters params, String forestName) {
        if (params == null) {
            params = new RequestParameters();
        }
        if (forestName != null) {
            params.add("forest-name", forestName);
        }
        return new OkHttpSearchRequest(reqlog, queryDef, mimetype, transaction, responseTransform, params);
    }

    private Format getStructuredQueryFormat(HandleImplementation baseHandle) {
        Format payloadFormat = baseHandle.getFormat();
        if (payloadFormat == Format.UNKNOWN) {
            payloadFormat = null;
        } else if (payloadFormat != Format.XML && payloadFormat != Format.JSON) {
            throw new IllegalArgumentException("Cannot perform raw search for format " + payloadFormat.name());
        }
        return payloadFormat;
    }

    private String getMimetypeWithDefaultXML(Format payloadFormat, HandleImplementation baseHandle) {
        String payloadMimetype = baseHandle.getMimetype();
        if (payloadFormat != null) {
            if (payloadMimetype == null) {
                payloadMimetype = payloadFormat.getDefaultMimetype();
            }
        } else if (payloadMimetype == null) {
            payloadMimetype = "application/xml";
        }
        return payloadMimetype;
    }

    @Override
    public void deleteSearch(RequestLogger reqlog, DeleteQueryDefinition queryDef, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        Function<Request.Builder, Response> doDeleteFunction;
        RequestParameters params = new RequestParameters();
        if (queryDef.getDirectory() != null) {
            params.add("directory", queryDef.getDirectory());
        }
        params.add("collection", queryDef.getCollections());
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        Request.Builder requestBldr = this.setupRequest("search", params);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), transaction == null, doDeleteFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.delete().build());
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to delete", this.extractErrorFields(response));
        }
        if (status != 204) {
            throw new FailedRequestException("delete failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        OkHttpServices.closeResponse(response);
        this.logRequest(reqlog, "deleted search results in %s transaction", OkHttpServices.getTransactionId(transaction));
    }

    @Override
    public void delete(RequestLogger logger, Transaction transaction, String ... uris) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        for (String uri : uris) {
            params.add("uri", uri);
        }
        this.deleteResource(logger, "documents", transaction, params, null);
    }

    @Override
    public <T> T values(Class<T> as, ValuesDefinition valDef, String mimetype, long start, long pageLength, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        T entity;
        Function<Request.Builder, Response> doFunction;
        RequestParameters docParams = new RequestParameters();
        String optionsName = valDef.getOptionsName();
        if (optionsName != null && optionsName.length() > 0) {
            docParams.add("options", optionsName);
        }
        if (valDef.getAggregate() != null) {
            docParams.add("aggregate", valDef.getAggregate());
        }
        if (valDef.getAggregatePath() != null) {
            docParams.add("aggregatePath", valDef.getAggregatePath());
        }
        if (valDef.getView() != null) {
            docParams.add("view", valDef.getView());
        }
        if (valDef.getDirection() != null) {
            if (valDef.getDirection() == ValuesDefinition.Direction.ASCENDING) {
                docParams.add("direction", "ascending");
            } else {
                docParams.add("direction", "descending");
            }
        }
        if (valDef.getFrequency() != null) {
            if (valDef.getFrequency() == ValuesDefinition.Frequency.FRAGMENT) {
                docParams.add("frequency", "fragment");
            } else {
                docParams.add("frequency", "item");
            }
        }
        if (start > 0L) {
            docParams.add("start", Long.toString(start));
            if (pageLength > 0L) {
                docParams.add("pageLength", Long.toString(pageLength));
            }
        }
        HandleImplementation baseHandle = null;
        if (valDef.getQueryDefinition() != null) {
            StructureWriteHandle handle;
            ValueQueryDefinition queryDef = valDef.getQueryDefinition();
            if (optionsName == null) {
                optionsName = queryDef.getOptionsName();
                if (optionsName != null) {
                    docParams.add("options", optionsName);
                }
            } else if (queryDef.getOptionsName() != null && !queryDef.getOptionsName().equals(optionsName)) {
                logger.warn("values definition options take precedence over query definition options");
            }
            if (queryDef.getCollections().length > 0) {
                logger.warn("collections scope ignored for values query");
            }
            if (queryDef.getDirectory() != null) {
                logger.warn("directory scope ignored for values query");
            }
            String text = null;
            if (queryDef instanceof StringQueryDefinition) {
                text = ((StringQueryDefinition)queryDef).getCriteria();
            } else if (queryDef instanceof StructuredQueryDefinition) {
                text = ((StructuredQueryDefinition)queryDef).getCriteria();
            } else if (queryDef instanceof RawStructuredQueryDefinition) {
                text = ((RawStructuredQueryDefinition)((Object)queryDef)).getCriteria();
            } else if (queryDef instanceof RawCtsQueryDefinition) {
                text = ((RawCtsQueryDefinition)queryDef).getCriteria();
            }
            if (text != null) {
                docParams.add("q", text);
            }
            if (queryDef instanceof StructuredQueryDefinition) {
                String structure = ((StructuredQueryDefinition)queryDef).serialize();
                if (structure != null) {
                    docParams.add("structuredQuery", structure);
                }
            } else if (queryDef instanceof RawQueryDefinition) {
                handle = ((RawQueryDefinition)((Object)queryDef)).getHandle();
                baseHandle = HandleAccessor.checkHandle(handle, "values");
            } else if (queryDef instanceof RawCtsQueryDefinition) {
                handle = ((RawCtsQueryDefinition)queryDef).getHandle();
                baseHandle = HandleAccessor.checkHandle(handle, "values");
            } else if (!(queryDef instanceof StringQueryDefinition)) {
                logger.warn("unsupported query definition: {}", (Object)queryDef.getClass().getName());
            }
            ServerTransform transform = queryDef.getResponseTransform();
            if (transform != null) {
                transform.merge(docParams);
            }
        }
        if (transaction != null) {
            docParams.add("txid", transaction.getTransactionId());
        }
        Object uri = "values";
        if (valDef.getName() != null) {
            uri = (String)uri + "/" + valDef.getName();
        }
        Request.Builder requestBldr = this.setupRequest((String)uri, docParams);
        requestBldr = this.setupRequest(requestBldr, null, mimetype);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        final HandleImplementation tempBaseHandle = baseHandle;
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doFunction = baseHandle == null ? new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doGet(funcBuilder);
            }
        } : new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doPost(null, funcBuilder.header("Content-Type", tempBaseHandle.getMimetype()), tempBaseHandle.sendContent());
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to search", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("search failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        T t = entity = body.contentLength() != 0L ? (T)OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    @Override
    public <T> T valuesList(Class<T> as, ValuesListDefinition valDef, String mimetype, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        T entity;
        Function<Request.Builder, Response> doGetFunction;
        RequestParameters docParams = new RequestParameters();
        String optionsName = valDef.getOptionsName();
        if (optionsName != null && optionsName.length() > 0) {
            docParams.add("options", optionsName);
        }
        if (transaction != null) {
            docParams.add("txid", transaction.getTransactionId());
        }
        String uri = "values";
        Request.Builder requestBldr = this.setupRequest(uri, docParams);
        requestBldr = this.setupRequest(requestBldr, null, mimetype);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), transaction == null, doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.get().build());
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to search", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("search failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        T t = entity = body.contentLength() != 0L ? (T)OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    @Override
    public <T> T optionsList(Class<T> as, String mimetype, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        T entity;
        Function<Request.Builder, Response> doGetFunction;
        RequestParameters docParams = new RequestParameters();
        if (transaction != null) {
            docParams.add("txid", transaction.getTransactionId());
        }
        String uri = "config/query";
        Request.Builder requestBldr = this.setupRequest(uri, docParams);
        requestBldr = requestBldr.header("Accept", mimetype);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), transaction == null, doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.get().build());
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to search", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("search failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        T t = entity = body.contentLength() != 0L ? (T)OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    @Override
    public <T> T getValue(RequestLogger reqlog, String type, String key, boolean isNullable, String mimetype, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.getValue(reqlog, type, key, null, isNullable, mimetype, as);
    }

    @Override
    public <T> T getValue(RequestLogger reqlog, String type, String key, Transaction transaction, boolean isNullable, String mimetype, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        Object entity;
        logger.debug("Getting {}/{}", (Object)type, (Object)key);
        Request.Builder requestBldr = this.setupRequest(type + "/" + key, null, null, mimetype);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.get().build());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doGetFunction, null);
        int status = response.code();
        if (status != 200) {
            if (status == 404) {
                OkHttpServices.closeResponse(response);
                if (!isNullable) {
                    throw new ResourceNotFoundException("Could not get " + type + "/" + key);
                }
                return null;
            }
            if (status == 403) {
                throw new ForbiddenUserException("User is not allowed to read " + type, this.extractErrorFields(response));
            }
            throw new FailedRequestException(type + " read failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s value with %s key and %s mime type", type, key, mimetype);
        ResponseBody body = response.body();
        Object v0 = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return reqlog != null ? reqlog.copyContent(entity) : entity;
    }

    @Override
    public <T> T getValues(RequestLogger reqlog, String type, String mimetype, Class<T> as) throws ForbiddenUserException, FailedRequestException {
        return this.getValues(reqlog, type, null, mimetype, as);
    }

    @Override
    public <T> T getValues(RequestLogger reqlog, String type, RequestParameters extraParams, String mimetype, Class<T> as) throws ForbiddenUserException, FailedRequestException {
        Object entity;
        logger.debug("Getting {}", (Object)type);
        Request.Builder requestBldr = this.setupRequest(type, extraParams).header("Accept", mimetype);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.get().build());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, doGetFunction, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to read " + type, this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException(type + " read failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        this.logRequest(reqlog, "read %s values with %s mime type", type, mimetype);
        ResponseBody body = response.body();
        Object v0 = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return reqlog != null ? reqlog.copyContent(entity) : entity;
    }

    @Override
    public void postValue(RequestLogger reqlog, String type, String key, String mimetype, Object value) throws ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        logger.debug("Posting {}/{}", (Object)type, (Object)key);
        this.putPostValueImpl(reqlog, "post", type, key, null, mimetype, value, 201);
    }

    @Override
    public void postValue(RequestLogger reqlog, String type, String key, RequestParameters extraParams) throws ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        logger.debug("Posting {}/{}", (Object)type, (Object)key);
        this.putPostValueImpl(reqlog, "post", type, key, extraParams, null, null, 204);
    }

    @Override
    public void putValue(RequestLogger reqlog, String type, String key, String mimetype, Object value) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        logger.debug("Putting {}/{}", (Object)type, (Object)key);
        this.putPostValueImpl(reqlog, "put", type, key, null, mimetype, value, 204, 201);
    }

    @Override
    public void putValue(RequestLogger reqlog, String type, String key, RequestParameters extraParams, String mimetype, Object value) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        logger.debug("Putting {}/{}", (Object)type, (Object)key);
        this.putPostValueImpl(reqlog, "put", type, key, extraParams, mimetype, value, 204);
    }

    private void putPostValueImpl(RequestLogger reqlog, String method, String type, String key, RequestParameters extraParams, String mimetype, Object value, int ... expectedStatuses) {
        int retry;
        if (key != null) {
            this.logRequest(reqlog, "writing %s value with %s key and %s mime type", type, key, mimetype);
        } else {
            this.logRequest(reqlog, "writing %s values with %s mime type", type, mimetype);
        }
        HandleImplementation handle = value instanceof HandleImplementation ? (HandleImplementation)value : null;
        MediaType mediaType = OkHttpServices.makeType(mimetype);
        String connectPath = null;
        Request.Builder requestBldr = null;
        Response response = null;
        int status = -1;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            Request.Builder resource;
            boolean isResendable;
            boolean isStreaming;
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Object nextValue = handle != null ? handle.sendContent() : value;
            RequestBody sentValue = null;
            sentValue = nextValue instanceof OutputStreamSender ? new StreamingOutputImpl((OutputStreamSender)nextValue, reqlog, mediaType) : (reqlog != null && retry == 0 ? new ObjectRequestBody(reqlog.copyContent(nextValue), mediaType) : new ObjectRequestBody(nextValue, mediaType));
            boolean bl = isStreaming = this.isFirstRequest() || handle == null ? this.isStreaming(sentValue) : false;
            boolean bl2 = handle == null ? !isStreaming : (isResendable = handle.isResendable());
            if (this.isFirstRequest() && !isResendable && isStreaming && (nextDelay = this.makeFirstRequest(retry)) != 0) continue;
            if ("put".equals(method)) {
                if (requestBldr == null) {
                    connectPath = key != null ? type + "/" + key : type;
                    resource = this.setupRequest(connectPath, extraParams);
                    requestBldr = mimetype == null ? resource : resource.header("Content-Type", mimetype);
                    requestBldr = this.addTelemetryAgentId(requestBldr);
                }
                response = sentValue == null ? this.sendRequestOnce(requestBldr.put(null).build()) : this.sendRequestOnce(requestBldr.put(sentValue).build());
            } else if ("post".equals(method)) {
                if (requestBldr == null) {
                    connectPath = type;
                    resource = this.setupRequest(connectPath, extraParams);
                    requestBldr = mimetype == null ? resource : resource.header("Content-Type", mimetype);
                    requestBldr = this.addTelemetryAgentId(requestBldr);
                }
                response = sentValue == null ? this.sendRequestOnce(requestBldr.post(RequestBody.create(null, (String)"")).build()) : this.sendRequestOnce(requestBldr.post(sentValue).build());
            } else {
                throw new MarkLogicInternalException("unknown method type " + method);
            }
            status = response.code();
            if (!this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            OkHttpServices.closeResponse(response);
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + connectPath);
            }
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to write " + type, this.extractErrorFields(response));
        }
        if (status == 404) {
            throw new ResourceNotFoundException(type + " not found for write", this.extractErrorFields(response));
        }
        boolean statusOk = false;
        for (int expectedStatus : expectedStatuses) {
            boolean bl = statusOk = statusOk || status == expectedStatus;
            if (statusOk) break;
        }
        if (!statusOk) {
            throw new FailedRequestException(type + " write failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        OkHttpServices.closeResponse(response);
    }

    @Override
    public void deleteValue(RequestLogger reqlog, String type, String key) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        logger.debug("Deleting {}/{}", (Object)type, (Object)key);
        Request.Builder requestBldr = this.setupRequest(type + "/" + key, null);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doDeleteFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.delete().build());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, doDeleteFunction, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to delete " + type, this.extractErrorFields(response));
        }
        if (status == 404) {
            throw new ResourceNotFoundException(type + " not found for delete", this.extractErrorFields(response));
        }
        if (status != 204) {
            throw new FailedRequestException("delete failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        OkHttpServices.closeResponse(response);
        this.logRequest(reqlog, "deleted %s value with %s key", type, key);
    }

    @Override
    public void deleteValues(RequestLogger reqlog, String type) throws ForbiddenUserException, FailedRequestException {
        logger.debug("Deleting {}", (Object)type);
        Request.Builder requestBldr = this.setupRequest(type, null);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doDeleteFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.delete().build());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, doDeleteFunction, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to delete " + type, this.extractErrorFields(response));
        }
        if (status != 204) {
            throw new FailedRequestException("delete failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        OkHttpServices.closeResponse(response);
        this.logRequest(reqlog, "deleted %s values", type);
    }

    @Override
    public <R extends UrisReadHandle> R uris(RequestLogger reqlog, Transaction transaction, QueryDefinition qdef, long start, String afterUri, long pageLength, String forestName, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        if (forestName != null) {
            params.add("forest-name", forestName);
        }
        if (start > 1L) {
            params.add("start", Long.toString(start));
        }
        if (afterUri != null) {
            params.add("after", afterUri);
        }
        if (pageLength >= 1L) {
            params.add("pageLength", Long.toString(pageLength));
        }
        if (qdef.getDirectory() != null) {
            params.add("directory", qdef.getDirectory());
        }
        if (qdef.getCollections() != null) {
            for (String collection : qdef.getCollections()) {
                params.add("collection", collection);
            }
        }
        if (qdef.getOptionsName() != null && qdef.getOptionsName().length() > 0) {
            params.add("options", qdef.getOptionsName());
        }
        if (qdef instanceof RawQueryByExampleDefinition) {
            throw new UnsupportedOperationException("Cannot search with RawQueryByExampleDefinition");
        }
        String text = null;
        if (qdef instanceof StringQueryDefinition) {
            text = ((StringQueryDefinition)qdef).getCriteria();
        } else if (qdef instanceof StructuredQueryDefinition) {
            text = ((StructuredQueryDefinition)qdef).getCriteria();
        } else if (qdef instanceof RawStructuredQueryDefinition) {
            text = ((RawStructuredQueryDefinition)qdef).getCriteria();
        } else if (qdef instanceof RawCtsQueryDefinition) {
            text = ((RawCtsQueryDefinition)qdef).getCriteria();
        }
        Object qtextMessage = "";
        if (text != null) {
            params.add("q", text);
            qtextMessage = " and string query \"" + text + "\"";
        }
        if (qdef instanceof RawCtsQueryDefinition) {
            String structure = qdef instanceof RawQueryDefinitionImpl.CtsQuery ? ((RawQueryDefinitionImpl.CtsQuery)qdef).serialize() : "";
            logger.debug("Query uris with raw cts query {}{}", (Object)structure, qtextMessage);
            CtsQueryWriteHandle input = ((RawCtsQueryDefinition)qdef).getHandle();
            return this.postResource(reqlog, "internal/uris", transaction, params, input, output);
        }
        if (qdef instanceof StructuredQueryDefinition) {
            String structure = ((StructuredQueryDefinition)qdef).serialize();
            logger.debug("Query uris with structured query {}{}", (Object)structure, qtextMessage);
            if (structure != null) {
                params.add("structuredQuery", structure);
            }
        } else if (qdef instanceof RawStructuredQueryDefinition) {
            String structure = ((RawStructuredQueryDefinition)qdef).serialize();
            logger.debug("Query uris with raw structured query {}{}", (Object)structure, qtextMessage);
            if (structure != null) {
                params.add("structuredQuery", structure);
            }
        } else if (qdef instanceof CombinedQueryDefinition) {
            String structure = ((CombinedQueryDefinition)qdef).serialize();
            logger.debug("Query uris with combined query {}", (Object)structure);
            if (structure != null) {
                params.add("structuredQuery", structure);
            }
        } else if (qdef instanceof StringQueryDefinition) {
            logger.debug("Query uris with string query \"{}\"", (Object)text);
        } else {
            if (qdef instanceof RawQueryDefinition) {
                logger.debug("Raw uris query");
                StructureWriteHandle input = ((RawQueryDefinition)qdef).getHandle();
                return this.postResource(reqlog, "internal/uris", transaction, params, input, output);
            }
            throw new UnsupportedOperationException("Cannot query uris with " + qdef.getClass().getName());
        }
        return this.getResource(reqlog, "internal/uris", transaction, params, output);
    }

    @Override
    public <R extends AbstractReadHandle> R getResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        this.addPointInTimeQueryParam(params, output);
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String mimetype = outputBase.getMimetype();
        Class as = outputBase.receiveAs();
        Request.Builder requestBldr = this.makeGetWebResource(path, params, mimetype);
        requestBldr = this.setupRequest(requestBldr, null, mimetype);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doGet(funcBuilder);
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doGetFunction, null);
        int status = response.code();
        this.checkStatus(response, status, "read", "resource", path, RESTServices.ResponseStatus.OK_OR_NO_CONTENT);
        OkHttpServices.updateDescriptor(outputBase, response.headers());
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "read", "resource", response, as));
        } else {
            OkHttpServices.closeResponse(response);
        }
        return output;
    }

    @Override
    public RESTServices.RESTServiceResultIterator getIteratedResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, String ... mimetypes) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.getIteratedResourceImpl(OkHttpServiceResultIterator::new, reqlog, path, transaction, params, mimetypes);
    }

    private <U extends OkHttpResultIterator> U getIteratedResourceImpl(ResultIteratorConstructor<U> constructor, RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, String ... mimetypes) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        Request.Builder requestBldr = this.makeGetWebResource(path, params, null);
        requestBldr = this.setupRequest(requestBldr, null, null);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        requestBldr = requestBldr.header("Accept", this.multipartMixedWithBoundary());
        Function<Request.Builder, Response> doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doGet(funcBuilder);
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doGetFunction, null);
        int status = response.code();
        this.checkStatus(response, status, "read", "resource", path, RESTServices.ResponseStatus.OK_OR_NO_CONTENT);
        return this.makeResults(constructor, reqlog, "read", "resource", response);
    }

    @Override
    public <R extends AbstractReadHandle> R putResource(final RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, AbstractWriteHandle input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        final HandleImplementation inputBase = HandleAccessor.checkHandle(input, "write");
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String inputMimetype = inputBase.getMimetype();
        boolean isResendable = inputBase.isResendable();
        String outputMimeType = null;
        Class as = null;
        if (outputBase != null) {
            outputMimeType = outputBase.getMimetype();
            as = outputBase.receiveAs();
        }
        Request.Builder requestBldr = this.makePutWebResource(path, params);
        requestBldr = this.setupRequest(requestBldr, (Object)inputMimetype, outputMimeType);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Consumer<Boolean> resendableConsumer = resendable -> {
            if (!isResendable) {
                this.checkFirstRequest();
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
        };
        Function<Request.Builder, Response> doPutFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doPut(reqlog, funcBuilder, inputBase.sendContent());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doPutFunction, resendableConsumer);
        int status = response.code();
        this.checkStatus(response, status, "write", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "write", "resource", response, as));
        } else {
            OkHttpServices.closeResponse(response);
        }
        return output;
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R putResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, W[] input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("input not specified for multipart");
        }
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String outputMimetype = outputBase.getMimetype();
        Class as = outputBase.receiveAs();
        Response response = null;
        int status = -1;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            MultipartBody.Builder multiPart = new MultipartBody.Builder();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, (AbstractWriteHandle[])input);
            Request.Builder requestBldr = this.makePutWebResource(path, params);
            requestBldr = this.setupRequest(requestBldr, multiPart, outputMimetype);
            requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
            requestBldr = this.addTelemetryAgentId(requestBldr);
            response = this.doPut(requestBldr, multiPart, hasStreamingPart);
            status = response.code();
            if (transaction != null || !this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            OkHttpServices.closeResponse(response);
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "write", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "write", "resource", response, as));
        } else {
            OkHttpServices.closeResponse(response);
        }
        return output;
    }

    @Override
    public <R extends AbstractReadHandle> R postResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, AbstractWriteHandle input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return this.postResource(reqlog, path, transaction, params, input, output, "apply");
    }

    @Override
    public <R extends AbstractReadHandle> R postResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, AbstractWriteHandle input, R output, String operation) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return this.postResource(reqlog, path, transaction, params, input, output, operation, null);
    }

    @Override
    public <R extends AbstractReadHandle> R postResource(final RequestLogger reqlog, final String path, Transaction transaction, RequestParameters params, AbstractWriteHandle input, R output, String operation, Map<String, List<String>> responseHeaders) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        HandleImplementation inputBase = HandleAccessor.checkHandle(input, "write");
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String inputMimetype = null;
        if (inputBase != null && (inputMimetype = inputBase.getMimetype()) == null && (Format.JSON == inputBase.getFormat() || Format.XML == inputBase.getFormat())) {
            inputMimetype = inputBase.getFormat().getDefaultMimetype();
        }
        String outputMimetype = outputBase == null ? null : outputBase.getMimetype();
        final boolean isResendable = inputBase == null ? true : inputBase.isResendable();
        Class as = outputBase == null ? null : outputBase.receiveAs();
        Request.Builder requestBldr = this.makePostWebResource(path, params);
        requestBldr = this.setupRequest(requestBldr, (Object)inputMimetype, outputMimetype);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Consumer<Boolean> resendableConsumer = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean resendable) {
                if (!isResendable) {
                    OkHttpServices.this.checkFirstRequest();
                    throw new ResourceNotResendableException("Cannot retry request for " + path);
                }
            }
        };
        final Object value = inputBase == null ? null : inputBase.sendContent();
        Function<Request.Builder, Response> doPostFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doPost(reqlog, funcBuilder, value);
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doPostFunction, resendableConsumer);
        int status = response.code();
        this.checkStatus(response, status, operation, "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (responseHeaders != null) {
            responseHeaders.putAll(response.headers().toMultimap());
        }
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, operation, "resource", response, as));
        } else {
            OkHttpServices.closeResponse(response);
        }
        return output;
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R postResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, W[] input, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return (R)this.postResource(reqlog, path, transaction, params, (AbstractWriteHandle[])input, null, output);
    }

    @Override
    public <R extends AbstractReadHandle, W extends AbstractWriteHandle> R postResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, W[] input, Map<String, List<String>>[] requestHeaders, R output) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        HandleImplementation outputBase;
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        String outputMimetype = (outputBase = HandleAccessor.checkHandle(output, "read")) != null ? outputBase.getMimetype() : null;
        Class as = outputBase != null ? outputBase.receiveAs() : null;
        Response response = null;
        int status = -1;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            MultipartBody.Builder multiPart = new MultipartBody.Builder();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, null, (AbstractWriteHandle[])input, requestHeaders);
            Request.Builder requestBldr = this.makePostWebResource(path, params);
            requestBldr = this.setupRequest(requestBldr, multiPart, outputMimetype);
            requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
            requestBldr = this.addTelemetryAgentId(requestBldr);
            response = this.doPost(requestBldr, multiPart, hasStreamingPart);
            status = response.code();
            if (transaction != null || !this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            OkHttpServices.closeResponse(response);
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "apply", "resource", response, as));
        } else {
            OkHttpServices.closeResponse(response);
        }
        return output;
    }

    @Override
    public void postBulkDocuments(RequestLogger reqlog, DocumentWriteSet writeSet, ServerTransform transform, Transaction transaction, Format defaultFormat) throws ForbiddenUserException, FailedRequestException {
        this.postBulkDocuments(reqlog, writeSet, transform, transaction, defaultFormat, (R)null, (String)null);
    }

    public <R extends AbstractReadHandle> R postBulkDocuments(RequestLogger reqlog, DocumentWriteSet writeSet, ServerTransform transform, Transaction transaction, Format defaultFormat, R output, String temporalCollection) throws ForbiddenUserException, FailedRequestException {
        ArrayList<AbstractWriteHandle> writeHandles = new ArrayList<AbstractWriteHandle>();
        ArrayList<RequestParameters> headerList = new ArrayList<RequestParameters>();
        for (DocumentWriteOperation write : writeSet) {
            RequestParameters headers;
            String temporalDocumentURI = write.getTemporalDocumentURI();
            HandleImplementation metadata = HandleAccessor.checkHandle(write.getMetadata(), "write");
            HandleImplementation content = HandleAccessor.checkHandle(write.getContent(), "write");
            Object contentDispositionTemporal = "";
            if (temporalDocumentURI != null) {
                temporalDocumentURI = this.escapeContentDispositionFilename(temporalDocumentURI);
                contentDispositionTemporal = "; temporal-document=" + temporalDocumentURI;
            }
            if (write.getOperationType() == DocumentWriteOperation.OperationType.DISABLE_METADATA_DEFAULT) {
                headers = new RequestParameters();
                headers.add("Content-Type", metadata.getMimetype());
                headers.add("Content-Disposition", "inline; category=metadata" + (String)contentDispositionTemporal);
                headerList.add(headers);
                writeHandles.add(write.getMetadata());
            } else if (metadata != null) {
                headers = new RequestParameters();
                headers.add("Content-Type", metadata.getMimetype());
                if (write.getOperationType() == DocumentWriteOperation.OperationType.METADATA_DEFAULT) {
                    headers.add("Content-Disposition", "inline; category=metadata" + (String)contentDispositionTemporal);
                } else {
                    String disposition = "attachment; filename=" + this.escapeContentDispositionFilename(write.getUri()) + "; category=metadata" + (String)contentDispositionTemporal;
                    headers.add("Content-Disposition", disposition);
                }
                headerList.add(headers);
                writeHandles.add(write.getMetadata());
            }
            if (content == null) continue;
            headers = new RequestParameters();
            String mimeType = content.getMimetype();
            if (mimeType == null && defaultFormat != null) {
                mimeType = defaultFormat.getDefaultMimetype();
            }
            headers.add("Content-Type", mimeType);
            String disposition = null;
            CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            if (asciiEncoder.canEncode(write.getUri())) {
                disposition = "attachment; filename=" + this.escapeContentDispositionFilename(write.getUri()) + (String)contentDispositionTemporal;
            } else {
                try {
                    disposition = "attachment; filename*=UTF-8''" + URLEncoder.encode(write.getUri(), "UTF-8") + (String)contentDispositionTemporal;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Uri cannot be encoded as UFT-8");
                }
            }
            asciiEncoder.reset();
            headers.add("Content-Disposition", disposition);
            headerList.add(headers);
            writeHandles.add(write.getContent());
        }
        RequestParameters params = new RequestParameters();
        if (transform != null) {
            transform.merge(params);
        }
        if (temporalCollection != null) {
            params.add("temporal-collection", temporalCollection);
        }
        return (R)this.postResource(reqlog, "documents", transaction, params, writeHandles.toArray(new AbstractWriteHandle[0]), headerList.toArray(new RequestParameters[0]), output);
    }

    private String escapeContentDispositionFilename(String str) {
        if (str == null) {
            return null;
        }
        return "\"" + str.replace("\"", "\\\"").replace("\\", "\\\\") + "\"";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EvalResultIterator postEvalInvoke(RequestLogger reqlog, String code, String modulePath, ServerEvaluationCallImpl.Context context, Map<String, Object> variables, EditableNamespaceContext namespaces, Transaction transaction) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        String formUrlEncodedPayload;
        String path;
        RequestParameters params = new RequestParameters();
        try {
            StringBuffer sb;
            block27: {
                sb = new StringBuffer();
                if (context == ServerEvaluationCallImpl.Context.ADHOC_XQUERY) {
                    path = "eval";
                    sb.append("xquery=");
                    sb.append(URLEncoder.encode(code, "UTF-8"));
                } else if (context == ServerEvaluationCallImpl.Context.ADHOC_JAVASCRIPT) {
                    path = "eval";
                    sb.append("javascript=");
                    sb.append(URLEncoder.encode(code, "UTF-8"));
                } else {
                    if (context != ServerEvaluationCallImpl.Context.INVOKE) {
                        throw new IllegalStateException("Invalid eval context: " + context);
                    }
                    path = "invoke";
                    sb.append("module=");
                    sb.append(URLEncoder.encode(modulePath, "UTF-8"));
                }
                if (variables == null || variables.size() <= 0) break block27;
                int i = 0;
                for (String name : variables.keySet()) {
                    String value;
                    String type;
                    block26: {
                        Object valueObject;
                        block30: {
                            block29: {
                                block28: {
                                    String namespace = "";
                                    String localname = name;
                                    if (namespaces != null) {
                                        for (String prefix : namespaces.keySet()) {
                                            if (name == null || prefix == null || !name.startsWith(prefix + ":")) continue;
                                            localname = name.substring(prefix.length() + 1);
                                            namespace = namespaces.get(prefix);
                                        }
                                    }
                                    sb.append("&evn" + i + "=");
                                    sb.append(URLEncoder.encode(namespace, "UTF-8"));
                                    sb.append("&evl" + i + "=");
                                    sb.append(URLEncoder.encode(localname, "UTF-8"));
                                    type = null;
                                    valueObject = variables.get(name);
                                    if (valueObject != null) break block28;
                                    value = "null";
                                    type = "null-node()";
                                    break block26;
                                }
                                if (!(valueObject instanceof JacksonHandle) && !(valueObject instanceof JacksonParserHandle)) break block29;
                                JsonNode jsonNode = null;
                                if (valueObject instanceof JacksonHandle) {
                                    jsonNode = ((JacksonHandle)valueObject).get();
                                } else if (valueObject instanceof JacksonParserHandle) {
                                    jsonNode = (JsonNode)((JacksonParserHandle)valueObject).get().readValueAs(JsonNode.class);
                                }
                                value = jsonNode.toString();
                                type = this.getJsonType(jsonNode);
                                break block26;
                            }
                            if (!(valueObject instanceof AbstractWriteHandle)) break block30;
                            value = HandleAccessor.contentAsString((AbstractWriteHandle)valueObject);
                            HandleImplementation valueBase = HandleAccessor.as((AbstractWriteHandle)valueObject);
                            Format format = valueBase.getFormat();
                            if (format == Format.XML) {
                                type = "document-node()";
                                break block26;
                            } else {
                                if (format == Format.JSON) {
                                    try (JacksonParserHandle handle = new JacksonParserHandle();){
                                        JsonNode jsonNode = handle.getMapper().readTree(value);
                                        type = this.getJsonType(jsonNode);
                                    }
                                }
                                if (format == Format.TEXT) {
                                    type = "xs:untypedAtomic";
                                    break block26;
                                } else {
                                    if (format == Format.BINARY) {
                                        throw new UnsupportedOperationException("Binary format is not supported for variables");
                                    }
                                    throw new UnsupportedOperationException("Undefined format is not supported for variables. Please set the format on your handle for variable " + name + ".");
                                }
                            }
                        }
                        if (!(valueObject instanceof String || valueObject instanceof Boolean || valueObject instanceof Number)) {
                            throw new IllegalArgumentException("Variable with name=" + name + " is of unsupported type" + valueObject.getClass() + ". Supported types are String, Boolean, Number, or AbstractWriteHandle");
                        }
                        value = valueObject.toString();
                        type = "xs:untypedAtomic";
                    }
                    sb.append("&evv" + i + "=");
                    sb.append(URLEncoder.encode(value, "UTF-8"));
                    sb.append("&evt" + i + "=" + type);
                    ++i;
                }
            }
            formUrlEncodedPayload = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported", e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        StringHandle input = new StringHandle(formUrlEncodedPayload).withMimetype("application/x-www-form-urlencoded");
        return new OkHttpEvalResultIterator(this.postIteratedResourceImpl(DefaultOkHttpResultIterator::new, reqlog, path, transaction, params, input, new String[0]));
    }

    private String getJsonType(JsonNode jsonNode) {
        if (jsonNode instanceof ArrayNode) {
            return "json:array";
        }
        if (jsonNode instanceof ObjectNode) {
            return "json:object";
        }
        throw new IllegalArgumentException("When using JacksonHandle or JacksonParserHandle with ServerEvaluationCall the content must be a valid array or object");
    }

    @Override
    public RESTServices.RESTServiceResultIterator postIteratedResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, AbstractWriteHandle input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return this.postIteratedResourceImpl(OkHttpServiceResultIterator::new, reqlog, path, transaction, params, input, outputMimetypes);
    }

    private <U extends OkHttpResultIterator> U postIteratedResourceImpl(ResultIteratorConstructor<U> constructor, final RequestLogger reqlog, final String path, Transaction transaction, RequestParameters params, AbstractWriteHandle input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        final HandleImplementation inputBase = HandleAccessor.checkHandle(input, "write");
        String inputMimetype = inputBase.getMimetype();
        final boolean isResendable = inputBase.isResendable();
        Request.Builder requestBldr = this.makePostWebResource(path, params);
        requestBldr = this.setupRequest(requestBldr, (Object)inputMimetype, null);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Consumer<Boolean> resendableConsumer = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean resendable) {
                if (!isResendable) {
                    OkHttpServices.this.checkFirstRequest();
                    throw new ResourceNotResendableException("Cannot retry request for " + path);
                }
            }
        };
        Function<Request.Builder, Response> doPostFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doPost(reqlog, funcBuilder.header("Accept", OkHttpServices.this.multipartMixedWithBoundary()), inputBase.sendContent());
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doPostFunction, resendableConsumer);
        int status = response.code();
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        return this.makeResults(constructor, reqlog, "apply", "resource", response);
    }

    @Override
    public <W extends AbstractWriteHandle> RESTServices.RESTServiceResultIterator postIteratedResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, W[] input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        return (RESTServices.RESTServiceResultIterator)((Object)this.postIteratedResourceImpl(OkHttpServiceResultIterator::new, reqlog, path, transaction, params, (AbstractWriteHandle[])input, outputMimetypes));
    }

    private <W extends AbstractWriteHandle, U extends OkHttpResultIterator> U postIteratedResourceImpl(ResultIteratorConstructor<U> constructor, RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, W[] input, String ... outputMimetypes) throws ResourceNotFoundException, ResourceNotResendableException, ForbiddenUserException, FailedRequestException {
        int retry;
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        Response response = null;
        int status = -1;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            MultipartBody.Builder multiPart = new MultipartBody.Builder();
            boolean hasStreamingPart = this.addParts(multiPart, reqlog, (AbstractWriteHandle[])input);
            Request.Builder requestBldr = this.makePostWebResource(path, params);
            requestBldr = this.setupRequest(requestBldr, multiPart, this.multipartMixedWithBoundary());
            requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
            requestBldr = this.addTelemetryAgentId(requestBldr);
            response = this.doPost(requestBldr, multiPart, hasStreamingPart);
            status = response.code();
            if (transaction != null || !this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            OkHttpServices.closeResponse(response);
            if (hasStreamingPart) {
                throw new ResourceNotResendableException("Cannot retry request for " + path);
            }
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        this.checkStatus(response, status, "apply", "resource", path, RESTServices.ResponseStatus.OK_OR_CREATED_OR_NO_CONTENT);
        return this.makeResults(constructor, reqlog, "apply", "resource", response);
    }

    @Override
    public <R extends AbstractReadHandle> R deleteResource(RequestLogger reqlog, String path, Transaction transaction, RequestParameters params, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (params == null) {
            params = new RequestParameters();
        }
        if (transaction != null) {
            params.add("txid", transaction.getTransactionId());
        }
        HandleImplementation outputBase = HandleAccessor.checkHandle(output, "read");
        String outputMimeType = null;
        Class as = null;
        if (outputBase != null) {
            outputMimeType = outputBase.getMimetype();
            as = outputBase.receiveAs();
        }
        Request.Builder requestBldr = this.makeDeleteWebResource(path, params);
        requestBldr = this.setupRequest(requestBldr, null, outputMimeType);
        requestBldr = this.addTransactionScopedCookies(requestBldr, transaction);
        requestBldr = this.addTelemetryAgentId(requestBldr);
        Function<Request.Builder, Response> doDeleteFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doDelete(funcBuilder);
            }
        };
        Response response = this.sendRequestWithRetry(requestBldr, transaction == null, doDeleteFunction, null);
        int status = response.code();
        this.checkStatus(response, status, "delete", "resource", path, RESTServices.ResponseStatus.OK_OR_NO_CONTENT);
        if (as != null) {
            outputBase.receiveContent(this.makeResult(reqlog, "delete", "resource", response, as));
        } else {
            OkHttpServices.closeResponse(response);
        }
        return output;
    }

    private Request.Builder makeGetWebResource(String path, RequestParameters params, Object mimetype) {
        if (path == null) {
            throw new IllegalArgumentException("Read with null path");
        }
        logger.debug(String.format("Getting %s as %s", path, mimetype));
        return this.setupRequest(path, params);
    }

    private Response doGet(Request.Builder requestBldr) {
        requestBldr = requestBldr.get();
        Response response = this.sendRequestOnce(requestBldr);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private Request.Builder makePutWebResource(String path, RequestParameters params) {
        if (path == null) {
            throw new IllegalArgumentException("Write with null path");
        }
        logger.debug("Putting {}", (Object)path);
        return this.setupRequest(path, params);
    }

    private Response doPut(RequestLogger reqlog, Request.Builder requestBldr, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Resource write with null value");
        }
        if (this.isFirstRequest() && this.isStreaming(value)) {
            this.makeFirstRequest(0);
        }
        MediaType mediaType = OkHttpServices.makeType(requestBldr.build().header("Content-Type"));
        requestBldr = value instanceof OutputStreamSender ? requestBldr.put((RequestBody)new StreamingOutputImpl((OutputStreamSender)value, reqlog, mediaType)) : (reqlog != null ? requestBldr.put((RequestBody)new ObjectRequestBody(reqlog.copyContent(value), mediaType)) : requestBldr.put((RequestBody)new ObjectRequestBody(value, mediaType)));
        Response response = this.sendRequestOnce(requestBldr);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private Response doPut(Request.Builder requestBldr, MultipartBody.Builder multiPart, boolean hasStreamingPart) {
        if (this.isFirstRequest() && hasStreamingPart) {
            this.makeFirstRequest(0);
        }
        requestBldr = requestBldr.put((RequestBody)multiPart.build());
        Response response = this.sendRequestOnce(requestBldr);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private Request.Builder makePostWebResource(String path, RequestParameters params) {
        if (path == null) {
            throw new IllegalArgumentException("Apply with null path");
        }
        logger.debug("Posting {}", (Object)path);
        return this.setupRequest(path, params);
    }

    private Response doPost(RequestLogger reqlog, Request.Builder requestBldr, Object value) {
        if (this.isFirstRequest() && this.isStreaming(value)) {
            this.makeFirstRequest(0);
        }
        MediaType mediaType = OkHttpServices.makeType(requestBldr.build().header("Content-Type"));
        requestBldr = value == null ? requestBldr.post((RequestBody)new ObjectRequestBody(null, null)) : (value instanceof OutputStreamSender ? requestBldr.post((RequestBody)new StreamingOutputImpl((OutputStreamSender)value, reqlog, mediaType)) : (reqlog != null ? requestBldr.post((RequestBody)new ObjectRequestBody(reqlog.copyContent(value), mediaType)) : requestBldr.post((RequestBody)new ObjectRequestBody(value, mediaType))));
        Response response = this.sendRequestOnce(requestBldr);
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private Response doPost(Request.Builder requestBldr, MultipartBody.Builder multiPart, boolean hasStreamingPart) {
        if (this.isFirstRequest() && hasStreamingPart) {
            this.makeFirstRequest(0);
        }
        Response response = this.sendRequestOnce(requestBldr.post((RequestBody)multiPart.build()));
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private Request.Builder makeDeleteWebResource(String path, RequestParameters params) {
        if (path == null) {
            throw new IllegalArgumentException("Delete with null path");
        }
        logger.debug("Deleting {}", (Object)path);
        return this.setupRequest(path, params);
    }

    private Response doDelete(Request.Builder requestBldr) {
        Response response = this.sendRequestOnce(requestBldr.delete().build());
        if (this.isFirstRequest()) {
            this.setFirstRequest(false);
        }
        return response;
    }

    private void addPointInTimeQueryParam(RequestParameters params, Object outputHandle) {
        HandleImplementation handleBase = HandleAccessor.as(outputHandle);
        if (params != null && handleBase != null && handleBase.getPointInTimeQueryTimestamp() != -1L) {
            logger.trace("param timestamp=[" + handleBase.getPointInTimeQueryTimestamp() + "]");
            params.add("timestamp", Long.toString(handleBase.getPointInTimeQueryTimestamp()));
        }
    }

    private Request.Builder addTransactionScopedCookies(Request.Builder requestBldr, Transaction transaction) {
        if (transaction != null && transaction.getCookies() != null) {
            if (requestBldr == null) {
                throw new MarkLogicInternalException("no requestBldr available to get the URI");
            }
            requestBldr = this.addCookies(requestBldr, transaction.getCookies(), ((TransactionImpl)transaction).getCreatedTimestamp());
        }
        return requestBldr;
    }

    private Request.Builder addCookies(Request.Builder requestBldr, List<ClientCookie> cookies, Calendar creation) {
        HttpUrl uri = requestBldr.build().url();
        for (ClientCookie cookie : cookies) {
            int currentAge;
            String path;
            if (cookie.isSecure() && !uri.isHttps() || cookie.getPath() != null && ((path = uri.encodedPath()) == null || !path.startsWith(cookie.getPath())) || cookie.getDomain() != null && (uri.host() == null || !uri.host().equals(cookie.getDomain())) || cookie.getMaxAge() == 0) continue;
            if (creation != null && cookie.getMaxAge() > 0 && (currentAge = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - creation.getTimeInMillis())) > cookie.getMaxAge()) {
                logger.warn(cookie.getName() + " cookie expired after " + cookie.getMaxAge() + " seconds: " + cookie.getValue());
                continue;
            }
            requestBldr = requestBldr.addHeader("Cookie", cookie.toString());
        }
        return requestBldr;
    }

    private Request.Builder addTelemetryAgentId(Request.Builder requestBldr) {
        if (requestBldr == null) {
            throw new MarkLogicInternalException("no requestBldr available to set ML-Agent-ID header");
        }
        return requestBldr.header("ML-Agent-ID", "java");
    }

    private <W extends AbstractWriteHandle> boolean addParts(MultipartBody.Builder multiPart, RequestLogger reqlog, W[] input) {
        return this.addParts(multiPart, reqlog, null, (AbstractWriteHandle[])input, null);
    }

    private <W extends AbstractWriteHandle> boolean addParts(MultipartBody.Builder multiPart, RequestLogger reqlog, String[] mimetypes, W[] input) {
        return this.addParts(multiPart, reqlog, null, (AbstractWriteHandle[])input, null);
    }

    private <W extends AbstractWriteHandle> boolean addParts(MultipartBody.Builder multiPart, RequestLogger reqlog, String[] mimetypes, W[] input, Map<String, List<String>>[] headers) {
        if (mimetypes != null && mimetypes.length != input.length) {
            throw new IllegalArgumentException("Mismatch between count of mimetypes and input");
        }
        if (headers != null && headers.length != input.length) {
            throw new IllegalArgumentException("Mismatch between count of headers and input");
        }
        multiPart.setType(MediaType.parse((String)"multipart/mixed"));
        boolean hasStreamingPart = false;
        for (int i = 0; i < input.length; ++i) {
            W handle = input[i];
            HandleImplementation handleBase = HandleAccessor.checkHandle(handle, "write");
            if (!hasStreamingPart) {
                hasStreamingPart = !handleBase.isResendable();
            }
            Object value = handleBase.sendContent();
            String inputMimetype = null;
            if (mimetypes != null) {
                inputMimetype = mimetypes[i];
            }
            if (inputMimetype == null && headers != null) {
                inputMimetype = OkHttpServices.getHeaderMimetype(OkHttpServices.getHeader(headers[i], "Content-Type"));
            }
            if (inputMimetype == null) {
                inputMimetype = handleBase.getMimetype();
            }
            MediaType mediaType = inputMimetype != null ? MediaType.parse((String)inputMimetype) : MediaType.parse((String)"*/*");
            Headers.Builder partHeaders = new Headers.Builder();
            if (headers != null) {
                for (String key : headers[i].keySet()) {
                    if ("Content-Type".equalsIgnoreCase(key)) continue;
                    for (String headerValue : headers[i].get(key)) {
                        partHeaders.add(key, headerValue);
                    }
                }
            }
            MultipartBody.Part bodyPart = null;
            bodyPart = value instanceof OutputStreamSender ? MultipartBody.Part.create((Headers)partHeaders.build(), (RequestBody)new StreamingOutputImpl((OutputStreamSender)value, reqlog, mediaType)) : (reqlog != null ? MultipartBody.Part.create((Headers)partHeaders.build(), (RequestBody)new ObjectRequestBody(reqlog.copyContent(value), mediaType)) : MultipartBody.Part.create((Headers)partHeaders.build(), (RequestBody)new ObjectRequestBody(value, mediaType)));
            multiPart = multiPart.addPart(bodyPart);
        }
        return hasStreamingPart;
    }

    private String multipartMixedWithBoundary() {
        return "multipart/mixed; boundary=" + UUID.randomUUID().toString();
    }

    private Request.Builder setupRequest(HttpUrl requestUri, String path, RequestParameters params) {
        if (requestUri == null) {
            throw new IllegalArgumentException("request URI cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        HttpUrl.Builder uri = requestUri.resolve(path).newBuilder();
        if (params != null) {
            for (String key : params.keySet()) {
                Iterator iterator = params.get(key).iterator();
                while (iterator.hasNext()) {
                    String value = (String)iterator.next();
                    uri.addQueryParameter(key, value);
                }
            }
        }
        if (this.database != null && !path.startsWith("config/")) {
            uri.addQueryParameter("database", this.database);
        }
        Request.Builder request = new Request.Builder().url(uri.build());
        return request;
    }

    private Request.Builder setupRequest(String path, RequestParameters params) {
        return this.setupRequest(this.baseUri, path, params);
    }

    private Request.Builder setupRequest(Request.Builder requestBldr, Object inputMimetype, Object outputMimetype) {
        if (inputMimetype != null) {
            if (inputMimetype instanceof String) {
                requestBldr = requestBldr.header("Content-Type", (String)inputMimetype);
            } else if (inputMimetype instanceof MediaType) {
                requestBldr = requestBldr.header("Content-Type", inputMimetype.toString());
            } else if (inputMimetype instanceof MultipartBody.Builder) {
                requestBldr = requestBldr.header("Content-Type", "multipart/mixed");
                logger.debug("Sending multipart for {}", (Object)requestBldr.build().url().encodedPath());
            } else {
                throw new IllegalArgumentException("Unknown input mimetype specifier " + inputMimetype.getClass().getName());
            }
        }
        if (outputMimetype != null) {
            if (outputMimetype instanceof String) {
                requestBldr = requestBldr.header("Accept", (String)outputMimetype);
            } else if (outputMimetype instanceof MediaType) {
                requestBldr = requestBldr.header("Accept", outputMimetype.toString());
            } else {
                throw new IllegalArgumentException("Unknown output mimetype specifier " + outputMimetype.getClass().getName());
            }
        }
        return requestBldr;
    }

    private Request.Builder setupRequest(String path, RequestParameters params, Object inputMimetype, Object outputMimetype) {
        return this.setupRequest(this.setupRequest(path, params), inputMimetype, outputMimetype);
    }

    private void checkStatus(Response response, int status, String operation, String entityType, String path, RESTServices.ResponseStatus expected) {
        if (!expected.isExpected(status)) {
            FailedRequest failure = this.extractErrorFields(response);
            if (status == 404) {
                throw new ResourceNotFoundException("Could not " + operation + " " + entityType + " at " + path, failure);
            }
            if ("RESTAPI-CONTENTNOVERSION".equals(failure.getMessageCode())) {
                throw new FailedRequestException("Content version required to " + operation + " " + entityType + " at " + path, failure);
            }
            if (status == 403) {
                throw new ForbiddenUserException("User is not allowed to " + operation + " " + entityType + " at " + path, failure);
            }
            throw new FailedRequestException("failed to " + operation + " " + entityType + " at " + path + ": " + OkHttpServices.getReasonPhrase(response), failure);
        }
    }

    private <T> T makeResult(RequestLogger reqlog, String operation, String entityType, Response response, Class<T> as) {
        Object entity;
        if (as == null) {
            return null;
        }
        this.logRequest(reqlog, "%s for %s", operation, entityType);
        ResponseBody body = response.body();
        Object v0 = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return reqlog != null ? reqlog.copyContent(entity) : entity;
    }

    private <U extends OkHttpResultIterator> U makeResults(ResultIteratorConstructor<U> constructor, RequestLogger reqlog, String operation, String entityType, Response response) {
        if (response == null) {
            return null;
        }
        ResponseBody body = response.body();
        MimeMultipart entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, MimeMultipart.class) : null;
        List<BodyPart> partList = OkHttpServices.getPartList(entity);
        Response closeable = response;
        return this.makeResults(constructor, reqlog, operation, entityType, partList, response, (Closeable)closeable);
    }

    private <U extends OkHttpResultIterator> U makeResults(ResultIteratorConstructor<U> constructor, RequestLogger reqlog, String operation, String entityType, List<BodyPart> partList, Response response, Closeable closeable) {
        this.logRequest(reqlog, "%s for %s", operation, entityType);
        if (response == null) {
            return null;
        }
        try {
            OkHttpResultIterator result = (OkHttpResultIterator)constructor.construct(reqlog, partList, closeable);
            Headers headers = response.headers();
            if (headers.get("vnd.marklogic.start") != null) {
                result.setStart(Long.parseLong(headers.get("vnd.marklogic.start")));
            }
            if (headers.get("vnd.marklogic.pageLength") != null) {
                result.setPageSize(Long.parseLong(headers.get("vnd.marklogic.pageLength")));
            }
            if (headers.get("vnd.marklogic.result-estimate") != null) {
                result.setTotalSize(Long.parseLong(headers.get("vnd.marklogic.result-estimate")));
            }
            return (U)result;
        }
        catch (Throwable t) {
            throw new MarkLogicInternalException("Error constructing iterator", t);
        }
    }

    private boolean isStreaming(Object value) {
        return !(value instanceof String) && !(value instanceof byte[]) && !(value instanceof File);
    }

    private void logRequest(RequestLogger reqlog, String message, Object ... params) {
        if (reqlog == null) {
            return;
        }
        PrintStream out = reqlog.getPrintStream();
        if (out == null) {
            return;
        }
        if (params == null || params.length == 0) {
            out.println(message);
        } else {
            out.format(message, params);
            out.println();
        }
    }

    private String stringJoin(Collection collection, String separator, String defaultValue) {
        if (collection == null || collection.size() == 0) {
            return defaultValue;
        }
        StringBuilder builder = null;
        for (Object value : collection) {
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append(separator);
            }
            builder.append(value);
        }
        return builder != null ? builder.toString() : null;
    }

    private int calculateDelay(Random rand, int i) {
        int min;
        int n = i > 6 ? 2000 : (min = i == 0 ? 125 : 125 + (1 << i) * 20);
        int range = i > 6 ? 125 : (i == 0 ? 40 : (i == 6 ? 2000 - min : (1 << i) * 20));
        return min + this.randRetry.nextInt(range);
    }

    public OkHttpClient getClientImplementation() {
        if (this.client == null) {
            return null;
        }
        return this.client;
    }

    public void setClientImplementation(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public <T> T suggest(Class<T> as, SuggestDefinition suggestionDef) {
        T entity;
        Function<Request.Builder, Response> doGetFunction;
        RequestParameters params = new RequestParameters();
        String suggestCriteria = suggestionDef.getStringCriteria();
        String[] queries = suggestionDef.getQueryStrings();
        String optionsName = suggestionDef.getOptionsName();
        Integer limit = suggestionDef.getLimit();
        Integer cursorPosition = suggestionDef.getCursorPosition();
        if (suggestCriteria != null) {
            params.add("partial-q", suggestCriteria);
        }
        if (optionsName != null) {
            params.add("options", optionsName);
        }
        if (limit != null) {
            params.add("limit", Long.toString(limit.intValue()));
        }
        if (cursorPosition != null) {
            params.add("cursor-position", Long.toString(cursorPosition.intValue()));
        }
        if (queries != null) {
            for (String stringQuery : queries) {
                params.add("q", stringQuery);
            }
        }
        Request.Builder requestBldr = null;
        requestBldr = this.setupRequest("suggest", params, null, "application/xml");
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.sendRequestOnce(funcBuilder.get().build());
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to get suggestions", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("Suggest call failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        T t = entity = body.contentLength() != 0L ? (T)OkHttpServices.getEntity(body, as) : null;
        if (entity == null || as != InputStream.class && as != Reader.class) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    @Override
    public InputStream match(StructureWriteHandle document, String[] candidateRules, String mimeType, ServerTransform transform) {
        InputStream entity;
        Function<Request.Builder, Response> doPostFunction;
        RequestParameters params = new RequestParameters();
        final HandleImplementation baseHandle = HandleAccessor.checkHandle(document, "match");
        if (candidateRules != null) {
            for (String candidateRule : candidateRules) {
                params.add("rule", candidateRule);
            }
        }
        if (transform != null) {
            transform.merge(params);
        }
        Request.Builder requestBldr = null;
        requestBldr = this.setupRequest("alert/match", params, "application/xml", mimeType);
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), doPostFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doPost(null, funcBuilder, baseHandle.sendContent());
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to match", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("match failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        InputStream inputStream = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, InputStream.class) : null;
        if (entity == null) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    @Override
    public InputStream match(QueryDefinition queryDef, long start, long pageLength, String[] candidateRules, ServerTransform transform) {
        InputStream entity;
        int retry;
        if (queryDef == null) {
            throw new IllegalArgumentException("Cannot match null query");
        }
        RequestParameters params = new RequestParameters();
        if (start > 1L) {
            params.add("start", Long.toString(start));
        }
        if (pageLength >= 0L) {
            params.add("pageLength", Long.toString(pageLength));
        }
        if (transform != null) {
            transform.merge(params);
        }
        if (candidateRules.length > 0) {
            for (String candidateRule : candidateRules) {
                params.add("rule", candidateRule);
            }
        }
        if (queryDef.getOptionsName() != null) {
            params.add("options", queryDef.getOptionsName());
        }
        Request.Builder requestBldr = null;
        String structure = null;
        HandleImplementation baseHandle = null;
        String text = null;
        if (queryDef instanceof StringQueryDefinition) {
            text = ((StringQueryDefinition)queryDef).getCriteria();
        } else if (queryDef instanceof StructuredQueryDefinition) {
            text = ((StructuredQueryDefinition)queryDef).getCriteria();
        } else if (queryDef instanceof RawStructuredQueryDefinition) {
            text = ((RawStructuredQueryDefinition)queryDef).getCriteria();
        }
        if (text != null) {
            params.add("q", text);
        }
        if (queryDef instanceof StructuredQueryDefinition) {
            structure = ((StructuredQueryDefinition)queryDef).serialize();
            logger.debug("Searching with structured query {}", (Object)structure);
            requestBldr = this.setupRequest("alert/match", params, "application/xml", "application/xml");
        } else if (queryDef instanceof RawQueryDefinition) {
            StructureWriteHandle handle = ((RawQueryDefinition)queryDef).getHandle();
            baseHandle = HandleAccessor.checkHandle(handle, "match");
            logger.debug("Searching with raw query");
            requestBldr = this.setupRequest("alert/match", params, "application/xml", "application/xml");
        } else if (queryDef instanceof StringQueryDefinition) {
            logger.debug("Searching with string query [{}]", (Object)text);
            requestBldr = this.setupRequest("alert/match", params, null, "application/xml");
        } else {
            throw new UnsupportedOperationException("Cannot match with " + queryDef.getClass().getName());
        }
        requestBldr = this.addTelemetryAgentId(requestBldr);
        MediaType mediaType = OkHttpServices.makeType(requestBldr.build().header("Content-Type"));
        Response response = null;
        int status = -1;
        long startTime = System.currentTimeMillis();
        int nextDelay = 0;
        for (retry = 0; retry < this.minRetry || System.currentTimeMillis() - startTime < (long)this.maxDelay; ++retry) {
            if (nextDelay > 0) {
                try {
                    Thread.sleep(nextDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (queryDef instanceof StructuredQueryDefinition) {
                response = this.doPost(null, requestBldr, structure);
            } else if (queryDef instanceof RawQueryDefinition) {
                response = this.doPost(null, requestBldr, baseHandle.sendContent());
            } else if (queryDef instanceof StringQueryDefinition) {
                response = this.sendRequestOnce(requestBldr.get());
            } else {
                throw new UnsupportedOperationException("Cannot match with " + queryDef.getClass().getName());
            }
            status = response.code();
            if (!this.retryStatus.contains(status)) {
                if (!this.isFirstRequest()) break;
                this.setFirstRequest(false);
                break;
            }
            String retryAfterRaw = response.header("Retry-After");
            int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
            OkHttpServices.closeResponse(response);
            nextDelay = Math.max(retryAfter, this.calculateDelay(this.randRetry, retry));
        }
        if (this.retryStatus.contains(status)) {
            this.checkFirstRequest();
            OkHttpServices.closeResponse(response);
            throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
        }
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to match", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("match failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        InputStream inputStream = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, InputStream.class) : null;
        if (entity == null) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    @Override
    public InputStream match(String[] docIds, String[] candidateRules, ServerTransform transform) {
        InputStream entity;
        Function<Request.Builder, Response> doGetFunction;
        RequestParameters params = new RequestParameters();
        if (docIds.length > 0) {
            for (String docId : docIds) {
                params.add("uri", docId);
            }
        }
        if (candidateRules.length > 0) {
            for (String candidateRule : candidateRules) {
                params.add("rule", candidateRule);
            }
        }
        if (transform != null) {
            transform.merge(params);
        }
        Request.Builder requestBldr = this.setupRequest("alert/match", params, "application/xml", "application/xml");
        Response response = this.sendRequestWithRetry(requestBldr = this.addTelemetryAgentId(requestBldr), doGetFunction = new Function<Request.Builder, Response>(){

            @Override
            public Response apply(Request.Builder funcBuilder) {
                return OkHttpServices.this.doGet(funcBuilder);
            }
        }, null);
        int status = response.code();
        if (status == 403) {
            throw new ForbiddenUserException("User is not allowed to match", this.extractErrorFields(response));
        }
        if (status != 200) {
            throw new FailedRequestException("match failed: " + OkHttpServices.getReasonPhrase(response), this.extractErrorFields(response));
        }
        ResponseBody body = response.body();
        InputStream inputStream = entity = body.contentLength() != 0L ? OkHttpServices.getEntity(body, InputStream.class) : null;
        if (entity == null) {
            OkHttpServices.closeResponse(response);
        }
        return entity;
    }

    private void addGraphUriParam(RequestParameters params, String uri) {
        if (uri == null || uri.equals("com.marklogic.client.semantics.GraphManager.DEFAULT_GRAPH")) {
            params.add("default", "");
        } else {
            params.add("graph", uri);
        }
    }

    private void addPermsParams(RequestParameters params, GraphPermissions permissions) {
        if (permissions != null) {
            for (Map.Entry entry : permissions.entrySet()) {
                if (entry.getValue() == null) continue;
                for (Capability capability : (Set)entry.getValue()) {
                    params.add("perm:" + (String)entry.getKey(), capability.toString().toLowerCase());
                }
            }
        }
    }

    @Override
    public <R extends AbstractReadHandle> R getGraphUris(RequestLogger reqlog, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.getResource(reqlog, "graphs", null, null, output);
    }

    @Override
    public <R extends AbstractReadHandle> R readGraph(RequestLogger reqlog, String uri, R output, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        return this.getResource(reqlog, "graphs", transaction, params, output);
    }

    @Override
    public void writeGraph(RequestLogger reqlog, String uri, AbstractWriteHandle input, GraphPermissions permissions, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        this.addPermsParams(params, permissions);
        this.putResource(reqlog, "graphs", transaction, params, input, null);
    }

    @Override
    public void writeGraphs(RequestLogger reqlog, AbstractWriteHandle input, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.putResource(reqlog, "graphs", transaction, params, input, null);
    }

    @Override
    public void mergeGraph(RequestLogger reqlog, String uri, AbstractWriteHandle input, GraphPermissions permissions, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        this.addPermsParams(params, permissions);
        this.postResource(reqlog, "graphs", transaction, params, input, null);
    }

    @Override
    public void mergeGraphs(RequestLogger reqlog, AbstractWriteHandle input, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.postResource(reqlog, "graphs", transaction, params, input, null);
    }

    @Override
    public <R extends AbstractReadHandle> R getPermissions(RequestLogger reqlog, String uri, R output, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        params.add("category", "permissions");
        return this.getResource(reqlog, "graphs", transaction, params, output);
    }

    @Override
    public void deletePermissions(RequestLogger reqlog, String uri, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        params.add("category", "permissions");
        this.deleteResource(reqlog, "graphs", transaction, params, null);
    }

    @Override
    public void writePermissions(RequestLogger reqlog, String uri, AbstractWriteHandle permissions, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        params.add("category", "permissions");
        this.putResource(reqlog, "graphs", transaction, params, permissions, null);
    }

    @Override
    public void mergePermissions(RequestLogger reqlog, String uri, AbstractWriteHandle permissions, Transaction transaction) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        params.add("category", "permissions");
        this.postResource(reqlog, "graphs", transaction, params, permissions, null);
    }

    @Override
    public Object deleteGraph(RequestLogger reqlog, String uri, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        RequestParameters params = new RequestParameters();
        this.addGraphUriParam(params, uri);
        return this.deleteResource(reqlog, "graphs", transaction, params, null);
    }

    @Override
    public void deleteGraphs(RequestLogger reqlog, Transaction transaction) throws ForbiddenUserException, FailedRequestException {
        this.deleteResource(reqlog, "graphs", transaction, null, null);
    }

    @Override
    public <R extends AbstractReadHandle> R getThings(RequestLogger reqlog, String[] iris, R output) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (iris == null) {
            throw new IllegalArgumentException("iris cannot be null");
        }
        RequestParameters params = new RequestParameters();
        for (String iri : iris) {
            params.add("iri", iri);
        }
        return this.getResource(reqlog, "graphs/things", null, params, output);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <R extends AbstractReadHandle> R executeSparql(RequestLogger reqlog, SPARQLQueryDefinition qdef, R output, long start, long pageLength, Transaction transaction, boolean isUpdate) {
        StringHandle input;
        if (qdef == null) {
            throw new IllegalArgumentException("qdef cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null");
        }
        RequestParameters params = new RequestParameters();
        if (start > 1L) {
            params.add("start", Long.toString(start));
        }
        if (pageLength >= 0L) {
            params.add("pageLength", Long.toString(pageLength));
        }
        if (qdef.getOptimizeLevel() >= 0) {
            params.add("optimize", Integer.toString(qdef.getOptimizeLevel()));
        }
        if (qdef.getCollections() != null) {
            for (String collection : qdef.getCollections()) {
                params.add("collection", collection);
            }
        }
        this.addPermsParams(params, qdef.getUpdatePermissions());
        String sparql = qdef.getSparql();
        SPARQLBindings bindings = qdef.getBindings();
        for (Map.Entry entry : bindings.entrySet()) {
            String paramName = "bind:" + (String)entry.getKey();
            Object typeOrLang = "";
            for (SPARQLBinding binding : (List)entry.getValue()) {
                if (binding.getDatatype() != null) {
                    typeOrLang = ":" + binding.getDatatype();
                } else if (binding.getLanguageTag() != null) {
                    typeOrLang = "@" + binding.getLanguageTag().toLanguageTag();
                }
                params.add(paramName + (String)typeOrLang, binding.getValue());
            }
        }
        QueryDefinition constrainingQuery = qdef.getConstrainingQueryDefinition();
        if (constrainingQuery != null) {
            Format format;
            CombinedQueryDefinition combinedQdef;
            if (qdef.getOptionsName() != null && qdef.getOptionsName().length() > 0) {
                params.add("options", qdef.getOptionsName());
            }
            if (constrainingQuery instanceof RawCombinedQueryDefinition) {
                combinedQdef = new CombinedQueryBuilderImpl().combine((RawCombinedQueryDefinition)constrainingQuery, null, null, sparql);
                format = combinedQdef.getFormat();
                input = new StringHandle(combinedQdef.serialize()).withFormat(format);
            } else if (constrainingQuery instanceof RawStructuredQueryDefinition) {
                combinedQdef = new CombinedQueryBuilderImpl().combine((RawStructuredQueryDefinition)constrainingQuery, null, null, sparql);
                format = combinedQdef.getFormat();
                input = new StringHandle(combinedQdef.serialize()).withFormat(format);
            } else {
                if (!(constrainingQuery instanceof StringQueryDefinition) && !(constrainingQuery instanceof StructuredQueryDefinition)) throw new IllegalArgumentException("Constraining query must be of type SPARQLConstrainingQueryDefinition");
                String stringQuery = constrainingQuery instanceof StringQueryDefinition ? ((StringQueryDefinition)constrainingQuery).getCriteria() : null;
                StructuredQueryDefinition structuredQuery = constrainingQuery instanceof StructuredQueryDefinition ? (StructuredQueryDefinition)constrainingQuery : null;
                CombinedQueryDefinition combinedQdef2 = new CombinedQueryBuilderImpl().combine(structuredQuery, null, stringQuery, sparql);
                input = new StringHandle(combinedQdef2.serialize()).withMimetype("application/xml");
            }
        } else {
            String mimetype = isUpdate ? "application/sparql-update" : "application/sparql-query";
            input = new StringHandle(sparql).withMimetype(mimetype);
        }
        if (qdef.getBaseUri() != null) {
            params.add("base", qdef.getBaseUri());
        }
        if (qdef.getDefaultGraphUris() != null) {
            for (String defaultGraphUri : qdef.getDefaultGraphUris()) {
                params.add("default-graph-uri", defaultGraphUri);
            }
        }
        if (qdef.getNamedGraphUris() != null) {
            for (String namedGraphUri : qdef.getNamedGraphUris()) {
                params.add("named-graph-uri", namedGraphUri);
            }
        }
        if (qdef.getUsingGraphUris() != null) {
            for (String usingGraphUri : qdef.getUsingGraphUris()) {
                params.add("using-graph-uri", usingGraphUri);
            }
        }
        if (qdef.getUsingNamedGraphUris() != null) {
            for (String usingNamedGraphUri : qdef.getUsingNamedGraphUris()) {
                params.add("using-named-graph-uri", usingNamedGraphUri);
            }
        }
        if (qdef.getRulesets() != null) {
            for (SPARQLRuleset ruleset : qdef.getRulesets()) {
                params.add("ruleset", ruleset.getName());
            }
        }
        if (qdef.getIncludeDefaultRulesets() == null) return this.postResource(reqlog, "/graphs/sparql", transaction, params, input, output);
        params.add("default-rulesets", qdef.getIncludeDefaultRulesets() != false ? "include" : "exclude");
        return this.postResource(reqlog, "/graphs/sparql", transaction, params, input, output);
    }

    private static String getTransactionId(Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        return transaction.getTransactionId();
    }

    private static String getReasonPhrase(Response response) {
        if (response == null || response.message() == null) {
            return "";
        }
        return response.message().replaceFirst("^\\d+ ", "");
    }

    private static <T> T getEntity(BodyPart part, Class<T> as) {
        try {
            String contentType = part.getContentType();
            return OkHttpServices.getEntity(ResponseBody.create((MediaType)MediaType.parse((String)contentType), (long)part.getSize(), (BufferedSource)Okio.buffer((Source)Okio.source((InputStream)part.getInputStream()))), as);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    private static MediaType makeType(String mimetype) {
        if (mimetype == null) {
            return null;
        }
        MediaType type = MediaType.parse((String)mimetype);
        if (type == null) {
            throw new IllegalArgumentException("Invalid mime-type: " + mimetype);
        }
        return type;
    }

    private static <T> T getEntity(ResponseBody body, Class<T> as) {
        try {
            if (as == InputStream.class) {
                return (T)body.byteStream();
            }
            if (as == byte[].class) {
                return (T)body.bytes();
            }
            if (as == Reader.class) {
                return (T)body.charStream();
            }
            if (as == String.class) {
                return (T)body.string();
            }
            if (as == MimeMultipart.class) {
                MediaType mediaType = body.contentType();
                String contentType = mediaType != null ? mediaType.toString() : "application/x-unknown-content-type";
                ByteArrayDataSource dataSource = new ByteArrayDataSource(body.byteStream(), contentType);
                return (T)new MimeMultipart((DataSource)dataSource);
            }
            if (as == File.class) {
                String subtype;
                Object suffix = ".unknown";
                boolean isBinary = true;
                MediaType mediaType = body.contentType();
                if (mediaType != null && (subtype = mediaType.subtype()) != null) {
                    if ((subtype = subtype.toLowerCase()).endsWith("json")) {
                        suffix = ".json";
                        isBinary = false;
                    } else if (subtype.endsWith("xml")) {
                        suffix = ".xml";
                        isBinary = false;
                    } else if (subtype.equals("vnd.marklogic-js-module")) {
                        suffix = ".mjs";
                        isBinary = false;
                    } else if (subtype.equals("vnd.marklogic-javascript")) {
                        suffix = ".sjs";
                        isBinary = false;
                    } else if (subtype.equals("vnd.marklogic-xdmp") || subtype.endsWith("xquery")) {
                        suffix = ".xqy";
                        isBinary = false;
                    } else if (subtype.endsWith("javascript")) {
                        suffix = ".js";
                        isBinary = false;
                    } else if (subtype.endsWith("html")) {
                        suffix = ".html";
                        isBinary = false;
                    } else if (mediaType.type().equalsIgnoreCase("text")) {
                        suffix = ".txt";
                        isBinary = false;
                    } else {
                        suffix = "." + subtype;
                    }
                }
                Path path = Files.createTempFile("tmp", (String)suffix, new FileAttribute[0]);
                if (isBinary) {
                    Files.copy(body.byteStream(), path, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    try (BufferedWriter out = Files.newBufferedWriter(path, Charset.forName("UTF-8"), new OpenOption[0]);){
                        Utilities.write(body.charStream(), out);
                    }
                }
                return (T)path.toFile();
            }
            throw new IllegalArgumentException("Handle recieveAs returned " + as + " which is not a supported type.  Try InputStream, Reader, String, byte[], File.");
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    private static List<BodyPart> getPartList(MimeMultipart multipart) {
        try {
            if (multipart == null) {
                return null;
            }
            ArrayList<BodyPart> partList = new ArrayList<BodyPart>();
            for (int i = 0; i < multipart.getCount(); ++i) {
                partList.add(multipart.getBodyPart(i));
            }
            return partList;
        }
        catch (MessagingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public RESTServices.CallRequest makeEmptyRequest(String endpoint, RESTServices.HttpMethod method, SessionState session) {
        return new CallRequestImpl(endpoint, method, session).withEmptyRequest();
    }

    @Override
    public RESTServices.CallRequest makeAtomicBodyRequest(String endpoint, RESTServices.HttpMethod method, SessionState session, RESTServices.CallField ... params) {
        if (params == null || params.length == 0) {
            return this.makeEmptyRequest(endpoint, method, session);
        }
        return new CallRequestImpl(endpoint, method, session).withAtomicBodyRequest(params);
    }

    @Override
    public RESTServices.CallRequest makeNodeBodyRequest(String endpoint, RESTServices.HttpMethod method, SessionState session, RESTServices.CallField ... params) {
        if (params == null || params.length == 0) {
            return this.makeEmptyRequest(endpoint, method, session);
        }
        return new CallRequestImpl(endpoint, method, session).withNodeBodyRequest(params);
    }

    private static String encodeParamValue(String paramName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return paramName + "=" + URLEncoder.encode(value, UTF8_ID);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported", e);
        }
    }

    private static String encodeParamValue(RESTServices.SingleAtomicCallField param) {
        if (param == null) {
            return null;
        }
        return OkHttpServices.encodeParamValue(param.getParamName(), param.getParamValue());
    }

    private static String encodeParamValue(RESTServices.MultipleAtomicCallField param) {
        if (param == null) {
            return null;
        }
        String paramName = param.getParamName();
        Stream<String> paramValues = param.getParamValues();
        if (paramValues == null) {
            return null;
        }
        String encodedParamValues = paramValues.map(paramValue -> OkHttpServices.encodeParamValue(paramName, paramValue)).filter(paramValue -> paramValue != null).collect(Collectors.joining("&"));
        if (encodedParamValues == null || encodedParamValues.length() == 0) {
            return null;
        }
        return encodedParamValues;
    }

    private static String encodeParamValue(RESTServices.CallField param) {
        if (param == null) {
            return null;
        }
        if (param instanceof RESTServices.SingleAtomicCallField) {
            return OkHttpServices.encodeParamValue((RESTServices.SingleAtomicCallField)param);
        }
        if (param instanceof RESTServices.MultipleAtomicCallField) {
            return OkHttpServices.encodeParamValue((RESTServices.MultipleAtomicCallField)param);
        }
        throw new IllegalStateException("could not encode parameter " + param.getParamName() + " of type: " + param.getClass().getName());
    }

    protected static boolean checkNull(ResponseBody body, Format expectedFormat) {
        if (body != null) {
            if (body.contentLength() == 0L) {
                body.close();
            } else {
                MediaType actualType = body.contentType();
                if (actualType == null) {
                    body.close();
                    throw new RuntimeException("Returned document with unknown mime type instead of " + expectedFormat.getDefaultMimetype());
                }
                Format actualFormat = Format.getFromMimetype(actualType.toString());
                if (expectedFormat != actualFormat) {
                    body.close();
                    throw new RuntimeException("Mime type " + actualType.toString() + " for returned document not recognized for " + expectedFormat.name());
                }
                return false;
            }
        }
        return true;
    }

    protected static boolean checkNull(MimeMultipart multipart, Format expectedFormat) {
        if (multipart != null) {
            try {
                if (multipart.getCount() != 0) {
                    String actualType;
                    BodyPart firstPart = multipart.getBodyPart(0);
                    String string = actualType = firstPart == null ? null : firstPart.getContentType();
                    if (actualType == null) {
                        throw new RuntimeException("Returned document with unknown mime type instead of " + expectedFormat.getDefaultMimetype());
                    }
                    Format actualFormat = Format.getFromMimetype(actualType);
                    if (expectedFormat != actualFormat) {
                        throw new RuntimeException("Mime type " + actualType + " for returned document not recognized for " + expectedFormat.name());
                    }
                    return false;
                }
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
        }
        return true;
    }

    private static void closeResponse(Response response) {
        if (response == null || response.body() == null) {
            return;
        }
        response.close();
    }

    Request.Builder forDocumentResponse(Request.Builder requestBldr, Format format) {
        return requestBldr.addHeader("Accept", format == Format.BINARY ? "application/x-unknown-content-type" : format.getDefaultMimetype());
    }

    Request.Builder forMultipartMixedResponse(Request.Builder requestBldr) {
        return requestBldr.addHeader("Accept", this.multipartMixedWithBoundary());
    }

    @FunctionalInterface
    private static interface ResultIteratorConstructor<T> {
        public T construct(RequestLogger var1, List var2, Closeable var3);
    }

    static class ConnectionResultImpl
    implements DatabaseClient.ConnectionResult {
        private boolean connected = false;
        private int statusCode;
        private String errorMessage;

        ConnectionResultImpl() {
        }

        @Override
        public boolean isConnected() {
            return this.connected;
        }

        private void setConnected(boolean connected) {
            this.connected = connected;
        }

        @Override
        public Integer getStatusCode() {
            return this.statusCode;
        }

        private void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        private void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    protected static class Condition {
        private boolean is = false;

        protected Condition() {
        }

        protected boolean get() {
            return this.is;
        }

        protected void set() {
            if (!this.is) {
                this.is = true;
            }
        }
    }

    static class MultipleCallResponseImpl
    extends CallResponseImpl
    implements RESTServices.MultipleCallResponse {
        private Format format;
        private MimeMultipart multipart;

        MultipleCallResponseImpl(Format format) {
            this.format = format;
        }

        @Override
        void setResponse(Response response) {
            try {
                super.setResponse(response);
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    this.setNull(true);
                    return;
                }
                MediaType contentType = responseBody.contentType();
                if (contentType == null) {
                    this.setNull(true);
                    return;
                }
                ByteArrayDataSource dataSource = new ByteArrayDataSource(responseBody.byteStream(), contentType.toString());
                this.setMultipart(new MimeMultipart((DataSource)dataSource));
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
        }

        void setMultipart(MimeMultipart multipart) {
            if (!OkHttpServices.checkNull(multipart, this.format)) {
                this.multipart = multipart;
                this.setNull(false);
            }
        }

        @Override
        public Stream<byte[]> asStreamOfBytes() {
            try {
                if (this.multipart == null) {
                    return Stream.empty();
                }
                int partCount = this.multipart.getCount();
                Stream.Builder<byte[]> builder = Stream.builder();
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    builder.accept(NodeConverter.InputStreamToBytes(bodyPart.getInputStream()));
                }
                return builder.build();
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Stream<InputStreamHandle> asStreamOfInputStreamHandle() {
            try {
                if (this.multipart == null) {
                    return Stream.empty();
                }
                int partCount = this.multipart.getCount();
                Stream.Builder<InputStreamHandle> builder = Stream.builder();
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    builder.accept(new InputStreamHandle(bodyPart.getInputStream()));
                }
                return builder.build();
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public Stream<InputStream> asStreamOfInputStream() {
            try {
                if (this.multipart == null) {
                    return Stream.empty();
                }
                int partCount = this.multipart.getCount();
                Stream.Builder<InputStream> builder = Stream.builder();
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    builder.accept(bodyPart.getInputStream());
                }
                return builder.build();
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public Stream<Reader> asStreamOfReader() {
            try {
                if (this.multipart == null) {
                    return Stream.empty();
                }
                int partCount = this.multipart.getCount();
                Stream.Builder<Reader> builder = Stream.builder();
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    builder.accept(NodeConverter.InputStreamToReader(bodyPart.getInputStream()));
                }
                return builder.build();
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public Stream<ReaderHandle> asStreamOfReaderHandle() {
            try {
                if (this.multipart == null) {
                    return Stream.empty();
                }
                int partCount = this.multipart.getCount();
                Stream.Builder<ReaderHandle> builder = Stream.builder();
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    builder.accept(new ReaderHandle(NodeConverter.InputStreamToReader(bodyPart.getInputStream())));
                }
                return builder.build();
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public Stream<String> asStreamOfString() {
            try {
                if (this.multipart == null) {
                    return Stream.empty();
                }
                int partCount = this.multipart.getCount();
                Stream.Builder<String> builder = Stream.builder();
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    builder.accept(NodeConverter.InputStreamToString(bodyPart.getInputStream()));
                }
                return builder.build();
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public byte[][] asArrayOfBytes() {
            try {
                if (this.multipart == null) {
                    return new byte[0][];
                }
                int partCount = this.multipart.getCount();
                byte[][] result = new byte[partCount][];
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    result[i] = NodeConverter.InputStreamToBytes(bodyPart.getInputStream());
                }
                return result;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public InputStream[] asArrayOfInputStream() {
            try {
                if (this.multipart == null) {
                    return new InputStream[0];
                }
                int partCount = this.multipart.getCount();
                InputStream[] result = new InputStream[partCount];
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    result[i] = bodyPart.getInputStream();
                }
                return result;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public InputStreamHandle[] asArrayOfInputStreamHandle() {
            try {
                if (this.multipart == null) {
                    return new InputStreamHandle[0];
                }
                int partCount = this.multipart.getCount();
                InputStreamHandle[] result = new InputStreamHandle[partCount];
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    result[i] = new InputStreamHandle(bodyPart.getInputStream());
                }
                return result;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public ReaderHandle[] asArrayOfReaderHandle() {
            try {
                if (this.multipart == null) {
                    return new ReaderHandle[0];
                }
                int partCount = this.multipart.getCount();
                ReaderHandle[] result = new ReaderHandle[partCount];
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    result[i] = new ReaderHandle(NodeConverter.InputStreamToReader(bodyPart.getInputStream()));
                }
                return result;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public Reader[] asArrayOfReader() {
            try {
                if (this.multipart == null) {
                    return new Reader[0];
                }
                int partCount = this.multipart.getCount();
                Reader[] result = new Reader[partCount];
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    result[i] = NodeConverter.InputStreamToReader(bodyPart.getInputStream());
                }
                return result;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public String[] asArrayOfString() {
            try {
                if (this.multipart == null) {
                    return new String[0];
                }
                int partCount = this.multipart.getCount();
                String[] result = new String[partCount];
                for (int i = 0; i < partCount; ++i) {
                    BodyPart bodyPart = this.multipart.getBodyPart(i);
                    result[i] = NodeConverter.InputStreamToString(bodyPart.getInputStream());
                }
                return result;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }
    }

    static class SingleCallResponseImpl
    extends CallResponseImpl
    implements RESTServices.SingleCallResponse,
    AutoCloseable {
        private Format format;
        private ResponseBody responseBody;

        SingleCallResponseImpl(Format format) {
            this.format = format;
        }

        @Override
        void setResponse(Response response) {
            super.setResponse(response);
            this.setResponseBody(response.body());
        }

        void setResponseBody(ResponseBody responseBody) {
            if (!OkHttpServices.checkNull(responseBody, this.format)) {
                this.responseBody = responseBody;
                this.setNull(false);
            }
        }

        @Override
        public byte[] asBytes() {
            try {
                if (this.responseBody == null) {
                    return null;
                }
                byte[] value = this.responseBody.bytes();
                this.closeImpl();
                return value;
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public InputStream asInputStream() {
            return this.responseBody == null ? null : this.responseBody.byteStream();
        }

        @Override
        public InputStreamHandle asInputStreamHandle() {
            return this.responseBody == null ? null : new InputStreamHandle(this.asInputStream());
        }

        @Override
        public Reader asReader() {
            return this.responseBody == null ? null : this.responseBody.charStream();
        }

        @Override
        public ReaderHandle asReaderHandle() {
            return this.responseBody == null ? null : new ReaderHandle(this.asReader());
        }

        @Override
        public String asString() {
            try {
                if (this.responseBody == null) {
                    return null;
                }
                String value = this.responseBody.string();
                this.closeImpl();
                return value;
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public void close() {
            if (this.responseBody != null) {
                this.closeImpl();
            }
        }

        private void closeImpl() {
            this.responseBody.close();
            this.responseBody = null;
        }
    }

    static class CallResponseImpl
    implements RESTServices.CallResponse {
        private boolean isNull = true;
        private Response response;

        CallResponseImpl() {
        }

        void setResponse(Response response) {
            this.response = response;
        }

        @Override
        public boolean isNull() {
            return this.isNull;
        }

        void setNull(boolean isNull) {
            this.isNull = isNull;
        }

        @Override
        public int getStatusCode() {
            return this.response.code();
        }

        @Override
        public String getStatusMsg() {
            return this.response.message();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getErrorBody() {
            try (ResponseBody errorBody = this.response.body();){
                if (errorBody.contentLength() <= 0L) return null;
                MediaType errorType = errorBody.contentType();
                if (errorType == null) return null;
                String subtype = errorType.subtype();
                if (subtype == null) return null;
                if (!subtype.toLowerCase().endsWith("json")) return null;
                String string = errorBody.string();
                return string;
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public void close() {
        }
    }

    class CallRequestImpl
    implements RESTServices.CallRequest {
        private SessionStateImpl session;
        private Request.Builder requestBldr;
        private RequestBody requestBody;
        private boolean hasStreamingPart;
        private RESTServices.HttpMethod method;
        private String endpoint;
        private HttpUrl callBaseUri;

        CallRequestImpl(String endpoint, RESTServices.HttpMethod method, SessionState session) {
            if (session != null && !(session instanceof SessionStateImpl)) {
                throw new IllegalArgumentException("Session state must be implemented by internal class: " + session.getClass().getName());
            }
            this.endpoint = endpoint;
            this.method = method;
            this.session = (SessionStateImpl)session;
            this.hasStreamingPart = false;
            this.callBaseUri = new HttpUrl.Builder().scheme(OkHttpServices.this.baseUri.scheme()).host(OkHttpServices.this.baseUri.host()).port(OkHttpServices.this.baseUri.port()).encodedPath("/").build();
        }

        @Override
        public RESTServices.CallResponse withEmptyResponse() {
            this.prepareRequestBuilder();
            CallResponseImpl responseImpl = new CallResponseImpl();
            this.executeRequest(responseImpl);
            return responseImpl;
        }

        @Override
        public RESTServices.SingleCallResponse withDocumentResponse(Format format) {
            this.prepareRequestBuilder();
            SingleCallResponseImpl responseImpl = new SingleCallResponseImpl(format);
            this.requestBldr = OkHttpServices.this.forDocumentResponse(this.requestBldr, format);
            this.executeRequest(responseImpl);
            return responseImpl;
        }

        @Override
        public RESTServices.MultipleCallResponse withMultipartMixedResponse(Format format) {
            this.prepareRequestBuilder();
            MultipleCallResponseImpl responseImpl = new MultipleCallResponseImpl(format);
            this.requestBldr = OkHttpServices.this.forMultipartMixedResponse(this.requestBldr);
            this.executeRequest(responseImpl);
            return responseImpl;
        }

        @Override
        public boolean hasStreamingPart() {
            return this.hasStreamingPart;
        }

        @Override
        public SessionState getSession() {
            return this.session;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public RESTServices.HttpMethod getHttpMethod() {
            return this.method;
        }

        private void prepareRequestBuilder() {
            this.requestBldr = OkHttpServices.this.setupRequest(this.callBaseUri, this.endpoint, null);
            if (this.session != null) {
                this.requestBldr = OkHttpServices.this.addCookies(this.requestBldr, this.session.getCookies(), this.session.getCreatedTimestamp());
                this.requestBldr.addHeader("Cookie", "SessionID=" + this.session.getSessionId());
            }
            this.addHttpMethod();
            this.requestBldr.addHeader("X-Error-Accept", "application/json");
        }

        private void addHttpMethod() {
            if (this.method != null && this.method == RESTServices.HttpMethod.POST) {
                if (this.requestBody == null) {
                    throw new IllegalStateException("Request Body is null!");
                }
            } else {
                throw new IllegalStateException("HTTP method is null or invalid!");
            }
            this.requestBldr.post(this.requestBody);
        }

        private void executeRequest(CallResponseImpl responseImpl) {
            SessionState session = this.getSession();
            boolean hasStreamingPart = this.hasStreamingPart();
            Consumer<Boolean> resendableConsumer = resendable -> {
                if (hasStreamingPart) {
                    OkHttpServices.this.checkFirstRequest();
                    throw new ResourceNotResendableException("Cannot retry request for " + this.getEndpoint());
                }
            };
            Function<Request.Builder, Response> sendRequestFunction = requestBldr -> {
                if (OkHttpServices.this.isFirstRequest() && hasStreamingPart) {
                    OkHttpServices.this.makeFirstRequest(this.callBaseUri, "", 0);
                }
                Response response = OkHttpServices.this.sendRequestOnce(requestBldr);
                if (OkHttpServices.this.isFirstRequest()) {
                    OkHttpServices.this.setFirstRequest(false);
                }
                return response;
            };
            Response response = OkHttpServices.this.sendRequestWithRetry(this.requestBldr, sendRequestFunction, resendableConsumer);
            if (session != null) {
                ArrayList<ClientCookie> cookies = new ArrayList<ClientCookie>();
                for (String setCookie : response.headers("Set-Cookie")) {
                    ClientCookie cookie = ClientCookie.parse(this.requestBldr.build().url(), setCookie);
                    cookies.add(cookie);
                }
                ((SessionStateImpl)session).setCookies(cookies);
            }
            this.checkStatus(response);
            responseImpl.setResponse(response);
        }

        private void checkStatus(Response response) {
            int statusCode = response.code();
            if (statusCode >= 300) {
                String subtype;
                FailedRequest failure = null;
                String contentType = response.header("Content-Type");
                MediaType mediaType = MediaType.parse((String)(contentType != null ? contentType : "application/x-unknown-content-type"));
                String string = subtype = mediaType != null ? mediaType.subtype() : null;
                if (subtype != null && ((subtype = subtype.toLowerCase()).endsWith("json") || subtype.endsWith("xml"))) {
                    failure = OkHttpServices.this.extractErrorFields(response);
                }
                if (failure == null) {
                    OkHttpServices.closeResponse(response);
                    if (statusCode == 401) {
                        failure = new FailedRequest();
                        failure.setMessageString("Unauthorized");
                        failure.setStatusString("Failed Auth");
                    } else {
                        if (statusCode == 404) {
                            throw new ResourceNotFoundException("Could not " + this.method + " at " + this.endpoint);
                        }
                        if (statusCode == 403) {
                            throw new ForbiddenUserException("User is not allowed to " + this.method + " at " + this.endpoint);
                        }
                        failure = new FailedRequest();
                        failure.setStatusCode(statusCode);
                        failure.setMessageCode("UNKNOWN");
                        failure.setMessageString("Server did not respond with an expected Error message.");
                        failure.setStatusString("UNKNOWN");
                    }
                }
                FailedRequestException ex = failure == null ? new FailedRequestException("failed to " + this.method + " at " + this.endpoint + ": " + OkHttpServices.getReasonPhrase(response)) : new FailedRequestException("failed to " + this.method + " at " + this.endpoint + ": " + OkHttpServices.getReasonPhrase(response), failure);
                throw ex;
            }
        }

        public RESTServices.CallRequest withEmptyRequest() {
            this.requestBody = new EmptyRequestBody();
            return this;
        }

        public RESTServices.CallRequest withAtomicBodyRequest(RESTServices.CallField ... params) {
            String atomics = Stream.of(params).map(param -> OkHttpServices.encodeParamValue(param)).filter(param -> param != null).collect(Collectors.joining("&"));
            this.requestBody = RequestBody.create((MediaType)URLENCODED_MIME_TYPE, (String)(atomics == null ? "" : atomics));
            return this;
        }

        public RESTServices.CallRequest withNodeBodyRequest(RESTServices.CallField ... params) {
            this.requestBody = this.makeRequestBody(params);
            return this;
        }

        private RequestBody makeRequestBody(String value) {
            if (value == null) {
                return new EmptyRequestBody();
            }
            return new AtomicRequestBody(value, MediaType.parse((String)"text/plain"));
        }

        private RequestBody makeRequestBody(AbstractWriteHandle document) {
            if (document == null) {
                return new EmptyRequestBody();
            }
            HandleImplementation handleBase = HandleAccessor.as(document);
            Format format = handleBase.getFormat();
            String mimetype = format == Format.BINARY ? null : handleBase.getMimetype();
            MediaType mediaType = MediaType.parse((String)(mimetype != null ? mimetype : "application/x-unknown-content-type"));
            return document instanceof OutputStreamSender ? new StreamingOutputImpl((OutputStreamSender)((Object)document), null, mediaType) : new ObjectRequestBody(HandleAccessor.sendContent(document), mediaType);
        }

        private RequestBody makeRequestBody(RESTServices.CallField[] params) {
            if (params == null || params.length == 0) {
                return new EmptyRequestBody();
            }
            MultipartBody.Builder multiBldr = new MultipartBody.Builder();
            multiBldr.setType(MultipartBody.FORM);
            Condition hasValue = new Condition();
            Condition hasStreamingPartCondition = new Condition();
            for (RESTServices.CallField param : params) {
                Object paramValues;
                if (param == null) continue;
                String paramName = param.getParamName();
                if (param instanceof RESTServices.SingleAtomicCallField) {
                    String paramValue2 = ((RESTServices.SingleAtomicCallField)param).getParamValue();
                    if (paramValue2 == null) continue;
                    hasValue.set();
                    multiBldr.addFormDataPart(paramName, null, this.makeRequestBody(paramValue2));
                    continue;
                }
                if (param instanceof RESTServices.MultipleAtomicCallField) {
                    paramValues = ((RESTServices.MultipleAtomicCallField)param).getParamValues();
                    if (paramValues == null) continue;
                    paramValues.filter(paramValue -> paramValue != null).forEachOrdered(paramValue -> multiBldr.addFormDataPart(paramName, null, this.makeRequestBody((String)paramValue)));
                    continue;
                }
                if (param instanceof RESTServices.SingleNodeCallField) {
                    RESTServices.SingleNodeCallField singleNodeParam = (RESTServices.SingleNodeCallField)param;
                    BufferableHandle paramValue3 = singleNodeParam.getParamValue();
                    if (paramValue3 == null) continue;
                    HandleImplementation handleBase = HandleAccessor.as(paramValue3);
                    if (!handleBase.isResendable()) {
                        BytesHandle bytesHandle = new BytesHandle(paramValue3);
                        singleNodeParam.setParamValue(bytesHandle);
                        paramValue3 = bytesHandle;
                    }
                    hasValue.set();
                    multiBldr.addFormDataPart(paramName, null, this.makeRequestBody(paramValue3));
                    continue;
                }
                if (param instanceof RESTServices.UnbufferedMultipleNodeCallField) {
                    paramValues = ((RESTServices.UnbufferedMultipleNodeCallField)param).getParamValues();
                    if (paramValues == null) continue;
                    paramValues.filter(paramValue -> paramValue != null).forEachOrdered(paramValue -> {
                        HandleImplementation handleBase = HandleAccessor.as(paramValue);
                        if (!handleBase.isResendable()) {
                            hasStreamingPartCondition.set();
                        }
                        hasValue.set();
                        multiBldr.addFormDataPart(paramName, null, this.makeRequestBody((AbstractWriteHandle)paramValue));
                    });
                    continue;
                }
                if (param instanceof RESTServices.BufferedMultipleNodeCallField) {
                    paramValues = ((RESTServices.BufferedMultipleNodeCallField)param).getParamValuesArray();
                    if (paramValues == null) continue;
                    boolean checkedBuffer = false;
                    for (int i = 0; i < ((BufferableHandle[])paramValues).length; ++i) {
                        BufferableHandle paramValue4 = paramValues[i];
                        if (paramValue4 == null) continue;
                        HandleImplementation handleBase = HandleAccessor.as(paramValue4);
                        if (!handleBase.isResendable()) {
                            paramValue4 = new BytesHandle(paramValue4);
                            if (!checkedBuffer) {
                                Class<?> actualClass = paramValues.getClass().getComponentType();
                                if (actualClass != BufferableHandle.class && actualClass != BytesHandle.class) {
                                    paramValues = (BufferableHandle[])Arrays.copyOf(paramValues, ((BufferableHandle[])paramValues).length, BufferableHandle[].class);
                                }
                                checkedBuffer = true;
                            }
                            paramValues[i] = paramValue4;
                        }
                        hasValue.set();
                        multiBldr.addFormDataPart(paramName, null, this.makeRequestBody(paramValue4));
                    }
                    continue;
                }
                throw new IllegalStateException("unknown multipart " + paramName + " param of: " + param.getClass().getName());
            }
            if (!hasValue.get()) {
                return new EmptyRequestBody();
            }
            this.hasStreamingPart = hasStreamingPartCondition.get();
            return multiBldr.build();
        }
    }

    static class AtomicRequestBody
    extends RequestBody {
        private MediaType contentType;
        private String value;

        AtomicRequestBody(String value, MediaType contentType) {
            this.value = value;
            this.contentType = contentType;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.writeUtf8(this.value);
        }
    }

    private static class EmptyRequestBody
    extends RequestBody {
        private EmptyRequestBody() {
        }

        public MediaType contentType() {
            return null;
        }

        public void writeTo(BufferedSink sink) {
        }
    }

    private static class ObjectRequestBody
    extends RequestBody {
        private Object obj;
        private MediaType contentType;

        ObjectRequestBody(Object obj, MediaType contentType) {
            this.obj = obj;
            this.contentType = contentType;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            if (this.obj instanceof InputStream) {
                sink.writeAll(Okio.source((InputStream)((InputStream)this.obj)));
            } else if (this.obj instanceof File) {
                try (Source source = Okio.source((File)((File)this.obj));){
                    sink.writeAll(source);
                }
            } else if (this.obj instanceof byte[]) {
                sink.write((byte[])this.obj);
            } else if (this.obj instanceof String) {
                sink.write(((String)this.obj).getBytes("UTF-8"));
            } else if (this.obj != null) {
                throw new IllegalStateException("Cannot write object of type: " + this.obj.getClass());
            }
        }
    }

    static class OkHttpDocumentRecord
    implements DocumentRecord {
        private OkHttpResult content;
        private OkHttpResult metadata;

        OkHttpDocumentRecord(OkHttpResult content, OkHttpResult metadata) {
            this.content = content;
            this.metadata = metadata;
        }

        OkHttpDocumentRecord(OkHttpResult content) {
            this.content = content;
        }

        @Override
        public String getUri() {
            if (this.content == null && this.metadata != null) {
                return this.metadata.getUri();
            }
            if (this.content != null) {
                return this.content.getUri();
            }
            throw new IllegalStateException("Missing both content and metadata!");
        }

        @Override
        public DocumentDescriptor getDescriptor() {
            if (this.content == null) {
                throw new IllegalStateException("getDescriptor() called when no content is available");
            }
            DocumentDescriptorImpl descriptor = new DocumentDescriptorImpl(this.getUri(), false);
            OkHttpServices.updateFormat(descriptor, this.getFormat());
            OkHttpServices.updateMimetype(descriptor, this.getMimetype());
            OkHttpServices.updateLength(descriptor, this.getLength());
            OkHttpServices.updateVersion(descriptor, this.content.getHeader("ETag"));
            return descriptor;
        }

        @Override
        public Format getFormat() {
            if (this.content == null) {
                throw new IllegalStateException("getFormat() called when no content is available");
            }
            return this.content.getFormat();
        }

        @Override
        public String getMimetype() {
            if (this.content == null) {
                throw new IllegalStateException("getMimetype() called when no content is available");
            }
            return this.content.getMimetype();
        }

        @Override
        public long getLength() {
            if (this.content == null) {
                throw new IllegalStateException("getLenth() called when no content is available");
            }
            return this.content.getLength();
        }

        @Override
        public <T extends DocumentMetadataReadHandle> T getMetadata(T metadataHandle) {
            if (this.metadata == null) {
                throw new IllegalStateException("getMetadata called when no metadata is available");
            }
            return this.metadata.getContent(metadataHandle);
        }

        @Override
        public <T> T getMetadataAs(Class<T> as) {
            if (as == null) {
                throw new IllegalStateException("getMetadataAs cannot accept null");
            }
            return this.metadata.getContentAs(as);
        }

        @Override
        public <T extends AbstractReadHandle> T getContent(T contentHandle) {
            if (this.content == null) {
                throw new IllegalStateException("getContent called when no content is available");
            }
            return this.content.getContent(contentHandle);
        }

        @Override
        public <T> T getContentAs(Class<T> as) {
            if (as == null) {
                throw new IllegalStateException("getContentAs cannot accept null");
            }
            return this.content.getContentAs(as);
        }
    }

    static class DefaultOkHttpResultIterator
    extends OkHttpResultIterator<OkHttpResult>
    implements Iterator<OkHttpResult> {
        DefaultOkHttpResultIterator(RequestLogger reqlog, List<BodyPart> partList, Closeable closeable) {
            super(reqlog, partList, closeable);
        }

        @Override
        OkHttpResult constructNext(RequestLogger logger, BodyPart part) {
            return new OkHttpResult(logger, part);
        }
    }

    static class OkHttpServiceResultIterator
    extends OkHttpResultIterator<OkHttpServiceResult>
    implements RESTServices.RESTServiceResultIterator {
        OkHttpServiceResultIterator(RequestLogger reqlog, List<BodyPart> partList, Closeable closeable) {
            super(reqlog, partList, closeable);
        }

        @Override
        OkHttpServiceResult constructNext(RequestLogger logger, BodyPart part) {
            return new OkHttpServiceResult(logger, part);
        }
    }

    static abstract class OkHttpResultIterator<T extends OkHttpResult> {
        private RequestLogger reqlog;
        private Iterator<BodyPart> partQueue;
        private long start = -1L;
        private long size = -1L;
        private long pageSize = -1L;
        private long totalSize = -1L;
        private Closeable closeable;

        OkHttpResultIterator(RequestLogger reqlog, List<BodyPart> partList, Closeable closeable) {
            this.reqlog = reqlog;
            if (partList != null && partList.size() > 0) {
                this.size = partList.size();
                this.partQueue = new ConcurrentLinkedQueue<BodyPart>(partList).iterator();
            } else {
                this.size = 0L;
            }
            this.closeable = closeable;
        }

        public long getStart() {
            return this.start;
        }

        public OkHttpResultIterator<T> setStart(long start) {
            this.start = start;
            return this;
        }

        public long getSize() {
            return this.size;
        }

        public OkHttpResultIterator<T> setSize(long size) {
            this.size = size;
            return this;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public OkHttpResultIterator<T> setPageSize(long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public OkHttpResultIterator<T> setTotalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public boolean hasNext() {
            if (this.partQueue == null) {
                return false;
            }
            boolean hasNext = this.partQueue.hasNext();
            return hasNext;
        }

        public T next() {
            if (this.partQueue == null) {
                return null;
            }
            try {
                return this.constructNext(this.reqlog, this.partQueue.next());
            }
            catch (Throwable t) {
                throw new IllegalStateException("Error instantiating iterated result", t);
            }
        }

        abstract T constructNext(RequestLogger var1, BodyPart var2);

        public void remove() {
            if (this.partQueue == null) {
                return;
            }
            this.partQueue.remove();
            if (!this.partQueue.hasNext()) {
                this.close();
            }
        }

        public void close() {
            this.partQueue = null;
            this.reqlog = null;
            if (this.closeable != null) {
                try {
                    this.closeable.close();
                }
                catch (IOException e) {
                    throw new MarkLogicIOException(e);
                }
            }
        }
    }

    static class OkHttpServiceResult
    extends OkHttpResult
    implements RESTServices.RESTServiceResult {
        OkHttpServiceResult(RequestLogger reqlog, BodyPart part) {
            super(reqlog, part);
        }
    }

    static class OkHttpResult {
        private RequestLogger reqlog;
        private BodyPart part;
        private boolean extractedHeaders = false;
        private String uri;
        private RequestParameters headers = new RequestParameters();
        private Format format;
        private String mimetype;
        private long length;

        OkHttpResult(RequestLogger reqlog, BodyPart part) {
            this.reqlog = reqlog;
            this.part = part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R extends AbstractReadHandle> R getContent(R handle) {
            if (this.part == null) {
                throw new IllegalStateException("Content already retrieved");
            }
            HandleImplementation handleBase = HandleAccessor.as(handle);
            this.extractHeaders();
            OkHttpServices.updateFormat(handleBase, this.format);
            OkHttpServices.updateMimetype(handleBase, this.mimetype);
            OkHttpServices.updateLength(handleBase, this.length);
            try {
                Object contentEntity = OkHttpServices.getEntity(this.part, handleBase.receiveAs());
                handleBase.receiveContent(this.reqlog != null ? this.reqlog.copyContent(contentEntity) : contentEntity);
                R r = handle;
                return r;
            }
            finally {
                this.part = null;
                this.reqlog = null;
            }
        }

        public <T> T getContentAs(Class<T> as) {
            ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(as);
            if ((readHandle = this.getContent(readHandle)) == null) {
                return null;
            }
            return readHandle.get();
        }

        public String getUri() {
            this.extractHeaders();
            return this.uri;
        }

        public Format getFormat() {
            this.extractHeaders();
            return this.format;
        }

        public String getMimetype() {
            this.extractHeaders();
            return this.mimetype;
        }

        public long getLength() {
            this.extractHeaders();
            return this.length;
        }

        public String getHeader(String name) {
            this.extractHeaders();
            Object values = this.headers.get(name);
            if (values != null && values.size() > 0) {
                return (String)values.get(0);
            }
            return null;
        }

        public Map<String, List<String>> getHeaders() {
            this.extractHeaders();
            return this.headers.getMap();
        }

        private void extractHeaders() {
            if (this.part == null || this.extractedHeaders) {
                return;
            }
            try {
                Enumeration e = this.part.getAllHeaders();
                while (e.hasMoreElements()) {
                    Header header = (Header)e.nextElement();
                    this.headers.put(header.getName(), header.getValue());
                }
                this.format = OkHttpServices.getHeaderFormat(this.part);
                this.mimetype = OkHttpServices.getHeaderMimetype(OkHttpServices.getHeader(this.part, "Content-Type"));
                this.length = OkHttpServices.getHeaderLength(OkHttpServices.getHeader(this.part, "Content-Length"));
                this.uri = OkHttpServices.getHeaderUri(this.part);
                this.extractedHeaders = true;
            }
            catch (MessagingException e) {
                throw new MarkLogicIOException(e);
            }
        }
    }

    public class OkHttpEvalResult
    implements EvalResult {
        private OkHttpResult content;

        public OkHttpEvalResult(OkHttpResult content) {
            this.content = content;
        }

        @Override
        public Format getFormat() {
            return this.content.getFormat();
        }

        @Override
        public EvalResult.Type getType() {
            String contentType = this.content.getHeader("Content-Type");
            String xPrimitive = this.content.getHeader("X-Primitive");
            if (contentType != null) {
                if ("application/json".equals(contentType)) {
                    if ("null-node()".equals(xPrimitive)) {
                        return EvalResult.Type.NULL;
                    }
                    return EvalResult.Type.JSON;
                }
                if ("text/json".equals(contentType)) {
                    return EvalResult.Type.JSON;
                }
                if ("application/xml".equals(contentType)) {
                    return EvalResult.Type.XML;
                }
                if ("text/xml".equals(contentType)) {
                    return EvalResult.Type.XML;
                }
                if ("application/x-unknown-content-type".equals(contentType) && "binary()".equals(xPrimitive)) {
                    return EvalResult.Type.BINARY;
                }
                if ("application/octet-stream".equals(contentType) && "node()".equals(xPrimitive)) {
                    return EvalResult.Type.BINARY;
                }
            }
            if (xPrimitive == null) {
                return EvalResult.Type.OTHER;
            }
            if ("string".equals(xPrimitive) || "untypedAtomic".equals(xPrimitive)) {
                return EvalResult.Type.STRING;
            }
            if ("boolean".equals(xPrimitive)) {
                return EvalResult.Type.BOOLEAN;
            }
            if ("attribute()".equals(xPrimitive)) {
                return EvalResult.Type.ATTRIBUTE;
            }
            if ("comment()".equals(xPrimitive)) {
                return EvalResult.Type.COMMENT;
            }
            if ("processing-instruction()".equals(xPrimitive)) {
                return EvalResult.Type.PROCESSINGINSTRUCTION;
            }
            if ("text()".equals(xPrimitive)) {
                return EvalResult.Type.TEXTNODE;
            }
            if ("binary()".equals(xPrimitive)) {
                return EvalResult.Type.BINARY;
            }
            if ("duration".equals(xPrimitive)) {
                return EvalResult.Type.DURATION;
            }
            if ("date".equals(xPrimitive)) {
                return EvalResult.Type.DATE;
            }
            if ("anyURI".equals(xPrimitive)) {
                return EvalResult.Type.ANYURI;
            }
            if ("hexBinary".equals(xPrimitive)) {
                return EvalResult.Type.HEXBINARY;
            }
            if ("base64Binary".equals(xPrimitive)) {
                return EvalResult.Type.BASE64BINARY;
            }
            if ("dateTime".equals(xPrimitive)) {
                return EvalResult.Type.DATETIME;
            }
            if ("decimal".equals(xPrimitive)) {
                return EvalResult.Type.DECIMAL;
            }
            if ("double".equals(xPrimitive)) {
                return EvalResult.Type.DOUBLE;
            }
            if ("float".equals(xPrimitive)) {
                return EvalResult.Type.FLOAT;
            }
            if ("gDay".equals(xPrimitive)) {
                return EvalResult.Type.GDAY;
            }
            if ("gMonth".equals(xPrimitive)) {
                return EvalResult.Type.GMONTH;
            }
            if ("gMonthDay".equals(xPrimitive)) {
                return EvalResult.Type.GMONTHDAY;
            }
            if ("gYear".equals(xPrimitive)) {
                return EvalResult.Type.GYEAR;
            }
            if ("gYearMonth".equals(xPrimitive)) {
                return EvalResult.Type.GYEARMONTH;
            }
            if ("integer".equals(xPrimitive)) {
                return EvalResult.Type.INTEGER;
            }
            if ("QName".equals(xPrimitive)) {
                return EvalResult.Type.QNAME;
            }
            if ("time".equals(xPrimitive)) {
                return EvalResult.Type.TIME;
            }
            return EvalResult.Type.OTHER;
        }

        @Override
        public <H extends AbstractReadHandle> H get(H handle) {
            if (this.getType() == EvalResult.Type.NULL && handle instanceof StringHandle) {
                return (H)((StringHandle)handle).with(null);
            }
            if (this.getType() == EvalResult.Type.NULL && handle instanceof BytesHandle) {
                return (H)((BytesHandle)handle).with(null);
            }
            return this.content.getContent(handle);
        }

        @Override
        public <T> T getAs(Class<T> as) {
            if (this.getType() == EvalResult.Type.NULL) {
                return null;
            }
            if (as == null) {
                throw new IllegalArgumentException("class cannot be null");
            }
            ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(as);
            if (readHandle == null) {
                return null;
            }
            if ((readHandle = this.get(readHandle)) == null) {
                return null;
            }
            return readHandle.get();
        }

        @Override
        public String getString() {
            if (this.getType() == EvalResult.Type.NULL) {
                return null;
            }
            return this.content.getContentAs(String.class);
        }

        @Override
        public Number getNumber() {
            if (this.getType() == EvalResult.Type.DECIMAL) {
                return new BigDecimal(this.getString());
            }
            if (this.getType() == EvalResult.Type.DOUBLE) {
                return Double.valueOf(this.getString());
            }
            if (this.getType() == EvalResult.Type.FLOAT) {
                return Float.valueOf(this.getString());
            }
            if (this.getType() == EvalResult.Type.INTEGER) {
                return Long.valueOf(this.getString());
            }
            return new BigDecimal(this.getString());
        }

        @Override
        public Boolean getBoolean() {
            return Boolean.valueOf(this.getString());
        }
    }

    public class OkHttpEvalResultIterator
    implements EvalResultIterator {
        private OkHttpResultIterator iterator;

        OkHttpEvalResultIterator(OkHttpResultIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<EvalResult> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EvalResult next() {
            if (this.iterator == null) {
                throw new NoSuchElementException("No results available");
            }
            Object jerseyResult = this.iterator.next();
            OkHttpEvalResult result = new OkHttpEvalResult((OkHttpResult)jerseyResult);
            return result;
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
    }

    private class OkHttpSearchRequest {
        RequestLogger reqlog;
        QueryDefinition queryDef;
        String mimetype;
        RequestParameters params;
        ServerTransform responseTransform;
        Transaction transaction;
        Request.Builder requestBldr = null;
        String structure = null;
        HandleImplementation baseHandle = null;

        OkHttpSearchRequest(RequestLogger reqlog, QueryDefinition queryDef, String mimetype, Transaction transaction, ServerTransform responseTransform, RequestParameters params) {
            this.reqlog = reqlog;
            this.queryDef = queryDef;
            this.mimetype = mimetype;
            this.transaction = transaction;
            this.responseTransform = responseTransform;
            this.params = params != null ? params : new RequestParameters();
            this.addParams();
            this.init();
        }

        void addParams() {
            ServerTransform transform;
            String directory = this.queryDef.getDirectory();
            if (directory != null) {
                this.params.add("directory", directory);
            }
            this.params.add("collection", this.queryDef.getCollections());
            String optionsName = this.queryDef.getOptionsName();
            if (optionsName != null && optionsName.length() > 0) {
                this.params.add("options", optionsName);
            }
            if ((transform = this.queryDef.getResponseTransform()) != null) {
                if (this.responseTransform != null) {
                    if (!transform.getName().equals(this.responseTransform.getName())) {
                        throw new IllegalStateException("QueryDefinition transform and DocumentManager transform have different names (" + transform.getName() + ", " + this.responseTransform.getName() + ")");
                    }
                    logger.warn("QueryDefinition and DocumentManager both specify a ServerTransform--using params from QueryDefinition");
                }
                transform.merge(this.params);
            } else if (this.responseTransform != null) {
                this.responseTransform.merge(this.params);
            }
            if (this.transaction != null) {
                this.params.add("txid", this.transaction.getTransactionId());
            }
        }

        void init() {
            String text = null;
            if (this.queryDef instanceof StringQueryDefinition) {
                text = ((StringQueryDefinition)this.queryDef).getCriteria();
            } else if (this.queryDef instanceof StructuredQueryDefinition) {
                text = ((StructuredQueryDefinition)this.queryDef).getCriteria();
            } else if (this.queryDef instanceof RawStructuredQueryDefinition) {
                text = ((RawStructuredQueryDefinition)this.queryDef).getCriteria();
            } else if (this.queryDef instanceof RawCtsQueryDefinition) {
                text = ((RawCtsQueryDefinition)this.queryDef).getCriteria();
            }
            if (text != null) {
                this.params.add("q", text);
            }
            if (this.queryDef instanceof StructuredQueryDefinition) {
                this.structure = ((StructuredQueryDefinition)this.queryDef).serialize();
                if (logger.isDebugEnabled()) {
                    Object qtextMessage = text == null ? "" : " and string query \"" + text + "\"";
                    logger.debug("Searching for structure {}{}", (Object)this.structure, qtextMessage);
                }
                this.requestBldr = OkHttpServices.this.setupRequest("search", this.params);
                this.requestBldr = this.requestBldr.header("Content-Type", "application/xml");
                this.requestBldr = this.requestBldr.header("Accept", this.mimetype);
            } else if (this.queryDef instanceof RawQueryDefinition || this.queryDef instanceof RawCtsQueryDefinition) {
                StructureWriteHandle handle;
                logger.debug("Raw search");
                if (this.queryDef instanceof RawQueryDefinition) {
                    handle = ((RawQueryDefinition)this.queryDef).getHandle();
                    this.baseHandle = HandleAccessor.checkHandle(handle, "search");
                } else if (this.queryDef instanceof RawCtsQueryDefinition) {
                    handle = ((RawCtsQueryDefinition)this.queryDef).getHandle();
                    this.baseHandle = HandleAccessor.checkHandle(handle, "search");
                }
                Format payloadFormat = OkHttpServices.this.getStructuredQueryFormat(this.baseHandle);
                String payloadMimetype = OkHttpServices.this.getMimetypeWithDefaultXML(payloadFormat, this.baseHandle);
                String path = this.queryDef instanceof RawQueryByExampleDefinition ? "qbe" : "search";
                this.requestBldr = OkHttpServices.this.setupRequest(path, this.params);
                if (payloadMimetype != null) {
                    this.requestBldr = this.requestBldr.header("Content-Type", payloadMimetype);
                }
                this.requestBldr = this.requestBldr.header("Accept", this.mimetype);
            } else if (this.queryDef instanceof CombinedQueryDefinition) {
                this.structure = ((CombinedQueryDefinition)this.queryDef).serialize();
                logger.debug("Searching for combined query {}", (Object)this.structure);
                this.requestBldr = OkHttpServices.this.setupRequest("search", this.params);
                this.requestBldr = this.requestBldr.header("Content-Type", "application/xml").header("Accept", this.mimetype);
            } else if (this.queryDef instanceof StringQueryDefinition) {
                logger.debug("Searching for string [{}]", (Object)text);
                this.requestBldr = OkHttpServices.this.setupRequest("search", this.params);
                this.requestBldr = this.requestBldr.header("Content-Type", "application/xml");
                this.requestBldr = this.requestBldr.header("Accept", this.mimetype);
            } else if (this.queryDef instanceof DeleteQueryDefinition) {
                logger.debug("Searching for deletes");
                this.requestBldr = OkHttpServices.this.setupRequest("search", this.params);
                this.requestBldr = this.requestBldr.header("Accept", this.mimetype);
            } else {
                throw new UnsupportedOperationException("Cannot search with " + this.queryDef.getClass().getName());
            }
            this.requestBldr = OkHttpServices.this.addTransactionScopedCookies(this.requestBldr, this.transaction);
            this.requestBldr = OkHttpServices.this.addTelemetryAgentId(this.requestBldr);
        }

        Response getResponse() {
            int retry;
            Response response = null;
            int status = -1;
            long startTime = System.currentTimeMillis();
            int nextDelay = 0;
            for (retry = 0; retry < OkHttpServices.this.minRetry || System.currentTimeMillis() - startTime < (long)OkHttpServices.this.maxDelay; ++retry) {
                if (nextDelay > 0) {
                    try {
                        Thread.sleep(nextDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.queryDef instanceof StructuredQueryDefinition && !(this.queryDef instanceof RawQueryDefinition)) {
                    response = OkHttpServices.this.doPost(this.reqlog, this.requestBldr, this.structure);
                } else if (this.queryDef instanceof CombinedQueryDefinition) {
                    response = OkHttpServices.this.doPost(this.reqlog, this.requestBldr, this.structure);
                } else if (this.queryDef instanceof DeleteQueryDefinition) {
                    response = OkHttpServices.this.doGet(this.requestBldr);
                } else if (this.queryDef instanceof RawQueryDefinition) {
                    response = OkHttpServices.this.doPost(this.reqlog, this.requestBldr, this.baseHandle.sendContent());
                } else if (this.queryDef instanceof RawCtsQueryDefinition) {
                    response = OkHttpServices.this.doPost(this.reqlog, this.requestBldr, this.baseHandle.sendContent());
                } else if (this.queryDef instanceof StringQueryDefinition) {
                    response = OkHttpServices.this.doGet(this.requestBldr);
                } else {
                    throw new UnsupportedOperationException("Cannot search with " + this.queryDef.getClass().getName());
                }
                status = response.code();
                if (this.transaction != null || !OkHttpServices.this.retryStatus.contains(status)) {
                    if (!OkHttpServices.this.isFirstRequest()) break;
                    OkHttpServices.this.setFirstRequest(false);
                    break;
                }
                String retryAfterRaw = response.header("Retry-After");
                int retryAfter = retryAfterRaw != null ? Integer.parseInt(retryAfterRaw) : -1;
                OkHttpServices.closeResponse(response);
                nextDelay = Math.max(retryAfter, OkHttpServices.this.calculateDelay(OkHttpServices.this.randRetry, retry));
            }
            if (OkHttpServices.this.retryStatus.contains(status)) {
                OkHttpServices.this.checkFirstRequest();
                OkHttpServices.closeResponse(response);
                throw new FailedRetryException("Service unavailable and maximum retry period elapsed: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds after " + retry + " retries");
            }
            if (status == 404) {
                OkHttpServices.closeResponse(response);
                return null;
            }
            if (status == 403) {
                throw new ForbiddenUserException("User is not allowed to search", OkHttpServices.this.extractErrorFields(response));
            }
            if (status != 200) {
                throw new FailedRequestException("search failed: " + OkHttpServices.getReasonPhrase(response), OkHttpServices.this.extractErrorFields(response));
            }
            return response;
        }
    }

    private class OkHttpDocumentPage
    extends BasicPage<DocumentRecord>
    implements DocumentPage,
    Iterator<DocumentRecord> {
        private OkHttpResultIterator iterator;
        private boolean hasMetadata;
        private boolean hasContent;

        OkHttpDocumentPage(OkHttpResultIterator iterator, boolean hasContent, boolean hasMetadata) {
            super(new ArrayList().iterator(), iterator != null ? iterator.getStart() : 1L, iterator != null ? iterator.getPageSize() : 0L, iterator != null ? iterator.getTotalSize() : 0L);
            this.iterator = iterator;
            this.hasContent = hasContent;
            this.hasMetadata = hasMetadata;
            if (iterator == null) {
                this.setSize(0L);
            } else if (hasContent && hasMetadata) {
                this.setSize(iterator.getSize() / 2L);
            } else {
                this.setSize(iterator.getSize());
            }
        }

        @Override
        public Iterator<DocumentRecord> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocumentRecord next() {
            OkHttpDocumentRecord record;
            if (this.iterator == null) {
                throw new NoSuchElementException("No documents available");
            }
            Object result = this.iterator.next();
            if (this.hasContent && this.hasMetadata) {
                Object metadata = result;
                Object content = this.iterator.next();
                record = new OkHttpDocumentRecord((OkHttpResult)content, (OkHttpResult)metadata);
            } else if (this.hasContent) {
                Object content = result;
                record = new OkHttpDocumentRecord((OkHttpResult)content);
            } else if (this.hasMetadata) {
                Object metadata = result;
                record = new OkHttpDocumentRecord(null, (OkHttpResult)metadata);
            } else {
                throw new IllegalStateException("Should never have neither content nor metadata");
            }
            return record;
        }

        @Override
        public <T extends AbstractReadHandle> T nextContent(T contentHandle) {
            return this.next().getContent(contentHandle);
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
    }

    protected static class ThreadState {
        boolean isFirstRequest;

        ThreadState(boolean value) {
            this.isFirstRequest = value;
        }
    }
}

