/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.SessionStateImpl;
import com.marklogic.client.impl.ValueConverter;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputSourceHandle;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.JacksonParserHandle;
import com.marklogic.client.io.OutputStreamHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.ReaderHandle;
import com.marklogic.client.io.SourceHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.XMLEventReaderHandle;
import com.marklogic.client.io.XMLStreamReaderHandle;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BaseProxy {
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("\\.\\w+$");
    private static ObjectMapper mapper = null;
    private String endpointDir;
    private String endpointExtension;
    private DatabaseClient db;

    protected static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    public BaseProxy() {
    }

    public BaseProxy(String endpointDir, JSONWriteHandle serviceDeclaration) {
        this();
        if (serviceDeclaration == null) {
            this.init(endpointDir);
        } else {
            JsonNode serviceDecl = NodeConverter.handleToJsonNode(serviceDeclaration);
            JsonNode endpointDirProp = serviceDecl.get("endpointDirectory");
            if (endpointDirProp == null) {
                throw new IllegalArgumentException("Service declaration without endpointDirectory property");
            }
            JsonNode endpointExtsnProp = serviceDecl.get("endpointExtension");
            if (endpointExtsnProp != null) {
                this.endpointExtension = endpointExtsnProp.asText();
                if (this.endpointExtension != null) {
                    if (this.endpointExtension.length() == 0) {
                        this.endpointExtension = null;
                    } else {
                        this.endpointExtension = this.endpointExtension.toLowerCase();
                        if (!this.endpointExtension.startsWith(".")) {
                            this.endpointExtension = "." + this.endpointExtension;
                        }
                        boolean isValid = false;
                        for (String extension : new String[]{".mjs", ".sjs", ".xqy"}) {
                            if (!extension.equals(this.endpointExtension)) continue;
                            isValid = true;
                            break;
                        }
                        if (!isValid) {
                            throw new IllegalArgumentException("endpoint extension must be mjs, sjs, or xqy and not: " + this.endpointExtension);
                        }
                    }
                }
            }
            this.init(endpointDirProp.asText());
        }
    }

    public BaseProxy(DatabaseClient db, String endpointDir, JSONWriteHandle serviceDeclaration) {
        this(endpointDir, serviceDeclaration);
        if (db == null) {
            throw new IllegalArgumentException("Cannot connect with null database client");
        }
        if (db.getDatabase() != null) {
            throw new IllegalArgumentException("Client cannot specify a database - specified: " + db.getDatabase());
        }
        this.db = db;
    }

    public BaseProxy(DatabaseClient db, String endpointDir) {
        this(db, endpointDir, null);
    }

    private void init(String endpointDir) {
        if (endpointDir == null || endpointDir.length() == 0) {
            throw new IllegalArgumentException("Cannot make requests with null or empty endpoint directory");
        }
        this.endpointDir = endpointDir;
    }

    public DBFunctionRequest request(String defaultModule, ParameterValuesKind paramsKind) {
        String module = this.endpointExtension == null ? defaultModule : EXTENSION_PATTERN.matcher(defaultModule).replaceFirst(this.endpointExtension);
        DBFunctionRequest request = BaseProxy.request(this.endpointDir, module, paramsKind);
        return this.db != null ? request.on(this.db) : request;
    }

    public static DBFunctionRequest request(String endpointDir, String module, ParameterValuesKind paramsKind) {
        if (endpointDir == null || endpointDir.length() == 0) {
            throw new IllegalArgumentException("Cannot make requests with null or empty endpoint directory");
        }
        if (module == null) {
            throw new IllegalArgumentException("null module");
        }
        return new DBFunctionRequest(endpointDir, module, paramsKind);
    }

    public static DBFunctionRequest moduleRequest(String endpoint, ParameterValuesKind paramsKind) {
        return new DBFunctionRequest(endpoint, paramsKind);
    }

    public static RESTServices.SingleAtomicCallField atomicParam(String paramName, boolean isNullable, String value) {
        return BaseProxy.isParamNull(paramName, isNullable, value) ? null : new RESTServices.SingleAtomicCallField(paramName, value);
    }

    public static RESTServices.MultipleAtomicCallField atomicParam(String paramName, boolean isNullable, Stream<String> values) {
        return BaseProxy.isParamNull(paramName, isNullable, values) ? null : new RESTServices.UnbufferedMultipleAtomicCallField(paramName, values);
    }

    public static RESTServices.SingleNodeCallField documentParam(String paramName, boolean isNullable, BufferableHandle value) {
        return BaseProxy.isParamNull(paramName, isNullable, value) ? null : new RESTServices.SingleNodeCallField(paramName, value);
    }

    public static RESTServices.MultipleNodeCallField documentParam(String paramName, boolean isNullable, Stream<? extends BufferableHandle> values) {
        return BaseProxy.isParamNull(paramName, isNullable, values) ? null : new RESTServices.UnbufferedMultipleNodeCallField(paramName, values);
    }

    public static RESTServices.MultipleNodeCallField documentParam(String paramName, boolean isNullable, BufferableHandle[] values) {
        return BaseProxy.isParamNull(paramName, isNullable, values) ? null : new RESTServices.BufferedMultipleNodeCallField(paramName, values);
    }

    protected static boolean isParamNull(String paramName, boolean isNullable, Object value) {
        if (value != null) {
            return false;
        }
        if (!isNullable) {
            throw new RequiredParamException("null value for required parameter: " + paramName);
        }
        return true;
    }

    public SessionState newSessionState() {
        return new SessionStateImpl();
    }

    public static class RequiredReturnException
    extends IllegalArgumentException {
        public RequiredReturnException(String s) {
            super(s);
        }
    }

    public static class RequiredParamException
    extends IllegalArgumentException {
        public RequiredParamException(String s) {
            super(s);
        }
    }

    public static class DBFunctionRequest {
        private RESTServices services;
        private String endpoint;
        private ParameterValuesKind paramsKind;
        private RESTServices.CallField[] params;
        private SessionState session;
        private RESTServices.HttpMethod method = RESTServices.HttpMethod.POST;

        private DBFunctionRequest(RESTServices services, String endpointDir, String module, ParameterValuesKind paramsKind) {
            this(services, endpointDir + module, paramsKind);
        }

        private DBFunctionRequest(RESTServices services, String endpoint, ParameterValuesKind paramsKind, RESTServices.HttpMethod method) {
            this(services, endpoint, paramsKind);
            this.method = method;
        }

        private DBFunctionRequest(RESTServices services, String endpoint, ParameterValuesKind paramsKind) {
            this(endpoint, paramsKind);
            this.services = services;
        }

        private DBFunctionRequest(String endpointDir, String module, ParameterValuesKind paramsKind) {
            this(endpointDir + module, paramsKind);
        }

        private DBFunctionRequest(String endpoint, ParameterValuesKind paramsKind) {
            this.endpoint = endpoint;
            this.paramsKind = paramsKind;
        }

        public DBFunctionRequest withMethod(String method) {
            this.method = RESTServices.HttpMethod.valueOf(method);
            return this;
        }

        public DBFunctionRequest on(DatabaseClient db) {
            if (db == null) {
                throw new IllegalArgumentException("Cannot connect with null database client");
            }
            if (!(db instanceof DatabaseClientImpl)) {
                throw new IllegalArgumentException("Cannot connect with non-standard implementation of database client");
            }
            if (db.getDatabase() != null) {
                throw new IllegalArgumentException("Client cannot specify a database - specified: " + db.getDatabase());
            }
            return new DBFunctionRequest(((DatabaseClientImpl)db).getServices(), this.endpoint, this.paramsKind, this.method);
        }

        public DBFunctionRequest withSession() {
            return this;
        }

        public DBFunctionRequest withSession(String paramName, SessionState session, boolean isNullable) {
            if (session != null) {
                this.session = session;
            } else if (!isNullable) {
                throw new RequiredParamException("null value for required session parameter: " + paramName);
            }
            return this;
        }

        public DBFunctionRequest withParams(RESTServices.CallField ... params) {
            this.params = params;
            return this;
        }

        private RESTServices.CallRequest makeRequest() {
            switch (this.paramsKind) {
                case NONE: {
                    return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                }
                case SINGLE_ATOMIC: 
                case MULTIPLE_ATOMICS: {
                    if (this.params == null || this.params.length == 0 || this.params.length == 1 && this.params[0] == null) {
                        return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                    }
                    return this.services.makeAtomicBodyRequest(this.endpoint, this.method, this.session, this.params);
                }
                case SINGLE_NODE: {
                    if (this.params == null || this.params.length == 0) {
                        return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                    }
                    if (this.params.length > 1) {
                        throw new InternalError("multiple parameters instead of single node");
                    }
                    if (this.params[0] == null) {
                        return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                    }
                    if (this.params.length > 1 || !(this.params[0] instanceof RESTServices.SingleNodeCallField)) {
                        throw new InternalError("invalid parameter type instead of single node: " + this.params[0].getClass().getName());
                    }
                    return this.services.makeNodeBodyRequest(this.endpoint, this.method, this.session, this.params);
                }
                case MULTIPLE_NODES: 
                case MULTIPLE_MIXED: {
                    return this.services.makeNodeBodyRequest(this.endpoint, this.method, this.session, this.params);
                }
            }
            throw new InternalError("unknown parameters kind: " + this.paramsKind.name());
        }

        public void responseNone() {
            this.makeRequest().withEmptyResponse();
        }

        public RESTServices.SingleCallResponse responseSingle(boolean isNullable, Format returnFormat) {
            RESTServices.SingleCallResponse responsedef = this.makeRequest().withDocumentResponse(returnFormat == null ? Format.TEXT : returnFormat);
            if (responsedef.isNull() && !isNullable) {
                responsedef.close();
                throw new RequiredReturnException("null for required single return value");
            }
            return responsedef;
        }

        public RESTServices.MultipleCallResponse responseMultiple(boolean isNullable, Format returnFormat) {
            RESTServices.MultipleCallResponse responsedef = this.makeRequest().withMultipartMixedResponse(returnFormat == null ? Format.TEXT : returnFormat);
            if (responsedef.isNull() && !isNullable) {
                throw new RequiredReturnException("null for required multiple return value");
            }
            return responsedef;
        }
    }

    public static enum ParameterValuesKind {
        NONE,
        SINGLE_ATOMIC,
        SINGLE_NODE,
        MULTIPLE_ATOMICS,
        MULTIPLE_NODES,
        MULTIPLE_MIXED;


        public static ParameterValuesKind forNodeCount(int nodeCount) {
            switch (nodeCount) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return SINGLE_NODE;
                }
            }
            return MULTIPLE_NODES;
        }
    }

    public static final class XmlDocumentType
    implements CharacterNodeDataType {
        public static final String NAME = "xmlDocument";
        public static final Format FORMAT = Format.XML;

        public static final XMLWriteHandle fromXMLWriteHandle(XMLWriteHandle value) {
            return NodeConverter.XMLWriter(value);
        }

        public static final Stream<XMLWriteHandle> fromXMLWriteHandle(Stream<? extends XMLWriteHandle> values) {
            return NodeConverter.XMLWriter(values);
        }

        public static final XMLWriteHandle[] fromXMLWriteHandle(XMLWriteHandle[] values) {
            XMLWriteHandle[] handleValues = (XMLWriteHandle[])Stream.of(values).map(value -> NodeConverter.XMLWriter(value)).toArray(XMLWriteHandle[]::new);
            return NodeConverter.arrayWithFormat(handleValues, FORMAT);
        }

        public static final DOMHandle fromDocument(Document value) {
            return NodeConverter.withFormat(NodeConverter.DocumentToHandle(value), FORMAT);
        }

        public static final Stream<DOMHandle> fromDocument(Stream<? extends Document> values) {
            return NodeConverter.streamWithFormat(NodeConverter.DocumentToHandle(values), FORMAT);
        }

        public static final DOMHandle[] fromDocument(Document[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.DocumentToHandle(values), FORMAT);
        }

        public static final InputSourceHandle fromInputSource(InputSource value) {
            return NodeConverter.withFormat(NodeConverter.InputSourceToHandle(value), FORMAT);
        }

        public static final Stream<InputSourceHandle> fromInputSource(Stream<? extends InputSource> values) {
            return NodeConverter.streamWithFormat(NodeConverter.InputSourceToHandle(values), FORMAT);
        }

        public static final InputSourceHandle[] fromInputSource(InputSource[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.InputSourceToHandle(values), FORMAT);
        }

        public static final SourceHandle fromSource(Source value) {
            return NodeConverter.withFormat(NodeConverter.SourceToHandle(value), FORMAT);
        }

        public static final Stream<SourceHandle> fromSource(Stream<? extends Source> values) {
            return NodeConverter.streamWithFormat(NodeConverter.SourceToHandle(values), FORMAT);
        }

        public static final SourceHandle[] fromSource(Source[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.SourceToHandle(values), FORMAT);
        }

        public static final XMLEventReaderHandle fromXMLEventReader(XMLEventReader value) {
            return NodeConverter.withFormat(NodeConverter.XMLEventReaderToHandle(value), FORMAT);
        }

        public static final Stream<XMLEventReaderHandle> fromXMLEventReader(Stream<? extends XMLEventReader> values) {
            return NodeConverter.streamWithFormat(NodeConverter.XMLEventReaderToHandle(values), FORMAT);
        }

        public static final XMLEventReaderHandle[] fromXMLEventReader(XMLEventReader[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.XMLEventReaderToHandle(values), FORMAT);
        }

        public static final XMLStreamReaderHandle fromXMLStreamReader(XMLStreamReader value) {
            return NodeConverter.withFormat(NodeConverter.XMLStreamReaderToHandle(value), FORMAT);
        }

        public static final Stream<XMLStreamReaderHandle> fromXMLStreamReader(Stream<? extends XMLStreamReader> values) {
            return NodeConverter.streamWithFormat(NodeConverter.XMLStreamReaderToHandle(values), FORMAT);
        }

        public static final XMLStreamReaderHandle[] fromXMLStreamReader(XMLStreamReader[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.XMLStreamReaderToHandle(values), FORMAT);
        }

        public static final FileHandle fromFile(File value) {
            return NodeConverter.withFormat(NodeConverter.FileToHandle(value), FORMAT);
        }

        public static final Stream<FileHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.streamWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final FileHandle[] fromFile(File[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final InputStreamHandle fromInputStream(InputStream value) {
            return NodeConverter.withFormat(NodeConverter.InputStreamToHandle(value), FORMAT);
        }

        public static final Stream<InputStreamHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.streamWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final InputStreamHandle[] fromInputStream(InputStream[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.withFormat(NodeConverter.OutputStreamSenderToHandle(value), FORMAT);
        }

        public static final Stream<OutputStreamHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.streamWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle[] fromOutputStreamSender(OutputStreamSender[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final ReaderHandle fromReader(Reader value) {
            return NodeConverter.withFormat(NodeConverter.ReaderToHandle(value), FORMAT);
        }

        public static final Stream<ReaderHandle> fromReader(Stream<? extends Reader> values) {
            return NodeConverter.streamWithFormat(NodeConverter.ReaderToHandle(values), FORMAT);
        }

        public static final ReaderHandle[] fromReader(Reader[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.ReaderToHandle(values), FORMAT);
        }

        public static final StringHandle fromString(String value) {
            return NodeConverter.withFormat(NodeConverter.StringToHandle(value), FORMAT);
        }

        public static final Stream<StringHandle> fromString(Stream<? extends String> values) {
            return NodeConverter.streamWithFormat(NodeConverter.StringToHandle(values), FORMAT);
        }

        public static final StringHandle[] fromString(String[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.StringToHandle(values), FORMAT);
        }

        public static final Document toDocument(RESTServices.SingleCallResponse response) {
            return NodeConverter.InputStreamToDocument(response.asInputStream());
        }

        public static final Stream<Document> toDocument(RESTServices.MultipleCallResponse response) {
            return NodeConverter.InputStreamToDocument(response.asStreamOfInputStream());
        }

        public static final InputSource toInputSource(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToInputSource(response.asReader());
        }

        public static final Stream<InputSource> toInputSource(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToInputSource(response.asStreamOfReader());
        }

        public static final Source toSource(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToSource(response.asReader());
        }

        public static final Stream<Source> toSource(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToSource(response.asStreamOfReader());
        }

        public static final XMLEventReader toXMLEventReader(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToXMLEventReader(response.asReader());
        }

        public static final Stream<XMLEventReader> toXMLEventReader(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToXMLEventReader(response.asStreamOfReader());
        }

        public static final XMLStreamReader toXMLStreamReader(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToXMLStreamReader(response.asReader());
        }

        public static final Stream<XMLStreamReader> toXMLStreamReader(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToXMLStreamReader(response.asStreamOfReader());
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }

        public static final Reader toReader(RESTServices.SingleCallResponse response) {
            return response.asReader();
        }

        public static final Stream<Reader> toReader(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfReader();
        }

        public static final XMLReadHandle toXMLReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.XMLReader(NodeConverter.ReaderToHandle(response.asReader()));
        }

        public static final Stream<XMLReadHandle> toXMLReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.XMLReader(NodeConverter.ReaderToHandle(response.asStreamOfReader()));
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class TextDocumentType
    implements CharacterNodeDataType {
        public static final String NAME = "textDocument";
        public static final Format FORMAT = Format.TEXT;

        public static final TextWriteHandle fromTextWriteHandle(TextWriteHandle value) {
            return NodeConverter.TextWriter(value);
        }

        public static final Stream<TextWriteHandle> fromTextWriteHandle(Stream<? extends TextWriteHandle> values) {
            return NodeConverter.TextWriter(values);
        }

        public static final TextWriteHandle[] fromTextWriteHandle(TextWriteHandle[] values) {
            TextWriteHandle[] handleValues = (TextWriteHandle[])Stream.of(values).map(value -> NodeConverter.TextWriter(value)).toArray(TextWriteHandle[]::new);
            return NodeConverter.arrayWithFormat(handleValues, FORMAT);
        }

        public static final FileHandle fromFile(File value) {
            return NodeConverter.withFormat(NodeConverter.FileToHandle(value), FORMAT);
        }

        public static final Stream<FileHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.streamWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final FileHandle[] fromFile(File[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final InputStreamHandle fromInputStream(InputStream value) {
            return NodeConverter.withFormat(NodeConverter.InputStreamToHandle(value), FORMAT);
        }

        public static final Stream<InputStreamHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.streamWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final InputStreamHandle[] fromInputStream(InputStream[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.withFormat(NodeConverter.OutputStreamSenderToHandle(value), FORMAT);
        }

        public static final Stream<OutputStreamHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.streamWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle[] fromOutputStreamSender(OutputStreamSender[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final ReaderHandle fromReader(Reader value) {
            return NodeConverter.withFormat(NodeConverter.ReaderToHandle(value), FORMAT);
        }

        public static final Stream<ReaderHandle> fromReader(Stream<? extends Reader> values) {
            return NodeConverter.streamWithFormat(NodeConverter.ReaderToHandle(values), FORMAT);
        }

        public static final ReaderHandle[] fromReader(Reader[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.ReaderToHandle(values), FORMAT);
        }

        public static final StringHandle fromString(String value) {
            return NodeConverter.withFormat(NodeConverter.StringToHandle(value), FORMAT);
        }

        public static final Stream<StringHandle> fromString(Stream<String> values) {
            return NodeConverter.streamWithFormat(NodeConverter.StringToHandle(values), FORMAT);
        }

        public static final StringHandle[] fromString(String[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.StringToHandle(values), FORMAT);
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }

        public static final Reader toReader(RESTServices.SingleCallResponse response) {
            return response.asReader();
        }

        public static final Stream<Reader> toReader(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfReader();
        }

        public static final TextReadHandle toTextReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.TextReader(NodeConverter.ReaderToHandle(response.asReader()));
        }

        public static final Stream<TextReadHandle> toTextReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.TextReader(NodeConverter.ReaderToHandle(response.asStreamOfReader()));
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class ObjectType
    extends JsonDocumentType {
        public static final String NAME = "object";
        public static final Format FORMAT = Format.JSON;
    }

    public static final class ArrayType
    extends JsonDocumentType {
        public static final String NAME = "array";
        public static final Format FORMAT = Format.JSON;
    }

    public static class JsonDocumentType
    implements CharacterNodeDataType {
        public static final String NAME = "jsonDocument";
        public static final Format FORMAT = Format.JSON;

        public static final JSONWriteHandle fromJSONWriteHandle(JSONWriteHandle value) {
            return NodeConverter.JSONWriter(value);
        }

        public static final Stream<JSONWriteHandle> fromJSONWriteHandle(Stream<? extends JSONWriteHandle> values) {
            return NodeConverter.JSONWriter(values);
        }

        public static final JSONWriteHandle[] fromJSONWriteHandle(JSONWriteHandle[] values) {
            JSONWriteHandle[] handleValues = (JSONWriteHandle[])Stream.of(values).map(value -> NodeConverter.JSONWriter(value)).toArray(JSONWriteHandle[]::new);
            return NodeConverter.arrayWithFormat(handleValues, FORMAT);
        }

        public static final JacksonHandle fromJsonNode(JsonNode value) {
            return NodeConverter.withFormat(NodeConverter.JsonNodeToHandle(value), FORMAT);
        }

        public static final Stream<JacksonHandle> fromJsonNode(Stream<? extends JsonNode> values) {
            return NodeConverter.streamWithFormat(NodeConverter.JsonNodeToHandle(values), FORMAT);
        }

        public static final JacksonHandle[] fromJsonNode(JsonNode[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.JsonNodeToHandle(values), FORMAT);
        }

        public static final JacksonHandle fromArrayNode(ArrayNode value) {
            return NodeConverter.withFormat(NodeConverter.JsonNodeToHandle((JsonNode)value), FORMAT);
        }

        public static final Stream<JacksonHandle> fromArrayNode(Stream<? extends ArrayNode> values) {
            return NodeConverter.streamWithFormat(NodeConverter.JsonNodeToHandle(values), FORMAT);
        }

        public static final JacksonHandle[] fromArrayNode(ArrayNode[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.JsonNodeToHandle((JsonNode[])values), FORMAT);
        }

        public static final JacksonHandle fromObjectNode(ObjectNode value) {
            return NodeConverter.withFormat(NodeConverter.JsonNodeToHandle((JsonNode)value), FORMAT);
        }

        public static final Stream<JacksonHandle> fromObjectNode(Stream<? extends ObjectNode> values) {
            return NodeConverter.streamWithFormat(NodeConverter.JsonNodeToHandle(values), FORMAT);
        }

        public static final JacksonHandle[] fromObjectNode(ObjectNode[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.JsonNodeToHandle((JsonNode[])values), FORMAT);
        }

        public static final JacksonParserHandle fromJsonParser(JsonParser value) {
            return NodeConverter.withFormat(NodeConverter.JsonParserToHandle(value), FORMAT);
        }

        public static final Stream<JacksonParserHandle> fromJsonParser(Stream<? extends JsonParser> values) {
            return NodeConverter.streamWithFormat(NodeConverter.JsonParserToHandle(values), FORMAT);
        }

        public static final JacksonParserHandle[] fromJsonParser(JsonParser[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.JsonParserToHandle(values), FORMAT);
        }

        public static final FileHandle fromFile(File value) {
            return NodeConverter.withFormat(NodeConverter.FileToHandle(value), FORMAT);
        }

        public static final Stream<FileHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.streamWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final FileHandle[] fromFile(File[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final InputStreamHandle fromInputStream(InputStream value) {
            return NodeConverter.withFormat(NodeConverter.InputStreamToHandle(value), FORMAT);
        }

        public static final Stream<InputStreamHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.streamWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final InputStreamHandle[] fromInputStream(InputStream[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.withFormat(NodeConverter.OutputStreamSenderToHandle(value), FORMAT);
        }

        public static final Stream<OutputStreamHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.streamWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle[] fromOutputStreamSender(OutputStreamSender[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final ReaderHandle fromReader(Reader value) {
            return NodeConverter.withFormat(NodeConverter.ReaderToHandle(value), FORMAT);
        }

        public static final Stream<ReaderHandle> fromReader(Stream<? extends Reader> values) {
            return NodeConverter.streamWithFormat(NodeConverter.ReaderToHandle(values), FORMAT);
        }

        public static final ReaderHandle[] fromReader(Reader[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.ReaderToHandle(values), FORMAT);
        }

        public static final StringHandle fromString(String value) {
            return NodeConverter.withFormat(NodeConverter.StringToHandle(value), FORMAT);
        }

        public static final Stream<StringHandle> fromString(Stream<? extends String> values) {
            return NodeConverter.streamWithFormat(NodeConverter.StringToHandle(values), FORMAT);
        }

        public static final StringHandle[] fromString(String[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.StringToHandle(values), FORMAT);
        }

        public static final ArrayNode toArrayNode(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToArrayNode(response.asReader());
        }

        public static final Stream<ArrayNode> toArrayNode(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToArrayNode(response.asStreamOfReader());
        }

        public static final JsonNode toJsonNode(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToJsonNode(response.asReader());
        }

        public static final Stream<JsonNode> toJsonNode(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToJsonNode(response.asStreamOfReader());
        }

        public static final ObjectNode toObjectNode(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToObjectNode(response.asReader());
        }

        public static final Stream<ObjectNode> toObjectNode(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToObjectNode(response.asStreamOfReader());
        }

        public static final JsonParser toJsonParser(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToJsonParser(response.asReader());
        }

        public static final Stream<JsonParser> toJsonParser(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToJsonParser(response.asStreamOfReader());
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }

        public static final Reader toReader(RESTServices.SingleCallResponse response) {
            return response.asReader();
        }

        public static final Stream<Reader> toReader(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfReader();
        }

        public static final JSONReadHandle toJSONReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.JSONReader(NodeConverter.ReaderToHandle(response.asReader()));
        }

        public static final Stream<JSONReadHandle> toJSONReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.JSONReader(NodeConverter.ReaderToHandle(response.asStreamOfReader()));
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class BinaryDocumentType
    implements NodeDataType {
        public static final String NAME = "binaryDocument";
        public static final Format FORMAT = Format.BINARY;

        public static final BinaryWriteHandle fromBinaryWriteHandle(BinaryWriteHandle value) {
            return NodeConverter.BinaryWriter(value);
        }

        public static final Stream<BinaryWriteHandle> fromBinaryWriteHandle(Stream<? extends BinaryWriteHandle> values) {
            return NodeConverter.BinaryWriter(values);
        }

        public static final BinaryWriteHandle[] fromBinaryWriteHandle(BinaryWriteHandle[] values) {
            BinaryWriteHandle[] binaryWriteHandleValues = (BinaryWriteHandle[])Stream.of(values).map(value -> NodeConverter.BinaryWriter(value)).toArray(BinaryWriteHandle[]::new);
            return NodeConverter.arrayWithFormat(binaryWriteHandleValues, FORMAT);
        }

        public static final BytesHandle fromBytes(byte[] value) {
            return NodeConverter.withFormat(NodeConverter.BytesToHandle(value), FORMAT);
        }

        public static final Stream<BytesHandle> fromBytes(Stream<? extends byte[]> values) {
            return NodeConverter.streamWithFormat(NodeConverter.BytesToHandle(values), FORMAT);
        }

        public static final BytesHandle[] fromBytes(byte[][] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.BytesToHandle(values), FORMAT);
        }

        public static final FileHandle fromFile(File value) {
            return NodeConverter.withFormat(NodeConverter.FileToHandle(value), FORMAT);
        }

        public static final Stream<FileHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.streamWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final FileHandle[] fromFile(File[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.FileToHandle(values), FORMAT);
        }

        public static final InputStreamHandle fromInputStream(InputStream value) {
            return NodeConverter.withFormat(NodeConverter.InputStreamToHandle(value), FORMAT);
        }

        public static final Stream<InputStreamHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.streamWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final InputStreamHandle[] fromInputStream(InputStream[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.InputStreamToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.withFormat(NodeConverter.OutputStreamSenderToHandle(value), FORMAT);
        }

        public static final Stream<OutputStreamHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.streamWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final OutputStreamHandle[] fromOutputStreamSender(OutputStreamSender[] values) {
            return NodeConverter.arrayWithFormat(NodeConverter.OutputStreamSenderToHandle(values), FORMAT);
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final BinaryReadHandle toBinaryReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.BinaryReader(NodeConverter.InputStreamToHandle(response.asInputStream()));
        }

        public static final Stream<BinaryReadHandle> toBinaryReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.BinaryReader(NodeConverter.InputStreamToHandle(response.asStreamOfInputStream()));
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }
    }

    public static final class UnsignedLongType
    implements AtomicDataType {
        public static final String NAME = "unsignedLong";

        public static final String fromLong(Long value) {
            return ValueConverter.UnsignedLongToString(value);
        }

        public static final Stream<String> fromLong(Stream<? extends Long> values) {
            return ValueConverter.UnsignedLongToString(values);
        }

        public static final String[] fromLong(Long[] values) {
            return ValueConverter.convert(values, ValueConverter::UnsignedLongToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Long toLong(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToUnsignedLong(response.asString());
        }

        public static final Stream<Long> toLong(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToUnsignedLong(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class UnsignedIntegerType
    implements AtomicDataType {
        public static final String NAME = "unsignedInt";

        public static final String fromInteger(Integer value) {
            return ValueConverter.UnsignedIntegerToString(value);
        }

        public static final Stream<String> fromInteger(Stream<? extends Integer> values) {
            return ValueConverter.UnsignedIntegerToString(values);
        }

        public static final String[] fromInteger(Integer[] values) {
            return ValueConverter.convert(values, ValueConverter::UnsignedIntegerToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Integer toInteger(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToUnsignedInteger(response.asString());
        }

        public static final Stream<Integer> toInteger(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToUnsignedInteger(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class TimeType
    implements AtomicDataType {
        public static final String NAME = "time";

        public static final String fromLocalTime(LocalTime value) {
            return ValueConverter.LocalTimeToString(value);
        }

        public static final Stream<String> fromLocalTime(Stream<? extends LocalTime> values) {
            return ValueConverter.LocalTimeToString(values);
        }

        public static final String[] fromLocalTime(LocalTime[] values) {
            return ValueConverter.convert(values, ValueConverter::LocalTimeToString);
        }

        public static final String fromOffsetTime(OffsetTime value) {
            return ValueConverter.OffsetTimeToString(value);
        }

        public static final Stream<String> fromOffsetTime(Stream<? extends OffsetTime> values) {
            return ValueConverter.OffsetTimeToString(values);
        }

        public static final String[] fromOffsetTime(OffsetTime[] values) {
            return ValueConverter.convert(values, ValueConverter::OffsetTimeToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final LocalTime toLocalTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLocalTime(response.asString());
        }

        public static final Stream<LocalTime> toLocalTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLocalTime(response.asStreamOfString());
        }

        public static final OffsetTime toOffsetTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToOffsetTime(response.asString());
        }

        public static final Stream<OffsetTime> toOffsetTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToOffsetTime(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class StringType
    implements AtomicDataType {
        public static final String NAME = "string";

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class LongType
    implements AtomicDataType {
        public static final String NAME = "long";

        public static final String fromLong(Long value) {
            return ValueConverter.LongToString(value);
        }

        public static final Stream<String> fromLong(Stream<? extends Long> values) {
            return ValueConverter.LongToString(values);
        }

        public static final String[] fromLong(Long[] values) {
            return ValueConverter.convert(values, ValueConverter::LongToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Long toLong(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLong(response.asString());
        }

        public static final Stream<Long> toLong(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLong(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class IntegerType
    implements AtomicDataType {
        public static final String NAME = "int";

        public static final String fromInteger(Integer value) {
            return ValueConverter.IntegerToString(value);
        }

        public static final Stream<String> fromInteger(Stream<? extends Integer> values) {
            return ValueConverter.IntegerToString(values);
        }

        public static final String[] fromInteger(Integer[] values) {
            return ValueConverter.convert(values, ValueConverter::IntegerToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Integer toInteger(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToInteger(response.asString());
        }

        public static final Stream<Integer> toInteger(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToInteger(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class FloatType
    implements AtomicDataType {
        public static final String NAME = "float";

        public static final String fromFloat(Float value) {
            return ValueConverter.FloatToString(value);
        }

        public static final Stream<String> fromFloat(Stream<? extends Float> values) {
            return ValueConverter.FloatToString(values);
        }

        public static final String[] fromFloat(Float[] values) {
            return ValueConverter.convert(values, ValueConverter::FloatToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Float toFloat(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToFloat(response.asString());
        }

        public static final Stream<Float> toFloat(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToFloat(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DoubleType
    implements AtomicDataType {
        public static final String NAME = "double";

        public static final String fromDouble(Double value) {
            return ValueConverter.DoubleToString(value);
        }

        public static final Stream<String> fromDouble(Stream<? extends Double> values) {
            return ValueConverter.DoubleToString(values);
        }

        public static final String[] fromDouble(Double[] values) {
            return ValueConverter.convert(values, ValueConverter::DoubleToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Double toDouble(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToDouble(response.asString());
        }

        public static final Stream<Double> toDouble(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToDouble(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DecimalType
    implements AtomicDataType {
        public static final String NAME = "decimal";

        public static final String fromBigDecimal(BigDecimal value) {
            return ValueConverter.BigDecimalToString(value);
        }

        public static final Stream<String> fromBigDecimal(Stream<? extends BigDecimal> values) {
            return ValueConverter.BigDecimalToString(values);
        }

        public static final String[] fromBigDecimal(BigDecimal[] values) {
            return ValueConverter.convert(values, ValueConverter::BigDecimalToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final BigDecimal toBigDecimal(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToBigDecimal(response.asString());
        }

        public static final Stream<BigDecimal> toBigDecimal(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToBigDecimal(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DayTimeDurationType
    implements AtomicDataType {
        public static final String NAME = "dayTimeDuration";

        public static final String fromDuration(Duration value) {
            return ValueConverter.DurationToString(value);
        }

        public static final Stream<String> fromDuration(Stream<? extends Duration> values) {
            return ValueConverter.DurationToString(values);
        }

        public static final String[] fromDuration(Duration[] values) {
            return ValueConverter.convert(values, ValueConverter::DurationToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Duration toDuration(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToDuration(response.asString());
        }

        public static final Stream<Duration> toDuration(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToDuration(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DateTimeType
    implements AtomicDataType {
        public static final String NAME = "dateTime";

        public static final String fromDate(Date value) {
            return ValueConverter.DateToString(value);
        }

        public static final Stream<String> fromDate(Stream<? extends Date> values) {
            return ValueConverter.DateToString(values);
        }

        public static final String[] fromDate(Date[] values) {
            return ValueConverter.convert(values, ValueConverter::DateToString);
        }

        public static final String fromLocalDateTime(LocalDateTime value) {
            return ValueConverter.LocalDateTimeToString(value);
        }

        public static final Stream<String> fromLocalDateTime(Stream<? extends LocalDateTime> values) {
            return ValueConverter.LocalDateTimeToString(values);
        }

        public static final String[] fromLocalDateTime(LocalDateTime[] values) {
            return ValueConverter.convert(values, ValueConverter::LocalDateTimeToString);
        }

        public static final String fromOffsetDateTime(OffsetDateTime value) {
            return ValueConverter.OffsetDateTimeToString(value);
        }

        public static final Stream<String> fromOffsetDateTime(Stream<? extends OffsetDateTime> values) {
            return ValueConverter.OffsetDateTimeToString(values);
        }

        public static final String[] fromOffsetDateTime(OffsetDateTime[] values) {
            return ValueConverter.convert(values, ValueConverter::OffsetDateTimeToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Date toDate(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToDate(response.asString());
        }

        public static final Stream<Date> toDate(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToDate(response.asStreamOfString());
        }

        public static final LocalDateTime toLocalDateTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLocalDateTime(response.asString());
        }

        public static final Stream<LocalDateTime> toLocalDateTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLocalDateTime(response.asStreamOfString());
        }

        public static final OffsetDateTime toOffsetDateTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToOffsetDateTime(response.asString());
        }

        public static final Stream<OffsetDateTime> toOffsetDateTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToOffsetDateTime(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DateType
    implements AtomicDataType {
        public static final String NAME = "date";

        public static final String fromLocalDate(LocalDate value) {
            return ValueConverter.LocalDateToString(value);
        }

        public static final Stream<String> fromLocalDate(Stream<? extends LocalDate> values) {
            return ValueConverter.LocalDateToString(values);
        }

        public static final String[] fromLocalDate(LocalDate[] values) {
            return ValueConverter.convert(values, ValueConverter::LocalDateToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final LocalDate toLocalDate(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLocalDate(response.asString());
        }

        public static final Stream<LocalDate> toLocalDate(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLocalDate(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class BooleanType
    implements AtomicDataType {
        public static final String NAME = "boolean";

        public static final String fromBoolean(Boolean value) {
            return ValueConverter.BooleanToString(value);
        }

        public static final Stream<String> fromBoolean(Stream<? extends Boolean> values) {
            return ValueConverter.BooleanToString(values);
        }

        public static final String[] fromBoolean(Boolean[] values) {
            return ValueConverter.convert(values, ValueConverter::BooleanToString);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Boolean toBoolean(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToBoolean(response.asString());
        }

        public static final Stream<Boolean> toBoolean(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToBoolean(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static interface CharacterNodeDataType
    extends NodeDataType {
    }

    public static interface NodeDataType
    extends ServerDataType {
    }

    public static interface AtomicDataType
    extends ServerDataType {
    }

    public static interface ServerDataType {
    }
}

