/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.jdom;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.XMLOutputter;

public class JDOMHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<Document>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private Document content;
    private SAXBuilder builder;
    private XMLOutputter outputter;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Document.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Document.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                JDOMHandle handle = this.isHandled(type) ? new JDOMHandle() : null;
                return handle;
            }
        };
    }

    public JDOMHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
    }

    public JDOMHandle(Document content) {
        this();
        this.set(content);
    }

    public SAXBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.makeBuilder();
        }
        return this.builder;
    }

    public void setBuilder(SAXBuilder builder) {
        this.builder = builder;
    }

    protected SAXBuilder makeBuilder() {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }

    public XMLOutputter getOutputter() {
        if (this.outputter == null) {
            this.outputter = this.makeOutputter();
        }
        return this.outputter;
    }

    public void setOutputter(XMLOutputter outputter) {
        this.outputter = outputter;
    }

    protected XMLOutputter makeOutputter() {
        return new XMLOutputter();
    }

    @Override
    public Document get() {
        return this.content;
    }

    @Override
    public void set(Document content) {
        this.content = content;
    }

    public JDOMHandle with(Document content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("JDOMHandle supports the XML format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            byte[] buffer = this.toBuffer();
            return buffer == null ? null : new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            return;
        }
        try {
            this.content = this.getBuilder().build((Reader)new InputStreamReader(content, "UTF-8"));
        }
        catch (JDOMException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.getOutputter().output(this.content, (Writer)new OutputStreamWriter(out, "UTF-8"));
    }
}

