/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.OutputEndpoint;
import com.marklogic.client.dataservices.impl.IOEndpointImpl;
import com.marklogic.client.dataservices.impl.OutputCallerImpl;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.InputStream;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputEndpointImpl
extends IOEndpointImpl
implements OutputEndpoint {
    private static Logger logger = LoggerFactory.getLogger(OutputEndpointImpl.class);
    private OutputCallerImpl caller;

    public OutputEndpointImpl(DatabaseClient client, JSONWriteHandle apiDecl) {
        this(client, new OutputCallerImpl(apiDecl));
    }

    private OutputEndpointImpl(DatabaseClient client, OutputCallerImpl caller) {
        super(client, caller);
        this.caller = caller;
    }

    private OutputCallerImpl getCaller() {
        return this.caller;
    }

    @Override
    public InputStream[] call() {
        return this.call(null, null, null);
    }

    @Override
    public InputStream[] call(InputStream endpointState, SessionState session, InputStream workUnit) {
        this.checkAllowedArgs(endpointState, session, workUnit);
        return this.getCaller().arrayCall(this.getClient(), endpointState, session, workUnit);
    }

    @Override
    public OutputEndpoint.BulkOutputCaller bulkCaller() {
        return new BulkOutputCallerImpl(this);
    }

    static final class BulkOutputCallerImpl
    extends IOEndpointImpl.BulkIOEndpointCallerImpl
    implements OutputEndpoint.BulkOutputCaller {
        private OutputEndpointImpl endpoint;
        private Consumer<InputStream> outputListener;

        private BulkOutputCallerImpl(OutputEndpointImpl endpoint) {
            super(endpoint);
            this.endpoint = endpoint;
        }

        private OutputEndpointImpl getEndpoint() {
            return this.endpoint;
        }

        private Consumer<InputStream> getOutputListener() {
            return this.outputListener;
        }

        @Override
        public void setOutputListener(Consumer<InputStream> listener) {
            this.outputListener = listener;
        }

        @Override
        public InputStream[] next() {
            if (this.getOutputListener() != null) {
                throw new IllegalStateException("Cannot call next while current output consumer is not empty.");
            }
            return this.getOutput(this.getOutputStream());
        }

        @Override
        public void awaitCompletion() {
            if (this.getOutputListener() == null) {
                throw new IllegalStateException("Output consumer is null");
            }
            logger.trace("output endpoint running endpoint={} work={}", (Object)this.getEndpointPath(), (Object)this.getWorkUnit());
            if (this.getPhase() != IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.INITIALIZING) {
                throw new IllegalStateException("Cannot process output since current phase is  " + this.getPhase().name());
            }
            this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.RUNNING);
            block5: while (true) {
                logger.trace("output endpoint={} count={} state={}", new Object[]{this.getEndpointPath(), this.getCallCount(), this.getEndpointState()});
                InputStream[] output = this.getOutputStream();
                this.processOutputBatch(output, this.getOutputListener());
                switch (this.getPhase()) {
                    case INTERRUPTING: {
                        this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.INTERRUPTED);
                        logger.info("output interrupted endpoint={} count={} work={}", new Object[]{this.getEndpointPath(), this.getCallCount(), this.getWorkUnit()});
                        break block5;
                    }
                    case RUNNING: {
                        if (output != null && output.length != 0) continue block5;
                        this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.COMPLETED);
                        logger.info("output completed endpoint={} count={} work={}", new Object[]{this.getEndpointPath(), this.getCallCount(), this.getWorkUnit()});
                        break block5;
                    }
                    case INTERRUPTED: 
                    case COMPLETED: {
                        throw new IllegalStateException("cannot process more output as current phase is  " + this.getPhase().name());
                    }
                    default: {
                        throw new MarkLogicInternalException("unexpected state for " + this.getEndpointPath() + " during loop: " + this.getPhase().name());
                    }
                }
                break;
            }
        }

        private InputStream[] getOutputStream() {
            InputStream[] output;
            try {
                output = this.getEndpoint().getCaller().arrayCall(this.getClient(), this.getEndpointState(), this.getSession(), this.getWorkUnit());
            }
            catch (Throwable throwable) {
                throw new RuntimeException("error while calling " + this.getEndpoint().getEndpointPath(), throwable);
            }
            this.incrementCallCount();
            return output;
        }
    }
}

