/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.impl.BaseCallerImpl;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.InputStream;
import java.util.stream.Stream;

abstract class IOCallerImpl
extends BaseCallerImpl {
    private JsonNode apiDeclaration;
    private String endpointPath;
    private BaseCallerImpl.ParamdefImpl endpointStateParamdef;
    private BaseCallerImpl.ParamdefImpl sessionParamdef;
    private BaseCallerImpl.ParamdefImpl workUnitParamdef;
    private BaseCallerImpl.ParamdefImpl inputParamdef;
    private BaseCallerImpl.ReturndefImpl returndef;
    private BaseProxy.DBFunctionRequest requester;

    IOCallerImpl(JSONWriteHandle apiDeclaration) {
        JsonNode functionReturn;
        this.apiDeclaration = NodeConverter.handleToJsonNode(apiDeclaration);
        if (!this.apiDeclaration.isObject()) {
            throw new IllegalArgumentException("endpoint declaration must be object: " + this.apiDeclaration.toString());
        }
        this.endpointPath = IOCallerImpl.getText(this.apiDeclaration.get("endpoint"));
        if (this.endpointPath == null || this.endpointPath.length() == 0) {
            throw new IllegalArgumentException("no endpoint in endpoint declaration: " + this.apiDeclaration.toString());
        }
        int nodeArgCount = 0;
        JsonNode functionParams = this.apiDeclaration.get("params");
        if (functionParams != null) {
            if (!functionParams.isArray()) {
                throw new IllegalArgumentException("params must be array in endpoint declaration: " + this.apiDeclaration.toString());
            }
            int paramCount = functionParams.size();
            if (paramCount > 0) {
                block12: for (JsonNode functionParam : functionParams) {
                    String paramName;
                    if (!functionParam.isObject()) {
                        throw new IllegalArgumentException("parameter must be object in endpoint declaration: " + functionParam.toString());
                    }
                    BaseCallerImpl.ParamdefImpl paramdef = new BaseCallerImpl.ParamdefImpl(functionParam);
                    switch (paramName = paramdef.getParamName()) {
                        case "endpointState": {
                            if (paramdef.isMultiple()) {
                                throw new IllegalArgumentException("endpointState parameter cannot be multiple");
                            }
                            if (!paramdef.isNullable()) {
                                throw new IllegalArgumentException("endpointState parameter must be nullable");
                            }
                            this.endpointStateParamdef = paramdef;
                            ++nodeArgCount;
                            continue block12;
                        }
                        case "input": {
                            if (!paramdef.isMultiple()) {
                                throw new IllegalArgumentException("input parameter must be multiple");
                            }
                            if (!paramdef.isNullable()) {
                                throw new IllegalArgumentException("input parameter must be nullable");
                            }
                            this.inputParamdef = paramdef;
                            nodeArgCount += 2;
                            continue block12;
                        }
                        case "session": {
                            if (!"session".equalsIgnoreCase(paramdef.getDataType())) {
                                throw new IllegalArgumentException("session parameter must have session data type");
                            }
                            if (paramdef.isMultiple()) {
                                throw new IllegalArgumentException("session parameter cannot be multiple");
                            }
                            this.sessionParamdef = paramdef;
                            continue block12;
                        }
                        case "workUnit": {
                            if (paramdef.isMultiple()) {
                                throw new IllegalArgumentException("workUnit parameter cannot be multiple");
                            }
                            this.workUnitParamdef = paramdef;
                            ++nodeArgCount;
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException("unknown parameter name: " + paramName);
                }
            }
        }
        if ((functionReturn = this.apiDeclaration.get("return")) != null) {
            if (!functionReturn.isObject()) {
                throw new IllegalArgumentException("return must be object in endpoint declaration: " + functionReturn.toString());
            }
            this.returndef = new BaseCallerImpl.ReturndefImpl(functionReturn);
            if (!this.returndef.isNullable()) {
                throw new IllegalArgumentException("return must be nullable");
            }
        }
        if (this.endpointStateParamdef != null) {
            if (this.returndef == null) {
                throw new IllegalArgumentException("endpointState parameter requires return in endpoint: " + this.getEndpointPath());
            }
            if (this.endpointStateParamdef.getFormat() != this.returndef.getFormat()) {
                throw new IllegalArgumentException("endpointState format must match return format in endpoint: " + this.getEndpointPath());
            }
        }
        this.getBaseProxy();
        this.requester = BaseProxy.moduleRequest(this.getEndpointPath(), BaseProxy.ParameterValuesKind.forNodeCount(nodeArgCount));
    }

    BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, InputStream endpointState, SessionState session, InputStream workUnit) {
        return this.makeRequest(db, endpointState, session, workUnit, (RESTServices.CallField)null);
    }

    BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, InputStream endpointState, SessionState session, InputStream workUnit, Stream<InputStream> input) {
        RESTServices.MultipleNodeCallField inputField = null;
        BaseCallerImpl.ParamdefImpl paramdef = this.getInputParamdef();
        if (paramdef != null) {
            inputField = BaseProxy.documentParam("input", paramdef.isNullable(), NodeConverter.streamWithFormat(NodeConverter.InputStreamToHandle(input), paramdef.getFormat()));
        } else if (input != null) {
            throw new IllegalArgumentException("input parameter not supported by endpoint: " + this.getEndpointPath());
        }
        return this.makeRequest(db, endpointState, session, workUnit, inputField);
    }

    BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, InputStream endpointState, SessionState session, InputStream workUnit, InputStream[] input) {
        RESTServices.MultipleNodeCallField inputField = null;
        BaseCallerImpl.ParamdefImpl paramdef = this.getInputParamdef();
        if (paramdef != null) {
            inputField = BaseProxy.documentParam("input", paramdef.isNullable(), NodeConverter.arrayWithFormat(NodeConverter.InputStreamToHandle(input), paramdef.getFormat()));
        } else if (input != null && input.length > 0) {
            throw new IllegalArgumentException("input parameter not supported by endpoint: " + this.getEndpointPath());
        }
        return this.makeRequest(db, endpointState, session, workUnit, inputField);
    }

    BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, InputStream endpointState, SessionState session, InputStream workUnit, RESTServices.CallField inputField) {
        BaseProxy.DBFunctionRequest request = this.getRequester().on(db);
        if (this.getSessionParamdef() != null) {
            request = request.withSession(this.getSessionParamdef().getParamName(), session, this.getSessionParamdef().isNullable());
        } else if (session != null) {
            throw new IllegalArgumentException("session not supported by endpoint: " + this.getEndpointPath());
        }
        int fieldNum = 0;
        RESTServices.SingleNodeCallField endpointStateField = null;
        if (this.getEndpointStateParamdef() != null) {
            endpointStateField = BaseProxy.documentParam("endpointState", this.getEndpointStateParamdef().isNullable(), NodeConverter.withFormat(NodeConverter.InputStreamToHandle(endpointState), this.getEndpointStateParamdef().getFormat()));
            if (endpointState != null) {
                ++fieldNum;
            }
        } else if (endpointState != null) {
            throw new IllegalArgumentException("endpointState parameter not supported by endpoint: " + this.getEndpointPath());
        }
        RESTServices.SingleNodeCallField workUnitField = null;
        if (this.getWorkUnitParamdef() != null) {
            workUnitField = BaseProxy.documentParam("workUnit", this.getWorkUnitParamdef().isNullable(), NodeConverter.withFormat(NodeConverter.InputStreamToHandle(workUnit), this.getWorkUnitParamdef().getFormat()));
            if (workUnit != null) {
                ++fieldNum;
            }
        } else if (endpointState != null) {
            throw new IllegalArgumentException("workUnit parameter not supported by endpoint: " + this.getEndpointPath());
        }
        if (inputField != null) {
            ++fieldNum;
        }
        if (fieldNum > 0) {
            RESTServices.CallField[] fields = new RESTServices.CallField[fieldNum];
            fieldNum = 0;
            if (endpointStateField != null) {
                fields[fieldNum++] = endpointStateField;
            }
            if (workUnitField != null) {
                fields[fieldNum++] = workUnitField;
            }
            if (inputField != null) {
                fields[fieldNum++] = inputField;
            }
            request = request.withParams(fields);
        }
        return request;
    }

    InputStream responseMaybe(BaseProxy.DBFunctionRequest request) {
        if (this.getReturndef() == null) {
            request.responseNone();
            return null;
        }
        if (this.getReturndef().isMultiple()) {
            throw new UnsupportedOperationException("multiple return from endpoint: " + this.getEndpointPath());
        }
        return request.responseSingle(this.getReturndef().isNullable(), this.getReturndef().getFormat()).asInputStream();
    }

    InputStream responseSingle(BaseProxy.DBFunctionRequest request) {
        if (this.getReturndef() == null) {
            throw new UnsupportedOperationException("no return from endpoint: " + this.getEndpointPath());
        }
        if (this.getReturndef().isMultiple()) {
            throw new UnsupportedOperationException("multiple return from endpoint: " + this.getEndpointPath());
        }
        return request.responseSingle(this.getReturndef().isNullable(), this.getReturndef().getFormat()).asInputStream();
    }

    Stream<InputStream> responseMultipleAsStream(BaseProxy.DBFunctionRequest request) {
        return this.responseMultiple(request).asStreamOfInputStream();
    }

    InputStream[] responseMultipleAsArray(BaseProxy.DBFunctionRequest request) {
        return this.responseMultiple(request).asArrayOfInputStream();
    }

    private RESTServices.MultipleCallResponse responseMultiple(BaseProxy.DBFunctionRequest request) {
        if (this.getReturndef() == null) {
            throw new UnsupportedOperationException("no return from endpoint: " + this.getEndpointPath());
        }
        if (!this.getReturndef().isMultiple()) {
            throw new UnsupportedOperationException("single return from endpoint: " + this.getEndpointPath());
        }
        return request.responseMultiple(this.getReturndef().isNullable(), this.getReturndef().getFormat());
    }

    JsonNode getApiDeclaration() {
        return this.apiDeclaration;
    }

    String getEndpointPath() {
        return this.endpointPath;
    }

    BaseCallerImpl.ParamdefImpl getEndpointStateParamdef() {
        return this.endpointStateParamdef;
    }

    BaseCallerImpl.ParamdefImpl getSessionParamdef() {
        return this.sessionParamdef;
    }

    BaseCallerImpl.ParamdefImpl getWorkUnitParamdef() {
        return this.workUnitParamdef;
    }

    BaseCallerImpl.ParamdefImpl getInputParamdef() {
        return this.inputParamdef;
    }

    BaseCallerImpl.ReturndefImpl getReturndef() {
        return this.returndef;
    }

    BaseProxy.DBFunctionRequest getRequester() {
        return this.requester;
    }
}

