/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.ExecEndpoint;
import com.marklogic.client.dataservices.impl.ExecCallerImpl;
import com.marklogic.client.dataservices.impl.IOEndpointImpl;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecEndpointImpl
extends IOEndpointImpl
implements ExecEndpoint {
    private static Logger logger = LoggerFactory.getLogger(ExecEndpointImpl.class);
    private ExecCallerImpl caller;

    public ExecEndpointImpl(DatabaseClient client, JSONWriteHandle apiDecl) {
        this(client, new ExecCallerImpl(apiDecl));
    }

    private ExecEndpointImpl(DatabaseClient client, ExecCallerImpl caller) {
        super(client, caller);
        this.caller = caller;
    }

    private ExecCallerImpl getCaller() {
        return this.caller;
    }

    @Override
    public void call() {
        this.call(null, null, null);
    }

    @Override
    public InputStream call(InputStream endpointState, SessionState session, InputStream workUnit) {
        this.checkAllowedArgs(endpointState, session, workUnit);
        return this.getCaller().call(this.getClient(), endpointState, session, workUnit);
    }

    @Override
    public ExecEndpoint.BulkExecCaller bulkCaller() {
        return new BulkExecCallerImpl(this);
    }

    static final class BulkExecCallerImpl
    extends IOEndpointImpl.BulkIOEndpointCallerImpl
    implements ExecEndpoint.BulkExecCaller {
        private ExecEndpointImpl endpoint;

        private BulkExecCallerImpl(ExecEndpointImpl endpoint) {
            super(endpoint);
            this.endpoint = endpoint;
        }

        private ExecEndpointImpl getEndpoint() {
            return this.endpoint;
        }

        @Override
        public void awaitCompletion() {
            this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.RUNNING);
            logger.trace("exec running endpoint={} work={}", (Object)this.getEndpointPath(), (Object)this.getWorkUnit());
            block6: while (true) {
                InputStream output = null;
                try {
                    logger.trace("exec calling endpoint={} count={} state={}", new Object[]{this.getEndpointPath(), this.getCallCount(), this.getEndpointState()});
                    output = this.getEndpoint().getCaller().call(this.getClient(), this.getEndpointState(), this.getSession(), this.getWorkUnit());
                    this.incrementCallCount();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("error while calling " + this.getEndpoint().getEndpointPath(), throwable);
                }
                if (this.allowsEndpointState()) {
                    this.setEndpointState(output);
                }
                switch (this.getPhase()) {
                    case INTERRUPTING: {
                        this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.INTERRUPTED);
                        logger.info("exec interrupted endpoint={} count={} work={}", new Object[]{this.getEndpointPath(), this.getCallCount(), this.getWorkUnit()});
                        break block6;
                    }
                    case RUNNING: {
                        if (output != null) continue block6;
                        this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.COMPLETED);
                        logger.info("exec completed endpoint={} count={} work={}", new Object[]{this.getEndpointPath(), this.getCallCount(), this.getWorkUnit()});
                        break block6;
                    }
                    default: {
                        throw new MarkLogicInternalException("unexpected state for " + this.getEndpointPath() + " during loop: " + this.getPhase().name());
                    }
                }
                break;
            }
        }
    }
}

