/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.Forest;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.JobReport;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.NoResponseListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.impl.DataMovementServices;
import com.marklogic.client.datamovement.impl.QueryBatcherImpl;
import com.marklogic.client.datamovement.impl.QueryJobReportListener;
import com.marklogic.client.datamovement.impl.WriteBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteJobReportListener;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.RawCombinedQueryDefinition;
import com.marklogic.client.query.RawCtsQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMovementManagerImpl
implements DataMovementManager {
    private static Logger logger = LoggerFactory.getLogger(DataMovementManager.class);
    private DataMovementServices service = new DataMovementServices();
    private static ConcurrentHashMap<String, JobTicket> activeJobs = new ConcurrentHashMap();
    private ForestConfiguration forestConfig;
    private DatabaseClient primaryClient;
    private Map<String, DatabaseClient> clientMap = new HashMap<String, DatabaseClient>();
    private long serverVersion = Long.parseUnsignedLong("9000000");

    public DataMovementManagerImpl(DatabaseClient client) {
        this.setPrimaryClient(client);
        try {
            String version = ((DatabaseClientImpl)client).getServices().getResource(null, "internal/effective-version", null, null, new StringHandle()).get();
            this.serverVersion = Long.parseUnsignedLong(version);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.clientMap.put(this.primaryClient.getHost(), this.primaryClient);
    }

    @Override
    public void release() {
        for (DatabaseClient client : this.clientMap.values()) {
            try {
                if (this.primaryClient == client) continue;
                client.release();
            }
            catch (Throwable t) {
                logger.error("Failed to release client for host \"" + client.getHost() + "\"", t);
            }
        }
    }

    @Override
    public JobTicket startJob(QueryBatcher batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        return this.service.startJob(batcher, activeJobs);
    }

    @Override
    public JobTicket startJob(WriteBatcher batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        return this.service.startJob(batcher, activeJobs);
    }

    @Override
    public JobReport getJobReport(JobTicket ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket must not be null");
        }
        return this.service.getJobReport(ticket);
    }

    @Override
    public void stopJob(JobTicket ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket must not be null");
        }
        this.service.stopJob(ticket, activeJobs);
    }

    @Override
    public void stopJob(Batcher batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        this.service.stopJob(batcher, activeJobs);
    }

    @Override
    public WriteBatcher newWriteBatcher() {
        WriteBatcherImpl batcher = new WriteBatcherImpl(this, this.getForestConfig());
        batcher.onBatchFailure(new HostAvailabilityListener(this));
        WriteJobReportListener writeJobListener = new WriteJobReportListener();
        batcher.onBatchFailure(writeJobListener);
        batcher.onBatchFailure(new NoResponseListener(this));
        batcher.onBatchSuccess(writeJobListener);
        return batcher;
    }

    @Override
    public QueryBatcher newQueryBatcher(StructuredQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(RawStructuredQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(StringQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(RawCombinedQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(RawCtsQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    private QueryBatcher newQueryBatcherImpl(QueryDefinition query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        return this.newQueryBatcher(new QueryBatcherImpl(query, (DataMovementManager)this, this.getForestConfig()));
    }

    @Override
    public QueryBatcher newQueryBatcher(Iterator<String> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator must not be null");
        }
        return this.newQueryBatcher(new QueryBatcherImpl(iterator, (DataMovementManager)this, this.getForestConfig()));
    }

    private QueryBatcher newQueryBatcher(QueryBatcherImpl batcher) {
        batcher.onQueryFailure(new HostAvailabilityListener(this));
        QueryJobReportListener queryJobListener = new QueryJobReportListener();
        batcher.onQueryFailure(queryJobListener);
        batcher.onQueryFailure(new NoResponseListener(this));
        batcher.onUrisReady(queryJobListener);
        return batcher;
    }

    private ForestConfiguration getForestConfig() {
        if (this.forestConfig != null) {
            return this.forestConfig;
        }
        return this.readForestConfig();
    }

    @Override
    public ForestConfiguration readForestConfig() {
        this.forestConfig = this.service.readForestConfig();
        return this.forestConfig;
    }

    public DatabaseClient getForestClient(Forest forest) {
        if (forest == null) {
            throw new IllegalArgumentException("forest must not be null");
        }
        return this.getHostClient(forest.getPreferredHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseClient getHostClient(String hostName) {
        if (this.getConnectionType() == DatabaseClient.ConnectionType.GATEWAY) {
            return this.getPrimaryClient();
        }
        DatabaseClient client = this.clientMap.get(hostName);
        if (client != null) {
            return client;
        }
        Map<String, DatabaseClient> map = this.clientMap;
        synchronized (map) {
            client = this.clientMap.get(hostName);
            if (client != null) {
                return client;
            }
            client = DatabaseClientFactory.newClient(hostName, this.primaryClient.getPort(), this.primaryClient.getDatabase(), this.primaryClient.getSecurityContext());
            this.clientMap.put(hostName, client);
        }
        return client;
    }

    @Override
    public JobTicket getActiveJob(String jobId) {
        if (jobId == null) {
            throw new IllegalArgumentException("Job id must not be null");
        }
        if (activeJobs.containsKey(jobId)) {
            return activeJobs.get(jobId);
        }
        return null;
    }

    @Override
    public DatabaseClient.ConnectionType getConnectionType() {
        return this.primaryClient.getConnectionType();
    }

    public DataMovementServices getDataMovementServices() {
        return this.service;
    }

    public void setDataMovementServices(DataMovementServices service) {
        this.service = service;
    }

    public void setPrimaryClient(DatabaseClient client) {
        this.primaryClient = client;
        this.service.setClient(this.primaryClient);
    }

    public DatabaseClient getPrimaryClient() {
        return this.primaryClient;
    }

    public long getServerVersion() {
        return this.serverVersion;
    }
}

