/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.WriteBatch;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.WriteEvent;
import com.marklogic.client.datamovement.impl.WriteBatchImpl;
import com.marklogic.client.datamovement.impl.WriteBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteEventImpl;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.ServerTransform;
import java.util.function.Consumer;

public class BatchWriteSet {
    private WriteBatcher batcher;
    private DocumentWriteSet writeSet;
    private long batchNumber;
    private long itemsSoFar;
    private DatabaseClient client;
    private WriteBatcherImpl.TransactionInfo transactionInfo;
    private ServerTransform transform;
    private String temporalCollection;
    private Runnable onSuccess;
    private Consumer<Throwable> onFailure;
    private Runnable onBeforeWrite;

    public BatchWriteSet(WriteBatcher batcher, DocumentWriteSet writeSet, DatabaseClient client, ServerTransform transform, String temporalCollection) {
        this.batcher = batcher;
        this.writeSet = writeSet;
        this.client = client;
        this.transform = transform;
        this.temporalCollection = temporalCollection;
    }

    public DocumentWriteSet getWriteSet() {
        return this.writeSet;
    }

    public void setWriteSet(DocumentWriteSet writeSet) {
        this.writeSet = writeSet;
    }

    public long getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchNumber(long batchNumber) {
        this.batchNumber = batchNumber;
    }

    public void setItemsSoFar(long itemsSoFar) {
        this.itemsSoFar = itemsSoFar;
    }

    public DatabaseClient getClient() {
        return this.client;
    }

    public void setClient(DatabaseClient client) {
        this.client = client;
    }

    public WriteBatcherImpl.TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    public void setTransactionInfo(WriteBatcherImpl.TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    public ServerTransform getTransform() {
        return this.transform;
    }

    public void setTransform(ServerTransform transform) {
        this.transform = transform;
    }

    public String getTemporalCollection() {
        return this.temporalCollection;
    }

    public void setTemporalCollection(String temporalCollection) {
        this.temporalCollection = temporalCollection;
    }

    public Runnable getOnSuccess() {
        return this.onSuccess;
    }

    public void onSuccess(Runnable onSuccess) {
        this.onSuccess = onSuccess;
    }

    public Consumer<Throwable> getOnFailure() {
        return this.onFailure;
    }

    public void onFailure(Consumer<Throwable> onFailure) {
        this.onFailure = onFailure;
    }

    public Runnable getOnBeforeWrite() {
        return this.onBeforeWrite;
    }

    public void onBeforeWrite(Runnable onBeforeWrite) {
        this.onBeforeWrite = onBeforeWrite;
    }

    public WriteBatch getBatchOfWriteEvents() {
        WriteBatchImpl batch = new WriteBatchImpl().withBatcher(this.batcher).withClient(this.client).withJobBatchNumber(this.batchNumber).withJobWritesSoFar(this.itemsSoFar).withJobTicket(this.batcher.getJobTicket());
        WriteEvent[] writeEvents = (WriteEvent[])this.getWriteSet().stream().map(writeOperation -> new WriteEventImpl().withTargetUri(writeOperation.getUri()).withContent(writeOperation.getContent()).withMetadata(writeOperation.getMetadata())).toArray(WriteEventImpl[]::new);
        batch.withItems(writeEvents);
        return batch;
    }
}

