/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Batch;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementException;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.NoResponseListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrisToWriterListener
implements QueryBatchListener {
    private static Logger logger = LoggerFactory.getLogger(UrisToWriterListener.class);
    private Writer writer;
    private String suffix = "\n";
    private String prefix;
    private List<OutputListener> outputListeners = new ArrayList<OutputListener>();
    private List<BatchFailureListener<Batch<String>>> failureListeners = new ArrayList<BatchFailureListener<Batch<String>>>();
    private List<BatchFailureListener<QueryBatch>> queryBatchFailureListeners = new ArrayList<BatchFailureListener<QueryBatch>>();

    public UrisToWriterListener(Writer writer) {
        this.writer = writer;
        logger.debug("new UrisToWriterListener - this should print once/job; if you see this once/batch, fix your job configuration");
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        BatchFailureListener<QueryBatch> noResponseRetryListener;
        NoResponseListener noResponseListener;
        BatchFailureListener<QueryBatch> retryListener;
        HostAvailabilityListener hostAvailabilityListener = HostAvailabilityListener.getInstance((Batcher)queryBatcher);
        if (hostAvailabilityListener != null && (retryListener = hostAvailabilityListener.initializeRetryListener(this)) != null) {
            this.onFailure(retryListener);
        }
        if ((noResponseListener = NoResponseListener.getInstance(queryBatcher)) != null && (noResponseRetryListener = noResponseListener.initializeRetryListener(this)) != null) {
            this.onFailure(noResponseRetryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(QueryBatch batch) {
        try {
            Writer writer = this.writer;
            synchronized (writer) {
                for (String uri : (String[])batch.getItems()) {
                    try {
                        if (this.prefix != null) {
                            this.writer.write(this.prefix);
                        }
                        if (this.outputListeners.size() > 0) {
                            for (OutputListener listener : this.outputListeners) {
                                String output = null;
                                try {
                                    output = listener.generateOutput(uri);
                                }
                                catch (Throwable t) {
                                    logger.error("Exception thrown by an onGenerateOutput listener", t);
                                }
                                if (output == null) continue;
                                this.writer.write(output);
                            }
                        } else {
                            this.writer.write(uri);
                        }
                        if (this.suffix == null) continue;
                        this.writer.write(this.suffix);
                    }
                    catch (IOException e) {
                        throw new DataMovementException("Failed to write uri \"" + uri + "\"", e);
                    }
                }
            }
        }
        catch (Throwable t) {
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.failureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onBatchFailure listener", t2);
                }
            }
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.queryBatchFailureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onFailure listener", t2);
                }
            }
        }
    }

    public UrisToWriterListener withRecordSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public UrisToWriterListener withRecordPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public UrisToWriterListener onGenerateOutput(OutputListener listener) {
        this.outputListeners.add(listener);
        return this;
    }

    @Deprecated
    public UrisToWriterListener onBatchFailure(BatchFailureListener<Batch<String>> listener) {
        this.failureListeners.add(listener);
        return this;
    }

    public UrisToWriterListener onFailure(BatchFailureListener<QueryBatch> listener) {
        this.queryBatchFailureListeners.add(listener);
        return this;
    }

    public static interface OutputListener {
        public String generateOutput(String var1);
    }
}

