/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.turf.TurfMeasurement;
import java.util.ArrayList;

public final class TurfTransformation {
    private static final int DEFAULT_STEPS = 64;

    private TurfTransformation() {
    }

    public static Polygon circle(@NonNull Point center, double radius) {
        return TurfTransformation.circle(center, radius, 64, "kilometers");
    }

    public static Polygon circle(@NonNull Point center, double radius, String units) {
        return TurfTransformation.circle(center, radius, 64, units);
    }

    public static Polygon circle(@NonNull Point center, double radius, @IntRange(from=1L) int steps, String units) {
        ArrayList<Object> coordinates = new ArrayList<Object>();
        for (int i = 0; i < steps; ++i) {
            coordinates.add(TurfMeasurement.destination(center, radius, (double)i * 360.0 / (double)steps, units));
        }
        if (coordinates.size() > 0) {
            coordinates.add(coordinates.get(0));
        }
        ArrayList<ArrayList<Object>> coordinate = new ArrayList<ArrayList<Object>>();
        coordinate.add(coordinates);
        return Polygon.fromLngLats(coordinate);
    }
}

