/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class MultiPoint
implements Geometry<List<Position>> {
    private final String type = "MultiPoint";
    private List<Position> coordinates;

    private MultiPoint(List<Position> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "MultiPoint";
    }

    @Override
    public List<Position> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void setCoordinates(List<Position> coordinates) {
        this.coordinates = coordinates;
    }

    public static MultiPoint fromCoordinates(List<Position> coordinates) {
        return new MultiPoint(coordinates);
    }

    public static MultiPoint fromCoordinates(double[][] coordinates) {
        ArrayList<Position> converted = new ArrayList<Position>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            converted.add(Position.fromCoordinates((double[])coordinates[i]));
        }
        return MultiPoint.fromCoordinates(converted);
    }

    public static MultiPoint fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        return (MultiPoint)gson.create().fromJson(json, MultiPoint.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }
}

