/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.provider;

import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.android.core.crashreporter.MapboxUncaughtExceptionHanlder;
import com.mapbox.android.telemetry.MapboxTelemetryService;
import com.mapbox.android.telemetry.errors.TokenChangeBroadcastReceiver;
import com.mapbox.android.telemetry.location.LocationCollectionClient;
import java.util.concurrent.TimeUnit;

public class MapboxTelemetryInitProvider
extends ContentProvider {
    private static final String TAG = "MbxTelemInitProvider";
    private static final String EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY = "com.mapbox.android.telemetry.provider.mapboxtelemetryinitprovider";
    MapboxTelemetryService telemetryService = null;
    private final ServiceConnection telemetryServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            MapboxTelemetryService.Binder binder = (MapboxTelemetryService.Binder)service;
            MapboxTelemetryInitProvider.this.telemetryService = binder.getService();
        }

        public void onServiceDisconnected(ComponentName name) {
            MapboxTelemetryInitProvider.this.telemetryService = null;
        }
    };

    public boolean onCreate() {
        try {
            Context context = this.getContext();
            if (context == null) {
                Log.e((String)TAG, (String)"Failed to initialize: context is null");
                return false;
            }
            Intent intent = new Intent(context, MapboxTelemetryService.class);
            context.bindService(intent, this.telemetryServiceConnection, 1);
            TokenChangeBroadcastReceiver.register(context);
            MapboxUncaughtExceptionHanlder.install((Context)context, (String)"com.mapbox.android.telemetry", (String)"6.3.0");
            LocationCollectionClient.install(context, TimeUnit.HOURS.toMillis(24L));
            return true;
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)throwable.toString());
            return false;
        }
    }

    public void attachInfo(Context context, ProviderInfo info) {
        MapboxTelemetryInitProvider.checkContentProviderAuthority(info);
        super.attachInfo(context, info);
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    private static void checkContentProviderAuthority(@NonNull ProviderInfo info) {
        if (info == null) {
            throw new IllegalStateException("MapboxTelemetryInitProvider: ProviderInfo cannot be null.");
        }
        if (EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY.equals(info.authority)) {
            throw new IllegalStateException("Incorrect provider authority in manifest. Most likely due to a missing applicationId variable in application's build.gradle.");
        }
    }
}

