/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.telemetry.metrics.TelemetryMetrics;
import java.util.concurrent.TimeUnit;

public class TelemetryMetricsClient {
    private static final String TELEMETRY_METRICS_USER_AGENT = "mapbox-android-metrics";
    private static TelemetryMetricsClient telemetryMetricsClient;
    private static final Object lock;
    private final TelemetryMetrics telemetryMetrics;

    @VisibleForTesting
    TelemetryMetricsClient(@NonNull TelemetryMetrics telemetryMetrics) {
        this.telemetryMetrics = telemetryMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelemetryMetricsClient install(@NonNull Context context) {
        if (context.getApplicationContext() == null) {
            Context applicationContext = context;
        } else {
            Context applicationContext = context.getApplicationContext();
        }
        TelemetryMetrics metrics = new TelemetryMetrics(TimeUnit.HOURS.toMillis(24L));
        Object object = lock;
        synchronized (object) {
            if (telemetryMetricsClient == null) {
                telemetryMetricsClient = new TelemetryMetricsClient(metrics);
            }
        }
        return telemetryMetricsClient;
    }

    @NonNull
    public static TelemetryMetricsClient getInstance() {
        Object object = lock;
        synchronized (object) {
            if (telemetryMetricsClient != null) {
                return telemetryMetricsClient;
            }
            throw new IllegalStateException("TelemetryMetricsClient is not installed.");
        }
    }

    @NonNull
    public TelemetryMetrics getMetrics() {
        return this.telemetryMetrics;
    }

    static {
        lock = new Object();
    }
}

