/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.errors;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.errors.ErrorReporterClient;
import java.io.File;
import java.util.concurrent.ExecutorService;

public final class ErrorReporterEngine {
    private static final String LOG_TAG = "CrashReporter";

    public static void sendErrorReports(final @NonNull Context context, @NonNull ExecutorService executorService) {
        if (Build.VERSION.SDK_INT < 26) {
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent("com.mapbox.android.telemetry.action.TOKEN_CHANGED"));
        } else {
            try {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        ErrorReporterEngine.sendReports(context);
                    }
                });
            }
            catch (Throwable throwable) {
                Log.e((String)LOG_TAG, (String)throwable.toString());
            }
        }
    }

    static void sendReports(@NonNull Context context) {
        if (context == null || context.getApplicationContext() == null) {
            return;
        }
        File rootDirectory = FileUtils.getFile((Context)context.getApplicationContext(), (String)"com.mapbox.android.telemetry");
        if (!rootDirectory.exists()) {
            Log.w((String)LOG_TAG, (String)"Root directory doesn't exist");
            return;
        }
        ErrorReporterEngine.handleErrorReports(ErrorReporterClient.create(context.getApplicationContext()).loadFrom(rootDirectory));
    }

    @VisibleForTesting
    static void handleErrorReports(@NonNull ErrorReporterClient client) {
        if (!client.isEnabled()) {
            Log.w((String)LOG_TAG, (String)"Crash reporter is disabled");
            return;
        }
        while (client.hasNextEvent()) {
            CrashEvent event = client.nextEvent();
            if (client.isDuplicate(event)) {
                Log.d((String)LOG_TAG, (String)("Skip duplicate crash in this batch: " + event.getHash()));
                client.delete(event);
                continue;
            }
            if (client.send(event)) {
                client.delete(event);
                continue;
            }
            Log.w((String)LOG_TAG, (String)"Failed to deliver crash event");
        }
    }
}

