/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import com.mapbox.android.telemetry.TelemetryUtils;

public class SessionIdentifier {
    private static final long HOURS_TO_MILLISECONDS = 3600000L;
    private static final int DEFAULT_ROTATION_HOURS = 24;
    private final long rotationInterval;
    private String sessionId = null;
    private long lastSessionIdUpdate;

    public SessionIdentifier() {
        this(86400000L);
    }

    public SessionIdentifier(long intervalMillis) {
        this.rotationInterval = intervalMillis;
    }

    @Deprecated
    public SessionIdentifier(int rotationInterval) {
        this.rotationInterval = (long)rotationInterval * 3600000L;
    }

    public long getInterval() {
        return this.rotationInterval;
    }

    String getSessionId() {
        long timeDiff = System.currentTimeMillis() - this.lastSessionIdUpdate;
        if (timeDiff >= this.rotationInterval || this.sessionId == null) {
            this.sessionId = TelemetryUtils.obtainUniversalUniqueIdentifier();
            this.lastSessionIdUpdate = System.currentTimeMillis();
        }
        return this.sessionId;
    }
}

