/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;

class AlarmSchedulerFlusher
implements SchedulerFlusher {
    private final Context context;
    private final AlarmManager manager;
    private final AlarmReceiver receiver;
    private PendingIntent pendingIntent;

    AlarmSchedulerFlusher(Context context, AlarmManager manager, AlarmReceiver receiver) {
        this.context = context;
        this.manager = manager;
        this.receiver = receiver;
    }

    @Override
    public void register() {
        Intent alarmIntent = this.receiver.supplyIntent();
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)alarmIntent, (int)0x8000000);
        IntentFilter filter = new IntentFilter("com.mapbox.scheduler_flusher");
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    @Override
    public void schedule(long elapsedRealTime) {
        long firstFlushingInMillis = elapsedRealTime + SchedulerFlusherFactory.flushingPeriod;
        this.manager.setInexactRepeating(3, firstFlushingInMillis, SchedulerFlusherFactory.flushingPeriod, this.pendingIntent);
    }

    @VisibleForTesting
    boolean scheduleExact(long interval) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.manager.setExact(3, SystemClock.elapsedRealtime() + interval, this.pendingIntent);
            return true;
        }
        return false;
    }

    @Override
    public void unregister() {
        if (this.pendingIntent != null) {
            this.manager.cancel(this.pendingIntent);
        }
        try {
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    PendingIntent obtainPendingIntent() {
        return this.pendingIntent;
    }
}

