/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.location.LocationEngineController;
import com.mapbox.android.telemetry.location.LocationEngineControllerImpl;
import com.mapbox.android.telemetry.location.LocationUpdatesBroadcastReceiver;
import com.mapbox.android.telemetry.location.SessionIdentifier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class LocationCollectionClient
implements SharedPreferences.OnSharedPreferenceChangeListener {
    public static final int DEFAULT_SESSION_ROTATION_INTERVAL_HOURS = 24;
    private static final String LOCATION_COLLECTOR_USER_AGENT = "mapbox-android-location";
    private static final String TAG = "LocationCollectionCli";
    private static final int LOCATION_COLLECTION_STATUS_UPDATED = 0;
    private static final Object lock = new Object();
    private static LocationCollectionClient locationCollectionClient;
    @VisibleForTesting
    final LocationEngineController locationEngineController;
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    private final AtomicReference<SessionIdentifier> sessionIdentifier = new AtomicReference();
    private final HandlerThread settingsChangeHandlerThread;
    private final MapboxTelemetry telemetry;
    private final SharedPreferences sharedPreferences;
    private Handler settingsChangeHandler;

    @VisibleForTesting
    LocationCollectionClient(@NonNull LocationEngineController collectionController, @NonNull HandlerThread handlerThread, @NonNull SessionIdentifier sessionIdentifier, @NonNull SharedPreferences sharedPreferences, @NonNull MapboxTelemetry telemetry) {
        this.locationEngineController = collectionController;
        this.settingsChangeHandlerThread = handlerThread;
        this.sessionIdentifier.set(sessionIdentifier);
        this.telemetry = telemetry;
        this.settingsChangeHandlerThread.start();
        this.settingsChangeHandler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message msg) {
                try {
                    LocationCollectionClient.this.handleSettingsChangeMessage(msg);
                }
                catch (Throwable throwable) {
                    Log.e((String)LocationCollectionClient.TAG, (String)throwable.toString());
                }
            }
        };
        this.sharedPreferences = sharedPreferences;
        this.initializeSharedPreferences(sharedPreferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationCollectionClient install(@NonNull Context context, long defaultInterval) {
        Context applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = lock;
        synchronized (object) {
            if (locationCollectionClient == null) {
                locationCollectionClient = new LocationCollectionClient(new LocationEngineControllerImpl(applicationContext, LocationEngineProvider.getBestLocationEngine((Context)applicationContext), new LocationUpdatesBroadcastReceiver()), new HandlerThread("LocationSettingsChangeThread"), new SessionIdentifier(defaultInterval), applicationContext.getSharedPreferences("MapboxSharedPreferences", 0), new MapboxTelemetry(applicationContext, "", String.format("%s/%s", LOCATION_COLLECTOR_USER_AGENT, "4.7.4")));
            }
        }
        return locationCollectionClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean uninstall() {
        boolean uninstalled = false;
        Object object = lock;
        synchronized (object) {
            if (locationCollectionClient != null) {
                LocationCollectionClient.locationCollectionClient.locationEngineController.onDestroy();
                LocationCollectionClient.locationCollectionClient.settingsChangeHandlerThread.quit();
                LocationCollectionClient.locationCollectionClient.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)locationCollectionClient);
                locationCollectionClient = null;
                uninstalled = true;
            }
        }
        return uninstalled;
    }

    @NonNull
    static LocationCollectionClient getInstance() {
        Object object = lock;
        synchronized (object) {
            if (locationCollectionClient != null) {
                return locationCollectionClient;
            }
            throw new IllegalStateException("LocationCollectionClient is not installed.");
        }
    }

    void setSessionRotationInterval(long interval) {
        this.sessionIdentifier.set(new SessionIdentifier(interval));
    }

    long getSessionRotationInterval() {
        return this.sessionIdentifier.get().getInterval();
    }

    String getSessionId() {
        return this.sessionIdentifier.get().getSessionId();
    }

    boolean isEnabled() {
        return this.isEnabled.get();
    }

    void setEnabled(boolean enabled) {
        if (this.isEnabled.compareAndSet(!enabled, enabled)) {
            this.settingsChangeHandler.sendEmptyMessage(0);
        }
    }

    MapboxTelemetry getTelemetry() {
        return this.telemetry;
    }

    @VisibleForTesting
    void setMockHandler(Handler mockHandler) {
        this.settingsChangeHandler = mockHandler;
    }

    @VisibleForTesting
    void handleSettingsChangeMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                if (this.isEnabled()) {
                    this.locationEngineController.onResume();
                    this.telemetry.enable();
                    break;
                }
                this.locationEngineController.onDestroy();
                this.telemetry.disable();
                break;
            }
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        try {
            if ("mapboxTelemetryLocationState".equals(key)) {
                this.setEnabled(sharedPreferences.getBoolean("mapboxTelemetryLocationState", false));
            } else if ("mapboxSessionRotationInterval".equals(key)) {
                this.setSessionRotationInterval(sharedPreferences.getLong("mapboxSessionRotationInterval", TimeUnit.HOURS.toMillis(24L)));
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
    }

    private void initializeSharedPreferences(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean("mapboxTelemetryLocationState", this.isEnabled.get());
        editor.putLong("mapboxSessionRotationInterval", this.sessionIdentifier.get().getInterval());
        editor.apply();
        sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }
}

