/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.android.core.crashreporter.MapboxUncaughtExceptionHanlder;
import com.mapbox.android.telemetry.location.LocationCollectionClient;
import java.util.concurrent.TimeUnit;

public class MapboxTelemetryInitProvider
extends ContentProvider {
    private static final String TAG = "MbxTelemInitProvider";
    private static final String EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY = "com.mapbox.android.telemetry.provider.mapboxtelemetryinitprovider";

    public boolean onCreate() {
        try {
            MapboxUncaughtExceptionHanlder.install((Context)this.getContext(), (String)"com.mapbox.android.telemetry", (String)"4.7.3");
            LocationCollectionClient.install(this.getContext(), TimeUnit.HOURS.toMillis(24L));
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)throwable.toString());
        }
        return false;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        MapboxTelemetryInitProvider.checkContentProviderAuthority(info);
        super.attachInfo(context, info);
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    private static void checkContentProviderAuthority(@NonNull ProviderInfo info) {
        if (info == null) {
            throw new IllegalStateException("MapboxTelemetryInitProvider: ProviderInfo cannot be null.");
        }
        if (EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY.equals(info.authority)) {
            throw new IllegalStateException("Incorrect provider authority in manifest. Most likely due to a missing applicationId variable in application's build.gradle.");
        }
    }
}

