/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.mapbox.android.telemetry.metrics.TelemetryMetrics;

public class NetworkUsageMetricsCollector {
    private static final int TYPE_NONE = -1;
    private final ConnectivityManager connectivityManager;
    private final TelemetryMetrics metrics;

    public NetworkUsageMetricsCollector(Context context, TelemetryMetrics metrics) {
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.metrics = metrics;
    }

    void addRxBytes(long bytes) {
        this.metrics.addRxBytesForType(this.getActiveNetworkType(), bytes);
    }

    void addTxBytes(long bytes) {
        this.metrics.addTxBytesForType(this.getActiveNetworkType(), bytes);
    }

    private int getActiveNetworkType() {
        NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
        return activeNetwork == null ? -1 : activeNetwork.getType();
    }
}

