/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentMetadata;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FileAttachment;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.VisionBuildEvent;
import com.mapbox.android.telemetry.VisionEvent;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;

public class VisionEventFactory {
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    private static final String NOT_A_VISION_EVENT_TYPE = "Type must be a vision event.";
    private final Map<Event.Type, VisionBuildEvent> BUILD_EVENT_VISION = new HashMap<Event.Type, VisionBuildEvent>(){
        {
            this.put(Event.Type.VIS_GENERAL, new VisionBuildEvent(){

                @Override
                public Event build() {
                    return VisionEventFactory.this.buildVisionEvent();
                }
            });
        }
    };

    public VisionEventFactory() {
        if (MapboxTelemetry.applicationContext == null) {
            throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
        }
    }

    public Event createVisionEvent(Event.Type type) {
        if (type == Event.Type.VIS_OBJ_DETECTION) {
            throw new UnsupportedOperationException("Unsupported event type: " + type.name());
        }
        this.checkVisionEvent(type);
        return this.BUILD_EVENT_VISION.get((Object)type).build();
    }

    public FileAttachment createFileAttachment(String filePath, MediaType mediaType, AttachmentMetadata attachmentMetadata) {
        return new FileAttachment(attachmentMetadata, filePath, mediaType);
    }

    public Attachment createAttachment(Event.Type type) {
        this.checkVisionEvent(type);
        return this.buildAttachment();
    }

    private VisionEvent buildVisionEvent() {
        VisionEvent visionEvent = new VisionEvent();
        return visionEvent;
    }

    private Attachment buildAttachment() {
        Attachment attachment = new Attachment();
        return attachment;
    }

    private void checkVisionEvent(Event.Type type) {
        this.checkEventType(type);
    }

    private void checkEventType(Event.Type type) {
        if (!Event.visionEventTypes.contains((Object)type)) {
            throw new IllegalArgumentException(NOT_A_VISION_EVENT_TYPE);
        }
    }
}

