/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.NavBuildEvent;
import com.mapbox.android.telemetry.NavigationArriveEvent;
import com.mapbox.android.telemetry.NavigationCancelEvent;
import com.mapbox.android.telemetry.NavigationDepartEvent;
import com.mapbox.android.telemetry.NavigationFasterRouteEvent;
import com.mapbox.android.telemetry.NavigationFeedbackEvent;
import com.mapbox.android.telemetry.NavigationRerouteEvent;
import com.mapbox.android.telemetry.NavigationState;
import java.util.HashMap;
import java.util.Map;

public class NavigationEventFactory {
    private static final String NOT_A_NAVIGATION_EVENT_TYPE = "Type must be a navigation event.";
    private static final String NAVIGATION_STATE_ILLEGAL_NULL = "NavigationState cannot be null.";
    private final Map<Event.Type, NavBuildEvent> BUILD_NAV_EVENT = new HashMap<Event.Type, NavBuildEvent>(){
        {
            this.put(Event.Type.NAV_ARRIVE, new NavBuildEvent(){

                @Override
                public Event build(NavigationState navigationState) {
                    return NavigationEventFactory.this.buildNavigationArriveEvent(navigationState);
                }
            });
            this.put(Event.Type.NAV_DEPART, new NavBuildEvent(){

                @Override
                public Event build(NavigationState navigationState) {
                    return NavigationEventFactory.this.buildNavigationDepartEvent(navigationState);
                }
            });
            this.put(Event.Type.NAV_CANCEL, new NavBuildEvent(){

                @Override
                public Event build(NavigationState navigationState) {
                    return NavigationEventFactory.this.buildNavigationCancelEvent(navigationState);
                }
            });
            this.put(Event.Type.NAV_FEEDBACK, new NavBuildEvent(){

                @Override
                public Event build(NavigationState navigationState) {
                    return NavigationEventFactory.this.buildNavigationFeedbackEvent(navigationState);
                }
            });
            this.put(Event.Type.NAV_REROUTE, new NavBuildEvent(){

                @Override
                public Event build(NavigationState navigationState) {
                    return NavigationEventFactory.this.buildNavigationRerouteEvent(navigationState);
                }
            });
            this.put(Event.Type.NAV_FASTER_ROUTE, new NavBuildEvent(){

                @Override
                public Event build(NavigationState navigationState) {
                    return NavigationEventFactory.this.buildNavigationFasterRouteEvent(navigationState);
                }
            });
        }
    };

    public Event createNavigationEvent(Event.Type type, NavigationState navigationState) {
        this.check(type, navigationState);
        return this.BUILD_NAV_EVENT.get((Object)type).build(navigationState);
    }

    private NavigationDepartEvent buildNavigationDepartEvent(NavigationState navigationState) {
        return new NavigationDepartEvent(navigationState);
    }

    private NavigationArriveEvent buildNavigationArriveEvent(NavigationState navigationState) {
        return new NavigationArriveEvent(navigationState);
    }

    private NavigationCancelEvent buildNavigationCancelEvent(NavigationState navigationState) {
        return new NavigationCancelEvent(navigationState);
    }

    private NavigationRerouteEvent buildNavigationRerouteEvent(NavigationState navigationState) {
        return new NavigationRerouteEvent(navigationState);
    }

    private NavigationFeedbackEvent buildNavigationFeedbackEvent(NavigationState navigationState) {
        return new NavigationFeedbackEvent(navigationState);
    }

    private NavigationFasterRouteEvent buildNavigationFasterRouteEvent(NavigationState navigationState) {
        return new NavigationFasterRouteEvent(navigationState);
    }

    private void check(Event.Type type, NavigationState navigationState) {
        this.checkNavigationEvent(type);
        this.isNotNull(navigationState);
    }

    private void checkNavigationEvent(Event.Type type) {
        if (!Event.navigationEventTypes.contains((Object)type)) {
            throw new IllegalArgumentException(NOT_A_NAVIGATION_EVENT_TYPE);
        }
    }

    private void isNotNull(NavigationState navigationState) {
        if (navigationState == null) {
            throw new IllegalArgumentException(NAVIGATION_STATE_ILLEGAL_NULL);
        }
    }
}

