/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.mapbox.android.telemetry.ConcurrentQueue;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FullQueueCallback;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

class EventsQueue {
    private static final String LOG_TAG = "EventsQueue";
    @VisibleForTesting
    static final int SIZE_LIMIT = 180;
    private final FullQueueCallback callback;
    private final ConcurrentQueue<Event> queue;
    private final ExecutorService executorService;

    @VisibleForTesting
    EventsQueue(@NonNull ConcurrentQueue<Event> queue, @NonNull FullQueueCallback callback, @NonNull ExecutorService executorService) {
        this.queue = queue;
        this.callback = callback;
        this.executorService = executorService;
    }

    static synchronized EventsQueue create(@NonNull FullQueueCallback callback, @NonNull ExecutorService executorService) {
        if (callback == null || executorService == null) {
            throw new IllegalArgumentException("Callback or executor can't be null");
        }
        return new EventsQueue(new ConcurrentQueue<Event>(), callback, executorService);
    }

    boolean isEmpty() {
        return this.queue.size() == 0;
    }

    int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean push(Event event) {
        EventsQueue eventsQueue = this;
        synchronized (eventsQueue) {
            if (this.queue.size() >= 180) {
                this.dispatchCallback(this.queue.flush());
            }
            return this.queue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Event> flush() {
        EventsQueue eventsQueue = this;
        synchronized (eventsQueue) {
            return this.queue.flush();
        }
    }

    private void dispatchCallback(final List<Event> events) {
        try {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    EventsQueue.this.callback.onFullQueue(events);
                }
            });
        }
        catch (RejectedExecutionException rex) {
            Log.e((String)LOG_TAG, (String)rex.toString());
        }
    }
}

