/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.arch.lifecycle.ProcessLifecycleOwner;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.mapbox.android.core.permissions.PermissionsManager;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentListener;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.Clock;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.FullQueueCallback;
import com.mapbox.android.telemetry.FullQueueFlusher;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.PermissionCheckRunnable;
import com.mapbox.android.telemetry.SchedulerCallback;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientFactory;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryListener;
import com.mapbox.android.telemetry.TelemetryLocationEnabler;
import com.mapbox.android.telemetry.TelemetryService;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class MapboxTelemetry
implements FullQueueCallback,
EventCallback,
ServiceTaskCallback,
LifecycleObserver {
    private static final String NON_NULL_APPLICATION_CONTEXT_REQUIRED = "Non-null application context required.";
    private static final String START_SERVICE_FAIL = "Unable to start service";
    private static final int NO_FLAGS = 0;
    private String accessToken;
    private String userAgent;
    private EventsQueue queue;
    private TelemetryClient telemetryClient;
    private TelemetryService telemetryService;
    private Callback httpCallback;
    private final SchedulerFlusher schedulerFlusher;
    private Clock clock;
    private ServiceConnection serviceConnection;
    private Intent locationServiceIntent;
    private final TelemetryEnabler telemetryEnabler;
    private final TelemetryLocationEnabler telemetryLocationEnabler;
    private boolean isLocationOpted;
    private boolean isServiceBound;
    private PermissionCheckRunnable permissionCheckRunnable;
    private CopyOnWriteArraySet<TelemetryListener> telemetryListeners;
    private CertificateBlacklist certificateBlacklist;
    private CopyOnWriteArraySet<AttachmentListener> attachmentListeners;
    static Context applicationContext;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public MapboxTelemetry(Context context, String string, String string2) {
        void alarmReceiver;
        void userAgent;
        void accessToken;
        void context2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.clock = null;
        this.serviceConnection = null;
        this.locationServiceIntent = null;
        this.isLocationOpted = false;
        this.isServiceBound = false;
        this.permissionCheckRunnable = null;
        this.telemetryListeners = null;
        this.attachmentListeners = null;
        blArray[0] = true;
        this.initializeContext((Context)context2);
        blArray[1] = true;
        this.initializeQueue();
        blArray[2] = true;
        this.checkBlacklist((Context)context2, (String)accessToken);
        blArray[3] = true;
        this.checkRequiredParameters((String)accessToken, (String)userAgent);
        blArray[4] = true;
        AlarmReceiver alarmReceiver2 = this.obtainAlarmReceiver();
        blArray[5] = true;
        this.schedulerFlusher = new SchedulerFlusherFactory(applicationContext, (AlarmReceiver)alarmReceiver).supply();
        blArray[6] = true;
        this.serviceConnection = this.obtainServiceConnection();
        blArray[7] = true;
        this.telemetryEnabler = new TelemetryEnabler(true);
        blArray[8] = true;
        this.telemetryLocationEnabler = new TelemetryLocationEnabler(true);
        blArray[9] = true;
        this.initializeTelemetryListeners();
        blArray[10] = true;
        this.initializeAttachmentListeners();
        blArray[11] = true;
        this.initializeTelemetryLocationState(context2.getApplicationContext());
        blArray[12] = true;
        this.httpCallback = MapboxTelemetry.getHttpCallback(this.telemetryListeners);
        blArray[13] = true;
    }

    /*
     * WARNING - void declaration
     */
    MapboxTelemetry(Context context, String string, String string2, EventsQueue eventsQueue, TelemetryClient telemetryClient, Callback callback, SchedulerFlusher schedulerFlusher, Clock clock, boolean bl, TelemetryEnabler telemetryEnabler, TelemetryLocationEnabler telemetryLocationEnabler) {
        void isServiceBound;
        void telemetryLocationEnabler2;
        void telemetryEnabler2;
        void clock2;
        void schedulerFlusher2;
        void httpCallback;
        void telemetryClient2;
        void userAgent;
        void accessToken;
        void queue;
        void context2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.clock = null;
        this.serviceConnection = null;
        this.locationServiceIntent = null;
        this.isLocationOpted = false;
        this.isServiceBound = false;
        this.permissionCheckRunnable = null;
        this.telemetryListeners = null;
        this.attachmentListeners = null;
        blArray[14] = true;
        this.initializeContext((Context)context2);
        this.queue = queue;
        blArray[15] = true;
        this.checkRequiredParameters((String)accessToken, (String)userAgent);
        this.telemetryClient = telemetryClient2;
        this.httpCallback = httpCallback;
        this.schedulerFlusher = schedulerFlusher2;
        this.clock = clock2;
        this.telemetryEnabler = telemetryEnabler2;
        this.telemetryLocationEnabler = telemetryLocationEnabler2;
        this.isServiceBound = isServiceBound;
        blArray[16] = true;
        this.initializeTelemetryListeners();
        blArray[17] = true;
        this.initializeAttachmentListeners();
        blArray[18] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFullQueue(List<Event> list) {
        void telemetryState;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        blArray[19] = true;
        if (!TelemetryEnabler.State.ENABLED.equals(telemetryState)) {
            blArray[20] = true;
        } else {
            blArray[21] = true;
            if (TelemetryUtils.adjustWakeUpMode(applicationContext)) {
                blArray[22] = true;
            } else {
                void fullQueue;
                blArray[23] = true;
                this.sendEventsIfPossible((List<Event>)fullQueue);
                blArray[24] = true;
            }
        }
        blArray[25] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEventReceived(Event event) {
        void event2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.pushToQueue((Event)event2);
        blArray[26] = true;
    }

    @Override
    public void onTaskRemoved() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.flushEnqueuedEvents();
        blArray[27] = true;
        this.unregisterTelemetry();
        blArray[28] = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean push(Event event) {
        void event2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.sendEventIfWhitelisted((Event)event2)) {
            blArray[29] = true;
            return true;
        }
        boolean isPushed = this.pushToQueue((Event)event2);
        blArray[30] = true;
        return isPushed;
    }

    public boolean enable() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            blArray[31] = true;
            this.startTelemetry();
            blArray[32] = true;
            return true;
        }
        blArray[33] = true;
        return false;
    }

    public boolean disable() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            blArray[34] = true;
            this.stopTelemetry();
            blArray[35] = true;
            return true;
        }
        blArray[36] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean updateSessionIdRotationInterval(SessionInterval sessionInterval) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.isServiceBound) {
            blArray[37] = true;
        } else if (this.telemetryService == null) {
            blArray[38] = true;
        } else {
            void sessionIdentifier;
            void hour;
            void interval;
            blArray[39] = true;
            int n = interval.obtainInterval();
            blArray[40] = true;
            SessionIdentifier sessionIdentifier2 = new SessionIdentifier((int)hour);
            blArray[41] = true;
            this.telemetryService.updateSessionIdentifier((SessionIdentifier)sessionIdentifier);
            blArray[42] = true;
            return true;
        }
        blArray[43] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void updateDebugLoggingEnabled(boolean bl) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.telemetryClient == null) {
            blArray[44] = true;
        } else {
            void isDebugLoggingEnabled;
            blArray[45] = true;
            this.telemetryClient.updateDebugLoggingEnabled((boolean)isDebugLoggingEnabled);
            blArray[46] = true;
        }
        blArray[47] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateUserAgent(String string) {
        void userAgent;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.isUserAgentValid((String)userAgent)) {
            blArray[48] = true;
        } else {
            blArray[49] = true;
            this.telemetryClient.updateUserAgent(TelemetryUtils.createFullUserAgent((String)userAgent, applicationContext));
            blArray[50] = true;
        }
        blArray[51] = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean updateAccessToken(String string) {
        void accessToken;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.isAccessTokenValid((String)accessToken)) {
            blArray[52] = true;
        } else if (!this.updateTelemetryClient((String)accessToken)) {
            blArray[53] = true;
        } else {
            this.accessToken = accessToken;
            blArray[54] = true;
            return true;
        }
        blArray[55] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addTelemetryListener(TelemetryListener telemetryListener) {
        void listener;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[56] = true;
        return this.telemetryListeners.add((TelemetryListener)listener);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeTelemetryListener(TelemetryListener telemetryListener) {
        void listener;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[57] = true;
        return this.telemetryListeners.remove(listener);
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAttachmentListener(AttachmentListener attachmentListener) {
        void listener;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[58] = true;
        return this.attachmentListeners.add((AttachmentListener)listener);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAttachmentListener(AttachmentListener attachmentListener) {
        void listener;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[59] = true;
        return this.attachmentListeners.remove(listener);
    }

    boolean optLocationIn() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.startTelemetryService();
        blArray[60] = true;
        this.bindTelemetryService();
        blArray[61] = true;
        return this.isLocationOpted;
    }

    /*
     * Unable to fully structure code
     */
    boolean optLocationOut() {
        block3: {
            block5: {
                block4: {
                    block2: {
                        var1_1 = MapboxTelemetry.$jacocoInit();
                        var1_1[62] = true;
                        telemetryLocationState = this.telemetryLocationEnabler.obtainTelemetryLocationState(MapboxTelemetry.applicationContext);
                        if (this.isServiceBound) break block2;
                        var1_1[63] = true;
                        break block3;
                    }
                    if (this.telemetryService != null) break block4;
                    var1_1[64] = true;
                    break block3;
                }
                var1_1[65] = true;
                this.telemetryService.unbindInstance();
                var1_1[66] = true;
                this.telemetryService.removeServiceTask(this);
                var1_1[67] = true;
                if (this.telemetryService.obtainBoundInstances() == 0) break block5;
                var1_1[68] = true;
                ** GOTO lbl34
            }
            var1_1[69] = true;
            if (TelemetryLocationEnabler.LocationState.ENABLED.equals((Object)telemetryLocationState)) {
                var1_1[71] = true;
                this.unbindServiceConnection();
                this.isServiceBound = false;
                var1_1[72] = true;
                this.stopLocation();
                this.isLocationOpted = false;
                var1_1[73] = true;
            } else {
                var1_1[70] = true;
lbl34:
                // 2 sources

                this.unbindServiceConnection();
                this.isServiceBound = false;
                var1_1[74] = true;
            }
        }
        var1_1[75] = true;
        return this.isLocationOpted;
    }

    boolean isQueueEmpty() {
        boolean bl;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.queue.queue.size() == 0) {
            bl = blArray[76] = true;
        } else {
            bl = false;
            blArray[77] = true;
        }
        blArray[78] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void startTelemetryService() {
        void telemetryLocationState;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[79] = true;
        TelemetryLocationEnabler.LocationState locationState = this.telemetryLocationEnabler.obtainTelemetryLocationState(applicationContext);
        blArray[80] = true;
        if (!TelemetryLocationEnabler.LocationState.DISABLED.equals(telemetryLocationState)) {
            blArray[81] = true;
        } else if (!this.checkLocationPermission()) {
            blArray[82] = true;
        } else {
            blArray[83] = true;
            this.startLocation(this.isLollipopOrHigher());
            this.isLocationOpted = true;
            blArray[84] = true;
        }
        blArray[85] = true;
    }

    private void bindTelemetryService() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        applicationContext.bindService(this.obtainLocationServiceIntent(), this.serviceConnection, 0);
        blArray[86] = true;
    }

    /*
     * WARNING - void declaration
     */
    boolean checkRequiredParameters(String string, String string2) {
        void userAgent;
        void accessToken;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        boolean areValidParameters = this.areRequiredParametersValid((String)accessToken, (String)userAgent);
        if (!areValidParameters) {
            blArray[87] = true;
        } else {
            blArray[88] = true;
            this.initializeTelemetryClient();
            blArray[89] = true;
            this.queue.setTelemetryInitialized(true);
            blArray[90] = true;
        }
        blArray[91] = true;
        return areValidParameters;
    }

    Intent obtainLocationServiceIntent() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.locationServiceIntent != null) {
            blArray[92] = true;
        } else {
            blArray[93] = true;
            this.locationServiceIntent = new Intent(applicationContext, TelemetryService.class);
            blArray[94] = true;
        }
        blArray[95] = true;
        return this.locationServiceIntent;
    }

    /*
     * WARNING - void declaration
     */
    void injectTelemetryService(TelemetryService telemetryService) {
        void telemetryService2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.telemetryService = telemetryService2;
        blArray[96] = true;
    }

    /*
     * Unable to fully structure code
     */
    private void initializeContext(Context var1_1) {
        block3: {
            block4: {
                block2: {
                    var2_2 = MapboxTelemetry.$jacocoInit();
                    if (MapboxTelemetry.applicationContext == null) break block2;
                    var2_2[97] = true;
                    break block3;
                }
                var2_2[98] = true;
                if (context != null) break block4;
                var2_2[99] = true;
                ** GOTO lbl17
            }
            if (context.getApplicationContext() != null) {
                var2_2[101] = true;
                MapboxTelemetry.applicationContext = context.getApplicationContext();
                var2_2[102] = true;
            } else {
                var2_2[100] = true;
lbl17:
                // 2 sources

                var2_2[103] = true;
                throw new IllegalArgumentException("Non-null application context required.");
            }
        }
        var2_2[104] = true;
    }

    private void initializeQueue() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.queue = new EventsQueue(new FullQueueFlusher(this));
        blArray[105] = true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean areRequiredParametersValid(String var1_1, String var2_2) {
        block2: {
            var3_3 = MapboxTelemetry.$jacocoInit();
            if (this.isAccessTokenValid((String)accessToken)) break block2;
            var3_3[106] = true;
            ** GOTO lbl10
        }
        if (this.isUserAgentValid((String)userAgent)) {
            v0 = var3_3[108] = true;
        } else {
            var3_3[107] = true;
lbl10:
            // 2 sources

            v0 = false;
            var3_3[109] = true;
        }
        var3_3[110] = true;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAccessTokenValid(String string) {
        void accessToken;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!TelemetryUtils.isEmpty((String)accessToken)) {
            this.accessToken = accessToken;
            blArray[111] = true;
            return true;
        }
        blArray[112] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUserAgentValid(String string) {
        void userAgent;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!TelemetryUtils.isEmpty((String)userAgent)) {
            this.userAgent = userAgent;
            blArray[113] = true;
            return true;
        }
        blArray[114] = true;
        return false;
    }

    private void initializeTelemetryClient() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.telemetryClient != null) {
            blArray[115] = true;
        } else {
            blArray[116] = true;
            this.telemetryClient = this.createTelemetryClient(this.accessToken, this.userAgent);
            blArray[117] = true;
        }
        blArray[118] = true;
    }

    /*
     * WARNING - void declaration
     */
    private TelemetryClient createTelemetryClient(String string, String string2) {
        void telemetryClientFactory;
        void fullUserAgent;
        void accessToken;
        void userAgent;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        String string3 = TelemetryUtils.createFullUserAgent((String)userAgent, applicationContext);
        blArray[119] = true;
        TelemetryClientFactory telemetryClientFactory2 = new TelemetryClientFactory((String)accessToken, (String)fullUserAgent, new Logger(), this.certificateBlacklist);
        blArray[120] = true;
        this.telemetryClient = telemetryClientFactory.obtainTelemetryClient(applicationContext);
        blArray[121] = true;
        return this.telemetryClient;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateTelemetryClient(String string) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.telemetryClient != null) {
            void accessToken;
            blArray[122] = true;
            this.telemetryClient.updateAccessToken((String)accessToken);
            blArray[123] = true;
            return true;
        }
        blArray[124] = true;
        return false;
    }

    private AlarmReceiver obtainAlarmReceiver() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[125] = true;
        return new AlarmReceiver(new SchedulerCallback(this){
            final /* synthetic */ MapboxTelemetry this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public void onPeriodRaised() {
                boolean[] blArray = 1.$jacocoInit();
                MapboxTelemetry.access$000(this.this$0);
                blArray[1] = true;
            }

            @Override
            public void onError() {
                boolean[] blArray = 1.$jacocoInit();
                blArray[2] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-3614969346044806713L, (String)"com/mapbox/android/telemetry/MapboxTelemetry$1", (int)3);
                }
                return blArray;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void flushEnqueuedEvents() {
        boolean bl;
        void currentEvents;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        List<Event> list = this.queue.flush();
        blArray[126] = true;
        if (currentEvents.size() > 0) {
            bl = blArray[127] = true;
        } else {
            bl = false;
            blArray[128] = true;
        }
        boolean areThereAnyEvents = bl;
        if (!areThereAnyEvents) {
            blArray[129] = true;
        } else {
            blArray[130] = true;
            this.sendEventsIfPossible((List<Event>)currentEvents);
            blArray[131] = true;
        }
        blArray[132] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void sendEventsIfPossible(List<Event> list) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.isNetworkConnected()) {
            blArray[133] = true;
        } else {
            void events;
            blArray[134] = true;
            this.sendEvents((List<Event>)events);
            blArray[135] = true;
        }
        blArray[136] = true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNetworkConnected() {
        NetworkInfo activeNetwork;
        block4: {
            boolean[] blArray = MapboxTelemetry.$jacocoInit();
            try {
                void connectivityManager;
                blArray[137] = true;
                ConnectivityManager connectivityManager2 = (ConnectivityManager)applicationContext.getSystemService("connectivity");
                blArray[138] = true;
                activeNetwork = connectivityManager.getActiveNetworkInfo();
                if (activeNetwork != null) {
                    blArray[139] = true;
                    break block4;
                }
                blArray[140] = true;
                return false;
            }
            catch (Exception exception) {
                blArray[142] = true;
                return false;
            }
        }
        blArray[141] = true;
        return activeNetwork.isConnected();
    }

    /*
     * WARNING - void declaration
     */
    private void sendEvents(List<Event> list) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.checkRequiredParameters(this.accessToken, this.userAgent)) {
            blArray[143] = true;
        } else {
            void events;
            blArray[144] = true;
            this.telemetryClient.sendEvents((List<Event>)events, this.httpCallback);
            blArray[145] = true;
        }
        blArray[146] = true;
    }

    private ServiceConnection obtainServiceConnection() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[147] = true;
        return new ServiceConnection(this){
            final /* synthetic */ MapboxTelemetry this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                void service;
                boolean[] blArray = 2.$jacocoInit();
                if (service instanceof TelemetryService.TelemetryBinder) {
                    void binder;
                    TelemetryService.TelemetryBinder telemetryBinder = (TelemetryService.TelemetryBinder)service;
                    blArray[1] = true;
                    MapboxTelemetry.access$102(this.this$0, binder.obtainService());
                    blArray[2] = true;
                    MapboxTelemetry.access$100(this.this$0).addServiceTask(this.this$0);
                    blArray[3] = true;
                    if (MapboxTelemetry.access$100(this.this$0).obtainBoundInstances() != 0) {
                        blArray[4] = true;
                    } else {
                        blArray[5] = true;
                        MapboxTelemetry.access$100(this.this$0).injectEventsQueue(MapboxTelemetry.access$200(this.this$0));
                        blArray[6] = true;
                    }
                    MapboxTelemetry.access$100(this.this$0).bindInstance();
                    blArray[7] = true;
                    MapboxTelemetry.access$302(this.this$0, true);
                    blArray[8] = true;
                } else {
                    applicationContext.stopService(this.this$0.obtainLocationServiceIntent());
                    blArray[9] = true;
                }
                blArray[10] = true;
            }

            public void onServiceDisconnected(ComponentName componentName) {
                boolean[] blArray = 2.$jacocoInit();
                MapboxTelemetry.access$102(this.this$0, null);
                blArray[11] = true;
                MapboxTelemetry.access$302(this.this$0, false);
                blArray[12] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)8733816645814413664L, (String)"com/mapbox/android/telemetry/MapboxTelemetry$2", (int)13);
                }
                return blArray;
            }
        };
    }

    private void initializeTelemetryListeners() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.telemetryListeners = new CopyOnWriteArraySet();
        blArray[148] = true;
    }

    private void initializeAttachmentListeners() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.attachmentListeners = new CopyOnWriteArraySet();
        blArray[149] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTelemetryLocationState(Context context) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.isMyServiceRunning(TelemetryService.class)) {
            blArray[150] = true;
        } else {
            void context2;
            blArray[151] = true;
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.DISABLED, (Context)context2);
            blArray[152] = true;
        }
        blArray[153] = true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMyServiceRunning(Class<?> clazz) {
        void manager;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        ActivityManager activityManager = (ActivityManager)applicationContext.getSystemService("activity");
        blArray[154] = true;
        Iterator iterator = manager.getRunningServices(Integer.MAX_VALUE).iterator();
        blArray[155] = true;
        while (iterator.hasNext()) {
            void service;
            void serviceClass;
            ActivityManager.RunningServiceInfo runningServiceInfo = (ActivityManager.RunningServiceInfo)iterator.next();
            blArray[156] = true;
            if (serviceClass.getName().equals(service.service.getClassName())) {
                blArray[157] = true;
                return true;
            }
            blArray[158] = true;
        }
        blArray[159] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean pushToQueue(Event event) {
        void telemetryState;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        blArray[160] = true;
        if (TelemetryEnabler.State.ENABLED.equals(telemetryState)) {
            void event2;
            blArray[161] = true;
            blArray[162] = true;
            return this.queue.push((Event)event2);
        }
        blArray[163] = true;
        return false;
    }

    private void unregisterTelemetry() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.stopAlarm();
        blArray[164] = true;
        if (!this.isMyServiceRunning(TelemetryService.class)) {
            blArray[165] = true;
        } else {
            blArray[166] = true;
            this.unbindTelemetryService();
            blArray[167] = true;
            this.stopTelemetryService();
            blArray[168] = true;
        }
        blArray[169] = true;
    }

    private void stopAlarm() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.schedulerFlusher.unregister();
        blArray[170] = true;
    }

    private void unbindTelemetryService() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.isServiceBound) {
            blArray[171] = true;
        } else if (this.telemetryService == null) {
            blArray[172] = true;
        } else {
            blArray[173] = true;
            this.telemetryService.unbindInstance();
            blArray[174] = true;
            this.unbindServiceConnection();
            blArray[175] = true;
        }
        blArray[176] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void stopTelemetryService() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.telemetryService == null) {
            blArray[177] = true;
            return;
        }
        blArray[178] = true;
        TelemetryLocationEnabler.LocationState locationState = this.telemetryLocationEnabler.obtainTelemetryLocationState(applicationContext);
        blArray[179] = true;
        if (this.telemetryService.obtainBoundInstances() != 0) {
            blArray[180] = true;
        } else {
            void telemetryLocationState;
            blArray[181] = true;
            if (!TelemetryLocationEnabler.LocationState.ENABLED.equals(telemetryLocationState)) {
                blArray[182] = true;
            } else {
                blArray[183] = true;
                this.stopLocation();
                blArray[184] = true;
            }
        }
        blArray[185] = true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean sendEventIfWhitelisted(Event event) {
        void event2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (Event.Type.TURNSTILE.equals((Object)event2.obtainType())) {
            void appUserTurnstile;
            blArray[186] = true;
            ArrayList arrayList = new ArrayList(1);
            blArray[187] = true;
            appUserTurnstile.add(event2);
            blArray[188] = true;
            this.sendEventsIfPossible((List<Event>)appUserTurnstile);
            blArray[189] = true;
            return true;
        }
        if (Event.Type.VIS_ATTACHMENT.equals((Object)event2.obtainType())) {
            blArray[190] = true;
            this.sendAttachment((Event)event2);
            blArray[191] = true;
            return true;
        }
        blArray[192] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean startTelemetry() {
        void telemetryState;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        blArray[193] = true;
        if (TelemetryEnabler.State.ENABLED.equals(telemetryState)) {
            blArray[194] = true;
            this.startAlarm();
            blArray[195] = true;
            this.optLocationIn();
            blArray[196] = true;
            return true;
        }
        blArray[197] = true;
        return false;
    }

    private boolean checkLocationPermission() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (PermissionsManager.areLocationPermissionsGranted((Context)applicationContext)) {
            blArray[198] = true;
            return true;
        }
        this.permissionBackoff();
        blArray[199] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void permissionBackoff() {
        void permissionCheckRunnable;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        PermissionCheckRunnable permissionCheckRunnable2 = this.obtainPermissionCheckRunnable();
        blArray[200] = true;
        permissionCheckRunnable.run();
        blArray[201] = true;
    }

    private PermissionCheckRunnable obtainPermissionCheckRunnable() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.permissionCheckRunnable != null) {
            blArray[202] = true;
        } else {
            blArray[203] = true;
            this.permissionCheckRunnable = new PermissionCheckRunnable(applicationContext, this);
            blArray[204] = true;
        }
        blArray[205] = true;
        return this.permissionCheckRunnable;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    void startLocation(boolean bl) {
        void isLollipopOrHigher;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (isLollipopOrHigher == false) {
            blArray[206] = true;
        } else {
            blArray[207] = true;
            if (ProcessLifecycleOwner.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                blArray[208] = true;
            } else {
                blArray[209] = true;
                ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
                blArray[210] = true;
                return;
            }
        }
        try {
            applicationContext.startService(this.obtainLocationServiceIntent());
        }
        catch (IllegalStateException illegalStateException) {
            void exception;
            blArray[212] = true;
            Log.e((String)START_SERVICE_FAIL, (String)exception.getMessage());
            blArray[213] = true;
        }
        blArray[211] = true;
        blArray[214] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void startAlarm() {
        void clock;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.schedulerFlusher.register();
        blArray[215] = true;
        Clock clock2 = this.obtainClock();
        blArray[216] = true;
        this.schedulerFlusher.schedule(clock.giveMeTheElapsedRealtime());
        blArray[217] = true;
    }

    private Clock obtainClock() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (this.clock != null) {
            blArray[218] = true;
        } else {
            blArray[219] = true;
            this.clock = new Clock();
            blArray[220] = true;
        }
        blArray[221] = true;
        return this.clock;
    }

    /*
     * WARNING - void declaration
     */
    private boolean stopTelemetry() {
        void telemetryState;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        blArray[222] = true;
        if (TelemetryEnabler.State.ENABLED.equals(telemetryState)) {
            blArray[223] = true;
            this.flushEnqueuedEvents();
            blArray[224] = true;
            this.stopAlarm();
            blArray[225] = true;
            this.optLocationOut();
            blArray[226] = true;
            return true;
        }
        blArray[227] = true;
        return false;
    }

    private void stopLocation() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        applicationContext.stopService(this.obtainLocationServiceIntent());
        blArray[228] = true;
    }

    private boolean unbindServiceConnection() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (TelemetryUtils.isServiceRunning(TelemetryService.class, applicationContext)) {
            blArray[229] = true;
            applicationContext.unbindService(this.serviceConnection);
            blArray[230] = true;
            return true;
        }
        blArray[231] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void checkBlacklist(Context context, String string) {
        void accessToken;
        void context2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.certificateBlacklist = new CertificateBlacklist((Context)context2, (String)accessToken);
        blArray[232] = true;
        if (!this.certificateBlacklist.daySinceLastUpdate()) {
            blArray[233] = true;
        } else {
            blArray[234] = true;
            this.certificateBlacklist.updateBlacklist();
            blArray[235] = true;
        }
        blArray[236] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void sendAttachment(Event event) {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (!this.checkNetworkAndParameters().booleanValue()) {
            blArray[237] = true;
        } else {
            void event2;
            blArray[238] = true;
            this.telemetryClient.sendAttachment(this.convertEventToAttachment((Event)event2), this.attachmentListeners);
            blArray[239] = true;
        }
        blArray[240] = true;
    }

    /*
     * WARNING - void declaration
     */
    private Attachment convertEventToAttachment(Event event) {
        void event2;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[241] = true;
        return (Attachment)event2;
    }

    /*
     * Unable to fully structure code
     */
    private Boolean checkNetworkAndParameters() {
        block2: {
            var1_1 = MapboxTelemetry.$jacocoInit();
            if (this.isNetworkConnected()) break block2;
            var1_1[242] = true;
            ** GOTO lbl10
        }
        if (this.checkRequiredParameters(this.accessToken, this.userAgent)) {
            v0 = var1_1[244] = true;
        } else {
            var1_1[243] = true;
lbl10:
            // 2 sources

            v0 = false;
            var1_1[245] = true;
        }
        var1_1[246] = true;
        return v0;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    void onEnterForeground() {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        this.startLocation(this.isLollipopOrHigher());
        blArray[247] = true;
        ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this);
        blArray[248] = true;
    }

    private static Callback getHttpCallback(Set<TelemetryListener> set) {
        Set<TelemetryListener> listeners;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[249] = true;
        return new Callback(listeners){
            final /* synthetic */ Set val$listeners;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 3.$jacocoInit();
                this.val$listeners = set;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onFailure(Call call, IOException iOException) {
                boolean[] blArray = 3.$jacocoInit();
                Iterator iterator = this.val$listeners.iterator();
                blArray[1] = true;
                while (iterator.hasNext()) {
                    void e;
                    void telemetryListener;
                    TelemetryListener telemetryListener2 = (TelemetryListener)iterator.next();
                    blArray[2] = true;
                    telemetryListener.onHttpFailure(e.getMessage());
                    blArray[3] = true;
                }
                blArray[4] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(Call call, Response response) throws IOException {
                void response2;
                boolean[] blArray = 3.$jacocoInit();
                ResponseBody body = response2.body();
                if (body == null) {
                    blArray[5] = true;
                } else {
                    blArray[6] = true;
                    body.close();
                    blArray[7] = true;
                }
                Iterator iterator = this.val$listeners.iterator();
                blArray[8] = true;
                while (iterator.hasNext()) {
                    void telemetryListener;
                    TelemetryListener telemetryListener2 = (TelemetryListener)iterator.next();
                    blArray[9] = true;
                    telemetryListener.onHttpResponse(response2.isSuccessful(), response2.code());
                    blArray[10] = true;
                }
                blArray[11] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)8731670851781336959L, (String)"com/mapbox/android/telemetry/MapboxTelemetry$3", (int)12);
                }
                return blArray;
            }
        };
    }

    private boolean isLollipopOrHigher() {
        boolean bl;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        if (Build.VERSION.SDK_INT >= 21) {
            bl = blArray[250] = true;
        } else {
            bl = false;
            blArray[251] = true;
        }
        blArray[252] = true;
        return bl;
    }

    static /* synthetic */ void access$000(MapboxTelemetry mapboxTelemetry) {
        MapboxTelemetry x0;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        x0.flushEnqueuedEvents();
        blArray[253] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ TelemetryService access$102(MapboxTelemetry mapboxTelemetry, TelemetryService telemetryService) {
        MapboxTelemetry x0;
        void x1;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        x0.telemetryService = x1;
        blArray[254] = true;
        return x0.telemetryService;
    }

    static /* synthetic */ TelemetryService access$100(MapboxTelemetry mapboxTelemetry) {
        MapboxTelemetry x0;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[255] = true;
        return x0.telemetryService;
    }

    static /* synthetic */ EventsQueue access$200(MapboxTelemetry mapboxTelemetry) {
        MapboxTelemetry x0;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        blArray[256] = true;
        return x0.queue;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$302(MapboxTelemetry mapboxTelemetry, boolean bl) {
        MapboxTelemetry x0;
        void x1;
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        x0.isServiceBound = x1;
        blArray[257] = true;
        return x0.isServiceBound;
    }

    static {
        boolean[] blArray = MapboxTelemetry.$jacocoInit();
        applicationContext = null;
        blArray[258] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-9008683299865893098L, (String)"com/mapbox/android/telemetry/MapboxTelemetry", (int)259);
        }
        return blArray;
    }
}

