/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapBuildEvent;
import com.mapbox.android.telemetry.MapClickEvent;
import com.mapbox.android.telemetry.MapDragendEvent;
import com.mapbox.android.telemetry.MapLoadEvent;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.OfflineDownloadEndEvent;
import com.mapbox.android.telemetry.OfflineDownloadStartEvent;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class MapEventFactory {
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    private static final String LANDSCAPE = "Landscape";
    private static final String PORTRAIT = "Portrait";
    private static final String NO_CARRIER = "EMPTY_CARRIER";
    private static final int NO_NETWORK = -1;
    private static final String NOT_A_LOAD_MAP_EVENT_TYPE = "Type must be a load map event.";
    private static final String NOT_A_GESTURE_MAP_EVENT_TYPE = "Type must be a gesture map event.";
    private static final String NOT_OFFLINEDOWNLOAD_EVENT_TYPE = "Type must be an offline download map event.";
    private static final String MAP_STATE_ILLEGAL_NULL = "MapState cannot be null.";
    private static final Map<Integer, String> ORIENTATIONS;
    private final Map<Event.Type, MapBuildEvent> BUILD_EVENT_MAP_GESTURE;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public MapEventFactory() {
        boolean[] blArray = MapEventFactory.$jacocoInit();
        blArray[0] = true;
        this.BUILD_EVENT_MAP_GESTURE = new HashMap<Event.Type, MapBuildEvent>(this){
            final /* synthetic */ MapEventFactory this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
                this.put(Event.Type.MAP_CLICK, new MapBuildEvent(this){
                    final /* synthetic */ 2 this$1;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$1;
                        boolean[] blArray = 1.$jacocoInit();
                        this.this$1 = this$1;
                        blArray[0] = true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Event build(MapState mapState) {
                        void mapState2;
                        boolean[] blArray = 1.$jacocoInit();
                        blArray[1] = true;
                        return MapEventFactory.access$000(this.this$1.this$0, (MapState)mapState2);
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)-2791047313319650771L, (String)"com/mapbox/android/telemetry/MapEventFactory$2$1", (int)2);
                        }
                        return blArray;
                    }
                });
                blArray[1] = true;
                this.put(Event.Type.MAP_DRAGEND, new MapBuildEvent(this){
                    final /* synthetic */ 2 this$1;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$1;
                        boolean[] blArray = 2.$jacocoInit();
                        this.this$1 = this$1;
                        blArray[0] = true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Event build(MapState mapState) {
                        void mapState2;
                        boolean[] blArray = 2.$jacocoInit();
                        blArray[1] = true;
                        return MapEventFactory.access$100(this.this$1.this$0, (MapState)mapState2);
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)251749026459752058L, (String)"com/mapbox/android/telemetry/MapEventFactory$2$2", (int)2);
                        }
                        return blArray;
                    }
                });
                blArray[2] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)8282580209962583839L, (String)"com/mapbox/android/telemetry/MapEventFactory$2", (int)3);
                }
                return blArray;
            }
        };
        if (MapboxTelemetry.applicationContext == null) {
            blArray[1] = true;
            blArray[2] = true;
            throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
        }
        blArray[3] = true;
    }

    /*
     * WARNING - void declaration
     */
    public Event createMapLoadEvent(Event.Type type) {
        void type2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        this.checkLoad((Event.Type)type2);
        blArray[4] = true;
        blArray[5] = true;
        return this.buildMapLoadEvent();
    }

    /*
     * WARNING - void declaration
     */
    public Event createMapGestureEvent(Event.Type type, MapState mapState) {
        void mapState2;
        void type2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        this.checkGesture((Event.Type)type2, (MapState)mapState2);
        blArray[6] = true;
        blArray[7] = true;
        return this.BUILD_EVENT_MAP_GESTURE.get(type2).build((MapState)mapState2);
    }

    /*
     * WARNING - void declaration
     */
    public Event createOfflineDownloadStartEvent(String string, Double d, Double d2, String string2) {
        void styleURL;
        void offlineEvent;
        void maxZoom;
        void minZoom;
        void shapeForOfflineRegion;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        OfflineDownloadStartEvent offlineDownloadStartEvent = new OfflineDownloadStartEvent((String)shapeForOfflineRegion, (Double)minZoom, (Double)maxZoom);
        blArray[8] = true;
        offlineEvent.setStyleURL((String)styleURL);
        blArray[9] = true;
        return offlineEvent;
    }

    /*
     * WARNING - void declaration
     */
    public Event createOfflineDownloadCompleteEvent(String string, Double d, Double d2, String string2, Long l, Long l2, String string3) {
        void numberOfTilesCompleted;
        void sizeOfResourcesCompleted;
        void styleURL;
        void offlineEvent;
        void maxZoom;
        void minZoom;
        void shapeForOfflineRegion;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        OfflineDownloadEndEvent offlineDownloadEndEvent = new OfflineDownloadEndEvent((String)shapeForOfflineRegion, (Double)minZoom, (Double)maxZoom);
        blArray[10] = true;
        offlineEvent.setStyleURL((String)styleURL);
        blArray[11] = true;
        offlineEvent.setSizeOfResourcesCompleted((Long)sizeOfResourcesCompleted);
        blArray[12] = true;
        offlineEvent.setNumberOfTilesCompleted((Long)numberOfTilesCompleted);
        blArray[13] = true;
        return offlineEvent;
    }

    /*
     * WARNING - void declaration
     */
    private MapClickEvent buildMapClickEvent(MapState mapState) {
        void mapClickEvent;
        void mapState2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        MapClickEvent mapClickEvent2 = new MapClickEvent((MapState)mapState2).setDeviceInfo(MapboxTelemetry.applicationContext);
        blArray[14] = true;
        mapClickEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        blArray[15] = true;
        mapClickEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        blArray[16] = true;
        mapClickEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        blArray[17] = true;
        return mapClickEvent;
    }

    /*
     * WARNING - void declaration
     */
    private MapDragendEvent buildMapDragendEvent(MapState mapState) {
        void mapDragendEvent;
        void mapState2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        MapDragendEvent mapDragendEvent2 = new MapDragendEvent((MapState)mapState2).setDeviceInfo(MapboxTelemetry.applicationContext);
        blArray[18] = true;
        mapDragendEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        blArray[19] = true;
        mapDragendEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        blArray[20] = true;
        mapDragendEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        blArray[21] = true;
        return mapDragendEvent;
    }

    /*
     * WARNING - void declaration
     */
    private String obtainOrientation(Context context) {
        void context2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        blArray[22] = true;
        return ORIENTATIONS.get(context2.getResources().getConfiguration().orientation);
    }

    /*
     * WARNING - void declaration
     */
    private float obtainAccessibilityFontScaleSize(Context context) {
        void context2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        blArray[23] = true;
        return context2.getResources().getConfiguration().fontScale;
    }

    /*
     * WARNING - void declaration
     */
    private String obtainCellularCarrier(Context context) {
        void carrierName;
        void manager;
        void context2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        TelephonyManager telephonyManager = (TelephonyManager)context2.getSystemService("phone");
        blArray[24] = true;
        String string = manager.getNetworkOperatorName();
        blArray[25] = true;
        if (TextUtils.isEmpty((CharSequence)carrierName)) {
            blArray[26] = true;
            return NO_CARRIER;
        }
        blArray[27] = true;
        return carrierName;
    }

    /*
     * WARNING - void declaration
     */
    private float obtainDisplayDensity(Context context) {
        void displayMetrics;
        void context2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        DisplayMetrics displayMetrics2 = new DisplayMetrics();
        blArray[28] = true;
        ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)displayMetrics);
        blArray[29] = true;
        return displayMetrics.density;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean obtainConnectedToWifi(Context context) {
        void context2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        blArray[30] = true;
        return this.isConnectedToWifi((Context)context2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isConnectedToWifi(Context context) {
        boolean[] blArray = MapEventFactory.$jacocoInit();
        try {
            void wifiInfo;
            void wifiMgr;
            void context2;
            WifiManager wifiManager = (WifiManager)context2.getApplicationContext().getSystemService("wifi");
            blArray[31] = true;
            WifiInfo wifiInfo2 = wifiMgr.getConnectionInfo();
            blArray[32] = true;
            blArray[33] = true;
            return this.isWifiConnected((WifiManager)wifiMgr, (WifiInfo)wifiInfo);
        }
        catch (Exception exception) {
            blArray[34] = true;
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isWifiConnected(WifiManager var1_1, WifiInfo var2_2) {
        block2: {
            var3_3 = MapEventFactory.$jacocoInit();
            if (wifiMgr.isWifiEnabled()) break block2;
            var3_3[35] = true;
            ** GOTO lbl10
        }
        if (this.networkConnected((WifiInfo)wifiInfo)) {
            v0 = var3_3[37] = true;
        } else {
            var3_3[36] = true;
lbl10:
            // 2 sources

            v0 = false;
            var3_3[38] = true;
        }
        var3_3[39] = true;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean networkConnected(WifiInfo wifiInfo) {
        void wifiInfo2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        if (wifiInfo2.getNetworkId() != -1) {
            blArray[40] = true;
            return true;
        }
        blArray[41] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private MapLoadEvent buildMapLoadEvent() {
        void mapLoadEvent;
        void userId;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        String string = TelemetryUtils.retrieveVendorId();
        blArray[42] = true;
        MapLoadEvent mapLoadEvent2 = new MapLoadEvent((String)userId).setDeviceInfo(MapboxTelemetry.applicationContext);
        blArray[43] = true;
        mapLoadEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        blArray[44] = true;
        mapLoadEvent.setAccessibilityFontScale(this.obtainAccessibilityFontScaleSize(MapboxTelemetry.applicationContext));
        blArray[45] = true;
        mapLoadEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        blArray[46] = true;
        mapLoadEvent.setResolution(this.obtainDisplayDensity(MapboxTelemetry.applicationContext));
        blArray[47] = true;
        mapLoadEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        blArray[48] = true;
        return mapLoadEvent;
    }

    /*
     * WARNING - void declaration
     */
    private void checkLoad(Event.Type type) {
        void type2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        if (type2 != Event.Type.MAP_LOAD) {
            blArray[49] = true;
            blArray[50] = true;
            throw new IllegalArgumentException(NOT_A_LOAD_MAP_EVENT_TYPE);
        }
        blArray[51] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void checkGesture(Event.Type type, MapState mapState) {
        void mapState2;
        void type2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        this.checkGestureMapEvent((Event.Type)type2);
        blArray[52] = true;
        this.isNotNull((MapState)mapState2);
        blArray[53] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void checkGestureMapEvent(Event.Type type) {
        void type2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        if (!Event.mapGestureEventTypes.contains(type2)) {
            blArray[54] = true;
            blArray[55] = true;
            throw new IllegalArgumentException(NOT_A_GESTURE_MAP_EVENT_TYPE);
        }
        blArray[56] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void isNotNull(MapState mapState) {
        void mapState2;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        if (mapState2 == null) {
            blArray[57] = true;
            blArray[58] = true;
            throw new IllegalArgumentException(MAP_STATE_ILLEGAL_NULL);
        }
        blArray[59] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MapClickEvent access$000(MapEventFactory mapEventFactory, MapState mapState) {
        void x1;
        MapEventFactory x0;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        blArray[60] = true;
        return x0.buildMapClickEvent((MapState)x1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MapDragendEvent access$100(MapEventFactory mapEventFactory, MapState mapState) {
        void x1;
        MapEventFactory x0;
        boolean[] blArray = MapEventFactory.$jacocoInit();
        blArray[61] = true;
        return x0.buildMapDragendEvent((MapState)x1);
    }

    static {
        boolean[] blArray = MapEventFactory.$jacocoInit();
        ORIENTATIONS = new HashMap<Integer, String>(){
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 1.$jacocoInit();
                blArray[0] = true;
                this.put(2, MapEventFactory.LANDSCAPE);
                blArray[1] = true;
                this.put(1, MapEventFactory.PORTRAIT);
                blArray[2] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)1902828475402062294L, (String)"com/mapbox/android/telemetry/MapEventFactory$1", (int)3);
                }
                return blArray;
            }
        };
        blArray[62] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-6834843088736628578L, (String)"com/mapbox/android/telemetry/MapEventFactory", (int)63);
        }
        return blArray;
    }
}

