/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mapbox.android.telemetry.ConfigurationChangeHandler;
import com.mapbox.android.telemetry.ConfigurationClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class CertificateBlacklist
implements ConfigurationChangeHandler {
    private static final String LOG_TAG = "MapboxBlacklist";
    private static final String BLACKLIST_FILE = "MapboxBlacklist";
    private final Context context;
    private final List<String> revokedKeys;

    CertificateBlacklist(Context context, ConfigurationClient configurationClient) {
        this.context = context;
        this.revokedKeys = new CopyOnWriteArrayList<String>();
        configurationClient.addHandler(this);
        if (configurationClient.shouldUpdate()) {
            configurationClient.update();
        } else {
            this.retrieveBlackList(context.getFilesDir(), false);
        }
    }

    boolean isBlacklisted(String hash) {
        return this.revokedKeys.contains(hash);
    }

    private void retrieveBlackList(File path, boolean overwrite) {
        if (!path.isDirectory()) {
            return;
        }
        File file = new File(path, "MapboxBlacklist");
        if (file.exists()) {
            try {
                List<String> blacklist = this.obtainBlacklistContents(file);
                if (blacklist.isEmpty()) {
                    return;
                }
                if (overwrite) {
                    this.revokedKeys.clear();
                }
                this.revokedKeys.addAll(blacklist);
            }
            catch (IOException exception) {
                Log.e((String)"MapboxBlacklist", (String)exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveBlackList(String data) {
        if (!CertificateBlacklist.isValidContent(data)) {
            return false;
        }
        boolean success = true;
        FileOutputStream outputStream = null;
        try {
            outputStream = this.context.openFileOutput("MapboxBlacklist", 0);
            outputStream.write(data.getBytes());
        }
        catch (IOException exception) {
            Log.e((String)"MapboxBlacklist", (String)exception.getMessage());
            success = false;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException exception) {
                Log.e((String)"MapboxBlacklist", (String)exception.getMessage());
                success = false;
            }
        }
        return success;
    }

    private static boolean isValidContent(String data) {
        JsonArray jsonArray;
        Gson gson = new GsonBuilder().create();
        try {
            JsonObject responseJson = (JsonObject)gson.fromJson(data, JsonObject.class);
            jsonArray = responseJson.getAsJsonArray("RevokedCertKeys");
        }
        catch (JsonSyntaxException exception) {
            Log.e((String)"MapboxBlacklist", (String)exception.getMessage());
            return false;
        }
        return jsonArray != null && jsonArray.size() > 0;
    }

    private List<String> obtainBlacklistContents(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        Gson gson = new Gson();
        List blacklist = null;
        try {
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject != null) {
                JsonArray jsonArray = jsonObject.getAsJsonArray("RevokedCertKeys");
                Type listType = new TypeToken<List<String>>(){}.getType();
                blacklist = (List)gson.fromJson(jsonArray.toString(), listType);
            }
        }
        catch (JsonIOException | JsonSyntaxException exception) {
            Log.e((String)"MapboxBlacklist", (String)exception.getMessage());
        }
        return blacklist != null ? blacklist : Collections.emptyList();
    }

    @Override
    public void onUpdate(String data) {
        if (this.saveBlackList(data)) {
            this.retrieveBlackList(this.context.getFilesDir(), true);
        }
    }
}

