/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineListener;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.LocationReceiver;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.TelemetryCallback;
import com.mapbox.android.telemetry.TelemetryLocationEnabler;
import com.mapbox.android.telemetry.TelemetryReceiver;
import java.util.concurrent.CopyOnWriteArraySet;

public class TelemetryService
extends Service
implements TelemetryCallback,
LocationEngineListener,
EventCallback {
    public static final String IS_LOCATION_ENABLER_FROM_PREFERENCES = "isLocationEnablerFromPreferences";
    private static final String TAG = "TelemetryService";
    private LocationReceiver locationReceiver = null;
    private TelemetryReceiver telemetryReceiver = null;
    private EventsQueue queue = null;
    private int boundInstances = 0;
    private LocationEngine locationEngine = null;
    private LocationEnginePriority locationPriority = LocationEnginePriority.NO_POWER;
    private CopyOnWriteArraySet<ServiceTaskCallback> serviceTaskCallbacks = null;
    private TelemetryLocationEnabler telemetryLocationEnabler;
    private boolean isLocationEnablerFromPreferences = true;
    private boolean isLocationReceiverRegistered = false;
    private boolean isTelemetryReceiverRegistered = false;

    public void onCreate() {
        super.onCreate();
        Context context = this.getApplicationContext();
        this.createLocationReceiver(context);
        this.createTelemetryReceiver(context);
        this.createServiceTaskCallbacks();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.enableTelemetryLocationState(intent, this.getApplicationContext());
        return 3;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new TelemetryBinder();
    }

    public void onDestroy() {
        Context context = this.getApplicationContext();
        this.unregisterLocationReceiver(context);
        this.unregisterTelemetryReceiver(context);
        this.disableTelemetryLocationState(context);
        super.onDestroy();
    }

    public void onTaskRemoved(Intent rootIntent) {
        for (ServiceTaskCallback callback : this.serviceTaskCallbacks) {
            callback.onTaskRemoved();
        }
        super.onTaskRemoved(rootIntent);
    }

    @Override
    public void onBackground() {
        System.out.println("TelemetryService#onBackground: Shutting down location receiver...");
        this.unregisterLocationReceiver(this.getApplicationContext());
    }

    @Override
    public void onForeground() {
        System.out.println("TelemetryService#onForeground: Restarting location receiver...");
        this.registerLocationReceiver(this.getApplicationContext());
    }

    public void onConnected() {
        this.locationEngine.requestLocationUpdates();
    }

    public void onLocationChanged(Location location) {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(LocationReceiver.supplyIntent(location));
    }

    @Override
    public void onEventReceived(Event event) {
        if (this.queue != null) {
            this.queue.push(event);
        }
    }

    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.locationReceiver.updateSessionIdentifier(sessionIdentifier);
    }

    public void updateLocationPriority(LocationEnginePriority priority) {
        this.locationPriority = priority;
        if (this.locationEngine != null) {
            this.disconnectLocationEngine();
            this.setupLocationEngine();
            this.activateLocationEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindInstance() {
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            ++this.boundInstances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindInstance() {
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            --this.boundInstances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int obtainBoundInstances() {
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            return this.boundInstances;
        }
    }

    boolean addServiceTask(ServiceTaskCallback callback) {
        return this.serviceTaskCallbacks.add(callback);
    }

    boolean removeServiceTask(ServiceTaskCallback callback) {
        return this.serviceTaskCallbacks.remove(callback);
    }

    void injectEventsQueue(EventsQueue queue) {
        this.queue = queue;
    }

    @VisibleForTesting
    boolean isLocationReceiverRegistered() {
        return this.isLocationReceiverRegistered;
    }

    @VisibleForTesting
    boolean isTelemetryReceiverRegistered() {
        return this.isTelemetryReceiverRegistered;
    }

    @VisibleForTesting
    boolean locationPermissionCheck() {
        return ContextCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private void createLocationReceiver(Context context) {
        this.locationReceiver = new LocationReceiver(this);
        this.registerLocationReceiver(context);
    }

    private void registerLocationReceiver(Context context) {
        this.connectLocationEngine();
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this.locationReceiver, new IntentFilter("com.mapbox.location_receiver"));
        this.isLocationReceiverRegistered = true;
    }

    private void connectLocationEngine() {
        this.obtainLocationEngine();
        this.setupLocationEngine();
        if (this.locationPermissionCheck()) {
            this.activateLocationEngine();
        }
    }

    private void obtainLocationEngine() {
        this.locationEngine = new LocationEngineProvider((Context)this).obtainBestLocationEngineAvailable();
    }

    private void setupLocationEngine() {
        this.locationEngine.setPriority(this.locationPriority);
        this.locationEngine.addLocationEngineListener((LocationEngineListener)this);
    }

    private void activateLocationEngine() {
        this.locationEngine.activate();
    }

    private void createTelemetryReceiver(Context context) {
        this.telemetryReceiver = new TelemetryReceiver(this);
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this.telemetryReceiver, new IntentFilter("com.mapbox.telemetry_receiver"));
        this.isTelemetryReceiverRegistered = true;
    }

    private void createServiceTaskCallbacks() {
        this.serviceTaskCallbacks = new CopyOnWriteArraySet();
    }

    private void enableTelemetryLocationState(Intent intent, Context context) {
        this.isLocationEnablerFromPreferences = intent != null ? intent.getBooleanExtra(IS_LOCATION_ENABLER_FROM_PREFERENCES, true) : true;
        if (this.isLocationEnablerFromPreferences) {
            this.createLocationEnabler();
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.ENABLED, context);
        }
    }

    private void disconnectLocationEngine() {
        this.removeLocationUpdates();
        this.deactivateLocationEngine();
    }

    private void removeLocationUpdates() {
        this.locationEngine.removeLocationUpdates();
        this.locationEngine.removeLocationEngineListener((LocationEngineListener)this);
    }

    private void deactivateLocationEngine() {
        this.locationEngine.deactivate();
    }

    private void unregisterLocationReceiver(Context context) {
        this.disconnectLocationEngine();
        LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)this.locationReceiver);
        this.isLocationReceiverRegistered = false;
    }

    private void unregisterTelemetryReceiver(Context context) {
        LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)this.telemetryReceiver);
        this.isTelemetryReceiverRegistered = false;
    }

    private void disableTelemetryLocationState(Context context) {
        if (this.isLocationEnablerFromPreferences) {
            this.createLocationEnabler();
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.DISABLED, context);
        }
    }

    private void createLocationEnabler() {
        if (this.telemetryLocationEnabler == null) {
            this.telemetryLocationEnabler = new TelemetryLocationEnabler(true);
        }
    }

    class TelemetryBinder
    extends Binder {
        TelemetryBinder() {
        }

        TelemetryService obtainService() {
            return TelemetryService.this;
        }
    }
}

