/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;

public class OfflineDownloadStartEvent
extends Event
implements Parcelable {
    private static final String OFFLINE_DOWNLOAD_START = "map.offlineDownload.start";
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="minZoom")
    private final Double minZoom;
    @SerializedName(value="maxZoom")
    private final Double maxZoom;
    @SerializedName(value="shapeForOfflineRegion")
    private final String shapeForOfflineRegion;
    @SerializedName(value="styleURL")
    private String styleURL;
    public static final Parcelable.Creator<OfflineDownloadStartEvent> CREATOR = new Parcelable.Creator<OfflineDownloadStartEvent>(){

        public OfflineDownloadStartEvent createFromParcel(Parcel in) {
            return new OfflineDownloadStartEvent(in);
        }

        public OfflineDownloadStartEvent[] newArray(int size) {
            return new OfflineDownloadStartEvent[size];
        }
    };

    public void setStyleURL(String styleURL) {
        this.styleURL = styleURL;
    }

    OfflineDownloadStartEvent(String shapeForOfflineRegion, Double minZoom, Double maxZoom) {
        this.event = OFFLINE_DOWNLOAD_START;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.shapeForOfflineRegion = shapeForOfflineRegion;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    private OfflineDownloadStartEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.shapeForOfflineRegion = in.readString();
        this.minZoom = in.readDouble();
        this.maxZoom = in.readDouble();
        this.styleURL = in.readString();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.OFFLINE_DOWNLOAD_START;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeString(this.shapeForOfflineRegion);
        dest.writeDouble(this.minZoom.doubleValue());
        dest.writeDouble(this.maxZoom.doubleValue());
        dest.writeString(this.styleURL);
    }
}

