/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.ContentResolver;
import android.media.AudioManager;
import android.provider.Settings;
import com.mapbox.android.telemetry.AudioTypeChain;
import com.mapbox.android.telemetry.AudioTypeResolver;
import com.mapbox.android.telemetry.MapboxTelemetry;

class NavigationUtils {
    private static final double PERCENT_NORMALIZER = 100.0;
    private static final double SCREEN_BRIGHTNESS_MAX = 255.0;
    private static final int BRIGHTNESS_EXCEPTION_VALUE = -1;

    NavigationUtils() {
    }

    static int obtainVolumeLevel() {
        AudioManager audioManager = (AudioManager)MapboxTelemetry.applicationContext.getSystemService("audio");
        return (int)Math.floor(100.0 * (double)audioManager.getStreamVolume(3) / (double)audioManager.getStreamMaxVolume(3));
    }

    static int obtainScreenBrightness() {
        int screenBrightness;
        try {
            screenBrightness = Settings.System.getInt((ContentResolver)MapboxTelemetry.applicationContext.getContentResolver(), (String)"screen_brightness");
            screenBrightness = NavigationUtils.calculateScreenBrightnessPercentage(screenBrightness);
        }
        catch (Settings.SettingNotFoundException exception) {
            screenBrightness = -1;
        }
        return screenBrightness;
    }

    static String obtainAudioType() {
        AudioTypeChain audioTypeChain = new AudioTypeChain();
        AudioTypeResolver setupChain = audioTypeChain.setup();
        return setupChain.obtainAudioType(MapboxTelemetry.applicationContext);
    }

    private static int calculateScreenBrightnessPercentage(int screenBrightness) {
        return (int)Math.floor(100.0 * (double)screenBrightness / 255.0);
    }
}

