/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.os.Handler;
import com.mapbox.android.core.permissions.PermissionsManager;
import com.mapbox.android.telemetry.ExponentialBackoff;
import com.mapbox.android.telemetry.MapboxTelemetry;

class PermissionCheckRunnable
implements Runnable {
    private final Context context;
    private final Handler handler = new Handler();
    private final ExponentialBackoff counter = new ExponentialBackoff();
    private MapboxTelemetry mapboxTelemetry;

    PermissionCheckRunnable(Context context, MapboxTelemetry mapboxTelemetry) {
        this.context = context;
        this.mapboxTelemetry = mapboxTelemetry;
    }

    @Override
    public void run() {
        if (PermissionsManager.areLocationPermissionsGranted((Context)this.context)) {
            this.mapboxTelemetry.optLocationIn();
        } else {
            long nextWaitTime = this.counter.nextBackOffMillis();
            this.handler.postDelayed((Runnable)this, nextWaitTime);
        }
    }
}

