/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.telemetry.ChinaCertificatePins;
import com.mapbox.android.telemetry.ComCertificatePins;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.StagingCertificatePins;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.CertificatePinner;

class CertificatePinnerFactory {
    private static final Map<Environment, Map<String, List<String>>> CERTIFICATES_PINS = new HashMap<Environment, Map<String, List<String>>>(){
        {
            this.put(Environment.STAGING, StagingCertificatePins.CERTIFICATE_PINS);
            this.put(Environment.COM, ComCertificatePins.CERTIFICATE_PINS);
            this.put(Environment.CHINA, ChinaCertificatePins.CERTIFICATE_PINS);
        }
    };

    CertificatePinnerFactory() {
    }

    CertificatePinner provideCertificatePinnerFor(Environment environment) {
        CertificatePinner.Builder certificatePinnerBuilder = new CertificatePinner.Builder();
        Map<String, List<String>> certificatesPins = this.provideCertificatesPinsFor(environment);
        this.addCertificatesPins(certificatesPins, certificatePinnerBuilder);
        return certificatePinnerBuilder.build();
    }

    Map<String, List<String>> provideCertificatesPinsFor(Environment environment) {
        return CERTIFICATES_PINS.get((Object)environment);
    }

    private void addCertificatesPins(Map<String, List<String>> pins, CertificatePinner.Builder builder) {
        for (Map.Entry<String, List<String>> entry : pins.entrySet()) {
            for (String pin : entry.getValue()) {
                builder.add(entry.getKey(), new String[]{pin});
            }
        }
    }
}

