/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.IBinder;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.permissions.PermissionsManager;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.Clock;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.FullQueueCallback;
import com.mapbox.android.telemetry.FullQueueFlusher;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.PermissionCheckRunnable;
import com.mapbox.android.telemetry.SchedulerCallback;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientFactory;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryListener;
import com.mapbox.android.telemetry.TelemetryLocationEnabler;
import com.mapbox.android.telemetry.TelemetryService;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class MapboxTelemetry
implements FullQueueCallback,
EventCallback,
ServiceTaskCallback,
Callback {
    private static final String EVENTS_USER_AGENT = "MapboxEventsAndroid/";
    private static final String TELEMETRY_USER_AGENT = "MapboxTelemetryAndroid/";
    private static final String UNITY_USER_AGENT = "MapboxEventsUnityAndroid/";
    private static final String NAVIGATION_USER_AGENT = "mapbox-navigation-android/";
    private static final String NAVIGATION_UI_USER_AGENT = "mapbox-navigation-ui-android/";
    private static final List<String> VALID_USER_AGENTS = new ArrayList<String>(){
        {
            this.add(MapboxTelemetry.EVENTS_USER_AGENT);
            this.add(MapboxTelemetry.TELEMETRY_USER_AGENT);
            this.add(MapboxTelemetry.UNITY_USER_AGENT);
            this.add(MapboxTelemetry.NAVIGATION_USER_AGENT);
            this.add(MapboxTelemetry.NAVIGATION_UI_USER_AGENT);
        }
    };
    private static final String NON_NULL_APPLICATION_CONTEXT_REQUIRED = "Non-null application context required.";
    private static final int NO_FLAGS = 0;
    private String accessToken;
    private String userAgent;
    private EventsQueue queue;
    private TelemetryClient telemetryClient;
    private TelemetryService telemetryService;
    private Callback httpCallback;
    private final SchedulerFlusher schedulerFlusher;
    private Clock clock = null;
    private ServiceConnection serviceConnection = null;
    private Intent locationServiceIntent = null;
    private final TelemetryEnabler telemetryEnabler;
    private final TelemetryLocationEnabler telemetryLocationEnabler;
    private boolean isLocationOpted = false;
    private boolean isServiceBound = false;
    private PermissionCheckRunnable permissionCheckRunnable = null;
    private CopyOnWriteArraySet<TelemetryListener> telemetryListeners = null;
    static Context applicationContext = null;

    public MapboxTelemetry(Context context, String accessToken, String userAgent) {
        this.initializeContext(context);
        this.initializeQueue();
        this.checkRequiredParameters(accessToken, userAgent);
        this.httpCallback = this;
        AlarmReceiver alarmReceiver = this.obtainAlarmReceiver();
        this.schedulerFlusher = new SchedulerFlusherFactory(applicationContext, alarmReceiver).supply();
        this.serviceConnection = this.obtainServiceConnection();
        this.telemetryEnabler = new TelemetryEnabler(true);
        this.telemetryLocationEnabler = new TelemetryLocationEnabler(true);
        this.initializeTelemetryListeners();
        this.initializeTelemetryLocationState();
    }

    MapboxTelemetry(Context context, String accessToken, String userAgent, EventsQueue queue, TelemetryClient telemetryClient, Callback httpCallback, SchedulerFlusher schedulerFlusher, Clock clock, boolean isServiceBound, TelemetryEnabler telemetryEnabler, TelemetryLocationEnabler telemetryLocationEnabler) {
        this.initializeContext(context);
        this.queue = queue;
        this.checkRequiredParameters(accessToken, userAgent);
        this.telemetryClient = telemetryClient;
        this.httpCallback = httpCallback;
        this.schedulerFlusher = schedulerFlusher;
        this.clock = clock;
        this.telemetryEnabler = telemetryEnabler;
        this.telemetryLocationEnabler = telemetryLocationEnabler;
        this.isServiceBound = isServiceBound;
        this.initializeTelemetryListeners();
    }

    @Override
    public void onFullQueue(List<Event> fullQueue) {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.sendEventsIfPossible(fullQueue);
        }
    }

    @Override
    public void onEventReceived(Event event) {
        this.pushToQueue(event);
    }

    @Override
    public void onTaskRemoved() {
        this.flushEnqueuedEvents();
        this.unregisterTelemetry();
    }

    public void onFailure(Call call, IOException exception) {
        for (TelemetryListener telemetryListener : this.telemetryListeners) {
            telemetryListener.onHttpFailure(exception.getMessage());
        }
    }

    public void onResponse(Call call, Response response) {
        for (TelemetryListener telemetryListener : this.telemetryListeners) {
            telemetryListener.onHttpResponse(response.isSuccessful(), response.code());
        }
    }

    public boolean push(Event event) {
        if (this.sendEventIfWhitelisted(event)) {
            return true;
        }
        boolean isPushed = this.pushToQueue(event);
        return isPushed;
    }

    public boolean enable() {
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            TelemetryEnabler.updateTelemetryState(TelemetryEnabler.State.ENABLED);
            this.startTelemetry();
            return true;
        }
        return false;
    }

    public boolean disable() {
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            this.stopTelemetry();
            TelemetryEnabler.updateTelemetryState(TelemetryEnabler.State.DISABLED);
            return true;
        }
        return false;
    }

    public boolean updateSessionIdRotationInterval(SessionInterval interval) {
        if (this.isServiceBound) {
            int hour = interval.obtainInterval();
            SessionIdentifier sessionIdentifier = new SessionIdentifier(hour);
            this.telemetryService.updateSessionIdentifier(sessionIdentifier);
            return true;
        }
        return false;
    }

    public void updateDebugLoggingEnabled(boolean isDebugLoggingEnabled) {
        if (this.telemetryClient != null) {
            this.telemetryClient.updateDebugLoggingEnabled(isDebugLoggingEnabled);
        }
    }

    public void updateUserAgent(String userAgent) {
        if (this.isUserAgentValid(userAgent)) {
            this.telemetryClient.updateUserAgent(TelemetryUtils.createFullUserAgent(userAgent, applicationContext));
        }
    }

    public void updateLocationPriority(LocationEnginePriority locationPriority) {
        if (this.isServiceBound) {
            this.telemetryService.updateLocationPriority(locationPriority);
        }
    }

    public boolean updateAccessToken(String accessToken) {
        if (this.isAccessTokenValid(accessToken) && this.updateTelemetryClient(accessToken)) {
            this.accessToken = accessToken;
            return true;
        }
        return false;
    }

    public boolean addTelemetryListener(TelemetryListener listener) {
        return this.telemetryListeners.add(listener);
    }

    public boolean removeTelemetryListener(TelemetryListener listener) {
        return this.telemetryListeners.remove(listener);
    }

    boolean optLocationIn() {
        this.startTelemetryService();
        this.bindTelemetryService();
        return this.isLocationOpted;
    }

    boolean optLocationOut() {
        TelemetryLocationEnabler.LocationState telemetryLocationState = this.telemetryLocationEnabler.obtainTelemetryLocationState();
        if (this.isServiceBound) {
            this.telemetryService.unbindInstance();
            this.telemetryService.removeServiceTask(this);
            if (this.telemetryService.obtainBoundInstances() == 0 && TelemetryLocationEnabler.LocationState.ENABLED.equals((Object)telemetryLocationState)) {
                applicationContext.unbindService(this.serviceConnection);
                this.isServiceBound = false;
                this.stopLocation();
                this.isLocationOpted = false;
            } else {
                applicationContext.unbindService(this.serviceConnection);
                this.isServiceBound = false;
            }
        }
        return this.isLocationOpted;
    }

    private void startTelemetryService() {
        TelemetryLocationEnabler.LocationState telemetryLocationState = this.telemetryLocationEnabler.obtainTelemetryLocationState();
        if (TelemetryLocationEnabler.LocationState.DISABLED.equals((Object)telemetryLocationState) && this.checkLocationPermission()) {
            this.startLocation();
            this.isLocationOpted = true;
        }
    }

    private void bindTelemetryService() {
        applicationContext.bindService(this.obtainLocationServiceIntent(), this.serviceConnection, 0);
    }

    boolean checkRequiredParameters(String accessToken, String userAgent) {
        boolean areValidParameters = this.areRequiredParametersValid(accessToken, userAgent);
        if (areValidParameters) {
            this.initializeTelemetryClient();
            this.queue.setTelemetryInitialized(true);
        }
        return areValidParameters;
    }

    Intent obtainLocationServiceIntent() {
        if (this.locationServiceIntent == null) {
            this.locationServiceIntent = new Intent(applicationContext, TelemetryService.class);
        }
        return this.locationServiceIntent;
    }

    void injectTelemetryService(TelemetryService telemetryService) {
        this.telemetryService = telemetryService;
    }

    private void initializeContext(Context context) {
        if (applicationContext == null) {
            if (context != null && context.getApplicationContext() != null) {
                applicationContext = context.getApplicationContext();
            } else {
                throw new IllegalArgumentException(NON_NULL_APPLICATION_CONTEXT_REQUIRED);
            }
        }
    }

    private void initializeQueue() {
        this.queue = new EventsQueue(new FullQueueFlusher(this));
    }

    private boolean areRequiredParametersValid(String accessToken, String userAgent) {
        return this.isAccessTokenValid(accessToken) && this.isUserAgentValid(userAgent);
    }

    private boolean isAccessTokenValid(String accessToken) {
        if (!TelemetryUtils.isEmpty(accessToken)) {
            this.accessToken = accessToken;
            return true;
        }
        return false;
    }

    private boolean isUserAgentValid(String userAgent) {
        if (!TelemetryUtils.isEmpty(userAgent)) {
            for (String userAgentPrefix : VALID_USER_AGENTS) {
                if (!userAgent.startsWith(userAgentPrefix)) continue;
                this.userAgent = userAgent;
                return true;
            }
        }
        return false;
    }

    private void initializeTelemetryClient() {
        if (this.telemetryClient == null) {
            this.telemetryClient = this.createTelemetryClient(this.accessToken, this.userAgent);
        }
    }

    private TelemetryClient createTelemetryClient(String accessToken, String userAgent) {
        String fullUserAgent = TelemetryUtils.createFullUserAgent(userAgent, applicationContext);
        TelemetryClientFactory telemetryClientFactory = new TelemetryClientFactory(accessToken, fullUserAgent, new Logger());
        this.telemetryClient = telemetryClientFactory.obtainTelemetryClient(applicationContext);
        return this.telemetryClient;
    }

    private boolean updateTelemetryClient(String accessToken) {
        if (this.telemetryClient != null) {
            this.telemetryClient.updateAccessToken(accessToken);
            return true;
        }
        return false;
    }

    private AlarmReceiver obtainAlarmReceiver() {
        return new AlarmReceiver(new SchedulerCallback(){

            @Override
            public void onPeriodRaised() {
                MapboxTelemetry.this.flushEnqueuedEvents();
            }

            @Override
            public void onError() {
            }
        });
    }

    private void flushEnqueuedEvents() {
        boolean areThereAnyEvents;
        List<Event> currentEvents = this.queue.flush();
        boolean bl = areThereAnyEvents = currentEvents.size() > 0;
        if (areThereAnyEvents) {
            this.sendEventsIfPossible(currentEvents);
        }
    }

    private void sendEventsIfPossible(List<Event> events) {
        if (this.isNetworkConnected()) {
            this.sendEvents(events);
        }
    }

    private boolean isNetworkConnected() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            return activeNetwork.isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void sendEvents(List<Event> events) {
        if (this.checkRequiredParameters(this.accessToken, this.userAgent)) {
            this.telemetryClient.sendEvents(events, this.httpCallback);
        }
    }

    private ServiceConnection obtainServiceConnection() {
        return new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder service) {
                TelemetryService.TelemetryBinder binder = (TelemetryService.TelemetryBinder)service;
                MapboxTelemetry.this.telemetryService = binder.obtainService();
                MapboxTelemetry.this.telemetryService.addServiceTask(MapboxTelemetry.this);
                if (MapboxTelemetry.this.telemetryService.obtainBoundInstances() == 0) {
                    MapboxTelemetry.this.telemetryService.injectEventsQueue(MapboxTelemetry.this.queue);
                }
                MapboxTelemetry.this.telemetryService.bindInstance();
                MapboxTelemetry.this.isServiceBound = true;
            }

            public void onServiceDisconnected(ComponentName className) {
                MapboxTelemetry.this.telemetryService = null;
                MapboxTelemetry.this.isServiceBound = false;
            }
        };
    }

    private void initializeTelemetryListeners() {
        this.telemetryListeners = new CopyOnWriteArraySet();
    }

    private void initializeTelemetryLocationState() {
        if (!this.isMyServiceRunning(TelemetryService.class)) {
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.DISABLED);
        }
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)applicationContext.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private boolean pushToQueue(Event event) {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            return this.queue.push(event);
        }
        return false;
    }

    private void unregisterTelemetry() {
        this.stopAlarm();
        this.unbindTelemetryService();
        this.stopTelemetryService();
    }

    private void stopAlarm() {
        this.schedulerFlusher.unregister();
    }

    private void unbindTelemetryService() {
        if (this.isServiceBound) {
            this.telemetryService.unbindInstance();
            applicationContext.unbindService(this.serviceConnection);
        }
    }

    private void stopTelemetryService() {
        TelemetryLocationEnabler.LocationState telemetryLocationState = this.telemetryLocationEnabler.obtainTelemetryLocationState();
        if (this.telemetryService.obtainBoundInstances() == 0 && TelemetryLocationEnabler.LocationState.ENABLED.equals((Object)telemetryLocationState)) {
            this.stopLocation();
        }
    }

    private boolean sendEventIfWhitelisted(Event event) {
        if (Event.Type.TURNSTILE.equals((Object)event.obtainType())) {
            ArrayList<Event> appUserTurnstile = new ArrayList<Event>(1);
            appUserTurnstile.add(event);
            this.sendEventsIfPossible(appUserTurnstile);
            return true;
        }
        return false;
    }

    private boolean startTelemetry() {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.startAlarm();
            this.optLocationIn();
            return true;
        }
        return false;
    }

    private boolean checkLocationPermission() {
        if (PermissionsManager.areLocationPermissionsGranted((Context)applicationContext)) {
            return true;
        }
        this.permissionBackoff();
        return false;
    }

    private void permissionBackoff() {
        PermissionCheckRunnable permissionCheckRunnable = this.obtainPermissionCheckRunnable();
        permissionCheckRunnable.run();
    }

    private PermissionCheckRunnable obtainPermissionCheckRunnable() {
        if (this.permissionCheckRunnable == null) {
            this.permissionCheckRunnable = new PermissionCheckRunnable(applicationContext, this);
        }
        return this.permissionCheckRunnable;
    }

    private void startLocation() {
        applicationContext.startService(this.obtainLocationServiceIntent());
    }

    private void startAlarm() {
        this.schedulerFlusher.register();
        Clock clock = this.obtainClock();
        this.schedulerFlusher.schedule(clock.giveMeTheElapsedRealtime());
    }

    private Clock obtainClock() {
        if (this.clock == null) {
            this.clock = new Clock();
        }
        return this.clock;
    }

    private boolean stopTelemetry() {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.flushEnqueuedEvents();
            this.stopAlarm();
            this.optLocationOut();
            return true;
        }
        return false;
    }

    private void stopLocation() {
        applicationContext.stopService(this.obtainLocationServiceIntent());
    }
}

