/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.location.Location;
import com.mapbox.android.telemetry.LocationEvent;
import com.mapbox.android.telemetry.SessionIdentifier;
import java.math.BigDecimal;

class LocationMapper {
    private static final int SEVEN_DIGITS_AFTER_DECIMAL = 7;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MAX_LONGITUDE = 180.0;
    private SessionIdentifier sessionIdentifier = new SessionIdentifier();

    LocationMapper() {
    }

    LocationEvent from(Location location) {
        LocationEvent locationEvent = this.createLocationEvent(location);
        return locationEvent;
    }

    void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    private LocationEvent createLocationEvent(Location location) {
        String sessionId = this.sessionIdentifier.getSessionId();
        double latitudeScaled = this.round(location.getLatitude());
        double longitudeScaled = this.round(location.getLongitude());
        double longitudeWrapped = this.wrapLongitude(longitudeScaled);
        LocationEvent locationEvent = new LocationEvent(sessionId, latitudeScaled, longitudeWrapped);
        this.addAltitudeIfPresent(location, locationEvent);
        this.addAccuracyIfPresent(location, locationEvent);
        return locationEvent;
    }

    private double round(double value) {
        return new BigDecimal(value).setScale(7, 1).doubleValue();
    }

    private double wrapLongitude(double longitude) {
        double wrapped = longitude;
        if (longitude < -180.0 || longitude > 180.0) {
            wrapped = this.wrap(longitude, -180.0, 180.0);
        }
        return wrapped;
    }

    private double wrap(double value, double min, double max) {
        double delta = max - min;
        double firstMod = (value - min) % delta;
        double secondMod = (firstMod + delta) % delta;
        return secondMod + min;
    }

    private void addAltitudeIfPresent(Location location, LocationEvent locationEvent) {
        if (location.hasAltitude()) {
            double altitudeRounded = Math.round(location.getAltitude());
            locationEvent.setAltitude(altitudeRounded);
        }
    }

    private void addAccuracyIfPresent(Location location, LocationEvent locationEvent) {
        if (location.hasAccuracy()) {
            float accuracyRounded = Math.round(location.getAccuracy());
            locationEvent.setAccuracy(Float.valueOf(accuracyRounded));
        }
    }
}

