/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ConcurrentQueue<T> {
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private int count = 0;

    ConcurrentQueue() {
    }

    boolean add(T event) {
        boolean isAdded = this.queue.add(event);
        ++this.count;
        return isAdded;
    }

    List<T> flush() {
        ArrayList<T> queuedEvents = new ArrayList<T>(this.count);
        for (int i = 0; i < this.count; ++i) {
            T event = this.queue.remove();
            queuedEvents.add(event);
        }
        this.count = 0;
        return queuedEvents;
    }

    boolean enqueue(T event) {
        this.queue.remove();
        return this.queue.add(event);
    }

    int size() {
        return this.count;
    }

    Queue<T> obtainQueue() {
        return this.queue;
    }
}

