/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.SchedulerFlusher;

class AlarmSchedulerFlusher
implements SchedulerFlusher {
    private final Context context;
    private final AlarmManager manager;
    private final AlarmReceiver receiver;
    private final int requestCode;
    private PendingIntent pendingIntent;

    AlarmSchedulerFlusher(Context context, AlarmManager manager, AlarmReceiver receiver, int requestCode) {
        this.context = context;
        this.manager = manager;
        this.receiver = receiver;
        this.requestCode = requestCode;
    }

    @Override
    public void register() {
        Intent alarmIntent = this.receiver.supplyIntent(this.requestCode);
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)this.requestCode, (Intent)alarmIntent, (int)0x10000000);
        String action = "com.mapbox.scheduler_flusher" + Integer.toString(this.requestCode);
        IntentFilter filter = new IntentFilter(action);
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    @Override
    public void schedule(long elapsedRealTime) {
        long firstFlushingInMillis = elapsedRealTime + 180000L;
        this.manager.setInexactRepeating(3, firstFlushingInMillis, 180000L, this.pendingIntent);
    }

    @Override
    public void unregister() {
        this.manager.cancel(this.pendingIntent);
        this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    PendingIntent obtainPendingIntent() {
        return this.pendingIntent;
    }
}

