/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.SharedPreferences;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

public class TelemetryEnabler {
    static final String MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE = "mapboxTelemetryState";
    static final Map<State, Boolean> TELEMETRY_STATES = new HashMap<State, Boolean>(){
        {
            this.put(State.NOT_INITIALIZED, false);
            this.put(State.ENABLED, true);
            this.put(State.DISABLED, false);
        }
    };
    private static final Map<String, State> STATES = new HashMap<String, State>(){
        {
            this.put(State.NOT_INITIALIZED.name(), State.NOT_INITIALIZED);
            this.put(State.ENABLED.name(), State.ENABLED);
            this.put(State.DISABLED.name(), State.DISABLED);
        }
    };
    private boolean isFromPreferences = true;
    private State currentTelemetryState = State.NOT_INITIALIZED;

    TelemetryEnabler(boolean isFromPreferences) {
        this.isFromPreferences = isFromPreferences;
    }

    public static State retrieveTelemetryStateFromPreferences() {
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences();
        String telemetryStateName = sharedPreferences.getString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, State.NOT_INITIALIZED.name());
        return STATES.get(telemetryStateName);
    }

    State obtainTelemetryState() {
        if (this.isFromPreferences) {
            return TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        }
        return this.currentTelemetryState;
    }

    State updateTelemetryState(State telemetryState) {
        if (this.isFromPreferences) {
            return this.updatePreferences(telemetryState);
        }
        this.currentTelemetryState = telemetryState;
        return this.currentTelemetryState;
    }

    void injectTelemetryState(State state) {
        this.currentTelemetryState = state;
    }

    private State updatePreferences(State telemetryState) {
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, telemetryState.name());
        editor.apply();
        return telemetryState;
    }

    public static enum State {
        NOT_INITIALIZED,
        ENABLED,
        DISABLED;

    }
}

