/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.permissions.PermissionsManager;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.Clock;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventReceiver;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.FullQueueCallback;
import com.mapbox.android.telemetry.FullQueueFlusher;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.PermissionCheckRunnable;
import com.mapbox.android.telemetry.SchedulerCallback;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientFactory;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryListener;
import com.mapbox.android.telemetry.TelemetryService;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class MapboxTelemetry
implements FullQueueCallback,
EventCallback,
ServiceTaskCallback,
Callback {
    private static final String EVENTS_USER_AGENT = "MapboxEventsAndroid/";
    private static final String TELEMETRY_USER_AGENT = "MapboxTelemetryAndroid/";
    private static final String UNITY_USER_AGENT = "MapboxEventsUnityAndroid/";
    private static final String NAVIGATION_USER_AGENT = "mapbox-navigation-android/";
    private static final String NAVIGATION_UI_USER_AGENT = "mapbox-navigation-ui-android/";
    private static final List<String> VALID_USER_AGENTS = new ArrayList<String>(){
        {
            this.add(MapboxTelemetry.EVENTS_USER_AGENT);
            this.add(MapboxTelemetry.TELEMETRY_USER_AGENT);
            this.add(MapboxTelemetry.UNITY_USER_AGENT);
            this.add(MapboxTelemetry.NAVIGATION_USER_AGENT);
            this.add(MapboxTelemetry.NAVIGATION_UI_USER_AGENT);
        }
    };
    private static final String NON_NULL_APPLICATION_CONTEXT_REQUIRED = "Non-null application context required.";
    private String accessToken;
    private String userAgent;
    private EventsQueue queue;
    private TelemetryClient telemetryClient;
    private TelemetryService telemetryService;
    private Callback httpCallback;
    private final SchedulerFlusher schedulerFlusher;
    private Clock clock = null;
    private LocalBroadcastManager localBroadcastManager = null;
    private ServiceConnection serviceConnection = null;
    private Intent locationServiceIntent = null;
    private EventReceiver eventReceiver = null;
    private IntentFilter eventReceiverIntentFilter = null;
    private final TelemetryEnabler telemetryEnabler;
    private boolean isOpted = false;
    private boolean isServiceBound = false;
    private PermissionCheckRunnable permissionCheckRunnable = null;
    private CopyOnWriteArraySet<TelemetryListener> telemetryListeners = null;
    static Context applicationContext = null;

    public MapboxTelemetry(Context context, String accessToken, String userAgent) {
        this.initializeContext(context);
        this.initializeQueue();
        this.checkRequiredParameters(accessToken, userAgent);
        this.httpCallback = this;
        AlarmReceiver alarmReceiver = this.obtainAlarmReceiver();
        this.schedulerFlusher = new SchedulerFlusherFactory(applicationContext, alarmReceiver).supply();
        this.serviceConnection = this.obtainServiceConnection();
        this.telemetryEnabler = new TelemetryEnabler(true);
        this.initializeTelemetryListeners();
    }

    MapboxTelemetry(Context context, String accessToken, String userAgent, EventsQueue queue, TelemetryClient telemetryClient, Callback httpCallback, SchedulerFlusher schedulerFlusher, Clock clock, LocalBroadcastManager localBroadcastManager, boolean isServiceBound, TelemetryEnabler telemetryEnabler) {
        this.initializeContext(context);
        this.queue = queue;
        this.checkRequiredParameters(accessToken, userAgent);
        this.telemetryClient = telemetryClient;
        this.httpCallback = httpCallback;
        this.schedulerFlusher = schedulerFlusher;
        this.clock = clock;
        this.localBroadcastManager = localBroadcastManager;
        this.telemetryEnabler = telemetryEnabler;
        this.isServiceBound = isServiceBound;
        this.initializeTelemetryListeners();
    }

    @Override
    public void onFullQueue(List<Event> fullQueue) {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.sendEventsIfPossible(fullQueue);
        }
    }

    @Override
    public void onEventReceived(Event event) {
        this.pushToQueue(event);
    }

    @Override
    public void onTaskRemoved() {
        if (this.isServiceBound) {
            this.stopTelemetry();
        }
    }

    public void onFailure(Call call, IOException exception) {
        for (TelemetryListener telemetryListener : this.telemetryListeners) {
            telemetryListener.onHttpFailure(exception.getMessage());
        }
    }

    public void onResponse(Call call, Response response) {
        for (TelemetryListener telemetryListener : this.telemetryListeners) {
            telemetryListener.onHttpResponse(response.isSuccessful(), response.code());
        }
    }

    public boolean push(Event event) {
        if (this.sendEventIfWhitelisted(event)) {
            return true;
        }
        boolean isPushed = this.pushToQueue(event);
        return isPushed;
    }

    public boolean enable() {
        this.telemetryEnabler.updateTelemetryState(TelemetryEnabler.State.ENABLED);
        this.startTelemetry();
        return true;
    }

    public boolean disable() {
        this.stopTelemetry();
        this.telemetryEnabler.updateTelemetryState(TelemetryEnabler.State.DISABLED);
        return true;
    }

    public boolean updateSessionIdRotationInterval(SessionInterval interval) {
        if (this.isServiceBound) {
            int hour = interval.obtainInterval();
            SessionIdentifier sessionIdentifier = new SessionIdentifier(hour);
            this.telemetryService.updateSessionIdentifier(sessionIdentifier);
            return true;
        }
        return false;
    }

    public void updateDebugLoggingEnabled(boolean isDebugLoggingEnabled) {
        if (this.telemetryClient != null) {
            this.telemetryClient.updateDebugLoggingEnabled(isDebugLoggingEnabled);
        }
    }

    public void updateUserAgent(String userAgent) {
        if (this.isUserAgentValid(userAgent)) {
            this.telemetryClient.updateUserAgent(TelemetryUtils.createFullUserAgent(userAgent, applicationContext));
        }
    }

    public void updateLocationPriority(LocationEnginePriority locationPriority) {
        if (this.isServiceBound) {
            this.telemetryService.updateLocationPriority(locationPriority);
        }
    }

    public boolean updateAccessToken(String accessToken) {
        if (this.isAccessTokenValid(accessToken) && this.updateTelemetryClient(accessToken)) {
            this.accessToken = accessToken;
            return true;
        }
        return false;
    }

    public boolean addTelemetryListener(TelemetryListener listener) {
        return this.telemetryListeners.add(listener);
    }

    public boolean removeTelemetryListener(TelemetryListener listener) {
        return this.telemetryListeners.remove(listener);
    }

    boolean optLocationIn() {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState) && !this.isOpted && this.checkLocationPermission()) {
            this.startLocation();
            this.registerEventReceiver();
            this.isOpted = true;
        }
        return this.isOpted;
    }

    boolean optLocationOut() {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState) && this.isOpted) {
            this.stopLocation();
            this.unregisterEventReceiver();
            this.isOpted = false;
        }
        return this.isOpted;
    }

    boolean checkRequiredParameters(String accessToken, String userAgent) {
        boolean areValidParameters = this.areRequiredParametersValid(accessToken, userAgent);
        if (areValidParameters) {
            this.initializeTelemetryClient();
            this.queue.setTelemetryInitialized(true);
        }
        return areValidParameters;
    }

    Intent obtainLocationServiceIntent() {
        if (this.locationServiceIntent == null) {
            this.locationServiceIntent = new Intent(applicationContext, TelemetryService.class);
        }
        return this.locationServiceIntent;
    }

    EventReceiver obtainEventReceiver() {
        if (this.eventReceiver == null) {
            this.eventReceiver = new EventReceiver(this);
        }
        return this.eventReceiver;
    }

    IntentFilter obtainEventReceiverIntentFilter() {
        if (this.eventReceiverIntentFilter == null) {
            this.eventReceiverIntentFilter = new IntentFilter("com.mapbox.event_receiver");
        }
        return this.eventReceiverIntentFilter;
    }

    void injectTelemetryService(TelemetryService telemetryService) {
        this.telemetryService = telemetryService;
    }

    private void initializeContext(Context context) {
        if (applicationContext == null) {
            if (context != null && context.getApplicationContext() != null) {
                applicationContext = context.getApplicationContext();
            } else {
                throw new IllegalArgumentException(NON_NULL_APPLICATION_CONTEXT_REQUIRED);
            }
        }
    }

    private void initializeQueue() {
        this.queue = new EventsQueue(new FullQueueFlusher(this));
    }

    private boolean areRequiredParametersValid(String accessToken, String userAgent) {
        return this.isAccessTokenValid(accessToken) && this.isUserAgentValid(userAgent);
    }

    private boolean isAccessTokenValid(String accessToken) {
        if (!TelemetryUtils.isEmpty(accessToken)) {
            this.accessToken = accessToken;
            return true;
        }
        return false;
    }

    private boolean isUserAgentValid(String userAgent) {
        if (!TelemetryUtils.isEmpty(userAgent)) {
            for (String userAgentPrefix : VALID_USER_AGENTS) {
                if (!userAgent.startsWith(userAgentPrefix)) continue;
                this.userAgent = userAgent;
                return true;
            }
        }
        return false;
    }

    private void initializeTelemetryClient() {
        if (this.telemetryClient == null) {
            this.telemetryClient = this.createTelemetryClient(this.accessToken, this.userAgent);
        }
    }

    private TelemetryClient createTelemetryClient(String accessToken, String userAgent) {
        TelemetryClientFactory telemetryClientFactory = new TelemetryClientFactory(accessToken, userAgent, new Logger());
        this.telemetryClient = telemetryClientFactory.obtainTelemetryClient(applicationContext);
        return this.telemetryClient;
    }

    private boolean updateTelemetryClient(String accessToken) {
        if (this.telemetryClient != null) {
            this.telemetryClient.updateAccessToken(accessToken);
            return true;
        }
        return false;
    }

    private AlarmReceiver obtainAlarmReceiver() {
        return new AlarmReceiver(new SchedulerCallback(){

            @Override
            public void onPeriodRaised() {
                System.out.println("MapboxTelemetry#onPeriodRaised");
                MapboxTelemetry.this.flushEnqueuedEvents();
            }

            @Override
            public void onError() {
            }
        });
    }

    private void flushEnqueuedEvents() {
        boolean areThereAnyEvents;
        List<Event> currentEvents = this.queue.flush();
        boolean bl = areThereAnyEvents = currentEvents.size() > 0;
        if (areThereAnyEvents) {
            this.sendEventsIfPossible(currentEvents);
        }
    }

    private void sendEventsIfPossible(List<Event> events) {
        if (this.isNetworkConnected()) {
            this.sendEvents(events);
        }
    }

    private boolean isNetworkConnected() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            return activeNetwork.isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void sendEvents(List<Event> events) {
        if (this.checkRequiredParameters(this.accessToken, this.userAgent)) {
            this.telemetryClient.sendEvents(events, this.httpCallback);
        }
    }

    private ServiceConnection obtainServiceConnection() {
        return new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder service) {
                TelemetryService.TelemetryBinder binder = (TelemetryService.TelemetryBinder)service;
                MapboxTelemetry.this.telemetryService = binder.obtainService();
                MapboxTelemetry.this.isServiceBound = true;
                MapboxTelemetry.this.telemetryService.injectServiceTask(MapboxTelemetry.this);
            }

            public void onServiceDisconnected(ComponentName className) {
                MapboxTelemetry.this.telemetryService = null;
                MapboxTelemetry.this.isServiceBound = false;
            }
        };
    }

    private boolean pushToQueue(Event event) {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            return this.queue.push(event);
        }
        return false;
    }

    private void initializeTelemetryListeners() {
        this.telemetryListeners = new CopyOnWriteArraySet();
    }

    private boolean sendEventIfWhitelisted(Event event) {
        if (Event.Type.TURNSTILE.equals((Object)event.obtainType())) {
            ArrayList<Event> appUserTurnstile = new ArrayList<Event>(1);
            appUserTurnstile.add(event);
            this.sendEventsIfPossible(appUserTurnstile);
            return true;
        }
        return false;
    }

    private boolean startTelemetry() {
        if (!this.isOpted) {
            this.registerFlusher();
        }
        this.optLocationIn();
        return true;
    }

    private boolean checkLocationPermission() {
        if (PermissionsManager.areLocationPermissionsGranted((Context)applicationContext)) {
            return true;
        }
        this.permissionBackoff();
        return false;
    }

    private void permissionBackoff() {
        PermissionCheckRunnable permissionCheckRunnable = this.obtainPermissionCheckRunnable();
        permissionCheckRunnable.run();
    }

    private PermissionCheckRunnable obtainPermissionCheckRunnable() {
        if (this.permissionCheckRunnable == null) {
            this.permissionCheckRunnable = new PermissionCheckRunnable(applicationContext, this);
        }
        return this.permissionCheckRunnable;
    }

    private void startLocation() {
        applicationContext.startService(this.obtainLocationServiceIntent());
        applicationContext.bindService(this.obtainLocationServiceIntent(), this.serviceConnection, 1);
    }

    private void registerEventReceiver() {
        LocalBroadcastManager localBroadcastManager = this.obtainLocalBroadcastManager();
        EventReceiver eventReceiver = this.obtainEventReceiver();
        IntentFilter eventReceiverIntentFilter = this.obtainEventReceiverIntentFilter();
        localBroadcastManager.registerReceiver((BroadcastReceiver)eventReceiver, eventReceiverIntentFilter);
    }

    private LocalBroadcastManager obtainLocalBroadcastManager() {
        if (this.localBroadcastManager == null) {
            this.localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
        }
        return this.localBroadcastManager;
    }

    private void registerFlusher() {
        this.schedulerFlusher.register();
        Clock clock = this.obtainClock();
        this.schedulerFlusher.schedule(clock.giveMeTheElapsedRealtime());
    }

    private Clock obtainClock() {
        if (this.clock == null) {
            this.clock = new Clock();
        }
        return this.clock;
    }

    private boolean stopTelemetry() {
        this.flushEnqueuedEvents();
        if (this.isOpted) {
            this.schedulerFlusher.unregister();
        }
        this.optLocationOut();
        return true;
    }

    private void stopLocation() {
        if (this.isServiceBound) {
            applicationContext.unbindService(this.serviceConnection);
            this.isServiceBound = false;
        }
        applicationContext.stopService(this.obtainLocationServiceIntent());
    }

    private void unregisterEventReceiver() {
        LocalBroadcastManager localBroadcastManager = this.obtainLocalBroadcastManager();
        EventReceiver eventReceiver = this.obtainEventReceiver();
        localBroadcastManager.unregisterReceiver((BroadcastReceiver)eventReceiver);
    }
}

