/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.backoff;

public class ExponentialBackoff {
    public static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 10000;
    public static final double DEFAULT_MULTIPLIER = 2.0;
    public static final int DEFAULT_MAX_INTERVAL_MILLIS = 600000;
    private int currentIntervalMillis;
    private int initialIntervalMillis = 10000;
    private double multiplier = 2.0;
    private int maxIntervalMillis = 600000;
    private long startTimeNanos;

    public ExponentialBackoff() {
        this.reset();
    }

    public final void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.startTimeNanos = System.nanoTime();
    }

    public long nextBackOffMillis() {
        int value = this.currentIntervalMillis;
        this.incrementCurrentInterval();
        return value;
    }

    public final int getInitialIntervalMillis() {
        return this.initialIntervalMillis;
    }

    public final int getCurrentIntervalMillis() {
        return this.currentIntervalMillis;
    }

    public final double getMultiplier() {
        return this.multiplier;
    }

    public final int getMaxIntervalMillis() {
        return this.maxIntervalMillis;
    }

    public final long getElapsedTimeMillis() {
        return (System.nanoTime() - this.startTimeNanos) / 1000000L;
    }

    private void incrementCurrentInterval() {
        this.currentIntervalMillis = (double)this.currentIntervalMillis >= (double)this.maxIntervalMillis / this.multiplier ? this.maxIntervalMillis : (int)((double)this.currentIntervalMillis * this.multiplier);
    }
}

