/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.database.platforms.PostgreSQLDatabasePlatform;
import com.manydesigns.portofino.di.Inject;
import com.manydesigns.portofino.liquibase.databases.PortofinoPostgresDatabase;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleRegistry;
import com.manydesigns.portofino.modules.ModuleStatus;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    @Inject(value="portofinoConfiguration")
    public Configuration configuration;
    @Inject(value="com.manydesigns.portofino.modules.DatabaseModule.databasePlatformsRegistry")
    DatabasePlatformsRegistry databasePlatformsRegistry;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(PostgresqlModule.class);

    public String getModuleVersion() {
        return ModuleRegistry.getPortofinoVersion();
    }

    public int getMigrationVersion() {
        return 1;
    }

    public double getPriority() {
        return 20.0;
    }

    public String getId() {
        return "postgresql";
    }

    public String getName() {
        return "PostgreSQL";
    }

    public int install() {
        return 1;
    }

    public void init() {
        this.databasePlatformsRegistry.addDatabasePlatform((DatabasePlatform)new PostgreSQLDatabasePlatform());
        DatabaseFactory.getInstance().register((Database)new PortofinoPostgresDatabase());
        this.status = ModuleStatus.ACTIVE;
    }

    public void start() {
        this.status = ModuleStatus.STARTED;
    }

    public void stop() {
        this.status = ModuleStatus.STOPPED;
    }

    public void destroy() {
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }
}

