/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.di.Inject;
import com.manydesigns.portofino.di.Injections;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleRegistry;
import com.manydesigns.portofino.modules.ModuleStatus;
import com.manydesigns.portofino.persistence.Persistence;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    @Inject(value="com.manydesigns.portofino.servletContext")
    public ServletContext servletContext;
    @Inject(value="portofinoConfiguration")
    public Configuration configuration;
    @Inject(value="com.manydesigns.portofino.application.directory")
    public File applicationDirectory;
    protected Persistence persistence;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final String PERSISTENCE = "com.manydesigns.portofino.modules.DatabaseModule.persistence";
    public static final String DATABASE_PLATFORMS_REGISTRY = "com.manydesigns.portofino.modules.DatabaseModule.databasePlatformsRegistry";
    public static final String LIQUIBASE_ENABLED = "liquibase.enabled";
    public static final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);

    public String getModuleVersion() {
        return ModuleRegistry.getPortofinoVersion();
    }

    public int getMigrationVersion() {
        return 1;
    }

    public double getPriority() {
        return 10.0;
    }

    public String getId() {
        return "database";
    }

    public String getName() {
        return "Database";
    }

    public int install() {
        return 1;
    }

    public void init() {
        logger.info("Initializing persistence");
        DatabasePlatformsRegistry databasePlatformsRegistry = new DatabasePlatformsRegistry(this.configuration);
        this.persistence = new Persistence(this.applicationDirectory, this.configuration, databasePlatformsRegistry);
        Injections.inject((Object)this.persistence, (ServletContext)this.servletContext, null);
        this.servletContext.setAttribute(DATABASE_PLATFORMS_REGISTRY, (Object)databasePlatformsRegistry);
        this.servletContext.setAttribute(PERSISTENCE, (Object)this.persistence);
        this.status = ModuleStatus.ACTIVE;
    }

    public void start() {
        this.persistence.start();
        this.status = ModuleStatus.STARTED;
    }

    public void stop() {
        this.persistence.stop();
        this.status = ModuleStatus.STOPPED;
    }

    public void destroy() {
        logger.info("ManyDesigns Portofino database module stopping...");
        logger.info("ManyDesigns Portofino database module stopped.");
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }
}

