/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import com.manydesigns.elements.fields.FieldUtils;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.json.JSONStringer;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Class loadClass(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            logger.debug("Loaded class: {}", aClass);
            return aClass;
        }
        catch (Throwable e) {
            logger.debug("Could not load class: {}", (Object)className);
            return null;
        }
    }

    public static Constructor getConstructor(String className, Class ... argClasses) {
        return ReflectionUtil.getConstructor(ReflectionUtil.loadClass(className), argClasses);
    }

    public static Constructor getConstructor(Class aClass, Class ... argClasses) {
        try {
            Constructor constructor = aClass.getConstructor(argClasses);
            logger.debug("Found constructor: {}", constructor);
            return constructor;
        }
        catch (Throwable e) {
            logger.debug("Could not find constructor for class: {}", (Object)aClass);
            return null;
        }
    }

    public static Constructor getBestMatchConstructor(Class aClass, Class ... argClasses) {
        for (Constructor<?> current : aClass.getConstructors()) {
            Class<?>[] parameterTypes = current.getParameterTypes();
            if (parameterTypes.length != argClasses.length) continue;
            boolean matches = true;
            for (int i = 0; i < argClasses.length; ++i) {
                Class<?> paramaterType = parameterTypes[i];
                Class argClass = argClasses[i];
                matches = matches && paramaterType.isAssignableFrom(argClass);
            }
            if (!matches) continue;
            return current;
        }
        logger.debug("Could not find best match construtor for class: {}", (Object)aClass);
        return null;
    }

    public static Object newInstance(String className) {
        return ReflectionUtil.newInstance(ReflectionUtil.loadClass(className));
    }

    public static Object newInstance(Class aClass) {
        Constructor constructor = ReflectionUtil.getConstructor(aClass, new Class[0]);
        return ReflectionUtil.newInstance(constructor, new Object[0]);
    }

    public static Object newInstance(Constructor constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Throwable e) {
            logger.debug("Could not instanciate class constructor: {}", (Object)constructor);
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) {
        return ReflectionUtil.class.getClassLoader().getResourceAsStream(resourceName);
    }

    public static JSONWriter propertyAccessorToJson(JSONStringer js, PropertyAccessor accessor) {
        js.object();
        js.key("name").value((Object)accessor.getName());
        js.key("type").value((Object)accessor.getType().getName());
        js.key("modifiers").array();
        int modifiers = accessor.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            js.value((Object)"abstract");
        }
        if (Modifier.isFinal(modifiers)) {
            js.value((Object)"final");
        }
        if (Modifier.isPrivate(modifiers)) {
            js.value((Object)"private");
        }
        if (Modifier.isProtected(modifiers)) {
            js.value((Object)"protected");
        }
        if (Modifier.isPublic(modifiers)) {
            js.value((Object)"public");
        }
        js.endArray();
        js.key("label").value((Object)FieldUtils.getLabel(accessor));
        js.key("annotations").array();
        for (Annotation ann : accessor.getAnnotations()) {
            ReflectionUtil.annotationToJson(js, ann);
        }
        js.endArray();
        return js.endObject();
    }

    public static void annotationToJson(JSONStringer js, Annotation ann) {
        js.object();
        Class<? extends Annotation> annotationType = ann.annotationType();
        js.key("type").value((Object)annotationType.getName());
        js.key("properties").object();
        for (Method method : annotationType.getDeclaredMethods()) {
            try {
                Object propertyValue = method.invoke((Object)ann, new Object[0]);
                js.key(method.getName());
                ReflectionUtil.annotationPropertyValueAsJson(js, propertyValue);
            }
            catch (Exception e) {
                logger.warn("Exception reading annotation property, skipping", (Throwable)e);
            }
        }
        js.endObject();
        js.endObject();
    }

    public static void annotationPropertyValueAsJson(JSONStringer js, Object propertyValue) {
        if (propertyValue instanceof Annotation) {
            ReflectionUtil.annotationToJson(js, (Annotation)propertyValue);
        } else if (propertyValue instanceof Class) {
            js.value((Object)propertyValue.toString());
        } else if (propertyValue != null && propertyValue.getClass().isArray()) {
            js.array();
            for (Object element : (Object[])propertyValue) {
                ReflectionUtil.annotationPropertyValueAsJson(js, element);
            }
            js.endArray();
        } else {
            js.value(propertyValue);
        }
    }

    public static JSONWriter classAccessorToJson(ClassAccessor accessor, JSONStringer js) {
        js.object();
        js.key("name").value((Object)accessor.getName());
        js.key("keyProperties").array();
        for (PropertyAccessor p : accessor.getKeyProperties()) {
            js.value((Object)p.getName());
        }
        js.endArray();
        js.key("properties").array();
        for (PropertyAccessor p : accessor.getProperties()) {
            ReflectionUtil.propertyAccessorToJson(js, p);
        }
        js.endArray();
        js.key("annotations").array();
        for (Annotation ann : accessor.getAnnotations()) {
            ReflectionUtil.annotationToJson(js, ann);
        }
        js.endArray();
        return js.endObject();
    }
}

